/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.phpModel.parser;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.php.core.phpModel.parser.IPhpModel;
import org.eclipse.php.core.phpModel.parser.ModelSupport;
import org.eclipse.php.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.core.phpModel.phpElementData.IPHPMarker;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;

public abstract class CompositePhpModel
implements IPhpModel {
    private IPhpModel[] models = new IPhpModel[0];

    public void addModel(IPhpModel iPhpModel) {
        if (this.indexOf(iPhpModel.getID()) != -1) {
            return;
        }
        IPhpModel[] iPhpModelArray = new IPhpModel[this.models.length + 1];
        System.arraycopy(this.models, 0, iPhpModelArray, 0, this.models.length);
        iPhpModelArray[iPhpModelArray.length - 1] = iPhpModel;
        this.models = iPhpModelArray;
    }

    public IPhpModel remove(String string) {
        if (string == null) {
            return null;
        }
        int n = this.indexOf(string);
        if (n == -1) {
            return null;
        }
        IPhpModel[] iPhpModelArray = new IPhpModel[this.models.length - 1];
        int n2 = 0;
        while (n2 < n) {
            iPhpModelArray[n2] = this.models[n2];
            ++n2;
        }
        n2 = n + 1;
        while (n2 < this.models.length) {
            iPhpModelArray[n2 - 1] = this.models[n2];
            ++n2;
        }
        IPhpModel iPhpModel = this.models[n];
        this.models = iPhpModelArray;
        return iPhpModel;
    }

    public IPhpModel getModel(String string) {
        int n = this.indexOf(string);
        if (n == -1) {
            return null;
        }
        return this.models[n];
    }

    public IPhpModel[] getModels() {
        return this.models;
    }

    private int indexOf(String string) {
        int n = 0;
        while (n < this.models.length) {
            if (this.models[n].getID().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public CodeData[] getPHPFilesData(String string) {
        ArrayList<CodeData[]> arrayList = new ArrayList<CodeData[]>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getPHPFilesData(string);
            if (codeDataArray != null && codeDataArray.length > 0) {
                arrayList.add(codeDataArray);
            }
            ++n;
        }
        return this.mergResults(arrayList);
    }

    public CodeData[] getNonPHPFiles(String string) {
        ArrayList<CodeData[]> arrayList = new ArrayList<CodeData[]>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getNonPHPFiles(string);
            if (codeDataArray != null && codeDataArray.length > 0) {
                arrayList.add(codeDataArray);
            }
            ++n;
        }
        return this.mergResults(arrayList);
    }

    public PHPFileData getFileData(String string) {
        int n = 0;
        while (n < this.models.length) {
            PHPFileData pHPFileData = this.models[n].getFileData(string);
            if (pHPFileData != null) {
                return pHPFileData;
            }
            ++n;
        }
        return null;
    }

    public CodeData[] getFunctions() {
        ArrayList<CodeData[]> arrayList = new ArrayList<CodeData[]>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getFunctions();
            if (codeDataArray != null && codeDataArray.length > 0) {
                arrayList.add(codeDataArray);
            }
            ++n;
        }
        return this.mergResults(arrayList);
    }

    public CodeData[] getFunction(String string) {
        ArrayList<CodeData[]> arrayList = new ArrayList<CodeData[]>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getFunction(string);
            if (codeDataArray != null && codeDataArray.length > 0) {
                arrayList.add(codeDataArray);
            }
            ++n;
        }
        return this.mergResults(arrayList);
    }

    public CodeData[] getFunctions(String string) {
        ArrayList<CodeData[]> arrayList = new ArrayList<CodeData[]>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getFunctions(string);
            if (codeDataArray != null && codeDataArray.length > 0) {
                arrayList.add(codeDataArray);
            }
            ++n;
        }
        return this.mergResults(arrayList);
    }

    public CodeData[] getClasses() {
        ArrayList<CodeData[]> arrayList = new ArrayList<CodeData[]>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getClasses();
            if (codeDataArray != null && codeDataArray.length > 0) {
                arrayList.add(codeDataArray);
            }
            ++n;
        }
        return this.mergResults(arrayList);
    }

    public PHPClassData getClass(String string, String string2) {
        int n = 0;
        while (n < this.models.length) {
            PHPClassData pHPClassData = this.models[n].getClass(string, string2);
            if (pHPClassData != null) {
                return pHPClassData;
            }
            ++n;
        }
        return null;
    }

    public CodeData[] getClasses(String string) {
        ArrayList<CodeData[]> arrayList = new ArrayList<CodeData[]>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getClasses(string);
            if (codeDataArray != null && codeDataArray.length > 0) {
                arrayList.add(codeDataArray);
            }
            ++n;
        }
        return this.mergResults(arrayList);
    }

    public CodeData[] getGlobalVariables(String string, String string2, boolean bl) {
        ArrayList<CodeData[]> arrayList = new ArrayList<CodeData[]>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getGlobalVariables(string, string2, bl);
            if (codeDataArray != null && codeDataArray.length > 0) {
                arrayList.add(codeDataArray);
            }
            ++n;
        }
        return this.mergResults(arrayList);
    }

    public CodeData[] getVariables(String string, PHPCodeContext pHPCodeContext, String string2, boolean bl) {
        ArrayList<CodeData[]> arrayList = new ArrayList<CodeData[]>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getVariables(string, pHPCodeContext, string2, bl);
            if (codeDataArray != null && codeDataArray.length > 0) {
                arrayList.add(codeDataArray);
            }
            ++n;
        }
        return this.mergResults(arrayList);
    }

    public String getVariableType(String string, PHPCodeContext pHPCodeContext, String string2, int n, boolean bl) {
        int n2 = 0;
        while (n2 < this.models.length) {
            String string3 = this.models[n2].getVariableType(string, pHPCodeContext, string2, n, bl);
            if (string3 != null && !string3.equals("")) {
                return string3;
            }
            ++n2;
        }
        return null;
    }

    public PHPConstantData getConstantData(String string) {
        int n = 0;
        while (n < this.models.length) {
            PHPConstantData pHPConstantData = this.models[n].getConstantData(string);
            if (pHPConstantData != null) {
                return pHPConstantData;
            }
            ++n;
        }
        return null;
    }

    public CodeData[] getConstants() {
        ArrayList<CodeData[]> arrayList = new ArrayList<CodeData[]>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getConstants();
            if (codeDataArray != null && codeDataArray.length > 0) {
                arrayList.add(codeDataArray);
            }
            ++n;
        }
        return this.mergResults(arrayList);
    }

    public CodeData[] getConstants(String string, boolean bl) {
        ArrayList<CodeData[]> arrayList = new ArrayList<CodeData[]>();
        int n = 0;
        while (n < this.models.length) {
            CodeData[] codeDataArray = this.models[n].getConstants(string, bl);
            if (codeDataArray != null && codeDataArray.length > 0) {
                arrayList.add(codeDataArray);
            }
            ++n;
        }
        return this.mergResults(arrayList);
    }

    public IPHPMarker[] getMarkers() {
        ArrayList<IPHPMarker[]> arrayList = new ArrayList<IPHPMarker[]>();
        int n = 0;
        int n2 = 0;
        while (n2 < this.models.length) {
            IPHPMarker[] iPHPMarkerArray = this.models[n2].getMarkers();
            if (iPHPMarkerArray != null && iPHPMarkerArray.length > 0) {
                arrayList.add(iPHPMarkerArray);
                n += iPHPMarkerArray.length;
            }
            ++n2;
        }
        IPHPMarker[] iPHPMarkerArray = new IPHPMarker[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < arrayList.size()) {
            IPHPMarker[] iPHPMarkerArray2 = (IPHPMarker[])arrayList.get(n4);
            System.arraycopy(iPHPMarkerArray2, 0, iPHPMarkerArray, n3, iPHPMarkerArray2.length);
            n3 += iPHPMarkerArray2.length;
            ++n4;
        }
        return iPHPMarkerArray;
    }

    public void clean() {
        int n = 0;
        while (n < this.models.length) {
            this.models[n].clean();
            ++n;
        }
    }

    public void dispose() {
        int n = 0;
        while (n < this.models.length) {
            this.models[n].dispose();
            ++n;
        }
    }

    private CodeData[] mergResults(ArrayList arrayList) {
        if (arrayList.size() == 0) {
            return new CodeData[0];
        }
        Object[] objectArray = (CodeData[])arrayList.get(0);
        Arrays.sort(objectArray);
        int n = 1;
        while (n < arrayList.size()) {
            Object[] objectArray2 = (CodeData[])arrayList.get(n);
            Arrays.sort(objectArray2);
            objectArray = ModelSupport.merge((CodeData[])objectArray, (CodeData[])objectArray2);
            ++n;
        }
        return objectArray;
    }
}

