/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.preferences.includepath;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.ui.PHPUiPlugin;

public class ArchieveFileFilter
extends ViewerFilter {
    private List fExcludes;
    private boolean fRecursive;
    private static String[] fFilterExtensions = new String[]{"*.zip", "*.jar"};

    public ArchieveFileFilter(IFile[] iFileArray, boolean bl, String[] stringArray) {
        this.fExcludes = iFileArray != null ? Arrays.asList(iFileArray) : null;
        this.fRecursive = bl;
        fFilterExtensions = stringArray;
    }

    public ArchieveFileFilter(List list, boolean bl, String[] stringArray) {
        this.fExcludes = list;
        this.fRecursive = bl;
        fFilterExtensions = stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object object, Object object2) {
        if (object2 instanceof IFile) {
            if (this.fExcludes == null) return ArchieveFileFilter.isZipPath(((IFile)object2).getFullPath());
            if (!this.fExcludes.contains(object2)) return ArchieveFileFilter.isZipPath(((IFile)object2).getFullPath());
            return false;
        }
        if (!(object2 instanceof IContainer)) return false;
        if (!this.fRecursive) {
            return true;
        }
        try {
            IResource[] iResourceArray = ((IContainer)object2).members();
            int n = 0;
            while (true) {
                if (n >= iResourceArray.length) {
                    return false;
                }
                if (this.select(viewer, object, iResourceArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            PHPUiPlugin.log(coreException.getStatus());
        }
        return false;
    }

    public static boolean isZipPath(IPath iPath) {
        String string = iPath.getFileExtension();
        if (string != null && string.length() != 0) {
            return ArchieveFileFilter.isArchiveFileExtension(string);
        }
        return false;
    }

    public static boolean isArchiveFileExtension(String string) {
        int n = 0;
        while (n < fFilterExtensions.length) {
            if (string.equalsIgnoreCase(fFilterExtensions[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

