/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import org.apache.xerces.util.XMLChar;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.xsd.ui.internal.adt.edit.ComponentReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.edit.IComponentDialog;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateComplexTypeDerivationBy;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateNameCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.RefactoringSection;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDTypeDefinition;

public class XSDComplexTypeSection
extends RefactoringSection
implements SelectionListener {
    protected Text nameText;
    protected CCombo baseTypeCombo;
    protected CCombo derivedByCombo;
    private String[] derivedByChoicesComboValues = new String[]{"", "restriction", "extension"};
    static /* synthetic */ Class class$0;

    public void createContents(Composite parent) {
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.composite.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel nameLabel = this.getWidgetFactory().createCLabel(this.composite, org.eclipse.wst.xsd.ui.internal.editor.Messages.UI_LABEL_NAME);
        nameLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.nameText = this.getWidgetFactory().createText(this.composite, "");
        this.nameText.setLayoutData((Object)data);
        this.applyAllListeners((Control)this.nameText);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.nameText, "org.eclipse.wst.xsd.ui.xsdup0260");
        this.createRenameHyperlink(this.composite);
        this.getWidgetFactory().createCLabel(this.composite, org.eclipse.wst.xsd.ui.internal.editor.Messages.UI_LABEL_INHERIT_FROM);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.baseTypeCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.baseTypeCombo.setEditable(false);
        this.baseTypeCombo.setLayoutData((Object)data);
        this.baseTypeCombo.addSelectionListener((SelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.baseTypeCombo, "org.eclipse.wst.xsd.ui.xsdup0270");
        this.getWidgetFactory().createCLabel(this.composite, "");
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel derivedByLabel = this.getWidgetFactory().createCLabel(this.composite, org.eclipse.wst.xsd.ui.internal.editor.Messages.UI_LABEL_INHERIT_BY);
        derivedByLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.derivedByCombo = this.getWidgetFactory().createCCombo(this.composite, 0x800000);
        this.derivedByCombo.setLayoutData((Object)data);
        this.derivedByCombo.setItems(this.derivedByChoicesComboValues);
        this.derivedByCombo.addSelectionListener((SelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.derivedByCombo, "org.eclipse.wst.xsd.ui.xsdup0280");
        this.getWidgetFactory().createCLabel(this.composite, "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refresh() {
        super.refresh();
        if (Display.getCurrent() == null) {
            return;
        }
        this.setListenerEnabled(false);
        try {
            this.nameText.setText("");
            this.baseTypeCombo.setText("");
            this.fillTypesCombo();
            if (this.input instanceof XSDComplexTypeDefinition) {
                boolean isAnonymousType;
                XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)this.input;
                String name = complexType.getName();
                if (name == null) {
                    name = "";
                }
                boolean bl = isAnonymousType = name.equals("");
                if (isAnonymousType) {
                    this.nameText.setText("**anonymous**");
                    this.nameText.setEditable(false);
                } else {
                    this.nameText.setText(name);
                    this.nameText.setEditable(true);
                }
                XSDTypeDefinition baseTypeDefinition = complexType.getBaseTypeDefinition();
                String baseType = "";
                if (baseTypeDefinition != null) {
                    baseType = baseTypeDefinition.getName();
                    if (baseType == null) {
                        baseType = "";
                    } else if (baseType.equals("anyType")) {
                        baseType = "";
                    }
                }
                this.baseTypeCombo.setText(baseType);
                this.derivedByCombo.setText("");
                int derivationMethod = complexType.getDerivationMethod().getValue();
                if (derivationMethod == 0) {
                    this.derivedByCombo.setText("extension");
                } else if (derivationMethod == 1) {
                    this.derivedByCombo.setText("restriction");
                }
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.setListenerEnabled(true);
            throw throwable;
        }
        this.setListenerEnabled(true);
    }

    public void doWidgetSelected(SelectionEvent e) {
        if (e.widget == this.baseTypeCombo) {
            IEditorPart editor = this.getActiveEditor();
            if (editor == null) {
                return;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDComplexTypeBaseTypeEditManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ComponentReferenceEditManager manager = (ComponentReferenceEditManager)editor.getAdapter((Class)clazz);
            String selection = this.baseTypeCombo.getText();
            IComponentDialog dialog = null;
            if (selection.equals(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_BROWSE)) {
                dialog = manager.getBrowseDialog();
            } else if (selection.equals(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_NEW)) {
                dialog = manager.getNewDialog();
            }
            if (dialog != null && dialog.createAndOpen() == 0) {
                ComponentSpecification newValue = dialog.getSelectedComponent();
                manager.modifyComponentReference(this.input, newValue);
            }
        } else if (e.widget == this.derivedByCombo) {
            XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)this.input;
            String value = this.derivedByCombo.getText();
            UpdateComplexTypeDerivationBy command = new UpdateComplexTypeDerivationBy(complexType, value);
            if (this.getCommandStack() != null) {
                this.getCommandStack().execute((Command)command);
            }
        }
        super.doWidgetSelected(e);
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    public void dispose() {
        super.dispose();
    }

    public void doHandleEvent(Event event) {
        super.doHandleEvent(event);
        if (event.widget == this.nameText) {
            if (!this.nameText.getEditable()) {
                return;
            }
            String newValue = this.nameText.getText().trim();
            if (this.input instanceof XSDNamedComponent) {
                XSDNamedComponent namedComponent = (XSDNamedComponent)this.input;
                if (!this.validateSection()) {
                    return;
                }
                UpdateNameCommand command = null;
                String oldName = namedComponent.getName();
                if (!newValue.equals(oldName)) {
                    command = new UpdateNameCommand(Messages._UI_ACTION_RENAME, namedComponent, newValue);
                }
                if (command != null && this.getCommandStack() != null) {
                    this.getCommandStack().execute((Command)command);
                }
            }
        }
    }

    protected boolean validateSection() {
        if (this.nameText == null || this.nameText.isDisposed()) {
            return true;
        }
        this.setErrorMessage(null);
        String name = this.nameText.getText().trim();
        if (name.length() < 1 || !XMLChar.isValidNCName((String)name)) {
            this.setErrorMessage(Messages._UI_ERROR_INVALID_NAME);
            return false;
        }
        return true;
    }

    private void fillTypesCombo() {
        String currentTypeName;
        this.baseTypeCombo.removeAll();
        this.baseTypeCombo.add(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_BROWSE);
        this.baseTypeCombo.add(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_NEW);
        XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)this.input;
        XSDTypeDefinition baseType = complexType.getBaseType();
        if (baseType != null && baseType.getQName() != null && (currentTypeName = baseType.getQName((XSDConcreteComponent)this.xsdSchema)) != null && !currentTypeName.equals("anyType")) {
            this.baseTypeCombo.add(currentTypeName);
        }
    }
}

