/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.page;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class LicenseComposite
extends Composite {
    protected TaskModel taskModel;
    protected IWizardHandle wizard;
    protected Text licenseText;
    protected Button accept;
    protected Button decline;
    protected boolean accepted;

    public LicenseComposite(Composite parent, TaskModel taskModel, IWizardHandle wizard) {
        super(parent, 0);
        this.taskModel = taskModel;
        this.wizard = wizard;
        this.createControl();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        this.setLayout((Layout)layout);
        this.licenseText = new Text((Composite)this, 2890);
        GridData data = new GridData(1808);
        this.licenseText.setLayoutData((Object)data);
        this.licenseText.setBackground(this.licenseText.getDisplay().getSystemColor(25));
        this.accept = new Button((Composite)this, 16);
        this.accept.setText(Messages.wizLicenseAccept);
        data = new GridData(258);
        data.horizontalIndent = 15;
        data.verticalIndent = 5;
        this.accept.setLayoutData((Object)data);
        this.accept.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseComposite.this.accepted = LicenseComposite.this.accept.getSelection();
                LicenseComposite.this.taskModel.putObject("accept", (Object)new Boolean(LicenseComposite.this.accepted));
                LicenseComposite.this.wizard.update();
            }
        });
        this.decline = new Button((Composite)this, 16);
        data = new GridData(258);
        data.horizontalIndent = 15;
        data.verticalIndent = 2;
        this.decline.setLayoutData((Object)data);
        this.decline.setText(Messages.wizLicenseDecline);
        this.updateLicense();
        Dialog.applyDialogFont((Control)this);
    }

    public void updateLicense() {
        Object acc;
        String license = (String)this.taskModel.getObject("license");
        if (license == null) {
            license = "unknown";
        }
        if ((acc = this.taskModel.getObject("accept")) == null) {
            this.accepted = false;
            this.accept.setSelection(false);
            this.decline.setSelection(false);
        }
        if ("none".equals(license)) {
            this.licenseText.setText(Messages.wizLicenseNone);
            this.accept.setEnabled(false);
            this.decline.setEnabled(false);
            this.accepted = true;
        } else if ("unknown".equals(license)) {
            this.licenseText.setText(Messages.wizLicenseNone);
            this.accept.setEnabled(true);
            this.decline.setEnabled(true);
        } else {
            this.licenseText.setText(license);
            this.accept.setEnabled(true);
            this.decline.setEnabled(true);
        }
        this.taskModel.putObject("accept", (Object)new Boolean(this.accepted));
    }
}

