/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.net.URL;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.PluginEntry;
import org.eclipse.update.internal.configurator.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FullFeatureParser
extends DefaultHandler
implements IConfigurationConstants {
    private SAXParser parser;
    private FeatureEntry feature;
    private URL url;
    private boolean isDescription;
    private StringBuffer description = new StringBuffer();
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();

    public FullFeatureParser(FeatureEntry feature) {
        this.feature = feature;
        try {
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            System.out.println(e);
        }
        catch (SAXException e) {
            System.out.println(e);
        }
    }

    /*
     * Exception decompiling
     */
    public void parse() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [6 : 127->131)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Utils.debug("Start Element: uri:" + uri + " local Name:" + localName + " qName:" + qName);
        if ("plugin".equals(localName)) {
            this.processPlugin(attributes);
        } else if ("description".equals(localName)) {
            this.isDescription = true;
        } else if ("license".equals(localName)) {
            this.processLicense(attributes);
        }
    }

    private void processPlugin(Attributes attributes) {
        String id = attributes.getValue("id");
        String ver = attributes.getValue("version");
        if (id == null || id.trim().equals("") || ver == null || ver.trim().equals("")) {
            System.out.println(NLS.bind((String)Messages.FeatureParser_IdOrVersionInvalid, (Object[])new String[]{id, ver}));
        } else {
            String arch;
            String ws;
            String nl = attributes.getValue("nl");
            String os = attributes.getValue("os");
            if (!Utils.isValidEnvironment(os, ws = attributes.getValue("ws"), arch = attributes.getValue("arch"), nl)) {
                return;
            }
            PluginEntry plugin = new PluginEntry();
            plugin.setPluginIdentifier(id);
            plugin.setPluginVersion(ver);
            this.feature.addPlugin(plugin);
            Utils.debug("End process DefaultFeature tag: id:" + id + " ver:" + ver + " url:" + this.feature.getURL());
        }
    }

    private void processLicense(Attributes attributes) {
        this.feature.setLicenseURL(attributes.getValue("url"));
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.isDescription) {
            return;
        }
        this.description.append(ch, start, length);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("description".equals(localName)) {
            this.isDescription = false;
            String d = this.description.toString().trim();
            ResourceBundle bundle = this.feature.getResourceBundle();
            this.feature.setDescription(Utils.getResourceString(bundle, d));
        }
    }
}

