/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui.breakpoint.provider;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.php.core.containers.LocalFileStorage;
import org.eclipse.php.core.containers.ZipEntryStorage;
import org.eclipse.php.core.documentModel.partitioner.PHPStructuredTextPartitioner;
import org.eclipse.php.debug.core.debugger.RemoteDebugger;
import org.eclipse.php.debug.core.model.PHPDebugTarget;
import org.eclipse.php.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.ui.util.StatusLineMessageTimerManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.breakpoint.IBreakpointProvider;

public class PHPBreakpointProvider
implements IBreakpointProvider,
IExecutableExtension {
    static /* synthetic */ Class class$0;

    public IStatus addBreakpoint(IDocument iDocument, IEditorInput iEditorInput, int n, int n2) throws CoreException {
        int n3 = PHPBreakpointProvider.getValidPosition(iDocument, n);
        Status status = null;
        IBreakpoint iBreakpoint = null;
        if (n3 >= 0) {
            IResource iResource = this.getResourceFromInput(iEditorInput);
            if (iResource != null && iEditorInput instanceof IFileEditorInput) {
                try {
                    n = iDocument.getLineOfOffset(n3) + 1;
                    Integer n4 = new Integer(n);
                    IMarker[] iMarkerArray = iResource.findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, true, 0);
                    int n5 = 0;
                    while (n5 < iMarkerArray.length) {
                        if (iMarkerArray[n5].getAttributes().get("lineNumber").equals(n4)) {
                            throw new BadLocationException();
                        }
                        ++n5;
                    }
                    iBreakpoint = PHPDebugTarget.createBreakpoint((IResource)iResource, (int)n);
                }
                catch (BadLocationException badLocationException) {}
            } else if (iEditorInput instanceof IStorageEditorInput) {
                String string;
                iResource = ResourcesPlugin.getWorkspace().getRoot();
                String string2 = iEditorInput.getName();
                IStorage iStorage = ((IStorageEditorInput)iEditorInput).getStorage();
                if (iEditorInput instanceof IStorageEditorInput && ((IStorageEditorInput)iEditorInput).getStorage() != null) {
                    string2 = iStorage.getFullPath().toString();
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("org.eclipse.wst.sse.ui.extensions.breakpoint.path", string2);
                String string3 = "";
                IProject iProject = null;
                if (iStorage instanceof ZipEntryStorage) {
                    string3 = RemoteDebugger.convertToSystemIndependentFileName((String)((ZipEntryStorage)iStorage).getZipEntry().getName());
                    hashMap.put("org.eclipse.php.debug.core.Include_Storage_Type", "org.eclipse.php.debug.core.zip");
                    iProject = ((ZipEntryStorage)iStorage).getProject();
                } else if (iStorage instanceof LocalFileStorage) {
                    hashMap.put("org.eclipse.php.debug.core.Include_Storage_Type", "org.eclipse.php.debug.core.lfile");
                    string3 = RemoteDebugger.convertToSystemIndependentFileName((String)((LocalFileStorage)iStorage).getName());
                    string = ((LocalFileStorage)iStorage).getIncBaseDirName();
                    string = RemoteDebugger.convertToSystemIndependentFileName((String)string);
                    if (string != null) {
                        string3 = string2.substring(string.length() + 1);
                    }
                    iProject = ((LocalFileStorage)iStorage).getProject();
                } else {
                    hashMap.put("org.eclipse.php.debug.core.Include_Storage_Type", "org.eclipse.php.debug.core.rfile");
                    string3 = iStorage.getName();
                }
                hashMap.put("org.eclipse.php.debug.core.Include_Storage", string3);
                string = "";
                if (iProject != null) {
                    string = iProject.getName();
                }
                hashMap.put("org.eclipse.php.debug.core.project", string);
                iBreakpoint = PHPDebugTarget.createBreakpoint((IResource)iResource, (int)n, hashMap);
            }
        }
        if (iBreakpoint == null) {
            StatusLineMessageTimerManager.setErrorMessage((String)PHPDebugUIMessages.ErrorCreatingBreakpoint_1, (long)1000L, (boolean)true);
        }
        if (status == null) {
            status = new Status(0, PHPDebugUIPlugin.getID(), 0, MessageFormat.format(PHPDebugUIMessages.BreakpointCreated_1, new Object[0]), null);
        }
        return status;
    }

    public IResource getResource(IEditorInput iEditorInput) {
        return this.getResourceFromInput(iEditorInput);
    }

    private IResource getResourceFromInput(IEditorInput iEditorInput) {
        IResource iResource;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iResource = (IResource)iEditorInput.getAdapter((Class)clazz)) == null) {
            iResource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return iResource;
    }

    public static int getValidPosition(IDocument iDocument, int n) {
        int n2 = -1;
        if (iDocument != null) {
            int n3 = 0;
            int n4 = 0;
            try {
                String string = null;
                boolean bl = false;
                do {
                    IRegion iRegion = iDocument.getLineInformation(n - 1);
                    n3 = iRegion.getOffset();
                    n4 = Math.max(iRegion.getOffset(), iRegion.getOffset() + iRegion.getLength());
                    ITypedRegion[] iTypedRegionArray = null;
                    iTypedRegionArray = iDocument.computePartitioning(n3, n4 - n3);
                    int n5 = 0;
                    while (n5 < iTypedRegionArray.length) {
                        string = iTypedRegionArray[n5].getType();
                        if (string.equals("org.eclipse.php.PHP_DEFAULT")) {
                            bl = true;
                            n3 = iTypedRegionArray[n5].getOffset();
                            String string2 = iDocument.get(n3, iTypedRegionArray[n5].getLength()).trim();
                            if (Pattern.matches(".*[a-zA-Z0-0_]+.*", string2) && !string2.trim().toLowerCase().equals("<?php")) {
                                n2 = n3;
                                break;
                            }
                        }
                        ++n5;
                    }
                    ++n;
                } while ((!bl || PHPStructuredTextPartitioner.isPHPPartitionType(string)) && n2 == -1);
            }
            catch (BadLocationException badLocationException) {
                n2 = -1;
            }
        }
        return n2;
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
    }

    public void setSourceEditingTextTools(ISourceEditingTextTools iSourceEditingTextTools) {
    }
}

