/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.util.preferences;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.core.Logger;
import org.eclipse.php.core.util.preferences.Key;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLPreferencesReader {
    public static final char DELIMITER = '\u0005';
    private static final Pattern LT_PATTERN = Pattern.compile("&lt;");
    private static final Pattern GT_PATTERN = Pattern.compile("&gt;");
    private static final Pattern QUOT_PATTERN = Pattern.compile("&quot;");
    private static final Pattern APOS_PATTERN = Pattern.compile("&apos;");
    private static final Pattern AMP_PATTERN = Pattern.compile("&amp;");
    public static final String STRING_DEFAULT = "";

    public static String getUnEscaped(String string) {
        string = LT_PATTERN.matcher(string).replaceAll("<");
        string = GT_PATTERN.matcher(string).replaceAll(">");
        string = QUOT_PATTERN.matcher(string).replaceAll("\"");
        string = APOS_PATTERN.matcher(string).replaceAll("'");
        string = AMP_PATTERN.matcher(string).replaceAll("&");
        return string;
    }

    private static HashMap read(NodeList nodeList) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(nodeList.getLength());
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.hasChildNodes()) {
                if (node.getFirstChild().getNodeType() == 3) {
                    hashMap.put(node.getNodeName(), XMLPreferencesReader.getUnEscaped(node.getFirstChild().getNodeValue()));
                } else {
                    hashMap.put(node.getNodeName(), XMLPreferencesReader.read(node.getChildNodes()));
                }
            }
            ++n;
        }
        return hashMap;
    }

    private static HashMap read(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes()));
            return XMLPreferencesReader.read(document.getChildNodes());
        }
        catch (Exception exception) {
            Logger.logException(exception);
            return null;
        }
    }

    public static HashMap[] read(IPreferenceStore iPreferenceStore, String string) {
        ArrayList<HashMap> arrayList = new ArrayList<HashMap>();
        StringTokenizer stringTokenizer = new StringTokenizer(iPreferenceStore.getString(string), new String(new char[]{'\u0005'}));
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(XMLPreferencesReader.read(stringTokenizer.nextToken()));
        }
        return arrayList.toArray(new HashMap[arrayList.size()]);
    }

    public static HashMap[] read(Preferences preferences, String string) {
        String string2 = preferences.getString(string);
        return XMLPreferencesReader.getHashFromStoredValue(string2);
    }

    public static HashMap[] read(Key key, ProjectScope projectScope, IWorkingCopyManager iWorkingCopyManager) {
        String string = key.getStoredValue((IScopeContext)projectScope, iWorkingCopyManager);
        if (string == null) {
            string = STRING_DEFAULT;
        }
        return XMLPreferencesReader.getHashFromStoredValue(string);
    }

    public static HashMap[] getHashFromStoredValue(String string) {
        ArrayList<HashMap> arrayList = new ArrayList<HashMap>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, new String(new char[]{'\u0005'}));
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(XMLPreferencesReader.read(stringTokenizer.nextToken()));
        }
        return arrayList.toArray(new HashMap[arrayList.size()]);
    }
}

