/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.debugger;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.php.debug.core.PHPDebugPlugin;
import org.eclipse.php.debug.core.debugger.parameters.IDebugParametersInitializer;

public class DebugParametersInitializersRegistry {
    private static final String EXTENSION_POINT_NAME = "phpDebugParametersInitializers";
    private static final String INITIALIZER_TAG = "initializer";
    private static final String ID_ATTRIBUTE = "id";
    private static final String LAUNCH_CONFIGURATION_TYPE_ATTRIBUTE = "launchConfigurationType";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String HANDLER_ATTRIBUTE = "handler";
    private static final String MODE_ATTRIBUTE = "mode";
    private static final String RUN = "run";
    private static final String DEBUG = "debug";
    private static final String PROFILE = "profile";
    private Dictionary runInitializers = new Hashtable();
    private Dictionary debugInitializers = new Hashtable();
    private Dictionary profileInitializers = new Hashtable();
    private static DebugParametersInitializersRegistry instance = null;

    private DebugParametersInitializersRegistry() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(PHPDebugPlugin.getID(), EXTENSION_POINT_NAME);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (INITIALIZER_TAG.equals(iConfigurationElement.getName())) {
                if (RUN.equals(iConfigurationElement.getAttribute(MODE_ATTRIBUTE))) {
                    this.runInitializers.put(iConfigurationElement.getAttribute(ID_ATTRIBUTE), new DebugParametersInitializerFactory(iConfigurationElement));
                } else if (PROFILE.equals(iConfigurationElement.getAttribute(MODE_ATTRIBUTE))) {
                    this.profileInitializers.put(iConfigurationElement.getAttribute(ID_ATTRIBUTE), new DebugParametersInitializerFactory(iConfigurationElement));
                } else {
                    this.debugInitializers.put(iConfigurationElement.getAttribute(ID_ATTRIBUTE), new DebugParametersInitializerFactory(iConfigurationElement));
                }
            }
            ++n;
        }
    }

    private static DebugParametersInitializersRegistry getInstance() {
        if (instance == null) {
            instance = new DebugParametersInitializersRegistry();
        }
        return instance;
    }

    private Dictionary getInitializersFactories(String string) {
        if (RUN.equals(string)) {
            return this.runInitializers;
        }
        if (PROFILE.equals(string)) {
            return this.profileInitializers;
        }
        return this.debugInitializers;
    }

    public static IDebugParametersInitializer getParametersInitializer(String string) throws Exception {
        DebugParametersInitializerFactory debugParametersInitializerFactory = (DebugParametersInitializerFactory)DebugParametersInitializersRegistry.getInstance().getInitializersFactories(RUN).get(string);
        if (debugParametersInitializerFactory == null) {
            debugParametersInitializerFactory = (DebugParametersInitializerFactory)DebugParametersInitializersRegistry.getInstance().getInitializersFactories(PROFILE).get(string);
        }
        if (debugParametersInitializerFactory == null) {
            debugParametersInitializerFactory = (DebugParametersInitializerFactory)DebugParametersInitializersRegistry.getInstance().getInitializersFactories(DEBUG).get(string);
        }
        if (debugParametersInitializerFactory != null) {
            return debugParametersInitializerFactory.createParametersInitializer();
        }
        return null;
    }

    public static IDebugParametersInitializer getCurrentDebugParametersInitializer() {
        try {
            String string = PHPDebugPlugin.getDefault().getPluginPreferences().getString("org.eclipse.php.debug.core.debugParametersInitializer");
            return DebugParametersInitializersRegistry.getParametersInitializer(string);
        }
        catch (Exception exception) {
            PHPDebugPlugin.log(exception);
            return null;
        }
    }

    public static IDebugParametersInitializer getBestMatchDebugParametersInitializer(ILaunch iLaunch) {
        try {
            String string;
            DebugParametersInitializerFactory debugParametersInitializerFactory;
            Dictionary dictionary = DebugParametersInitializersRegistry.getInstance().getInitializersFactories(iLaunch.getLaunchMode());
            Enumeration enumeration = dictionary.elements();
            while (enumeration.hasMoreElements()) {
                debugParametersInitializerFactory = (DebugParametersInitializerFactory)enumeration.nextElement();
                string = debugParametersInitializerFactory.element.getAttribute(LAUNCH_CONFIGURATION_TYPE_ATTRIBUTE);
                if (string == null || "".equals(string) || !string.equals(iLaunch.getLaunchConfiguration().getType().getIdentifier())) continue;
                return debugParametersInitializerFactory.createParametersInitializer();
            }
            enumeration = dictionary.elements();
            while (enumeration.hasMoreElements()) {
                debugParametersInitializerFactory = (DebugParametersInitializerFactory)enumeration.nextElement();
                string = debugParametersInitializerFactory.element.getAttribute(LAUNCH_CONFIGURATION_TYPE_ATTRIBUTE);
                if (string != null && !"".equals(string) || PHPDebugPlugin.getID().equals(debugParametersInitializerFactory.element.getNamespaceIdentifier())) continue;
                return debugParametersInitializerFactory.createParametersInitializer();
            }
            enumeration = dictionary.elements();
            while (enumeration.hasMoreElements()) {
                debugParametersInitializerFactory = (DebugParametersInitializerFactory)enumeration.nextElement();
                if (!PHPDebugPlugin.getID().equals(debugParametersInitializerFactory.element.getNamespaceIdentifier())) continue;
                return debugParametersInitializerFactory.createParametersInitializer();
            }
        }
        catch (Exception exception) {
            PHPDebugPlugin.log(exception);
        }
        return DebugParametersInitializersRegistry.getCurrentDebugParametersInitializer();
    }

    class DebugParametersInitializerFactory {
        private IConfigurationElement element;
        private IDebugParametersInitializer parametersInitializer;

        public DebugParametersInitializerFactory(IConfigurationElement iConfigurationElement) {
            this.element = iConfigurationElement;
        }

        public IDebugParametersInitializer createParametersInitializer() {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(this, "Error creation extension for extension-point org.eclipse.php.debug.core.phpDebugParametersInitializers"){
                final /* synthetic */ DebugParametersInitializerFactory this$1;
                {
                    this.this$1 = debugParametersInitializerFactory;
                    super(string);
                }

                public void run() throws Exception {
                    DebugParametersInitializerFactory.access$1(this.this$1, (IDebugParametersInitializer)DebugParametersInitializerFactory.access$0(this.this$1).createExecutableExtension("class"));
                }
            });
            this.parametersInitializer.setDebugHandler(this.element.getAttribute(DebugParametersInitializersRegistry.HANDLER_ATTRIBUTE));
            return this.parametersInitializer;
        }

        static /* synthetic */ void access$1(DebugParametersInitializerFactory debugParametersInitializerFactory, IDebugParametersInitializer iDebugParametersInitializer) {
            debugParametersInitializerFactory.parametersInitializer = iDebugParametersInitializer;
        }
    }
}

