/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.Logger;
import org.eclipse.php.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPBlock;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.ui.editor.util.PHPDocBlockSerialezer;
import org.eclipse.php.internal.ui.editor.util.PHPDocTool;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.util.EditorUtility;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class AddDescriptionAction
implements IObjectActionDelegate {
    private PHPCodeData phpCodeData;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    public void run(IAction iAction) {
        IEditorPart iEditorPart;
        UserData userData = this.phpCodeData.getUserData();
        String string = userData.getFileName();
        IFile iFile = PHPUiPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string));
        try {
            iEditorPart = EditorUtility.openInEditor(iFile, true);
        }
        catch (PartInitException partInitException) {
            Logger.logException(partInitException);
            return;
        }
        PHPStructuredEditor pHPStructuredEditor = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)iEditorPart);
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        IDocument iDocument = pHPStructuredEditor.getDocumentProvider().getDocument((Object)iEditorInput);
        if (this.phpCodeData instanceof PHPFileData) {
            this.handleFileDocBlock((PHPFileData)this.phpCodeData, (IStructuredDocument)iDocument);
        }
        PHPDocBlock pHPDocBlock = PHPDocTool.createPhpDoc((CodeData)this.phpCodeData, iDocument);
        int n = this.getCodeDataOffset();
        String string2 = this.insertDocBlock((CodeData)this.phpCodeData, (IStructuredDocument)iDocument, n);
        if (string2 == null) {
            return;
        }
        String string3 = pHPDocBlock.getShortDescription();
        int n2 = string2.indexOf(string3);
        int n3 = n + n2;
        EditorUtility.revealInEditor((IEditorPart)pHPStructuredEditor, n3, string3.length());
    }

    private int getCodeDataOffset() {
        if (this.phpCodeData instanceof PHPFileData) {
            PHPBlock[] pHPBlockArray = ((PHPFileData)this.phpCodeData).getPHPBlocks();
            return pHPBlockArray.length > 0 ? pHPBlockArray[0].getPHPStartTag().getEndPosition() : -1;
        }
        int n = this.phpCodeData.getUserData().getStartPosition();
        return n;
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        if (iSelection == null || !(iSelection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        this.phpCodeData = (PHPCodeData)iStructuredSelection.getFirstElement();
    }

    private void handleFileDocBlock(PHPFileData pHPFileData, IStructuredDocument iStructuredDocument) {
        IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getFirstStructuredDocumentRegion();
        while (iStructuredDocumentRegion != null && iStructuredDocumentRegion.getType() != "PHP_CONTENT") {
            iStructuredDocumentRegion = iStructuredDocumentRegion.getNext();
        }
        if (iStructuredDocumentRegion == null) {
            return;
        }
        ITextRegion iTextRegion = iStructuredDocumentRegion.getFirstRegion();
        int n = iTextRegion.getEnd();
        iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(iStructuredDocumentRegion.getStartOffset() + n + 1);
        if (iTextRegion == null) {
            return;
        }
        if (iTextRegion.getType() == "PHP_CLASS") {
            this.addClassBlock(iStructuredDocument, pHPFileData, iTextRegion.getStart() + iStructuredDocumentRegion.getStartOffset());
        } else if (iTextRegion.getType() == "PHP_FUNCTION") {
            this.addFunctionBlock(iStructuredDocument, pHPFileData, iTextRegion.getStart() + iStructuredDocumentRegion.getStartOffset());
        } else if (iTextRegion.getType() == "PHP_STRING" && iStructuredDocumentRegion.getFullText(iTextRegion).trim().equalsIgnoreCase("define")) {
            this.addConstantBlock(iStructuredDocument, pHPFileData, iTextRegion.getStart() + iStructuredDocumentRegion.getStartOffset());
        }
    }

    private void addConstantBlock(IStructuredDocument iStructuredDocument, PHPFileData pHPFileData, int n) {
        PHPConstantData[] pHPConstantDataArray = pHPFileData.getConstants();
        if (pHPConstantDataArray.length > 0 && pHPConstantDataArray[0].getUserData().getStartPosition() == n) {
            this.insertDocBlock((CodeData)pHPConstantDataArray[0], iStructuredDocument, n);
        }
    }

    private void addFunctionBlock(IStructuredDocument iStructuredDocument, PHPFileData pHPFileData, int n) {
        PHPFunctionData[] pHPFunctionDataArray = pHPFileData.getFunctions();
        if (pHPFunctionDataArray.length > 0 && pHPFunctionDataArray[0].getUserData().getStartPosition() == n) {
            this.insertDocBlock((CodeData)pHPFunctionDataArray[0], iStructuredDocument, n);
        }
    }

    private void addClassBlock(IStructuredDocument iStructuredDocument, PHPFileData pHPFileData, int n) {
        PHPClassData[] pHPClassDataArray = pHPFileData.getClasses();
        if (pHPClassDataArray.length > 0 && pHPClassDataArray[0].getUserData().getStartPosition() == n) {
            this.insertDocBlock((CodeData)pHPClassDataArray[0], iStructuredDocument, n);
        }
    }

    private String insertDocBlock(CodeData codeData, IStructuredDocument iStructuredDocument, int n) {
        PHPDocBlock pHPDocBlock = PHPDocTool.createPhpDoc(codeData, (IDocument)iStructuredDocument);
        String string = PHPDocBlockSerialezer.instance().createDocBlockText(iStructuredDocument, pHPDocBlock, n, true);
        try {
            iStructuredDocument.replace(n, 0, string);
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
            string = null;
        }
        return string;
    }
}

