/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.php.core.phpModel.PHPModelUtil;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.UserData;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.util.IProblemChangedListener;
import org.eclipse.php.ui.util.PHPPluginImages;

public class ProblemsLabelDecorator
implements ILightweightLabelDecorator {
    private static final int ERRORTICK_WARNING = 32;
    private static final int ERRORTICK_ERROR = 64;
    private IProblemChangedListener fProblemChangedListener;
    private Collection fListeners;

    protected int computeAdornmentFlags(Object object) {
        try {
            if (object instanceof PHPProjectModel) {
                object = PHPWorkspaceModelManager.getInstance().getProjectForModel((PHPProjectModel)object);
            }
            if (object instanceof PHPCodeData) {
                IResource iResource = PHPModelUtil.getResource((Object)object);
                return this.getErrorTicksFromMarkers(iResource, 1, (PHPCodeData)object);
            }
            if (object instanceof IResource) {
                return this.getErrorTicksFromMarkers((IResource)object, 2, null);
            }
        }
        catch (CoreException coreException) {
            if (coreException.getStatus().getCode() == 376) {
                return 0;
            }
            PHPUiPlugin.log(coreException);
        }
        return 0;
    }

    private int getErrorTicksFromMarkers(IResource iResource, int n, PHPCodeData pHPCodeData) throws CoreException {
        if (iResource == null || !iResource.isAccessible()) {
            return 0;
        }
        int n2 = 0;
        IMarker[] iMarkerArray = iResource.findMarkers("org.eclipse.core.resources.problemmarker", true, n);
        if (iMarkerArray != null) {
            int n3 = 0;
            while (n3 < iMarkerArray.length && n2 != 64) {
                IMarker iMarker = iMarkerArray[n3];
                if (pHPCodeData == null || this.isMarkerInRange(iMarker, pHPCodeData)) {
                    int n4 = iMarker.getAttribute("severity", -1);
                    if (n4 == 1) {
                        n2 = 32;
                    } else if (n4 == 2) {
                        n2 = 64;
                    }
                }
                ++n3;
            }
        }
        return n2;
    }

    private boolean isMarkerInRange(IMarker iMarker, PHPCodeData pHPCodeData) throws CoreException {
        if (iMarker.isSubtypeOf("org.eclipse.core.resources.textmarker")) {
            int n = iMarker.getAttribute("charStart", -1);
            return this.isInside(n, pHPCodeData);
        }
        return false;
    }

    protected boolean isInside(int n, PHPCodeData pHPCodeData) throws CoreException {
        UserData userData = pHPCodeData.getUserData();
        if (userData != null) {
            int n2 = userData.getStartPosition();
            return n2 <= n && userData.getStopPosition() > n;
        }
        return false;
    }

    public void dispose() {
        if (this.fProblemChangedListener != null) {
            PHPUiPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
            this.fProblemChangedListener = null;
        }
    }

    public boolean isLabelProperty(Object object, String string) {
        return true;
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
        if (this.fListeners == null) {
            this.fListeners = new ArrayList();
        }
        this.fListeners.add(iLabelProviderListener);
        if (this.fProblemChangedListener == null) {
            this.fProblemChangedListener = new IProblemChangedListener(){

                public void problemsChanged(IResource[] iResourceArray, boolean bl) {
                    ProblemsLabelDecorator.this.fireProblemsChanged(iResourceArray, bl);
                }
            };
            PHPUiPlugin.getDefault().getProblemMarkerManager().addListener(this.fProblemChangedListener);
        }
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        if (this.fListeners != null) {
            this.fListeners.remove(iLabelProviderListener);
            if (this.fListeners.isEmpty() && this.fProblemChangedListener != null) {
                PHPUiPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
                this.fProblemChangedListener = null;
            }
        }
    }

    private void fireProblemsChanged(IResource[] iResourceArray, boolean bl) {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            ProblemsLabelChangedEvent problemsLabelChangedEvent = new ProblemsLabelChangedEvent((IBaseLabelProvider)this, iResourceArray, bl);
            Object[] objectArray = this.fListeners.toArray();
            int n = 0;
            while (n < objectArray.length) {
                ((ILabelProviderListener)objectArray[n]).labelProviderChanged((LabelProviderChangedEvent)problemsLabelChangedEvent);
                ++n;
            }
        }
    }

    public void decorate(Object object, IDecoration iDecoration) {
        int n = this.computeAdornmentFlags(object);
        if (n == 64) {
            iDecoration.addOverlay(PHPPluginImages.DESC_OVR_ERROR);
        } else if (n == 32) {
            iDecoration.addOverlay(PHPPluginImages.DESC_OVR_WARNING);
        }
    }

    public static class ProblemsLabelChangedEvent
    extends LabelProviderChangedEvent {
        private boolean fMarkerChange;

        public ProblemsLabelChangedEvent(IBaseLabelProvider iBaseLabelProvider, IResource[] iResourceArray, boolean bl) {
            super(iBaseLabelProvider, (Object[])iResourceArray);
            this.fMarkerChange = bl;
        }

        public boolean isMarkerChange() {
            return this.fMarkerChange;
        }
    }
}

