/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDAnnotationImpl;
import org.eclipse.xsd.impl.XSDConcreteComponentImpl;
import org.eclipse.xsd.impl.XSDFeatureImpl;
import org.eclipse.xsd.impl.XSDSimpleTypeDefinitionImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDAttributeDeclarationImpl
extends XSDFeatureImpl
implements XSDAttributeDeclaration {
    protected static final boolean ATTRIBUTE_DECLARATION_REFERENCE_EDEFAULT = false;
    protected XSDAnnotation annotation = null;
    protected XSDSimpleTypeDefinition anonymousTypeDefinition = null;
    protected XSDSimpleTypeDefinition typeDefinition = null;
    protected XSDAttributeDeclaration resolvedAttributeDeclaration = this;
    protected boolean isTypeExplicit = false;

    public static XSDAttributeDeclaration createAttributeDeclaration(Node node) {
        if (XSDConstants.nodeType(node) == 5) {
            XSDAttributeDeclaration xsdAttributeDeclaration = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
            xsdAttributeDeclaration.setElement((Element)node);
            return xsdAttributeDeclaration;
        }
        return null;
    }

    protected XSDAttributeDeclarationImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_ATTRIBUTE_DECLARATION;
    }

    public Boolean getAttributeDeclarationReference() {
        return this.isAttributeDeclarationReference() ? Boolean.TRUE : Boolean.FALSE;
    }

    public Element createElement() {
        Element newElement = this.createElement(5);
        this.setElement(newElement);
        XSDSimpleTypeDefinition anonymousTypeDefinition = this.getAnonymousTypeDefinition();
        if (anonymousTypeDefinition != null) {
            Element child = ((XSDConcreteComponentImpl)((Object)anonymousTypeDefinition)).createElement();
            newElement.appendChild(child);
        }
        return newElement;
    }

    protected void patch() {
        super.patch();
        XSDAttributeDeclaration theResolvedAttributeDeclaration = this.getResolvedAttributeDeclaration();
        if (theResolvedAttributeDeclaration == this) {
            XSDSimpleTypeDefinition typeDefinition = this.getTypeDefinition();
            if (typeDefinition != null && (this.forceResolve || typeDefinition.getContainer() == null)) {
                XSDSimpleTypeDefinition newTypeDefinition = this.resolveSimpleTypeDefinition(typeDefinition.getTargetNamespace(), typeDefinition.getName());
                if (this.forceResolve || newTypeDefinition.getContainer() != null & newTypeDefinition != typeDefinition) {
                    this.setTypeDefinition(newTypeDefinition);
                }
            }
        } else {
            XSDAttributeDeclaration newResolvedAttributeDeclaration = this.resolveAttributeDeclaration(theResolvedAttributeDeclaration.getTargetNamespace(), theResolvedAttributeDeclaration.getName());
            if (newResolvedAttributeDeclaration != theResolvedAttributeDeclaration) {
                this.setResolvedAttributeDeclaration(newResolvedAttributeDeclaration);
            }
        }
    }

    protected void patchTargetNamespaceAttribute() {
        XSDSchema xsdSchema;
        if (!this.isAttributeDeclarationReference() && (xsdSchema = this.getSchema()) != null) {
            if (this.getScope() instanceof XSDSchema && (!this.isSetForm() || XSDForm.QUALIFIED_LITERAL != this.getForm())) {
                this.setForm(XSDForm.QUALIFIED_LITERAL);
            }
            if (this.isSetForm() ? this.getForm() == XSDForm.UNQUALIFIED_LITERAL : xsdSchema.getAttributeFormDefault() == XSDForm.UNQUALIFIED_LITERAL) {
                if (this.getTargetNamespace() != null) {
                    this.setTargetNamespace(null);
                }
            } else {
                String newTargetNamespace = xsdSchema.getTargetNamespace();
                if (newTargetNamespace == null ? this.getTargetNamespace() != null : !newTargetNamespace.equals(this.getTargetNamespace())) {
                    this.setTargetNamespace(newTargetNamespace);
                }
            }
        }
    }

    protected boolean analyze() {
        if (!this.isAttributeDeclarationReference()) {
            XSDSimpleTypeDefinition newTypeDefinition;
            XSDSimpleTypeDefinition theTypeDefinition = this.getTypeDefinition();
            if (!(this.isTypeExplicit && theTypeDefinition != null || (newTypeDefinition = this.getSchema().getSchemaForSchema().resolveSimpleTypeDefinition("anySimpleType")) == theTypeDefinition)) {
                this.isTypeExplicit = false;
                this.setTypeDefinitionGen(newTypeDefinition);
            }
        }
        return super.analyze();
    }

    public void validate() {
        super.validate();
        Element theElement = this.getElement();
        if (theElement != null) {
            if (this.getContainer() instanceof XSDSchema) {
                this.checkAttributes("http://www.w3.org/TR/xmlschema-1/", "element-attribute", theElement, new String[]{"default", "fixed", "id", "name", "type"});
                this.checkComplexContent("topLevelAttribute", "http://www.w3.org/TR/xmlschema-1/", "element-attribute", theElement);
            } else {
                this.checkAttributes("http://www.w3.org/TR/xmlschema-1/", "element-attribute", theElement, new String[]{"default", "fixed", "form", "id", "name", "ref", "type", "use"});
                this.checkComplexContent("attribute", "http://www.w3.org/TR/xmlschema-1/", "element-attribute", theElement);
                this.checkAttributeTypeConstraint("attribute", "use", null, "http://www.w3.org/TR/xmlschema-1/", "element-attribute", theElement, "use", false);
                this.checkBuiltInTypeConstraint("formChoice", null, "http://www.w3.org/TR/xmlschema-1/", "element-attribute", theElement, "form", false);
            }
            if (theElement.hasAttributeNS(null, "fixed") && theElement.hasAttributeNS(null, "default")) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-attribute.1");
            }
            this.checkBuiltInTypeConstraint("ID", null, "http://www.w3.org/TR/xmlschema-1/", "element-attribute", theElement, "id", false);
            if (theElement.hasAttributeNS(null, "type")) {
                Node child = this.element.getFirstChild();
                while (child != null) {
                    if (XSDConstants.nodeType(child) == 37) {
                        this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-attribute.4");
                        break;
                    }
                    child = child.getNextSibling();
                }
            }
        }
        if (this.isAttributeDeclarationReference()) {
            XSDAttributeDeclaration theResolvedAttributeDeclaration = this.getResolvedAttributeDeclaration();
            if (theResolvedAttributeDeclaration.getContainer() == null) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "_UI_UnresolvedAttributeDeclaration_message", theResolvedAttributeDeclaration.getURI());
            }
            if (this.getName() != null || theElement != null && theElement.hasAttributeNS(null, "name")) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-attribute.3.1");
            }
            if (this.isSetForm() || theElement != null && theElement.hasAttributeNS(null, "form")) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-attribute.3.2.1");
            }
            if (this.getType() != null || theElement != null && theElement.hasAttributeNS(null, "type")) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-attribute.3.2.2");
            } else if (theElement != null) {
                Node child = this.element.getFirstChild();
                while (child != null) {
                    if (XSDConstants.nodeType(child) == 37) {
                        this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-attribute.3.2.2");
                        break;
                    }
                    child = child.getNextSibling();
                }
            }
        } else {
            XSDSimpleTypeDefinition theTypeDefinition;
            this.checkBuiltInTypeConstraint("NCName", this.getName(), "http://www.w3.org/TR/xmlschema-1/", "element-attribute", theElement, "name", true);
            if ("xmlns".equals(this.getName())) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "no-xmlns");
            }
            if (XSDConstants.isSchemaInstanceNamespace(this.getTargetNamespace())) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "no-xsi");
            }
            if ((theTypeDefinition = this.getTypeDefinition()) == null || theTypeDefinition.getContainer() == null) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "_UI_UnresolvedTypeDefinition_message", theTypeDefinition == null ? "" : theTypeDefinition.getURI());
            }
            if (theTypeDefinition != null && this.getLexicalValue() != null) {
                if (XSDConstants.isOrIsDerivedFromID(theTypeDefinition)) {
                    this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "coss-attribute.3");
                } else {
                    this.checkSimpleTypeConstraint(theTypeDefinition, this.getLexicalValue(), "http://www.w3.org/TR/xmlschema-1/", "element-attribute", theElement, this.getConstraint() == XSDConstraint.FIXED_LITERAL ? "fixed" : "default", false);
                }
            }
        }
    }

    protected void reconcileAttributes(Element changedElement) {
        super.reconcileAttributes(changedElement);
        if (changedElement == this.getElement()) {
            XSDAttributeDeclaration newResolvedAttributeDeclaration = this;
            if (changedElement.hasAttributeNS(null, "ref")) {
                newResolvedAttributeDeclaration = this.resolveAttributeDeclarationURI(XSDConstants.lookupQNameForAttribute(changedElement, "ref"));
            }
            if (newResolvedAttributeDeclaration != this.getResolvedAttributeDeclaration()) {
                this.setResolvedAttributeDeclaration(newResolvedAttributeDeclaration);
            }
            if (this == newResolvedAttributeDeclaration) {
                if (changedElement.hasAttributeNS(null, "type")) {
                    XSDSimpleTypeDefinition newTypeDefinition = this.resolveSimpleTypeDefinitionURI(XSDConstants.lookupQNameForAttribute(changedElement, "type"));
                    if (newTypeDefinition != this.getTypeDefinition()) {
                        this.setTypeDefinition(newTypeDefinition);
                    }
                } else if (this.getAnonymousTypeDefinition() != this.getTypeDefinition()) {
                    this.isTypeExplicit = false;
                    this.setTypeDefinitionGen(this.resolveSimpleTypeDefinition(changedElement.getNamespaceURI(), "anySimpleType"));
                }
                if (this.getScope() instanceof XSDSchema) {
                    if (this.getForm() != XSDForm.QUALIFIED_LITERAL) {
                        this.setForm(XSDForm.QUALIFIED_LITERAL);
                    }
                } else if (changedElement.hasAttributeNS(null, "form")) {
                    XSDForm newForm = XSDForm.get(changedElement.getAttributeNS(null, "form"));
                    if (!this.isSetForm() || newForm != this.getForm()) {
                        this.setForm(newForm);
                    }
                } else if (this.isSetForm()) {
                    this.unsetForm();
                }
            }
        }
    }

    protected void reconcileNameAttribute() {
        if (!this.isAttributeDeclarationReference()) {
            super.reconcileNameAttribute();
        }
    }

    protected void handleUnreconciledElement(Element child, List newContents, List remainingContents) {
        XSDAnnotation xsdAnnotation = XSDAnnotationImpl.createAnnotation(child);
        if (xsdAnnotation != null) {
            if (newContents.isEmpty()) {
                newContents.add(xsdAnnotation);
            }
        } else {
            XSDSimpleTypeDefinition xsdSimpleTypeDefinition = XSDSimpleTypeDefinitionImpl.createSimpleTypeDefinition(child);
            if (xsdSimpleTypeDefinition != null) {
                newContents.add(xsdSimpleTypeDefinition);
            }
        }
    }

    protected void handleReconciliation(List newContents, List remainingContents) {
        this.handleAnnotationReconciliation(XSDPackage.Literals.XSD_ATTRIBUTE_DECLARATION__ANNOTATION, newContents, remainingContents);
        if (!this.isAttributeDeclarationReference()) {
            Element theElement = this.getElement();
            XSDSimpleTypeDefinition newTypeDefinition = null;
            if (newContents.isEmpty()) {
                if (!remainingContents.isEmpty()) {
                    this.setAnonymousTypeDefinition(null);
                }
            } else {
                newTypeDefinition = (XSDSimpleTypeDefinition)newContents.get(0);
                this.setAnonymousTypeDefinition(newTypeDefinition);
            }
            if (theElement.hasAttributeNS(null, "type")) {
                newTypeDefinition = this.resolveSimpleTypeDefinitionURI(XSDConstants.lookupQNameForAttribute(theElement, "type"));
            }
            if (newTypeDefinition == null) {
                newTypeDefinition = this.resolveSimpleTypeDefinition(theElement.getNamespaceURI(), "anySimpleType");
            }
            if (newTypeDefinition != this.getTypeDefinition()) {
                this.setTypeDefinition(newTypeDefinition);
            }
        }
    }

    protected void changeAttribute(EAttribute eAttribute) {
        super.changeAttribute(eAttribute);
        if (!this.isAttributeDeclarationReference()) {
            Element theElement = this.getElement();
            if (!(theElement == null || eAttribute != null && eAttribute != XSDPackage.Literals.XSD_FEATURE__FORM || this.getScope() instanceof XSDSchema)) {
                this.niceSetAttribute(theElement, "form", this.isSetForm() ? this.getForm().getName() : null);
            }
            if (eAttribute == XSDPackage.Literals.XSD_FEATURE__FORM) {
                this.patchTargetNamespaceAttribute();
            }
        }
    }

    protected void changeReference(EReference eReference) {
        super.changeReference(eReference);
        Element theElement = this.getElement();
        if (this.isAttributeDeclarationReference()) {
            XSDAttributeDeclaration theResolvedAttributeDeclaration = this.getResolvedAttributeDeclaration();
            if (eReference == null || eReference == XSDPackage.Literals.XSD_ATTRIBUTE_DECLARATION__RESOLVED_ATTRIBUTE_DECLARATION) {
                if (theElement != null) {
                    this.niceSetAttributeURIValue(theElement, "ref", theResolvedAttributeDeclaration.getURI());
                }
                if (eReference != null && this.getContainer() instanceof XSDAttributeUse) {
                    ((XSDAttributeUse)this.getContainer()).setAttributeDeclaration(theResolvedAttributeDeclaration);
                }
            }
        } else {
            if (theElement != null && eReference == XSDPackage.Literals.XSD_ATTRIBUTE_DECLARATION__RESOLVED_ATTRIBUTE_DECLARATION) {
                this.niceSetAttributeURIValue(theElement, "ref", null);
            }
            if (eReference == null || eReference == XSDPackage.Literals.XSD_ATTRIBUTE_DECLARATION__TYPE_DEFINITION) {
                XSDSimpleTypeDefinition theTypeDefinition = this.getTypeDefinition();
                XSDSimpleTypeDefinition theAnonymousTypeDefinition = this.getAnonymousTypeDefinition();
                if (theTypeDefinition == null || theTypeDefinition == theAnonymousTypeDefinition || XSDConstants.isURType(theTypeDefinition) || !this.isTypeExplicit) {
                    if (theElement != null) {
                        this.niceSetAttribute(theElement, "type", null);
                    }
                } else {
                    if (theElement != null) {
                        this.niceSetAttributeURIValue(theElement, "type", theTypeDefinition.getURI());
                    }
                    if (eReference != null && theAnonymousTypeDefinition != null) {
                        this.setAnonymousTypeDefinition(null);
                    }
                }
                if (eReference != null) {
                    this.isTypeExplicit = true;
                }
            }
        }
    }

    protected void adoptContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.adoptContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.Literals.XSD_ATTRIBUTE_DECLARATION__ANONYMOUS_TYPE_DEFINITION) {
            this.setTypeDefinition((XSDSimpleTypeDefinition)xsdConcreteComponent);
        }
    }

    protected void orphanContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.orphanContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.Literals.XSD_ATTRIBUTE_DECLARATION__ANONYMOUS_TYPE_DEFINITION && this.getTypeDefinition() == xsdConcreteComponent) {
            this.setTypeDefinition(null);
        }
    }

    public boolean isAttributeDeclarationReference() {
        return this != this.getResolvedAttributeDeclaration();
    }

    public XSDAnnotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(XSDAnnotation newAnnotation) {
        if (newAnnotation != this.annotation) {
            NotificationChain msgs = null;
            if (this.annotation != null) {
                msgs = ((InternalEObject)this.annotation).eInverseRemove((InternalEObject)this, -22, null, msgs);
            }
            if (newAnnotation != null) {
                msgs = ((InternalEObject)newAnnotation).eInverseAdd((InternalEObject)this, -22, null, msgs);
            }
            if ((msgs = this.basicSetAnnotation(newAnnotation, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 21, (Object)newAnnotation, (Object)newAnnotation));
        }
    }

    public NotificationChain basicSetAnnotation(XSDAnnotation newAnnotation, NotificationChain msgs) {
        XSDAnnotation oldAnnotation = this.annotation;
        this.annotation = newAnnotation;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 21, (Object)oldAnnotation, (Object)newAnnotation);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public XSDSimpleTypeDefinition getAnonymousTypeDefinition() {
        return this.anonymousTypeDefinition;
    }

    public void setAnonymousTypeDefinition(XSDSimpleTypeDefinition newAnonymousTypeDefinition) {
        if (newAnonymousTypeDefinition != this.anonymousTypeDefinition) {
            NotificationChain msgs = null;
            if (this.anonymousTypeDefinition != null) {
                msgs = ((InternalEObject)this.anonymousTypeDefinition).eInverseRemove((InternalEObject)this, -23, null, msgs);
            }
            if (newAnonymousTypeDefinition != null) {
                msgs = ((InternalEObject)newAnonymousTypeDefinition).eInverseAdd((InternalEObject)this, -23, null, msgs);
            }
            if ((msgs = this.basicSetAnonymousTypeDefinition(newAnonymousTypeDefinition, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 22, (Object)newAnonymousTypeDefinition, (Object)newAnonymousTypeDefinition));
        }
    }

    public NotificationChain basicSetAnonymousTypeDefinition(XSDSimpleTypeDefinition newAnonymousTypeDefinition, NotificationChain msgs) {
        XSDSimpleTypeDefinition oldAnonymousTypeDefinition = this.anonymousTypeDefinition;
        this.anonymousTypeDefinition = newAnonymousTypeDefinition;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 22, (Object)oldAnonymousTypeDefinition, (Object)newAnonymousTypeDefinition);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public XSDSimpleTypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }

    public void setTypeDefinitionGen(XSDSimpleTypeDefinition newTypeDefinition) {
        XSDSimpleTypeDefinition oldTypeDefinition = this.typeDefinition;
        this.typeDefinition = newTypeDefinition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 23, (Object)oldTypeDefinition, (Object)this.typeDefinition));
        }
    }

    public void setTypeDefinition(XSDSimpleTypeDefinition newTypeDefinition) {
        this.isTypeExplicit = newTypeDefinition != null;
        this.setTypeDefinitionGen(newTypeDefinition);
    }

    public XSDAttributeDeclaration getResolvedAttributeDeclaration() {
        return this.resolvedAttributeDeclaration;
    }

    public void setResolvedAttributeDeclaration(XSDAttributeDeclaration newResolvedAttributeDeclaration) {
        XSDAttributeDeclaration oldResolvedAttributeDeclaration = this.resolvedAttributeDeclaration;
        this.resolvedAttributeDeclaration = newResolvedAttributeDeclaration;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 24, (Object)oldResolvedAttributeDeclaration, (Object)this.resolvedAttributeDeclaration));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 21: {
                return this.basicSetAnnotation(null, msgs);
            }
            case 22: {
                return this.basicSetAnonymousTypeDefinition(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 20: {
                return this.isAttributeDeclarationReference() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 21: {
                return this.getAnnotation();
            }
            case 22: {
                return this.getAnonymousTypeDefinition();
            }
            case 23: {
                return this.getTypeDefinition();
            }
            case 24: {
                return this.getResolvedAttributeDeclaration();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 21: {
                this.setAnnotation((XSDAnnotation)newValue);
                return;
            }
            case 22: {
                this.setAnonymousTypeDefinition((XSDSimpleTypeDefinition)newValue);
                return;
            }
            case 23: {
                this.setTypeDefinition((XSDSimpleTypeDefinition)newValue);
                return;
            }
            case 24: {
                this.setResolvedAttributeDeclaration((XSDAttributeDeclaration)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 21: {
                this.setAnnotation(null);
                return;
            }
            case 22: {
                this.setAnonymousTypeDefinition(null);
                return;
            }
            case 23: {
                this.setTypeDefinition(null);
                return;
            }
            case 24: {
                this.setResolvedAttributeDeclaration(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 20: {
                return this.isAttributeDeclarationReference();
            }
            case 21: {
                return this.annotation != null;
            }
            case 22: {
                return this.anonymousTypeDefinition != null;
            }
            case 23: {
                return this.typeDefinition != null;
            }
            case 24: {
                return this.resolvedAttributeDeclaration != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String getQName() {
        XSDAttributeDeclaration resolvedAttributeDeclaration = this.getResolvedAttributeDeclaration();
        if (resolvedAttributeDeclaration == this) {
            return super.getQName();
        }
        return resolvedAttributeDeclaration.getQName(this);
    }

    public boolean isNamedComponentReference() {
        return this.isAttributeDeclarationReference();
    }

    public XSDNamedComponent getResolvedNamedComponent() {
        return this.getResolvedAttributeDeclaration();
    }

    public boolean isFeatureReference() {
        return this.isAttributeDeclarationReference();
    }

    public XSDFeature getResolvedFeature() {
        return this.getResolvedAttributeDeclaration();
    }

    public XSDTypeDefinition getType() {
        return this.getTypeDefinition();
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDAttributeDeclarationImpl clonedAttributeDeclaration = (XSDAttributeDeclarationImpl)this.getXSDFactory().createXSDAttributeDeclaration();
        clonedAttributeDeclaration.isReconciling = true;
        if (this.isAttributeDeclarationReference()) {
            XSDAttributeDeclaration theResolvedAttributeDeclaration = this.getResolvedAttributeDeclaration();
            clonedAttributeDeclaration.setResolvedAttributeDeclaration(this.createUnresolvedAttributeDeclaration(theResolvedAttributeDeclaration.getTargetNamespace(), theResolvedAttributeDeclaration.getName()));
        } else {
            if (this.getName() != null) {
                clonedAttributeDeclaration.setName(this.getName());
            }
            if (this.isSetForm()) {
                clonedAttributeDeclaration.setForm(this.getForm());
            }
            if (this.isSetConstraint()) {
                clonedAttributeDeclaration.setConstraint(this.getConstraint());
            }
            if (this.getLexicalValue() != null) {
                clonedAttributeDeclaration.setLexicalValue(this.getLexicalValue());
            }
            if (this.getTypeDefinition() != null && this.getTypeDefinition() != this.getAnonymousTypeDefinition()) {
                XSDSimpleTypeDefinition theTypeDefinition = this.getTypeDefinition();
                clonedAttributeDeclaration.setTypeDefinition(this.createUnresolvedSimpleTypeDefinition(theTypeDefinition.getTargetNamespace(), theTypeDefinition.getName()));
            }
            if (deep && this.getAnonymousTypeDefinition() != null) {
                clonedAttributeDeclaration.setAnonymousTypeDefinition((XSDSimpleTypeDefinition)this.getAnonymousTypeDefinition().cloneConcreteComponent(deep, shareDOM));
            }
        }
        if (deep && this.getAnnotation() != null) {
            clonedAttributeDeclaration.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(deep, shareDOM));
        }
        if (shareDOM && this.getElement() != null) {
            clonedAttributeDeclaration.setElement(this.getElement());
        }
        clonedAttributeDeclaration.isReconciling = shareDOM;
        return clonedAttributeDeclaration;
    }
}

