/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.server.ui;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.server.PHPServerUIMessages;
import org.eclipse.php.server.core.Server;
import org.eclipse.php.ui.util.SWTUtil;
import org.eclipse.php.ui.wizards.CompositeFragment;
import org.eclipse.php.ui.wizards.ICompositeFragmentFactory;
import org.eclipse.php.ui.wizards.IControlHandler;
import org.eclipse.php.ui.wizards.WizardFragmentsFactoryRegistry;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ServerEditDialog
extends TitleAreaDialog
implements IControlHandler {
    protected static final String FRAGMENT_GROUP_ID = "org.eclipse.php.server.ui.serverWizardAndComposite";
    private Server server;
    private ArrayList runtimeComposites;
    private SelectionListener tabsListener;

    public ServerEditDialog(Shell shell, Server server) {
        super(shell);
        this.server = server;
        this.runtimeComposites = new ArrayList(3);
    }

    protected Control createDialogArea(Composite composite) {
        CTabFolder cTabFolder = SWTUtil.createTabFolder((Composite)composite);
        ICompositeFragmentFactory[] iCompositeFragmentFactoryArray = WizardFragmentsFactoryRegistry.getFragmentsFactories((String)FRAGMENT_GROUP_ID);
        int n = 0;
        while (n < iCompositeFragmentFactoryArray.length) {
            CTabItem cTabItem = new CTabItem(cTabFolder, 2048);
            CompositeFragment compositeFragment = iCompositeFragmentFactoryArray[n].createComposite((Composite)cTabFolder, (IControlHandler)this);
            compositeFragment.setData((Object)this.server);
            cTabItem.setText(compositeFragment.getDisplayName());
            cTabItem.setControl((Control)compositeFragment);
            this.runtimeComposites.add(compositeFragment);
            ++n;
        }
        this.getShell().setText(PHPServerUIMessages.getString("ServerEditDialog.editServer"));
        this.tabsListener = new TabsSelectionListener();
        cTabFolder.addSelectionListener(this.tabsListener);
        return cTabFolder;
    }

    protected void cancelPressed() {
        Iterator iterator = this.runtimeComposites.iterator();
        while (iterator.hasNext()) {
            ((CompositeFragment)iterator.next()).performCancel();
        }
        super.cancelPressed();
    }

    protected void okPressed() {
        Iterator iterator = this.runtimeComposites.iterator();
        while (iterator.hasNext()) {
            ((CompositeFragment)iterator.next()).performOk();
        }
        super.okPressed();
    }

    public void setDescription(String string) {
        super.setMessage(string);
    }

    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        super.setTitleImage(imageDescriptor.createImage());
    }

    public void update() {
        Button button = this.getButton(0);
        if (button != null) {
            Iterator iterator = this.runtimeComposites.iterator();
            while (iterator.hasNext()) {
                if (((CompositeFragment)iterator.next()).isComplete()) continue;
                button.setEnabled(false);
                return;
            }
            button.setEnabled(true);
        }
    }

    public void setMessage(String string, int n) {
        if (n == 2) {
            n = 1;
        }
        super.setMessage(string, n);
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    private class TabsSelectionListener
    implements SelectionListener {
        private TabsSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            CTabItem cTabItem = (CTabItem)selectionEvent.item;
            CompositeFragment compositeFragment = (CompositeFragment)cTabItem.getControl();
            ServerEditDialog.this.setTitle(compositeFragment.getTitle());
            ServerEditDialog.this.setDescription(compositeFragment.getDescription());
        }
    }
}

