/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.util.CollectionUtils;

public class ParentChecker {
    private IResource[] fResources;
    private PHPCodeData[] fPHPElements;

    public ParentChecker(IResource[] iResourceArray, PHPCodeData[] pHPCodeDataArray) {
        this.fResources = iResourceArray;
        this.fPHPElements = pHPCodeDataArray;
    }

    public boolean haveCommonParent() {
        return this.getCommonParent() != null;
    }

    public Object getCommonParent() {
        if (this.fPHPElements.length == 0 && this.fResources.length == 0) {
            return null;
        }
        if (!this.resourcesHaveCommonParent() || !this.phpElementsHaveCommonParent()) {
            return null;
        }
        if (this.fPHPElements.length == 0) {
            IResource iResource = this.getCommonResourceParent();
            PHPCodeData pHPCodeData = ParentChecker.getPHPCodeData(iResource);
            if (pHPCodeData != null) {
                return pHPCodeData;
            }
            return iResource;
        }
        if (this.fResources.length == 0) {
            return this.getCommonPHPElementParent();
        }
        IResource iResource = this.getCommonResourceParent();
        PHPCodeData pHPCodeData = this.getCommonPHPElementParent();
        PHPCodeData pHPCodeData2 = ParentChecker.getPHPCodeData(iResource);
        if (pHPCodeData2 == null || !pHPCodeData.equals(pHPCodeData2)) {
            return null;
        }
        return pHPCodeData;
    }

    private static PHPCodeData getPHPCodeData(IResource iResource) {
        return PHPWorkspaceModelManager.getInstance().getModelForFile((IFile)iResource, false);
    }

    private PHPCodeData getCommonPHPElementParent() {
        return this.fPHPElements[0].getContainer();
    }

    private IResource getCommonResourceParent() {
        return this.fResources[0].getParent();
    }

    private boolean phpElementsHaveCommonParent() {
        if (this.fPHPElements.length == 0) {
            return true;
        }
        PHPCodeData pHPCodeData = this.fPHPElements[0].getContainer();
        int n = 1;
        while (n < this.fPHPElements.length) {
            if (!pHPCodeData.equals(this.fPHPElements[n].getContainer())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean resourcesHaveCommonParent() {
        if (this.fResources.length == 0) {
            return true;
        }
        IContainer iContainer = this.fResources[0].getParent();
        int n = 1;
        while (n < this.fResources.length) {
            if (!iContainer.equals((Object)this.fResources[n].getParent())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public IResource[] getResources() {
        return this.fResources;
    }

    public PHPCodeData[] getPHPElements() {
        return this.fPHPElements;
    }

    public void removeElementsWithAncestorsOnList(boolean bl) {
        if (!bl) {
            this.removeResourcesDescendantsOfResources();
            this.removeResourcesDescendantsOfPHPElements();
        }
        this.removePHPElementsDescendantsOfPHPElements();
    }

    private void removeResourcesDescendantsOfPHPElements() {
        ArrayList<IResource> arrayList = new ArrayList<IResource>(3);
        int n = 0;
        while (n < this.fResources.length) {
            IResource iResource = this.fResources[n];
            int n2 = 0;
            while (n2 < this.fPHPElements.length) {
                PHPCodeData pHPCodeData = this.fPHPElements[n2];
                if (ParentChecker.isDescendantOf(iResource, pHPCodeData)) {
                    arrayList.add(iResource);
                }
                ++n2;
            }
            ++n;
        }
        this.removeFromSetToDelete(arrayList.toArray(new IResource[arrayList.size()]));
    }

    private void removePHPElementsDescendantsOfPHPElements() {
        ArrayList<PHPCodeData> arrayList = new ArrayList<PHPCodeData>(3);
        int n = 0;
        while (n < this.fPHPElements.length) {
            PHPCodeData pHPCodeData = this.fPHPElements[n];
            int n2 = 0;
            while (n2 < this.fPHPElements.length) {
                PHPCodeData pHPCodeData2 = this.fPHPElements[n2];
                if (ParentChecker.isDescendantOf(pHPCodeData, pHPCodeData2)) {
                    arrayList.add(pHPCodeData);
                }
                ++n2;
            }
            ++n;
        }
        this.removeFromSetToDelete(arrayList.toArray(new PHPCodeData[arrayList.size()]));
    }

    private void removeResourcesDescendantsOfResources() {
        ArrayList<IResource> arrayList = new ArrayList<IResource>(3);
        int n = 0;
        while (n < this.fResources.length) {
            IResource iResource = this.fResources[n];
            int n2 = 0;
            while (n2 < this.fResources.length) {
                IResource iResource2 = this.fResources[n2];
                if (ParentChecker.isDescendantOf(iResource, iResource2)) {
                    arrayList.add(iResource);
                }
                ++n2;
            }
            ++n;
        }
        this.removeFromSetToDelete(arrayList.toArray(new IResource[arrayList.size()]));
    }

    public static boolean isDescendantOf(IResource iResource, PHPCodeData pHPCodeData) {
        IContainer iContainer = iResource.getParent();
        while (iContainer != null) {
            PHPCodeData pHPCodeData2 = ParentChecker.getPHPCodeData((IResource)iContainer);
            if (pHPCodeData2 != null && pHPCodeData2.equals(pHPCodeData)) {
                return true;
            }
            iContainer = iContainer.getParent();
        }
        return false;
    }

    public static boolean isDescendantOf(PHPCodeData pHPCodeData, PHPCodeData pHPCodeData2) {
        if (pHPCodeData.equals(pHPCodeData2)) {
            return false;
        }
        PHPCodeData pHPCodeData3 = pHPCodeData.getContainer();
        while (pHPCodeData3 != null) {
            if (pHPCodeData3.equals(pHPCodeData2)) {
                return true;
            }
            pHPCodeData3 = pHPCodeData3.getContainer();
        }
        return false;
    }

    public static boolean isDescendantOf(IResource iResource, IResource iResource2) {
        return !iResource.equals((Object)iResource2) && iResource2.getFullPath().isPrefixOf(iResource.getFullPath());
    }

    private void removeFromSetToDelete(IResource[] iResourceArray) {
        this.fResources = CollectionUtils.setMinus(this.fResources, iResourceArray);
    }

    private void removeFromSetToDelete(PHPCodeData[] pHPCodeDataArray) {
        this.fPHPElements = CollectionUtils.setMinus(this.fPHPElements, pHPCodeDataArray);
    }
}

