/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.IThreadListener;

public class WorkbenchRunnableAdapter
implements IRunnableWithProgress,
IThreadListener {
    private boolean fTransfer = false;
    private IWorkspaceRunnable fWorkspaceRunnable;
    private ISchedulingRule fRule;

    public WorkbenchRunnableAdapter(IWorkspaceRunnable iWorkspaceRunnable) {
        this(iWorkspaceRunnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    public WorkbenchRunnableAdapter(IWorkspaceRunnable iWorkspaceRunnable, ISchedulingRule iSchedulingRule) {
        this.fWorkspaceRunnable = iWorkspaceRunnable;
        this.fRule = iSchedulingRule;
    }

    public WorkbenchRunnableAdapter(IWorkspaceRunnable iWorkspaceRunnable, ISchedulingRule iSchedulingRule, boolean bl) {
        this.fWorkspaceRunnable = iWorkspaceRunnable;
        this.fRule = iSchedulingRule;
        this.fTransfer = bl;
    }

    public ISchedulingRule getSchedulingRule() {
        return this.fRule;
    }

    public void threadChange(Thread thread) {
        if (this.fTransfer) {
            Platform.getJobManager().transferRule(this.fRule, thread);
        }
    }

    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            iWorkspace.run(this.fWorkspaceRunnable, this.fRule, 1, iProgressMonitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException(operationCanceledException.getMessage());
        }
        catch (CoreException coreException) {
            throw new InvocationTargetException(coreException);
        }
    }

    public void runAsUserJob(String string, final Object object) {
        Job job = new Job(string){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor iProgressMonitor) {
                try {
                    try {
                        WorkbenchRunnableAdapter.this.run(iProgressMonitor);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Throwable throwable = invocationTargetException.getCause();
                        if (throwable instanceof CoreException) {
                            IStatus iStatus = ((CoreException)throwable).getStatus();
                            Object var4_7 = null;
                            iProgressMonitor.done();
                            return iStatus;
                        }
                        Status status = new Status(4, "org.eclipse.php.ui", 0, invocationTargetException.toString(), throwable);
                        Object var4_8 = null;
                        iProgressMonitor.done();
                        return status;
                    }
                    catch (InterruptedException interruptedException) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        Object var4_9 = null;
                        iProgressMonitor.done();
                        return iStatus;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_10 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                {
                    Object var4_11 = null;
                }
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object object2) {
                return object == object2;
            }
        };
        job.setRule(this.fRule);
        job.setUser(true);
        job.schedule();
    }
}

