/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.editor.contentassist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.core.documentModel.DOMModelForPHP;
import org.eclipse.php.core.phpModel.parser.ModelSupport;
import org.eclipse.php.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.core.phpModel.parser.PHPDocLanguageModel;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.core.util.WeakPropertyChangeListener;
import org.eclipse.php.ui.editor.contentassist.CompletionProposalGroup;
import org.eclipse.php.ui.editor.contentassist.ContentAssistSupport;
import org.eclipse.php.ui.editor.contentassist.PHPTextSequenceUtilities;
import org.eclipse.php.ui.editor.util.TextSequence;
import org.eclipse.php.ui.editor.util.TextSequenceUtilities;
import org.eclipse.php.ui.preferences.PreferenceConstants;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;

public class PHPDocContentAssistSupport
extends ContentAssistSupport {
    private static final char TAG_SIGN = '@';
    private char[] autoActivationTriggers;
    private CompletionProposalGroup phpDocCompletionProposalGroup = new ContentAssistSupport.PHPCompletionProposalGroup();
    protected IPropertyChangeListener prefChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent != null) {
                PHPDocContentAssistSupport.this.initPreferences(propertyChangeEvent.getProperty());
            }
        }
    };

    protected void initPreferences(String string) {
        if (string == null || "contentAssistAutoactivationTriggersPHPDoc".equals(string)) {
            this.autoActivationTriggers = PreferenceConstants.getPreferenceStore().getString("contentAssistAutoactivationTriggersPHPDoc").trim().toCharArray();
        }
    }

    public PHPDocContentAssistSupport() {
        this.initPreferences(null);
        PreferenceConstants.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)WeakPropertyChangeListener.create((IPropertyChangeListener)this.prefChangeListener, (Object)PreferenceConstants.getPreferenceStore()));
    }

    public char[] getAutoactivationTriggers() {
        return this.autoActivationTriggers;
    }

    protected void calcCompletionOption(DOMModelForPHP dOMModelForPHP, int n, ITextViewer iTextViewer) throws BadLocationException {
        PHPFileData pHPFileData = dOMModelForPHP.getFileData();
        if (pHPFileData == null) {
            return;
        }
        IStructuredDocumentRegion iStructuredDocumentRegion = ContentAssistUtils.getStructuredDocumentRegion((StructuredTextViewer)((StructuredTextViewer)iTextViewer), (int)n);
        int n2 = dOMModelForPHP.getStructuredDocument().getLineInformationOfOffset(n).getOffset();
        TextSequence textSequence = TextSequenceUtilities.createTextSequence(iStructuredDocumentRegion, n2, n - n2);
        int n3 = textSequence.length();
        int n4 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n3);
        int n5 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n4, true);
        String string = textSequence.subSequence(n5, n4).toString();
        boolean bl = n3 != n4;
        int n6 = ((TextSelection)iTextViewer.getSelectionProvider().getSelection()).getLength();
        if (this.isInPhpDocCompletion(iTextViewer, textSequence, n, string, n6, bl)) {
            return;
        }
        if (this.isVariableCompletion(dOMModelForPHP, pHPFileData, n, string, n6, bl)) {
            return;
        }
        this.templateProposals = this.getTemplates(iTextViewer, n);
    }

    private boolean isInPhpDocCompletion(ITextViewer iTextViewer, CharSequence charSequence, int n, String string, int n2, boolean bl) {
        if (bl) {
            return false;
        }
        int n3 = charSequence.length() - string.length();
        if (n3 <= 0 || charSequence.charAt(n3 - 1) != '@') {
            return false;
        }
        --n3;
        boolean bl2 = false;
        while (n3 > 0) {
            if (!Character.isWhitespace(charSequence.charAt(n3 - 1))) {
                if (bl2 || charSequence.charAt(n3 - 1) != '*') break;
                bl2 = true;
            }
            --n3;
        }
        if (n3 != 0) {
            return true;
        }
        CodeData[] codeDataArray = PHPDocLanguageModel.getPHPDocTags((String)string);
        this.phpDocCompletionProposalGroup.setData(n, codeDataArray, string, n2);
        this.completionProposalGroup = this.phpDocCompletionProposalGroup;
        this.templateProposals = this.getTemplates(iTextViewer, n);
        return true;
    }

    private boolean isVariableCompletion(DOMModelForPHP dOMModelForPHP, PHPFileData pHPFileData, int n, String string, int n2, boolean bl) {
        if (bl) {
            return false;
        }
        if (string.startsWith("$")) {
            CodeData[] codeDataArray;
            string = string.substring(1);
            PHPCodeContext pHPCodeContext = ModelSupport.createContext((PHPFileData)pHPFileData, (int)n);
            PHPProjectModel pHPProjectModel = dOMModelForPHP.getProjectModel();
            String string2 = pHPFileData.getName();
            CodeData[] codeDataArray2 = pHPProjectModel.getVariables(string2, pHPCodeContext, string, true);
            PHPClassData[] pHPClassDataArray = pHPFileData.getClasses();
            boolean bl2 = false;
            int n3 = 0;
            while (n3 < pHPClassDataArray.length) {
                CodeData codeData = this.isInClassBlocks(pHPClassDataArray[n3], n);
                if (codeData != null) {
                    pHPCodeContext = ModelSupport.createContext((CodeData)codeData);
                    codeDataArray = pHPProjectModel.getVariables(string2, pHPCodeContext, string, false);
                    codeDataArray2 = this.mergeCodeData(codeDataArray2, codeDataArray);
                    bl2 = true;
                    break;
                }
                ++n3;
            }
            if (!bl2) {
                PHPFunctionData[] pHPFunctionDataArray = pHPFileData.getFunctions();
                int n4 = 0;
                while (n4 < pHPFunctionDataArray.length) {
                    if (this.isInBlock((PHPCodeData)pHPFunctionDataArray[n4], n)) {
                        pHPCodeContext = ModelSupport.createContext((CodeData)pHPFunctionDataArray[n4]);
                        codeDataArray = pHPProjectModel.getVariables(string2, pHPCodeContext, string, false);
                        codeDataArray2 = this.mergeCodeData(codeDataArray2, codeDataArray);
                        break;
                    }
                    ++n4;
                }
            }
            this.completionProposalGroup = this.phpCompletionProposalGroup;
            this.completionProposalGroup.setData(n, codeDataArray2, string, n2);
            return true;
        }
        return false;
    }

    private CodeData isInClassBlocks(PHPClassData pHPClassData, int n) {
        if (this.isInBlock((PHPCodeData)pHPClassData, n)) {
            return pHPClassData;
        }
        PHPFunctionData[] pHPFunctionDataArray = pHPClassData.getFunctions();
        int n2 = 0;
        while (n2 < pHPFunctionDataArray.length) {
            if (this.isInBlock((PHPCodeData)pHPFunctionDataArray[n2], n)) {
                return pHPFunctionDataArray[n2];
            }
            ++n2;
        }
        return null;
    }

    private CodeData[] mergeCodeData(CodeData[] codeDataArray, CodeData[] codeDataArray2) {
        CodeData[] codeDataArray3 = new CodeData[codeDataArray.length + codeDataArray2.length];
        System.arraycopy(codeDataArray, 0, codeDataArray3, 0, codeDataArray.length);
        System.arraycopy(codeDataArray2, 0, codeDataArray3, codeDataArray.length, codeDataArray2.length);
        return codeDataArray3;
    }

    private boolean isInBlock(PHPCodeData pHPCodeData, int n) {
        return pHPCodeData.getDocBlock() != null ? pHPCodeData.getDocBlock().containsPosition(n) : false;
    }

    protected String getTemplateContext() {
        return "phpdoc";
    }
}

