/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.server.internal.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.php.server.PHPServerUIMessages;
import org.eclipse.php.server.core.Server;
import org.eclipse.php.server.core.manager.ServersManager;
import org.eclipse.php.server.internal.ui.ClosableWizardDialog;
import org.eclipse.php.server.internal.ui.PixelConverter;
import org.eclipse.php.server.internal.ui.ServerWizard;
import org.eclipse.php.server.ui.ServerEditDialog;
import org.eclipse.php.ui.preferences.ui.IPreferenceConfigurationBlock;
import org.eclipse.php.ui.preferences.ui.ScrolledCompositeImpl;
import org.eclipse.php.ui.util.StatusInfo;
import org.eclipse.php.ui.util.StatusUtil;
import org.eclipse.php.ui.wizards.fields.DialogField;
import org.eclipse.php.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.ui.wizards.fields.IListAdapter;
import org.eclipse.php.ui.wizards.fields.ListDialogField;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.internal.preferences.OverlayPreferenceStore;

public class PHPServersConfigurationBlock
implements IPreferenceConfigurationBlock {
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private IStatus fServersStatus;
    private ListDialogField fServersList;
    private PreferencePage fMainPreferencePage;

    public PHPServersConfigurationBlock(PreferencePage preferencePage, OverlayPreferenceStore overlayPreferenceStore) {
        Assert.isNotNull((Object)preferencePage);
        Assert.isNotNull((Object)overlayPreferenceStore);
        this.fMainPreferencePage = preferencePage;
    }

    public Control createControl(Composite composite) {
        ServerAdapter serverAdapter = new ServerAdapter();
        String[] stringArray = new String[]{PHPServerUIMessages.getString("PHPServersConfigurationBlock.new"), PHPServerUIMessages.getString("PHPServersConfigurationBlock.edit"), PHPServerUIMessages.getString("PHPServersConfigurationBlock.remove")};
        this.fServersList = new ListDialogField(serverAdapter, stringArray, (ILabelProvider)new PHPServersLabelProvider()){

            protected boolean managedButtonPressed(int n) {
                if (n == this.getRemoveButtonIndex()) {
                    PHPServersConfigurationBlock.this.handleRemoveServer();
                }
                return super.managedButtonPressed(n);
            }
        };
        this.fServersList.setDialogFieldListener((IDialogFieldListener)serverAdapter);
        this.fServersList.setRemoveButtonIndex(2);
        String[] stringArray2 = new String[]{PHPServerUIMessages.getString("PHPServersConfigurationBlock.name"), PHPServerUIMessages.getString("PHPServersConfigurationBlock.url"), PHPServerUIMessages.getString("PHPServersConfigurationBlock.publish")};
        ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[]{new ColumnWeightData(40), new ColumnWeightData(40), new ColumnWeightData(20)};
        this.fServersList.setTableColumns(new ListDialogField.ColumnsDescription(columnLayoutDataArray, stringArray2, true));
        if (this.fServersList.getSize() > 0) {
            this.fServersList.selectFirstElement();
        } else {
            this.fServersList.enableButton(1, false);
        }
        this.fServersStatus = new StatusInfo();
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        ScrolledCompositeImpl scrolledCompositeImpl = new ScrolledCompositeImpl(composite, 768);
        Composite composite2 = new Composite((Composite)scrolledCompositeImpl, 0);
        composite2.setLayout((Layout)gridLayout);
        scrolledCompositeImpl.setContent((Control)composite2);
        scrolledCompositeImpl.setLayout((Layout)gridLayout);
        scrolledCompositeImpl.setFont(composite.getFont());
        GridData gridData = new GridData(1808);
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        Control control = this.fServersList.getListControl(composite2);
        control.setLayoutData((Object)gridData);
        Composite composite3 = this.fServersList.getButtonBox(composite2);
        composite3.setLayoutData((Object)new GridData(258));
        this.addFiller(composite2);
        Point point = composite2.computeSize(-1, -1);
        scrolledCompositeImpl.setMinSize(point.x, point.y);
        return scrolledCompositeImpl;
    }

    private void addFiller(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label label = new Label(composite, 16384);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        label.setLayoutData((Object)gridData);
    }

    protected void sideButtonPressed(int n) {
        if (n == 0) {
            Server server = this.getServerFromWizard();
            if (server != null) {
                this.fServersList.addElement((Object)server);
                ServersManager.addServer((Server)server);
                ServersManager.save();
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        PHPServersConfigurationBlock.this.fServersList.refresh();
                    }
                });
            }
        } else if (n == 1) {
            this.handleEditServerButtonSelected();
            this.fServersList.refresh();
        }
    }

    protected Server getServerFromWizard() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        Server server = null;
        ServerWizard serverWizard = new ServerWizard();
        ClosableWizardDialog closableWizardDialog = new ClosableWizardDialog(shell, (IWizard)serverWizard);
        if (closableWizardDialog.open() == 1) {
            nullProgressMonitor.setCanceled(true);
            return null;
        }
        server = (Server)serverWizard.getRootFragment().getWizardModel().getObject("server");
        return server;
    }

    protected void handleEditServerButtonSelected() {
        Server server = (Server)this.fServersList.getSelectedElements().get(0);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        ServerEditDialog serverEditDialog = new ServerEditDialog(shell, server);
        if (serverEditDialog.open() == 1) {
            nullProgressMonitor.setCanceled(true);
            return;
        }
        ServersManager.save();
    }

    protected void handleRemoveServer() {
        Server server = (Server)this.fServersList.getSelectedElements().get(0);
        ServersManager.removeServer((String)server.getName());
        ServersManager.save();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                PHPServersConfigurationBlock.this.fServersList.refresh();
            }
        });
    }

    protected void updateStatus() {
        this.fMainPreferencePage.setValid(this.fServersStatus.isOK());
        StatusUtil.applyToStatusLine((DialogPage)this.fMainPreferencePage, (IStatus)this.fServersStatus);
    }

    public void initialize() {
        ArrayList arrayList = new ArrayList();
        this.populateServerList(arrayList);
        this.fServersList.setElements(arrayList);
    }

    public void dispose() {
    }

    public void performDefaults() {
    }

    public void performOk() {
    }

    protected void populateServerList(List arrayList) {
        Server[] serverArray = ServersManager.getServers();
        if (arrayList == null) {
            arrayList = new ArrayList<Server>();
        }
        if (serverArray != null) {
            int n = serverArray.length;
            int n2 = 0;
            while (n2 < n) {
                Server server = serverArray[n2];
                arrayList.add(server);
                ++n2;
            }
        }
    }

    protected boolean isDefault(Server server) {
        return ServersManager.getDefaultServer(null) == server;
    }

    private class PHPServersLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        private PHPServersLabelProvider() {
        }

        public Font getFont(Object object) {
            if (PHPServersConfigurationBlock.this.isDefault((Server)object)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            Server server = null;
            if (!(object instanceof Server)) {
                return super.getText(object);
            }
            server = (Server)object;
            if (n == 0) {
                String string = server.getName();
                if (PHPServersConfigurationBlock.this.isDefault((Server)object)) {
                    string = String.valueOf(string) + PHPServerUIMessages.getString("PHPServersConfigurationBlock.workspaceDefault");
                }
                return string;
            }
            if (n == 1) {
                return server.getHost();
            }
            if (n == 2) {
                return server.canPublish() ? PHPServerUIMessages.getString("PHPServersConfigurationBlock.yes") : PHPServerUIMessages.getString("PHPServersConfigurationBlock.no");
            }
            return object.toString();
        }
    }

    private class ServerAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private ServerAdapter() {
        }

        private boolean hasActiveSelection(List list) {
            return list.size() == 1;
        }

        public void dialogFieldChanged(DialogField dialogField) {
        }

        public void customButtonPressed(ListDialogField listDialogField, int n) {
            PHPServersConfigurationBlock.this.sideButtonPressed(n);
        }

        public void doubleClicked(ListDialogField listDialogField) {
            PHPServersConfigurationBlock.this.sideButtonPressed(1);
        }

        public void selectionChanged(ListDialogField listDialogField) {
            List list = listDialogField.getSelectedElements();
            listDialogField.enableButton(1, this.hasActiveSelection(list));
            listDialogField.enableButton(2, this.hasActiveSelection(list) && listDialogField.getElements().size() > 1);
        }
    }
}

