/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui.presentation;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.php.debug.core.PHPDebugPlugin;
import org.eclipse.php.debug.ui.PHPDebugUIPlugin;

public class PHPModelPresentationRegistry {
    private static final String EXTENSION_POINT_NAME = "phpDebugModelPresentations";
    private static final String MODEL_PRESENTATION_TAG = "phpDebugModelPresentation";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String VIEWER_CONFIGURATION_ATTRIBUTE = "detailsViewerConfiguration";
    private static PHPModelPresentationRegistry instance = null;
    private Dictionary debugModelPresentations = new Hashtable();
    private IDebugModelPresentation bestMatchPresentation;

    private PHPModelPresentationRegistry() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(PHPDebugUIPlugin.getID(), EXTENSION_POINT_NAME);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (MODEL_PRESENTATION_TAG.equals(iConfigurationElement.getName())) {
                this.debugModelPresentations.put(iConfigurationElement.getAttribute(ID_ATTRIBUTE), new DebugModelPresentationFactory(iConfigurationElement));
            }
            ++n;
        }
    }

    private static PHPModelPresentationRegistry getInstance() {
        if (instance == null) {
            instance = new PHPModelPresentationRegistry();
        }
        return instance;
    }

    public static IDebugModelPresentation getBestMatchPresentation() {
        PHPModelPresentationRegistry pHPModelPresentationRegistry = PHPModelPresentationRegistry.getInstance();
        if (pHPModelPresentationRegistry.bestMatchPresentation != null) {
            return pHPModelPresentationRegistry.bestMatchPresentation;
        }
        try {
            DebugModelPresentationFactory debugModelPresentationFactory = null;
            Dictionary dictionary = pHPModelPresentationRegistry.debugModelPresentations;
            Enumeration enumeration = dictionary.elements();
            while (enumeration.hasMoreElements()) {
                DebugModelPresentationFactory debugModelPresentationFactory2 = (DebugModelPresentationFactory)enumeration.nextElement();
                if (PHPDebugUIPlugin.getID().equals(debugModelPresentationFactory2.element.getNamespaceIdentifier())) {
                    debugModelPresentationFactory = debugModelPresentationFactory2;
                    continue;
                }
                pHPModelPresentationRegistry.bestMatchPresentation = debugModelPresentationFactory2.createParametersInitializer();
                return pHPModelPresentationRegistry.bestMatchPresentation;
            }
            if (debugModelPresentationFactory != null) {
                pHPModelPresentationRegistry.bestMatchPresentation = debugModelPresentationFactory.createParametersInitializer();
                return pHPModelPresentationRegistry.bestMatchPresentation;
            }
        }
        catch (Exception exception) {
            PHPDebugPlugin.log((Throwable)exception);
        }
        return null;
    }

    private class DebugModelPresentationFactory {
        private IConfigurationElement element;
        private IDebugModelPresentation modelPresentation;

        public DebugModelPresentationFactory(IConfigurationElement iConfigurationElement) {
            this.element = iConfigurationElement;
        }

        public IDebugModelPresentation createParametersInitializer() {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(this, "Error creation extension for extension-point org.eclipse.php.debug.core.phpDebugParametersInitializers"){
                final /* synthetic */ DebugModelPresentationFactory this$1;
                {
                    this.this$1 = debugModelPresentationFactory;
                    super(string);
                }

                public void run() throws Exception {
                    DebugModelPresentationFactory.access$1(this.this$1, (IDebugModelPresentation)DebugModelPresentationFactory.access$0(this.this$1).createExecutableExtension("class"));
                }
            });
            return this.modelPresentation;
        }

        static /* synthetic */ void access$1(DebugModelPresentationFactory debugModelPresentationFactory, IDebugModelPresentation iDebugModelPresentation) {
            debugModelPresentationFactory.modelPresentation = iDebugModelPresentation;
        }
    }
}

