/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.internal.text.link.contentassist.HTMLTextPresenter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension3;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.php.PHPUIMessages;
import org.eclipse.php.core.containers.LocalFileStorage;
import org.eclipse.php.core.containers.ZipEntryStorage;
import org.eclipse.php.core.documentModel.parser.PhpSourceParser;
import org.eclipse.php.core.phpModel.PHPModelUtil;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.core.phpModel.phpElementData.UserData;
import org.eclipse.php.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.core.project.properties.handlers.PhpVersionChangedHandler;
import org.eclipse.php.internal.ui.actions.AddBlockCommentAction;
import org.eclipse.php.internal.ui.actions.BlockCommentAction;
import org.eclipse.php.internal.ui.actions.GotoMatchingBracketAction;
import org.eclipse.php.internal.ui.actions.OpenDeclarationAction;
import org.eclipse.php.internal.ui.actions.OpenFunctionsManualAction;
import org.eclipse.php.internal.ui.actions.RemoveBlockCommentAction;
import org.eclipse.php.internal.ui.actions.ToggleCommentAction;
import org.eclipse.php.internal.ui.text.DocumentCharacterIterator;
import org.eclipse.php.internal.ui.text.PHPWordIterator;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.containers.StorageEditorInput;
import org.eclipse.php.ui.editor.PHPPairMatcher;
import org.eclipse.php.ui.editor.PHPStructuredTextViewer;
import org.eclipse.php.ui.editor.hover.IHoverMessageDecorator;
import org.eclipse.php.ui.editor.hover.IPHPTextHover;
import org.eclipse.php.ui.editor.hover.SourceViewerInformationControl;
import org.eclipse.php.ui.outline.PHPContentOutlineConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.TextNavigationAction;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentoutline.ConfigurableContentOutlinePage;

public class PHPStructuredEditor
extends StructuredTextEditor {
    private static final String ORG_ECLIPSE_PHP_UI_ACTIONS_OPEN = "org.eclipse.php.ui.actions.Open";
    private static final String ORG_ECLIPSE_PHP_UI_ACTIONS_OPEN_DECLARATION = "org.eclipse.php.ui.actions.OpenDeclaration";
    private static final String ORG_ECLIPSE_PHP_UI_ACTIONS_OPEN_FUNCTIONS_MANUAL_ACTION = "org.eclipse.php.ui.actions.OpenFunctionsManualAction";
    private static final String ORG_ECLIPSE_PHP_UI_ACTIONS_UNCOMMENT = "org.eclipse.php.ui.actions.Uncomment";
    private static final String ORG_ECLIPSE_PHP_UI_ACTIONS_COMMENT = "org.eclipse.php.ui.actions.Comment";
    private static final String ORG_ECLIPSE_PHP_UI_ACTIONS_REMOVE_BLOCK_COMMENT = "org.eclipse.php.ui.actions.RemoveBlockComment";
    private static final String ORG_ECLIPSE_PHP_UI_ACTIONS_ADD_BLOCK_COMMENT = "org.eclipse.php.ui.actions.AddBlockComment";
    protected PHPPairMatcher fBracketMatcher = new PHPPairMatcher(BRACKETS);
    private IPreferencesPropagatorListener phpVersionListener = new IPreferencesPropagatorListener(){

        public void preferencesEventOccured(PreferencesPropagatorEvent preferencesPropagatorEvent) {
        }

        public IProject getProject() {
            return PHPStructuredEditor.this.getFile().getProject();
        }
    };
    private final List fCursorActions = new ArrayList(5);
    protected InformationPresenter fInformationPresenter;
    ISelectionChangedListener selectionListener;
    static /* synthetic */ Class class$0;

    public PHPStructuredEditor() {
        boolean bl = PHPUiPlugin.getDefault().getPreferenceStore().getBoolean("foldingEnabled");
        SSEUIPlugin.getDefault().getPreferenceStore().setValue("foldingEnabled", bl);
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        super.init(iEditorSite, iEditorInput);
        PhpVersionChangedHandler.getInstance().addPhpVersionChangedListener(this.phpVersionListener);
    }

    public void dispose() {
        PhpVersionChangedHandler.getInstance().removePhpVersionChangedListener(this.phpVersionListener);
        super.dispose();
    }

    protected void addContextMenuActions(IMenuManager iMenuManager) {
        super.addContextMenuActions(iMenuManager);
        if (this.getSourceViewer().isEditable()) {
            String string = PHPUIMessages.PHPStructuredEditor_Source;
            MenuManager menuManager = new MenuManager(string, "org.eclipse.php.ui.source.menu");
            menuManager.add((IContributionItem)new GroupMarker("editGroup"));
            this.addAction((IMenuManager)menuManager, "org.eclipse.php.ui.actions.ToggleCommentAction");
            this.addAction((IMenuManager)menuManager, ORG_ECLIPSE_PHP_UI_ACTIONS_ADD_BLOCK_COMMENT);
            this.addAction((IMenuManager)menuManager, ORG_ECLIPSE_PHP_UI_ACTIONS_REMOVE_BLOCK_COMMENT);
            iMenuManager.appendToGroup("group.edit", (IContributionItem)menuManager);
            iMenuManager.appendToGroup("group.edit", (IContributionItem)new Separator("group.open"));
            IAction iAction = this.getAction(ORG_ECLIPSE_PHP_UI_ACTIONS_OPEN);
            if (iAction != null) {
                iMenuManager.appendToGroup("group.open", iAction);
            }
            if ((iAction = this.getAction(ORG_ECLIPSE_PHP_UI_ACTIONS_OPEN_FUNCTIONS_MANUAL_ACTION)) != null) {
                iMenuManager.appendToGroup("group.open", iAction);
            }
        }
    }

    protected void createNavigationActions() {
        super.createNavigationActions();
        StyledText styledText = this.getSourceViewer().getTextWidget();
        Object object = new SmartLineStartAction(styledText, false);
        object.setActionDefinitionId("org.eclipse.ui.edit.text.goto.lineStart");
        this.setAction("org.eclipse.ui.edit.text.goto.lineStart", (IAction)object);
        object = new SmartLineStartAction(styledText, true);
        object.setActionDefinitionId("org.eclipse.ui.edit.text.select.lineStart");
        this.setAction("org.eclipse.ui.edit.text.select.lineStart", (IAction)object);
        object = new SmartLineEndAction(styledText, false);
        object.setActionDefinitionId("org.eclipse.ui.edit.text.goto.lineEnd");
        this.setAction("org.eclipse.ui.edit.text.goto.lineEnd", (IAction)object);
        object = new SmartLineEndAction(styledText, true);
        object.setActionDefinitionId("org.eclipse.ui.edit.text.select.lineEnd");
        this.setAction("org.eclipse.ui.edit.text.select.lineEnd", (IAction)object);
        object = new NavigatePreviousSubWordAction();
        object.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.goto.wordPrevious", (IAction)object);
        styledText.setKeyBinding(17039363, 0);
        object = new NavigateNextSubWordAction();
        object.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordNext");
        this.setAction("org.eclipse.ui.edit.text.goto.wordNext", (IAction)object);
        styledText.setKeyBinding(0x1040004, 0);
        object = new SelectPreviousSubWordAction();
        object.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.select.wordPrevious", (IAction)object);
        styledText.setKeyBinding(17170435, 0);
        object = new SelectNextSubWordAction();
        object.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordNext");
        this.setAction("org.eclipse.ui.edit.text.select.wordNext", (IAction)object);
        styledText.setKeyBinding(17170436, 0);
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle resourceBundle = PHPUIMessages.getResourceBundle();
        ISourceViewer iSourceViewer = this.getSourceViewer();
        SourceViewerConfiguration sourceViewerConfiguration = this.getSourceViewerConfiguration();
        Object object = new ToggleCommentAction(resourceBundle, "ToggleCommentAction_", (ITextEditor)this);
        object.setActionDefinitionId("org.eclipse.php.ui.edit.text.toggle.comment");
        this.setAction("org.eclipse.php.ui.actions.ToggleCommentAction", (IAction)object);
        object.configure(iSourceViewer, sourceViewerConfiguration);
        object = new GotoMatchingBracketAction(this);
        object.setActionDefinitionId("org.eclipse.php.ui.editor.goto.matching.bracket");
        this.setAction("GotoMatchingBracket", (IAction)object);
        object = new AddBlockCommentAction(resourceBundle, "AddBlockCommentAction_", (ITextEditor)this);
        object.setActionDefinitionId("org.eclipse.php.ui.edit.text.add.block.comment");
        this.setAction(ORG_ECLIPSE_PHP_UI_ACTIONS_ADD_BLOCK_COMMENT, (IAction)object);
        this.markAsSelectionDependentAction(ORG_ECLIPSE_PHP_UI_ACTIONS_ADD_BLOCK_COMMENT, true);
        ((BlockCommentAction)((Object)object)).configure(iSourceViewer, sourceViewerConfiguration);
        object = new RemoveBlockCommentAction(resourceBundle, "RemoveBlockCommentAction_", (ITextEditor)this);
        object.setActionDefinitionId("org.eclipse.php.ui.edit.text.remove.block.comment");
        this.setAction(ORG_ECLIPSE_PHP_UI_ACTIONS_REMOVE_BLOCK_COMMENT, (IAction)object);
        this.markAsCursorDependentAction(ORG_ECLIPSE_PHP_UI_ACTIONS_REMOVE_BLOCK_COMMENT, true);
        ((BlockCommentAction)((Object)object)).configure(iSourceViewer, sourceViewerConfiguration);
        object = new TextOperationAction(resourceBundle, "CommentAction_", (ITextEditor)this, 11);
        object.setActionDefinitionId("org.eclipse.php.ui.edit.text.comment");
        this.setAction(ORG_ECLIPSE_PHP_UI_ACTIONS_COMMENT, (IAction)object);
        this.markAsStateDependentAction(ORG_ECLIPSE_PHP_UI_ACTIONS_COMMENT, true);
        object = new TextOperationAction(resourceBundle, "UncommentAction_", (ITextEditor)this, 11);
        object.setActionDefinitionId("org.eclipse.php.ui.edit.text.uncomment");
        this.setAction(ORG_ECLIPSE_PHP_UI_ACTIONS_UNCOMMENT, (IAction)object);
        this.markAsStateDependentAction(ORG_ECLIPSE_PHP_UI_ACTIONS_UNCOMMENT, true);
        object = new OpenFunctionsManualAction(resourceBundle, this);
        object.setActionDefinitionId("org.eclipse.php.ui.edit.OpenFunctionsManualAction");
        this.setAction(ORG_ECLIPSE_PHP_UI_ACTIONS_OPEN_FUNCTIONS_MANUAL_ACTION, (IAction)object);
        this.markAsCursorDependentAction(ORG_ECLIPSE_PHP_UI_ACTIONS_OPEN_FUNCTIONS_MANUAL_ACTION, true);
        object = new OpenDeclarationAction(resourceBundle, this);
        object.setActionDefinitionId("org.eclipse.php.ui.edit.text.OpenDeclaration");
        this.setAction(ORG_ECLIPSE_PHP_UI_ACTIONS_OPEN_DECLARATION, (IAction)object);
        this.markAsCursorDependentAction(ORG_ECLIPSE_PHP_UI_ACTIONS_OPEN_DECLARATION, true);
        Object object2 = new TextOperationAction(PHPUIMessages.getBundleForConstructedKeys(), "ShowPHPDoc.", (ITextEditor)this, 16, true);
        object2 = new InformationDispatchAction(PHPUIMessages.getBundleForConstructedKeys(), "ShowPHPDoc.", (TextOperationAction)object2);
        object2.setActionDefinitionId("org.eclipse.php.ui.edit.text.show.phpdoc");
        this.setAction("ShowPHPDoc", (IAction)object2);
    }

    public void gotoMatchingBracket() {
        IRegion iRegion;
        ISourceViewer iSourceViewer = this.getSourceViewer();
        IDocument iDocument = iSourceViewer.getDocument();
        if (iDocument == null) {
            return;
        }
        IRegion iRegion2 = this.getSignedSelection(iSourceViewer);
        int n = Math.abs(iRegion2.getLength());
        if (n > 1) {
            this.setStatusLineErrorMessage(PHPUIMessages.GotoMatchingBracket_error_invalidSelection);
            iSourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int n2 = iRegion2.getOffset() + iRegion2.getLength();
        if (PHPStructuredEditor.isSurroundedByBrackets(iDocument, n2)) {
            n2 -= iRegion2.getLength();
        }
        if ((iRegion = this.fBracketMatcher.match(iDocument, n2)) == null) {
            this.setStatusLineErrorMessage(PHPUIMessages.GotoMatchingBracket_error_noMatchingBracket);
            iSourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int n3 = iRegion.getOffset();
        int n4 = iRegion.getLength();
        if (n4 < 1) {
            return;
        }
        int n5 = this.fBracketMatcher.getAnchor();
        int n6 = n5 == 0 ? n3 + 1 : n3 + n4;
        boolean bl = false;
        if (iSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)iSourceViewer;
            bl = iTextViewerExtension5.modelOffset2WidgetOffset(n6) > -1;
        } else {
            IRegion iRegion3 = iSourceViewer.getVisibleRegion();
            boolean bl2 = bl = n6 >= iRegion3.getOffset() && n6 <= iRegion3.getOffset() + iRegion3.getLength();
        }
        if (!bl) {
            this.setStatusLineErrorMessage(PHPUIMessages.GotoMatchingBracket_error_bracketOutsideSelectedElement);
            iSourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        if (iRegion2.getLength() < 0) {
            n6 -= iRegion2.getLength();
        }
        iSourceViewer.setSelectedRange(n6, iRegion2.getLength());
        iSourceViewer.revealRange(n6, iRegion2.getLength());
    }

    private static boolean isSurroundedByBrackets(IDocument iDocument, int n) {
        if (n == 0 || n == iDocument.getLength()) {
            return false;
        }
        try {
            return PHPStructuredEditor.isBracket(iDocument.getChar(n - 1)) && PHPStructuredEditor.isBracket(iDocument.getChar(n));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private static boolean isBracket(char c) {
        int n = 0;
        while (n != BRACKETS.length) {
            if (c == BRACKETS[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected IRegion getSignedSelection(ISourceViewer iSourceViewer) {
        StyledText styledText = iSourceViewer.getTextWidget();
        Point point = styledText.getSelectionRange();
        if (styledText.getCaretOffset() == point.x) {
            point.x += point.y;
            point.y = -point.y;
        }
        point.x = PHPStructuredEditor.widgetOffset2ModelOffset((ISourceViewer)iSourceViewer, (int)point.x);
        return new Region(point.x, point.y);
    }

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        this.getSite().getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)new IPerspectiveListener2(){

            public void perspectiveChanged(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, IWorkbenchPartReference iWorkbenchPartReference, String string) {
                if (string == "editorClose" && iWorkbenchPartReference.getPart(false) == PHPStructuredEditor.this.getEditorPart()) {
                    IFile iFile = PHPStructuredEditor.this.getFile();
                    if (iFile.exists() && iFile.isAccessible()) {
                        PHPWorkspaceModelManager.getInstance().addFileToModel(PHPStructuredEditor.this.getFile());
                    }
                    PHPStructuredEditor.this.getSite().getWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this);
                }
            }

            public void perspectiveActivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
            }

            public void perspectiveChanged(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, String string) {
            }
        });
        IInformationControlCreator iInformationControlCreator = new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                boolean bl = false;
                int n = bl ? 0 : 768;
                return new DefaultInformationControl(shell, 20, n, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(bl));
            }
        };
        this.fInformationPresenter = new InformationPresenter(iInformationControlCreator);
        this.fInformationPresenter.setSizeConstraints(60, 10, true, true);
        this.fInformationPresenter.install((ITextViewer)this.getSourceViewer());
        StyledText styledText = this.getTextViewer().getTextWidget();
        styledText.getContent().addTextChangeListener(new TextChangeListener(){

            public void textChanging(TextChangingEvent textChangingEvent) {
            }

            public void textChanged(TextChangedEvent textChangedEvent) {
            }

            public void textSet(TextChangedEvent textChangedEvent) {
                PHPStructuredEditor.this.refreshViewer();
            }
        });
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
                try {
                    if (PHPStructuredEditor.this.getSite().getPage().getActiveEditor().equals((Object)PHPStructuredEditor.this) && iResourceChangeEvent.getType() == 1 && iResourceChangeEvent.getDelta() != null) {
                        PHPStructuredEditor.this.refreshViewer();
                    }
                }
                catch (NullPointerException nullPointerException) {}
            }
        });
    }

    private void refreshViewer() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                StructuredTextViewer structuredTextViewer = PHPStructuredEditor.this.getTextViewer();
                if (structuredTextViewer != null) {
                    structuredTextViewer.getTextWidget().redraw();
                }
            }
        });
    }

    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        IFile iFile = null;
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            iFile = iFileEditorInput.getFile();
        } else if (iEditorInput instanceof StorageEditorInput) {
            StorageEditorInput storageEditorInput = (StorageEditorInput)iEditorInput;
            IStorage iStorage = storageEditorInput.getStorage();
            if (iStorage instanceof ZipEntryStorage) {
                iFile = ((ZipEntryStorage)iStorage).getProject();
            } else if (iStorage instanceof LocalFileStorage) {
                iFile = ((LocalFileStorage)iStorage).getProject();
            }
        }
        if (iFile instanceof IFile) {
            if (PHPModelUtil.isPhpFile((IFile)iFile)) {
                PhpSourceParser.editFile.set(iFile);
                super.doSetInput(iEditorInput);
            } else {
                this.close(false);
            }
        } else {
            super.doSetInput(iEditorInput);
        }
    }

    public Object getAdapter(Class clazz) {
        Object object = super.getAdapter(clazz);
        if (object instanceof ConfigurableContentOutlinePage) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz2.equals(clazz)) {
                final ConfigurableContentOutlinePage configurableContentOutlinePage = (ConfigurableContentOutlinePage)object;
                PHPContentOutlineConfiguration.DoubleClickListener doubleClickListener = ((PHPContentOutlineConfiguration)configurableContentOutlinePage.getConfiguration()).getDoubleClickListener();
                if (!doubleClickListener.isEnabled()) {
                    configurableContentOutlinePage.addDoubleClickListener((IDoubleClickListener)doubleClickListener);
                    doubleClickListener.setEnabled(true);
                }
                if (this.selectionListener == null) {
                    this.selectionListener = new ISelectionChangedListener(){
                        boolean selecting = false;

                        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            ISelection iSelection;
                            if (!configurableContentOutlinePage.getConfiguration().isLinkedWithEditor(null)) {
                                return;
                            }
                            if (selectionChangedEvent.getSelection().isEmpty() || this.selecting) {
                                return;
                            }
                            if (PHPStructuredEditor.this.getSourceViewer() != null && PHPStructuredEditor.this.getSourceViewer().getTextWidget() != null && !PHPStructuredEditor.this.getSourceViewer().getTextWidget().isDisposed() && PHPStructuredEditor.this.getSite().getPage().getActivePart() != PHPStructuredEditor.this.getEditorPart() && selectionChangedEvent.getSelection() instanceof IStructuredSelection && (iSelection = PHPStructuredEditor.this.getSelectionProvider().getSelection()) instanceof IStructuredSelection && !Arrays.equals(objectArray2 = ((IStructuredSelection)iSelection).toArray(), objectArray = ((IStructuredSelection)selectionChangedEvent.getSelection()).toArray()) && objectArray.length > 0) {
                                Object object = objectArray[0];
                                this.selecting = true;
                                if (object instanceof PHPCodeData) {
                                    PHPStructuredEditor.this.setSelection((PHPCodeData)object, true);
                                }
                                this.selecting = false;
                            }
                            PHPStructuredEditor.this.clearStatusLine();
                        }
                    };
                }
                configurableContentOutlinePage.addSelectionChangedListener(this.selectionListener);
            }
        }
        return object;
    }

    protected void clearStatusLine() {
        this.setStatusLineErrorMessage(null);
        this.setStatusLineMessage(null);
    }

    public IFile getFile() {
        String string = this.getModel().getBaseLocation();
        return (IFile)((Workspace)ResourcesPlugin.getWorkspace()).newResource((IPath)new Path(string), 1);
    }

    public PHPFileData getPHPFileData() {
        String string = this.getModel().getBaseLocation();
        return PHPWorkspaceModelManager.getInstance().getModelForFile(string);
    }

    public SourceViewerConfiguration getSourceViwerConfiguration() {
        return super.getSourceViewerConfiguration();
    }

    protected void handleCursorPositionChanged() {
        this.updateCursorDependentActions();
        super.handleCursorPositionChanged();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        try {
            if ("hoverModifiers".equals(string)) {
                this.updateHoverBehavior();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            super.handlePreferenceStoreChanged(propertyChangeEvent);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        super.handlePreferenceStoreChanged(propertyChangeEvent);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.php.ui.phpEditorScope"});
    }

    public void markAsCursorDependentAction(String string, boolean bl) {
        Assert.isNotNull((Object)string);
        if (bl) {
            if (!this.fCursorActions.contains(string)) {
                this.fCursorActions.add(string);
            }
        } else {
            this.fCursorActions.remove(string);
        }
    }

    public void setSelection(PHPCodeData pHPCodeData, boolean bl) {
        if (pHPCodeData != null) {
            IStructuredDocument iStructuredDocument;
            IStructuredDocumentRegion iStructuredDocumentRegion;
            UserData userData = pHPCodeData.getUserData();
            PHPFileData pHPFileData = this.getPHPFileData();
            if (userData == null || pHPFileData == null || !userData.getFileName().equals(pHPFileData.getUserData().getFileName())) {
                return;
            }
            int n = userData.getStartPosition();
            int n2 = userData.getEndPosition() - userData.getStartPosition() + 1;
            IDocument iDocument = this.getSourceViewer().getDocument();
            if (iDocument instanceof IStructuredDocument && (iStructuredDocumentRegion = (iStructuredDocument = (IStructuredDocument)iDocument).getRegionAtCharacterOffset(n)) != null) {
                int n3 = iStructuredDocumentRegion.getStartOffset();
                ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
                String string = pHPCodeData.getName();
                if (pHPCodeData instanceof PHPVariableData) {
                    string = "$" + string;
                }
                while (iTextRegion != null && iTextRegion.getEnd() + n3 < n + n2) {
                    String string2 = iStructuredDocumentRegion.getText(iTextRegion).trim().replaceAll("[\"']+", "");
                    if (string.equals(string2)) {
                        n = iTextRegion.getStart() + n3;
                        n2 = iTextRegion.getTextLength();
                        break;
                    }
                    iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(iTextRegion.getEnd() + n3);
                }
            }
            if (!bl) {
                this.getSourceViewer().setSelectedRange(n, n2);
            } else {
                this.selectAndReveal(n, n2);
            }
        }
    }

    private void updateAction(String string) {
        Assert.isNotNull((Object)string);
        IAction iAction = this.getAction(string);
        if (iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
    }

    protected void updateCursorDependentActions() {
        if (this.fCursorActions != null) {
            Iterator iterator = this.fCursorActions.iterator();
            while (iterator.hasNext()) {
                this.updateAction((String)iterator.next());
            }
        }
    }

    private void updateHoverBehavior() {
        SourceViewerConfiguration sourceViewerConfiguration = this.getSourceViewerConfiguration();
        String[] stringArray = sourceViewerConfiguration.getConfiguredContentTypes(this.getSourceViewer());
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            ISourceViewer iSourceViewer = this.getSourceViewer();
            if (iSourceViewer instanceof ITextViewerExtension2) {
                ((ITextViewerExtension2)iSourceViewer).removeTextHovers(string);
                int[] nArray = sourceViewerConfiguration.getConfiguredTextHoverStateMasks(this.getSourceViewer(), string);
                if (nArray != null) {
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        int n3 = nArray[n2];
                        ITextHover iTextHover = sourceViewerConfiguration.getTextHover(iSourceViewer, string, n3);
                        ((ITextViewerExtension2)iSourceViewer).setTextHover(iTextHover, string, n3);
                        ++n2;
                    }
                } else {
                    ITextHover iTextHover = sourceViewerConfiguration.getTextHover(iSourceViewer, string);
                    ((ITextViewerExtension2)iSourceViewer).setTextHover(iTextHover, string, 255);
                }
            } else {
                iSourceViewer.setTextHover(sourceViewerConfiguration.getTextHover(iSourceViewer, string), string);
            }
            ++n;
        }
    }

    protected StructuredTextViewer createStructedTextViewer(Composite composite, IVerticalRuler iVerticalRuler, int n) {
        return new PHPStructuredTextViewer(composite, iVerticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), n);
    }

    static /* synthetic */ int access$2(ISourceViewer iSourceViewer, int n) {
        return AbstractTextEditor.widgetOffset2ModelOffset((ISourceViewer)iSourceViewer, (int)n);
    }

    static /* synthetic */ int access$3(ISourceViewer iSourceViewer, int n) {
        return AbstractTextEditor.modelOffset2WidgetOffset((ISourceViewer)iSourceViewer, (int)n);
    }

    class InformationDispatchAction
    extends TextEditorAction {
        private final TextOperationAction fTextOperationAction;

        public InformationDispatchAction(ResourceBundle resourceBundle, String string, TextOperationAction textOperationAction) {
            super(resourceBundle, string, (ITextEditor)PHPStructuredEditor.this);
            if (textOperationAction == null) {
                throw new IllegalArgumentException();
            }
            this.fTextOperationAction = textOperationAction;
        }

        private int computeOffsetAtLocation(ITextViewer iTextViewer, int n, int n2) {
            StyledText styledText = iTextViewer.getTextWidget();
            IDocument iDocument = iTextViewer.getDocument();
            if (iDocument == null) {
                return -1;
            }
            try {
                int n3 = styledText.getOffsetAtLocation(new Point(n, n2));
                Point point = styledText.getLocationAtOffset(n3);
                if (point.x > n) {
                    --n3;
                }
                if (iTextViewer instanceof ITextViewerExtension5) {
                    ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)iTextViewer;
                    return iTextViewerExtension5.widgetOffset2ModelOffset(n3);
                }
                IRegion iRegion = iTextViewer.getVisibleRegion();
                return n3 + iRegion.getOffset();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean makeAnnotationHoverFocusable(ISourceViewer iSourceViewer, IAnnotationHover iAnnotationHover) {
            IVerticalRuler iVerticalRuler = PHPStructuredEditor.this.getVerticalRuler();
            int n = iVerticalRuler.getLineOfLastMouseButtonActivity();
            if (n == -1) {
                return false;
            }
            try {
                Object object;
                IAnnotationHoverExtension iAnnotationHoverExtension;
                if (iAnnotationHover instanceof IAnnotationHoverExtension) {
                    iAnnotationHoverExtension = (IAnnotationHoverExtension)iAnnotationHover;
                    ILineRange iLineRange = iAnnotationHoverExtension.getHoverLineRange(iSourceViewer, n);
                    if (iLineRange == null) {
                        return false;
                    }
                    object = iAnnotationHoverExtension.getHoverInfo(iSourceViewer, iLineRange, Integer.MAX_VALUE);
                } else {
                    object = iAnnotationHover.getHoverInfo(iSourceViewer, n);
                }
                iAnnotationHoverExtension = iSourceViewer.getDocument();
                int n2 = iAnnotationHoverExtension.getLineOffset(n);
                String string = TextUtilities.getContentType((IDocument)iAnnotationHoverExtension, (String)"org.eclipse.php.PHP_DOC", (int)n2, (boolean)true);
                IInformationControlCreator iInformationControlCreator = null;
                if ("org.eclipse.jface.text.source.projection.ProjectionAnnotationHover".equals(iAnnotationHover.getClass().getName())) {
                    iInformationControlCreator = new IInformationControlCreator(this){
                        final /* synthetic */ InformationDispatchAction this$1;
                        {
                            this.this$1 = informationDispatchAction;
                        }

                        public IInformationControl createInformationControl(Shell shell) {
                            int n = 0x14 | InformationDispatchAction.access$0(this.this$1).getOrientation();
                            return new SourceViewerInformationControl(shell, n, 768);
                        }
                    };
                } else if (iAnnotationHover instanceof IInformationProviderExtension2) {
                    iInformationControlCreator = ((IInformationProviderExtension2)iAnnotationHover).getInformationPresenterControlCreator();
                } else if (iAnnotationHover instanceof IAnnotationHoverExtension) {
                    iInformationControlCreator = ((IAnnotationHoverExtension)iAnnotationHover).getHoverControlCreator();
                }
                InformationProvider informationProvider = new InformationProvider((IRegion)new Region(n2, 0), object, iInformationControlCreator);
                PHPStructuredEditor.this.fInformationPresenter.setOffset(n2);
                PHPStructuredEditor.this.fInformationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_RIGHT);
                PHPStructuredEditor.this.fInformationPresenter.setMargins(4, 0);
                PHPStructuredEditor.this.fInformationPresenter.setInformationProvider((IInformationProvider)informationProvider, string);
                PHPStructuredEditor.this.fInformationPresenter.showInformation();
                return true;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }

        private boolean makeTextHoverFocusable(ISourceViewer iSourceViewer, ITextHover iTextHover) {
            Object object;
            IHoverMessageDecorator iHoverMessageDecorator;
            IRegion iRegion;
            int n;
            block6: {
                Point point = ((ITextViewerExtension2)iSourceViewer).getHoverEventLocation();
                n = this.computeOffsetAtLocation((ITextViewer)iSourceViewer, point.x, point.y);
                if (n == -1) {
                    return false;
                }
                try {
                    iRegion = iTextHover.getHoverRegion((ITextViewer)iSourceViewer, n);
                    if (iRegion != null) break block6;
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            Object object2 = iTextHover.getHoverInfo((ITextViewer)iSourceViewer, iRegion);
            if (iTextHover instanceof IPHPTextHover && (iHoverMessageDecorator = ((IPHPTextHover)iTextHover).getMessageDecorator()) != null && (object = iHoverMessageDecorator.getDecoratedMessage((String)object2)) != null && ((String)object).length() > 0) {
                object2 = object;
            }
            iHoverMessageDecorator = null;
            if (iTextHover instanceof IInformationProviderExtension2) {
                iHoverMessageDecorator = ((IInformationProviderExtension2)iTextHover).getInformationPresenterControlCreator();
            }
            object = new InformationProvider(iRegion, object2, (IInformationControlCreator)iHoverMessageDecorator);
            PHPStructuredEditor.this.fInformationPresenter.setOffset(n);
            PHPStructuredEditor.this.fInformationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_BOTTOM);
            PHPStructuredEditor.this.fInformationPresenter.setMargins(6, 6);
            String string = TextUtilities.getContentType((IDocument)iSourceViewer.getDocument(), (String)"org.eclipse.php.PHP_DOC", (int)n, (boolean)true);
            PHPStructuredEditor.this.fInformationPresenter.setInformationProvider((IInformationProvider)object, string);
            PHPStructuredEditor.this.fInformationPresenter.showInformation();
            return true;
        }

        public void run() {
            ITextViewerExtension4 iTextViewerExtension4;
            ISourceViewer iSourceViewer = PHPStructuredEditor.this.getSourceViewer();
            if (iSourceViewer == null) {
                this.fTextOperationAction.run();
                return;
            }
            if (iSourceViewer instanceof ITextViewerExtension4 && (iTextViewerExtension4 = (ITextViewerExtension4)iSourceViewer).moveFocusToWidgetToken()) {
                return;
            }
            if (iSourceViewer instanceof ITextViewerExtension2 && (iTextViewerExtension4 = ((ITextViewerExtension2)iSourceViewer).getCurrentTextHover()) != null && this.makeTextHoverFocusable(iSourceViewer, (ITextHover)iTextViewerExtension4)) {
                return;
            }
            if (iSourceViewer instanceof ISourceViewerExtension3 && (iTextViewerExtension4 = ((ISourceViewerExtension3)iSourceViewer).getCurrentAnnotationHover()) != null && this.makeAnnotationHoverFocusable(iSourceViewer, (IAnnotationHover)iTextViewerExtension4)) {
                return;
            }
            this.fTextOperationAction.run();
        }

        static /* synthetic */ PHPStructuredEditor access$0(InformationDispatchAction informationDispatchAction) {
            return informationDispatchAction.PHPStructuredEditor.this;
        }
    }

    private static final class InformationProvider
    implements IInformationProvider,
    IInformationProviderExtension,
    IInformationProviderExtension2 {
        private IInformationControlCreator fControlCreator;
        private Object fHoverInfo;
        private IRegion fHoverRegion;

        InformationProvider(IRegion iRegion, Object object, IInformationControlCreator iInformationControlCreator) {
            this.fHoverRegion = iRegion;
            this.fHoverInfo = object;
            this.fControlCreator = iInformationControlCreator;
        }

        public String getInformation(ITextViewer iTextViewer, IRegion iRegion) {
            return this.fHoverInfo.toString();
        }

        public Object getInformation2(ITextViewer iTextViewer, IRegion iRegion) {
            return this.fHoverInfo;
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return this.fControlCreator;
        }

        public IRegion getSubject(ITextViewer iTextViewer, int n) {
            return this.fHoverRegion;
        }
    }

    protected class NavigateNextSubWordAction
    extends NextSubWordAction {
        public NavigateNextSubWordAction() {
            super(0x1040004);
        }

        protected void setCaretPosition(int n) {
            this.getTextWidget().setCaretOffset(PHPStructuredEditor.access$3(PHPStructuredEditor.this.getSourceViewer(), n));
        }
    }

    protected class NavigatePreviousSubWordAction
    extends PreviousSubWordAction {
        public NavigatePreviousSubWordAction() {
            super(17039363);
        }

        protected void setCaretPosition(int n) {
            this.getTextWidget().setCaretOffset(PHPStructuredEditor.access$3(PHPStructuredEditor.this.getSourceViewer(), n));
        }
    }

    protected abstract class NextSubWordAction
    extends TextNavigationAction {
        protected PHPWordIterator fIterator;

        protected NextSubWordAction(int n) {
            super(PHPStructuredEditor.this.getSourceViewer().getTextWidget(), n);
            this.fIterator = new PHPWordIterator();
        }

        private IPreferenceStore getPreferenceStore() {
            return PHPUiPlugin.getDefault().getPreferenceStore();
        }

        public void run() {
            IPreferenceStore iPreferenceStore = this.getPreferenceStore();
            if (!iPreferenceStore.getBoolean("editorSubWordNavigation")) {
                super.run();
                return;
            }
            ISourceViewer iSourceViewer = PHPStructuredEditor.this.getSourceViewer();
            IDocument iDocument = iSourceViewer.getDocument();
            this.fIterator.setText(new DocumentCharacterIterator(iDocument));
            int n = PHPStructuredEditor.access$2(iSourceViewer, iSourceViewer.getTextWidget().getCaretOffset());
            if (n == -1) {
                return;
            }
            int n2 = this.findNextPosition(n);
            if (n2 != -1) {
                this.setCaretPosition(n2);
                this.getTextWidget().showSelection();
                this.fireSelectionChanged();
            }
        }

        protected int findNextPosition(int n) {
            ISourceViewer iSourceViewer = PHPStructuredEditor.this.getSourceViewer();
            int n2 = -1;
            while (n != -1 && n2 == -1) {
                if ((n = this.fIterator.following(n)) == -1) continue;
                n2 = PHPStructuredEditor.access$3(iSourceViewer, n);
            }
            return n;
        }

        protected abstract void setCaretPosition(int var1);
    }

    protected abstract class PreviousSubWordAction
    extends TextNavigationAction {
        protected PHPWordIterator fIterator;

        protected PreviousSubWordAction(int n) {
            super(PHPStructuredEditor.this.getSourceViewer().getTextWidget(), n);
            this.fIterator = new PHPWordIterator();
        }

        private IPreferenceStore getPreferenceStore() {
            return PHPUiPlugin.getDefault().getPreferenceStore();
        }

        public void run() {
            IPreferenceStore iPreferenceStore = this.getPreferenceStore();
            if (!iPreferenceStore.getBoolean("editorSubWordNavigation")) {
                super.run();
                return;
            }
            ISourceViewer iSourceViewer = PHPStructuredEditor.this.getSourceViewer();
            IDocument iDocument = iSourceViewer.getDocument();
            this.fIterator.setText(new DocumentCharacterIterator(iDocument));
            int n = PHPStructuredEditor.access$2(iSourceViewer, iSourceViewer.getTextWidget().getCaretOffset());
            if (n == -1) {
                return;
            }
            int n2 = this.findPreviousPosition(n);
            if (n2 != -1) {
                this.setCaretPosition(n2);
                this.getTextWidget().showSelection();
                this.fireSelectionChanged();
            }
        }

        protected int findPreviousPosition(int n) {
            ISourceViewer iSourceViewer = PHPStructuredEditor.this.getSourceViewer();
            int n2 = -1;
            while (n != -1 && n2 == -1) {
                if ((n = this.fIterator.preceding(n)) == -1) continue;
                n2 = PHPStructuredEditor.access$3(iSourceViewer, n);
            }
            return n;
        }

        protected abstract void setCaretPosition(int var1);
    }

    protected class SelectNextSubWordAction
    extends NextSubWordAction {
        public SelectNextSubWordAction() {
            super(17170436);
        }

        protected void setCaretPosition(int n) {
            ISourceViewer iSourceViewer = PHPStructuredEditor.this.getSourceViewer();
            StyledText styledText = iSourceViewer.getTextWidget();
            if (styledText != null && !styledText.isDisposed()) {
                Point point = styledText.getSelection();
                int n2 = styledText.getCaretOffset();
                int n3 = PHPStructuredEditor.access$3(iSourceViewer, n);
                if (n2 == point.x) {
                    styledText.setSelectionRange(point.y, n3 - point.y);
                } else {
                    styledText.setSelectionRange(point.x, n3 - point.x);
                }
            }
        }
    }

    protected class SelectPreviousSubWordAction
    extends PreviousSubWordAction {
        public SelectPreviousSubWordAction() {
            super(17170435);
        }

        protected void setCaretPosition(int n) {
            ISourceViewer iSourceViewer = PHPStructuredEditor.this.getSourceViewer();
            StyledText styledText = iSourceViewer.getTextWidget();
            if (styledText != null && !styledText.isDisposed()) {
                Point point = styledText.getSelection();
                int n2 = styledText.getCaretOffset();
                int n3 = PHPStructuredEditor.access$3(iSourceViewer, n);
                if (n2 == point.x) {
                    styledText.setSelectionRange(point.y, n3 - point.y);
                } else {
                    styledText.setSelectionRange(point.x, n3 - point.x);
                }
            }
        }
    }

    protected class SmartLineEndAction
    extends TextNavigationAction {
        private boolean fDoSelect;

        public SmartLineEndAction(StyledText styledText, boolean bl) {
            super(styledText, 0x1000008);
            this.fDoSelect = bl;
        }

        private IPreferenceStore getPreferenceStore() {
            return PHPUiPlugin.getDefault().getPreferenceStore();
        }

        public void run() {
            int n;
            int n2;
            ISourceViewer iSourceViewer;
            StyledText styledText;
            boolean bl = true;
            IPreferenceStore iPreferenceStore = this.getPreferenceStore();
            if (iPreferenceStore != null) {
                bl = iPreferenceStore.getBoolean("useSmartHomeEnd");
            }
            if ((styledText = (iSourceViewer = PHPStructuredEditor.this.getSourceViewer()).getTextWidget()) == null || styledText.isDisposed()) {
                return;
            }
            int n3 = styledText.getCaretOffset();
            int n4 = styledText.getLineAtOffset(n3);
            int n5 = styledText.getOffsetAtLine(n4);
            try {
                n2 = PHPStructuredEditor.access$2(iSourceViewer, n3);
                n = iSourceViewer.getDocument().getLineInformationOfOffset(n2).getLength();
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            n2 = n5 + n;
            int n6 = n2 - styledText.getCharCount();
            if (n6 > 0) {
                n2 -= n6;
                n -= n6;
            }
            String string = "";
            if (n > 0) {
                string = styledText.getText(n5, n2 - 1);
            }
            int n7 = n - 1;
            while (n7 > -1 && Character.isWhitespace(string.charAt(n7))) {
                --n7;
            }
            ++n7;
            Point point = styledText.getSelection();
            int n8 = -1;
            if (bl) {
                n8 = n3 - n5 == n7 ? n2 : n5 + n7;
            } else if (n3 < n2) {
                n8 = n2;
            }
            if (n8 == -1) {
                n8 = n3;
            } else {
                styledText.setCaretOffset(n8);
            }
            styledText.setCaretOffset(n8);
            if (this.fDoSelect) {
                if (n3 < point.y) {
                    styledText.setSelection(point.y, n8);
                } else {
                    styledText.setSelection(point.x, n8);
                }
            } else {
                styledText.setSelection(n8);
            }
            this.fireSelectionChanged(point);
        }
    }

    protected class SmartLineStartAction
    extends AbstractTextEditor.LineStartAction {
        private boolean fDoSelect;

        public SmartLineStartAction(StyledText styledText, boolean bl) {
            super((AbstractTextEditor)PHPStructuredEditor.this, styledText, bl);
            this.fDoSelect = bl;
        }

        protected int getLineStartPosition(IDocument iDocument, String string, int n, int n2) {
            String string2 = "__dftl_partition_content_type";
            try {
                string2 = TextUtilities.getContentType((IDocument)iDocument, (String)"org.eclipse.php.PHP_DEFAULT", (int)n2, (boolean)true);
            }
            catch (BadLocationException badLocationException) {}
            int n3 = super.getLineStartPosition(iDocument, string, n, n2);
            if (string2.equals("org.eclipse.php.PHP_DOC") || string2.equals("org.eclipse.php.PHP_MULTI_LINE_COMMENT")) {
                if (n3 < n - 1 && string.charAt(n3) == '*' && string.charAt(n3 + 1) != '/') {
                    while (++n3 < n && Character.isWhitespace(string.charAt(n3))) {
                    }
                }
            } else if (n3 < n - 1 && string.charAt(n3) == '/' && string.charAt(n3 + 1) == '/') {
                ++n3;
                while (++n3 < n && Character.isWhitespace(string.charAt(n3))) {
                }
            }
            return n3;
        }

        private IPreferenceStore getPreferenceStore() {
            return PHPUiPlugin.getDefault().getPreferenceStore();
        }

        public void run() {
            int n;
            int n2;
            int n3;
            ISourceViewer iSourceViewer;
            StyledText styledText;
            boolean bl = true;
            IPreferenceStore iPreferenceStore = this.getPreferenceStore();
            if (iPreferenceStore != null) {
                bl = iPreferenceStore.getBoolean("useSmartHomeEnd");
            }
            if ((styledText = (iSourceViewer = PHPStructuredEditor.this.getSourceViewer()).getTextWidget()) == null || styledText.isDisposed()) {
                return;
            }
            int n4 = styledText.getCaretOffset();
            int n5 = styledText.getLineAtOffset(n4);
            int n6 = styledText.getOffsetAtLine(n5);
            IDocument iDocument = iSourceViewer.getDocument();
            try {
                n3 = PHPStructuredEditor.access$2(iSourceViewer, n4);
                n2 = iDocument.getLineInformationOfOffset(n3).getLength();
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            String string = "";
            if (n2 > 0) {
                n = n6 + n2 - 1;
                n = Math.min(n, styledText.getCharCount() - 1);
                string = styledText.getText(n6, n);
            }
            n = this.getLineStartPosition(iDocument, string, n2, n3);
            Point point = styledText.getSelection();
            int n7 = -1;
            if (bl) {
                n7 = n4 - n6 == n ? n6 : n6 + n;
            } else if (n4 > n6) {
                n7 = n6;
            }
            if (n7 == -1) {
                n7 = n4;
            } else {
                styledText.setCaretOffset(n7);
            }
            if (this.fDoSelect) {
                if (n4 < point.y) {
                    styledText.setSelection(point.y, n7);
                } else {
                    styledText.setSelection(point.x, n7);
                }
            } else {
                styledText.setSelection(n7);
            }
            this.fireSelectionChanged(point);
        }
    }
}

