/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.communication;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.php.internal.debug.core.debugger.Breakpoint;

public class CommunicationUtilities {
    public static void writeString(DataOutputStream dataOutputStream, String string) throws IOException {
        byte[] byArray = string.getBytes();
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
    }

    public static void writeStringAsBytes(DataOutputStream dataOutputStream, byte[] byArray) throws IOException {
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
    }

    public static void writeBreakpoint(DataOutputStream dataOutputStream, Breakpoint breakpoint) throws IOException {
        dataOutputStream.writeShort(breakpoint.getType());
        dataOutputStream.writeShort(breakpoint.getLifeTime());
        if (breakpoint.getConditionalFlag()) {
            CommunicationUtilities.writeString(dataOutputStream, breakpoint.getExpression());
            if (!breakpoint.getStaticFlag()) {
                return;
            }
        }
        CommunicationUtilities.writeString(dataOutputStream, breakpoint.getFileName());
        if (breakpoint.getStaticFlag()) {
            int n = breakpoint.getLineNumber();
            dataOutputStream.writeInt(n);
        }
    }

    public static String readString(DataInputStream dataInputStream) throws IOException {
        return new String(CommunicationUtilities.readStringAsBytes(dataInputStream));
    }

    public static String readEncodedString(DataInputStream dataInputStream, String string) throws IOException {
        byte[] byArray = CommunicationUtilities.readStringAsBytes(dataInputStream);
        String string2 = CommunicationUtilities.getTextFromBytes(byArray, string);
        return string2;
    }

    public static void writeEncodedString(DataOutputStream dataOutputStream, String string, String string2) throws IOException {
        byte[] byArray = CommunicationUtilities.getBytesFromText(string, string2);
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
    }

    public static final byte[] getBytesFromText(String string, String string2) {
        try {
            return string.getBytes(string2);
        }
        catch (Exception exception) {
            return string.getBytes();
        }
    }

    public static final String getTextFromBytes(byte[] byArray, String string) {
        try {
            return new String(byArray, string);
        }
        catch (Exception exception) {
            return new String(byArray);
        }
    }

    public static byte[] readStringAsBytes(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        return byArray;
    }

    public static Breakpoint readBreakpoint(DataInputStream dataInputStream) throws IOException {
        Breakpoint breakpoint = new Breakpoint();
        breakpoint.setType(dataInputStream.readShort());
        breakpoint.setLifeTime(dataInputStream.readShort());
        if (breakpoint.getType() == 2) {
            breakpoint.setExpression(CommunicationUtilities.readString(dataInputStream));
        }
        breakpoint.setFileName(CommunicationUtilities.readString(dataInputStream));
        if (breakpoint.getType() == 1) {
            breakpoint.setLineNumber(dataInputStream.readInt());
        }
        return breakpoint;
    }
}

