/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileFinder;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.AccessRule;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;

public class Main
implements ProblemSeverities,
SuffixConstants {
    Compiler batchCompiler;
    FileSystem.Classpath[] checkedClasspaths;
    public CompilerOptions compilerOptions;
    public String destinationPath;
    private boolean didSpecifySource;
    private boolean didSpecifyTarget;
    public String[] encodings;
    public int exportedClassFilesCounter;
    public String[] filenames;
    public boolean generatePackagesStructure;
    public int globalErrorsCount;
    public int globalProblemsCount;
    public int globalTasksCount;
    public int globalWarningsCount;
    private File javaHomeCache;
    private boolean javaHomeChecked;
    public long lineCount;
    public String log;
    public Logger logger;
    public int maxProblems;
    public boolean noWarn = false;
    public Map options;
    PrintWriter out;
    public boolean proceed = true;
    public boolean proceedOnError = false;
    public boolean produceRefInfo = false;
    public int repetitions;
    public boolean showProgress = false;
    public long startTime;
    public boolean systemExitWhenFinished = true;
    public long[] times;
    public int timesCounter;
    public boolean timing = false;
    public boolean verbose = false;
    public static ResourceBundle bundle;
    public static final String bundleName = "org.eclipse.jdt.internal.compiler.batch.messages";

    static {
        Main.relocalize();
    }

    public static String bind(String id) {
        return Main.bind(id, null);
    }

    public static String bind(String id, String binding) {
        return Main.bind(id, new String[]{binding});
    }

    public static String bind(String id, String binding1, String binding2) {
        return Main.bind(id, new String[]{binding1, binding2});
    }

    public static String bind(String id, String[] arguments) {
        if (id == null) {
            return "No message available";
        }
        String message = null;
        try {
            message = bundle.getString(id);
        }
        catch (MissingResourceException missingResourceException) {
            return "Missing message: " + id + " in: " + bundleName;
        }
        return MessageFormat.format(message, arguments);
    }

    public static boolean compile(String commandLine) {
        return Main.compile(commandLine, new PrintWriter(System.out), new PrintWriter(System.err));
    }

    public static boolean compile(String commandLine, PrintWriter outWriter, PrintWriter errWriter) {
        return new Main(outWriter, errWriter, false).compile(Main.tokenize(commandLine));
    }

    public static void main(String[] argv) {
        new Main(new PrintWriter(System.out), new PrintWriter(System.err), true).compile(argv);
    }

    public static void relocalize() {
        try {
            bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault());
        }
        catch (MissingResourceException e) {
            System.out.println("Missing resource : " + bundleName.replace('.', '/') + ".properties for locale " + Locale.getDefault());
            throw e;
        }
    }

    public static String[] tokenize(String commandLine) {
        int count = 0;
        String[] arguments = new String[10];
        StringTokenizer tokenizer = new StringTokenizer(commandLine, " \"", true);
        String token = "";
        boolean insideQuotes = false;
        boolean startNewToken = true;
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (token.equals(" ")) {
                if (insideQuotes) {
                    int n = count - 1;
                    arguments[n] = String.valueOf(arguments[n]) + token;
                    startNewToken = false;
                    continue;
                }
                startNewToken = true;
                continue;
            }
            if (token.equals("\"")) {
                if (!insideQuotes && startNewToken) {
                    if (count == arguments.length) {
                        String[] stringArray = arguments;
                        arguments = new String[count * 2];
                        System.arraycopy(stringArray, 0, arguments, 0, count);
                    }
                    arguments[count++] = "";
                }
                insideQuotes = !insideQuotes;
                startNewToken = false;
                continue;
            }
            if (insideQuotes) {
                int n = count - 1;
                arguments[n] = String.valueOf(arguments[n]) + token;
            } else if (token.length() > 0 && !startNewToken) {
                int n = count - 1;
                arguments[n] = String.valueOf(arguments[n]) + token;
            } else {
                String trimmedToken;
                if (count == arguments.length) {
                    String[] stringArray = arguments;
                    arguments = new String[count * 2];
                    System.arraycopy(stringArray, 0, arguments, 0, count);
                }
                if ((trimmedToken = token.trim()).length() != 0) {
                    arguments[count++] = trimmedToken;
                }
            }
            startNewToken = false;
        }
        String[] stringArray = arguments;
        arguments = new String[count];
        System.arraycopy(stringArray, 0, arguments, 0, count);
        return arguments;
    }

    public Main(PrintWriter outWriter, PrintWriter errWriter, boolean systemExitWhenFinished) {
        this(outWriter, errWriter, systemExitWhenFinished, null);
    }

    public Main(PrintWriter outWriter, PrintWriter errWriter, boolean systemExitWhenFinished, Map customDefaultOptions) {
        this.logger = new Logger(outWriter, errWriter);
        this.out = outWriter;
        this.systemExitWhenFinished = systemExitWhenFinished;
        this.options = new CompilerOptions().getMap();
        if (customDefaultOptions != null) {
            this.didSpecifySource = customDefaultOptions.get("org.eclipse.jdt.core.compiler.source") != null;
            this.didSpecifyTarget = customDefaultOptions.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform") != null;
            Iterator iter = customDefaultOptions.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                this.options.put(key, customDefaultOptions.get(key));
            }
        } else {
            this.didSpecifySource = false;
            this.didSpecifyTarget = false;
        }
    }

    private void addNewEntry(ArrayList paths, String currentClasspathName, ArrayList currentRuleSpecs, String customEncoding, boolean isSourceOnly) {
        AccessRule[] accessRules = new AccessRule[currentRuleSpecs.size()];
        boolean rulesOK = true;
        Iterator i = currentRuleSpecs.iterator();
        int j = 0;
        while (i.hasNext()) {
            String ruleSpec = (String)i.next();
            char key = ruleSpec.charAt(0);
            String pattern = ruleSpec.substring(1);
            if (pattern.length() > 0) {
                switch (key) {
                    case '+': {
                        accessRules[j++] = new AccessRule(pattern.toCharArray(), 0);
                        break;
                    }
                    case '~': {
                        accessRules[j++] = new AccessRule(pattern.toCharArray(), 0x1000118);
                        break;
                    }
                    case '-': {
                        accessRules[j++] = new AccessRule(pattern.toCharArray(), 0x1000133);
                        break;
                    }
                    case '?': {
                        accessRules[j++] = new AccessRule(pattern.toCharArray(), 0x1000133, true);
                        break;
                    }
                    default: {
                        rulesOK = false;
                        break;
                    }
                }
                continue;
            }
            rulesOK = false;
        }
        if (rulesOK) {
            String[] templates = new String[]{Main.bind("template.restrictedAccess.type", new String[]{"{0}", currentClasspathName}), Main.bind("template.restrictedAccess.constructor", new String[]{"{0}", currentClasspathName}), Main.bind("template.restrictedAccess.method", new String[]{"{0}", "{1}", currentClasspathName}), Main.bind("template.restrictedAccess.field", new String[]{"{0}", "{1}", currentClasspathName})};
            AccessRuleSet accessRuleSet = new AccessRuleSet(accessRules, templates);
            FileSystem.Classpath currentClasspath = FileSystem.getClasspath(currentClasspathName, customEncoding, isSourceOnly, accessRuleSet);
            if (currentClasspath != null) {
                paths.add(currentClasspath);
            } else {
                this.logger.logIncorrectClasspath(currentClasspathName);
            }
        } else {
            this.logger.logIncorrectClasspath(currentClasspathName);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compile(String[] argv) {
        try {
            try {
                this.configure(argv);
                if (this.proceed) {
                    if (this.showProgress) {
                        this.logger.compiling();
                    }
                    int i = 0;
                    while (true) {
                        if (i >= this.repetitions) {
                            if (this.times != null) {
                                this.logger.logAverage(this.times, this.lineCount);
                            }
                            if (!this.showProgress) break;
                            this.logger.printNewLine();
                            break;
                        }
                        this.globalProblemsCount = 0;
                        this.globalErrorsCount = 0;
                        this.globalWarningsCount = 0;
                        this.globalTasksCount = 0;
                        this.lineCount = 0L;
                        this.exportedClassFilesCounter = 0;
                        if (this.repetitions > 1) {
                            this.logger.flush();
                            this.logger.logRepetition(i, this.repetitions);
                        }
                        this.performCompilation();
                        ++i;
                    }
                }
                if (this.systemExitWhenFinished) {
                    this.logger.flush();
                    this.logger.close();
                    System.exit(this.globalErrorsCount > 0 ? -1 : 0);
                }
            }
            catch (InvalidInputException e) {
                block15: {
                    this.logger.logException(e);
                    if (this.systemExitWhenFinished) {
                        this.logger.flush();
                        this.logger.close();
                        System.exit(-1);
                    }
                    break block15;
                    catch (RuntimeException e2) {
                        this.logger.logException(e2);
                        if (!this.systemExitWhenFinished) break block15;
                        this.logger.flush();
                        this.logger.close();
                        System.exit(-1);
                    }
                }
                Object var3_5 = null;
                this.logger.flush();
                this.logger.close();
                return false;
            }
            Object var3_7 = null;
            this.logger.flush();
            this.logger.close();
            if (this.globalErrorsCount != 0) return false;
            return true;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.logger.flush();
            this.logger.close();
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void configure(String[] argv) throws InvalidInputException {
        if (argv == null || argv.length == 0) {
            this.printUsage();
            return;
        }
        bootclasspaths = new ArrayList<Object>(4);
        sourcepathClasspaths = new ArrayList<String>(4);
        classpaths = new ArrayList<Object>(4);
        extdirsClasspaths = null;
        endorsedDirClasspaths = null;
        index = -1;
        filesCount = 0;
        argCount = argv.length;
        mode = 0;
        this.repetitions = 0;
        printUsageRequired = false;
        usageSection = null;
        printVersionRequired = false;
        didSpecifyDefaultEncoding = false;
        didSpecifyDeprecation = false;
        didSpecifyWarnings = false;
        useEnableJavadoc = false;
        didSpecifyCompliance = false;
        customEncoding = null;
        currentArg = "";
        needExpansion = false;
        i = 0;
        while (i < argCount) {
            if (argv[i].startsWith("@")) {
                needExpansion = true;
                break;
            }
            ++i;
        }
        newCommandLineArgs = null;
        if (needExpansion) {
            newCommandLineArgs = new String[argCount];
            index = 0;
            i = 0;
            while (i < argCount) {
                newArgs = null;
                arg = argv[i].trim();
                if (arg.startsWith("@")) {
                    try {
                        reader = new LineNumberReader(new StringReader(new String(Util.getFileCharContent(new File(arg.substring(1)), null))));
                        buffer = new StringBuffer();
                        while ((line = reader.readLine()) != null) {
                            if ((line = line.trim()).startsWith("#")) continue;
                            buffer.append(line).append(" ");
                        }
                        newArgs = Main.tokenize(buffer.toString());
                    }
                    catch (IOException v0) {
                        throw new InvalidInputException(Main.bind("configure.invalidexpansionargumentname", arg));
                    }
                }
                if (newArgs != null) {
                    newCommandLineArgsLength = newCommandLineArgs.length;
                    newArgsLength = newArgs.length;
                    v1 = newCommandLineArgs;
                    newCommandLineArgs = new String[newCommandLineArgsLength + newArgsLength - 1];
                    System.arraycopy(v1, 0, newCommandLineArgs, 0, index);
                    System.arraycopy(newArgs, 0, newCommandLineArgs, index, newArgsLength);
                    index += newArgsLength;
                } else {
                    newCommandLineArgs[index++] = arg;
                }
                ++i;
            }
            index = -1;
        } else {
            newCommandLineArgs = argv;
            i = 0;
            while (i < argCount) {
                newCommandLineArgs[i] = newCommandLineArgs[i].trim();
                ++i;
            }
        }
        argCount = newCommandLineArgs.length;
        block35: while (++index < argCount) {
            if (customEncoding != null) {
                throw new InvalidInputException(Main.bind("configure.unexpectedCustomEncoding", currentArg, customEncoding));
            }
            currentArg = newCommandLineArgs[index];
            switch (mode) {
                case 0: {
                    customEncoding = null;
                    if (currentArg.endsWith("]") && mode != 8 && mode != 1 && mode != 11) {
                        encodingStart = currentArg.indexOf(91) + 1;
                        encodingEnd = currentArg.length() - 1;
                        if (encodingStart >= 1) {
                            if (encodingStart < encodingEnd) {
                                customEncoding = currentArg.substring(encodingStart, encodingEnd);
                                try {
                                    new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), customEncoding);
                                }
                                catch (UnsupportedEncodingException v2) {
                                    throw new InvalidInputException(Main.bind("configure.unsupportedEncoding", customEncoding));
                                }
                            }
                            currentArg = currentArg.substring(0, encodingStart - 1);
                        }
                    }
                    if (currentArg.endsWith(".java")) {
                        if (this.filenames == null) {
                            this.filenames = new String[argCount - index];
                            this.encodings = new String[argCount - index];
                        } else if (filesCount == this.filenames.length) {
                            length = this.filenames.length;
                            this.filenames = new String[length + argCount - index];
                            System.arraycopy(this.filenames, 0, this.filenames, 0, length);
                            this.encodings = new String[length + argCount - index];
                            System.arraycopy(this.encodings, 0, this.encodings, 0, length);
                        }
                        this.filenames[filesCount] = currentArg;
                        this.encodings[filesCount++] = customEncoding;
                        customEncoding = null;
                        mode = 0;
                        break;
                    }
                    if (currentArg.equals("-log")) {
                        if (this.log != null) {
                            throw new InvalidInputException(Main.bind("configure.duplicateLog", currentArg));
                        }
                        mode = 4;
                        break;
                    }
                    if (currentArg.equals("-repeat")) {
                        if (this.repetitions > 0) {
                            throw new InvalidInputException(Main.bind("configure.duplicateRepeat", currentArg));
                        }
                        mode = 5;
                        break;
                    }
                    if (currentArg.equals("-maxProblems")) {
                        if (this.maxProblems > 0) {
                            throw new InvalidInputException(Main.bind("configure.duplicateMaxProblems", currentArg));
                        }
                        mode = 9;
                        break;
                    }
                    if (currentArg.equals("-source")) {
                        mode = 6;
                        break;
                    }
                    if (currentArg.equals("-encoding")) {
                        mode = 7;
                        break;
                    }
                    if (currentArg.equals("-1.3")) {
                        if (didSpecifyCompliance) {
                            throw new InvalidInputException(Main.bind("configure.duplicateCompliance", currentArg));
                        }
                        didSpecifyCompliance = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.3");
                        mode = 0;
                        break;
                    }
                    if (currentArg.equals("-1.4")) {
                        if (didSpecifyCompliance) {
                            throw new InvalidInputException(Main.bind("configure.duplicateCompliance", currentArg));
                        }
                        didSpecifyCompliance = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                        mode = 0;
                        break;
                    }
                    if (currentArg.equals("-1.5") || currentArg.equals("-5") || currentArg.equals("-5.0")) {
                        if (didSpecifyCompliance) {
                            throw new InvalidInputException(Main.bind("configure.duplicateCompliance", currentArg));
                        }
                        didSpecifyCompliance = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                        mode = 0;
                        break;
                    }
                    if (currentArg.equals("-1.6") || currentArg.equals("-6") || currentArg.equals("-6.0")) {
                        if (didSpecifyCompliance) {
                            throw new InvalidInputException(Main.bind("configure.duplicateCompliance", currentArg));
                        }
                        didSpecifyCompliance = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
                        mode = 0;
                        break;
                    }
                    if (currentArg.equals("-d")) {
                        if (this.destinationPath != null) {
                            errorMessage = new StringBuffer();
                            errorMessage.append(currentArg);
                            if (index + 1 < argCount) {
                                errorMessage.append(' ');
                                errorMessage.append(newCommandLineArgs[index + 1]);
                            }
                            throw new InvalidInputException(Main.bind("configure.duplicateOutputPath", errorMessage.toString()));
                        }
                        mode = 2;
                        this.generatePackagesStructure = true;
                        break;
                    }
                    if (currentArg.equals("-classpath") || currentArg.equals("-cp")) {
                        mode = 1;
                        break;
                    }
                    if (currentArg.equals("-bootclasspath")) {
                        if (bootclasspaths.size() > 0) {
                            errorMessage = new StringBuffer();
                            errorMessage.append(currentArg);
                            if (index + 1 < argCount) {
                                errorMessage.append(' ');
                                errorMessage.append(newCommandLineArgs[index + 1]);
                            }
                            throw new InvalidInputException(Main.bind("configure.duplicateBootClasspath", errorMessage.toString()));
                        }
                        mode = 8;
                        break;
                    }
                    if (currentArg.equals("-sourcepath")) {
                        if (sourcepathClasspaths.size() > 0) {
                            errorMessage = new StringBuffer();
                            errorMessage.append(currentArg);
                            if (index + 1 < argCount) {
                                errorMessage.append(' ');
                                errorMessage.append(newCommandLineArgs[index + 1]);
                            }
                            throw new InvalidInputException(Main.bind("configure.duplicateSourcepath", errorMessage.toString()));
                        }
                        mode = 11;
                        break;
                    }
                    if (currentArg.equals("-extdirs")) {
                        if (extdirsClasspaths != null) {
                            errorMessage = new StringBuffer();
                            errorMessage.append(currentArg);
                            if (index + 1 < argCount) {
                                errorMessage.append(' ');
                                errorMessage.append(newCommandLineArgs[index + 1]);
                            }
                            throw new InvalidInputException(Main.bind("configure.duplicateExtDirs", errorMessage.toString()));
                        }
                        mode = 10;
                        break;
                    }
                    if (currentArg.equals("-endorseddirs")) {
                        if (endorsedDirClasspaths != null) {
                            errorMessage = new StringBuffer();
                            errorMessage.append(currentArg);
                            if (index + 1 < argCount) {
                                errorMessage.append(' ');
                                errorMessage.append(newCommandLineArgs[index + 1]);
                            }
                            throw new InvalidInputException(Main.bind("configure.duplicateEndorsedDirs", errorMessage.toString()));
                        }
                        mode = 12;
                        break;
                    }
                    if (currentArg.equals("-progress")) {
                        mode = 0;
                        this.showProgress = true;
                        break;
                    }
                    if (currentArg.equals("-proceedOnError")) {
                        mode = 0;
                        this.proceedOnError = true;
                        break;
                    }
                    if (currentArg.equals("-time")) {
                        mode = 0;
                        this.timing = true;
                        break;
                    }
                    if (currentArg.equals("-version") || currentArg.equals("-v")) {
                        this.logger.logVersion(true);
                        this.proceed = false;
                        return;
                    }
                    if (currentArg.equals("-showversion")) {
                        printVersionRequired = true;
                        mode = 0;
                        break;
                    }
                    if ("-deprecation".equals(currentArg)) {
                        didSpecifyDeprecation = true;
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                        mode = 0;
                        break;
                    }
                    if (currentArg.equals("-help") || currentArg.equals("-?")) {
                        printUsageRequired = true;
                        mode = 0;
                        break;
                    }
                    if (currentArg.equals("-help:warn") || currentArg.equals("-?:warn")) {
                        printUsageRequired = true;
                        usageSection = "misc.usage.warn";
                        break;
                    }
                    if (currentArg.equals("-noExit")) {
                        this.systemExitWhenFinished = false;
                        mode = 0;
                        break;
                    }
                    if (currentArg.equals("-verbose")) {
                        this.verbose = true;
                        mode = 0;
                        break;
                    }
                    if (currentArg.equals("-referenceInfo")) {
                        this.produceRefInfo = true;
                        mode = 0;
                        break;
                    }
                    if (currentArg.equals("-inlineJSR")) {
                        mode = 0;
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode", "enabled");
                        break;
                    }
                    if (currentArg.startsWith("-g")) {
                        mode = 0;
                        debugOption = currentArg;
                        length = currentArg.length();
                        if (length == 2) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                            break;
                        }
                        if (length > 3) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
                            if (length == 7 && debugOption.equals("-g:none")) continue block35;
                            tokenizer = new StringTokenizer(debugOption.substring(3, debugOption.length()), ",");
                            while (tokenizer.hasMoreTokens()) {
                                token = tokenizer.nextToken();
                                if (token.equals("vars")) {
                                    this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                                    continue;
                                }
                                if (token.equals("lines")) {
                                    this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                                    continue;
                                }
                                if (token.equals("source")) {
                                    this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                                    continue;
                                }
                                throw new InvalidInputException(Main.bind("configure.invalidDebugOption", debugOption));
                            }
                            continue block35;
                        }
                        throw new InvalidInputException(Main.bind("configure.invalidDebugOption", debugOption));
                    }
                    if (currentArg.startsWith("-nowarn")) {
                        this.disableWarnings();
                        mode = 0;
                        break;
                    }
                    if (currentArg.startsWith("-warn")) {
                        mode = 0;
                        warningOption = currentArg;
                        length = currentArg.length();
                        if (length == 10 && warningOption.equals("-warn:none")) {
                            this.disableWarnings();
                            break;
                        }
                        if (length <= 6) {
                            throw new InvalidInputException(Main.bind("configure.invalidWarningConfiguration", warningOption));
                        }
                        switch (warningOption.charAt(6)) {
                            case '+': {
                                warnTokenStart = 7;
                                isEnabling = true;
                                break;
                            }
                            case '-': {
                                warnTokenStart = 7;
                                isEnabling = false;
                                break;
                            }
                            default: {
                                warnTokenStart = 6;
                                if (!didSpecifyWarnings) {
                                    this.disableWarnings();
                                }
                                isEnabling = true;
                            }
                        }
                        tokenizer = new StringTokenizer(warningOption.substring(warnTokenStart, warningOption.length()), ",");
                        tokenCounter = 0;
                        if (didSpecifyDeprecation) {
                            this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                        }
                        while (tokenizer.hasMoreTokens()) {
                            token = tokenizer.nextToken();
                            ++tokenCounter;
                            if (token.equals("constructorName")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("pkgDefaultMethod") || token.equals("packageDefaultMethod")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("maskedCatchBlock") || token.equals("maskedCatchBlocks")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("deprecation")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", isEnabling != false ? "warning" : "ignore");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "disabled");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "disabled");
                                continue;
                            }
                            if (token.equals("allDeprecation")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", isEnabling != false ? "warning" : "ignore");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", isEnabling != false ? "enabled" : "disabled");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", isEnabling != false ? "enabled" : "disabled");
                                continue;
                            }
                            if (token.equals("unusedLocal") || token.equals("unusedLocals")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("unusedArgument") || token.equals("unusedArguments")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("unusedImport") || token.equals("unusedImports")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("unusedPrivate")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("unusedLabel")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLabel", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("localHiding")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("fieldHiding")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("specialParamHiding")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.specialParameterHidingField", isEnabling != false ? "enabled" : "disabled");
                                continue;
                            }
                            if (token.equals("conditionAssign")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("syntheticAccess") || token.equals("synthetic-access")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("nls")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("staticReceiver")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("indirectStatic")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("noEffectAssign")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.noEffectAssignment", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("intfNonInherited") || token.equals("interfaceNonInherited")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("charConcat") || token.equals("noImplicitStringConversion")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("semicolon")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.emptyStatement", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("serial")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("emptyBlock")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("uselessTypeCheck")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("unchecked") || token.equals("unsafe")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("raw")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("finalBound")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.finalParameterBound", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("suppress")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", isEnabling != false ? "enabled" : "disabled");
                                continue;
                            }
                            if (token.equals("warningToken")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.unhandledWarningToken", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("unnecessaryElse")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryElse", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("javadoc")) {
                                if (!useEnableJavadoc) {
                                    this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", isEnabling != false ? "enabled" : "disabled");
                                }
                                if (!isEnabling) continue;
                                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "warning");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", "enabled");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", "disabled");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef", "disabled");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", "warning");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
                                continue;
                            }
                            if (token.equals("allJavadoc")) {
                                if (!useEnableJavadoc) {
                                    this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", isEnabling != false ? "enabled" : "disabled");
                                }
                                if (!isEnabling) continue;
                                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "warning");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", "enabled");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", "warning");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", "warning");
                                continue;
                            }
                            if (token.startsWith("tasks")) {
                                taskTags = "";
                                start = token.indexOf(40);
                                end = token.indexOf(41);
                                if (start >= 0 && end >= 0 && start < end) {
                                    taskTags = token.substring(start + 1, end).trim();
                                    taskTags = taskTags.replace('|', ',');
                                }
                                if (taskTags.length() == 0) {
                                    throw new InvalidInputException(Main.bind("configure.invalidTaskTag", token));
                                }
                                this.options.put("org.eclipse.jdt.core.compiler.taskTags", isEnabling != false ? taskTags : "");
                                continue;
                            }
                            if (token.equals("assertIdentifier")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("enumIdentifier")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("finally")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("unusedThrown")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("unqualifiedField") || token.equals("unqualified-field-access")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("typeHiding")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("varargsCast")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.varargsArgumentNeedCast", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("null")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.nullReference", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("boxing")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.autoboxing", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("over-ann")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("dep-ann")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("intfAnnotation")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.annotationSuperInterface", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("enumSwitch") || token.equals("incomplete-switch")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("hiding")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", isEnabling != false ? "warning" : "ignore");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", isEnabling != false ? "warning" : "ignore");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", isEnabling != false ? "warning" : "ignore");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("static-access")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", isEnabling != false ? "warning" : "ignore");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("unused")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", isEnabling != false ? "warning" : "ignore");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", isEnabling != false ? "warning" : "ignore");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", isEnabling != false ? "warning" : "ignore");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", isEnabling != false ? "warning" : "ignore");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", isEnabling != false ? "warning" : "ignore");
                                this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLabel", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("paramAssign")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.parameterAssignment", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("discouraged")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.discouragedReference", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("forbidden")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.forbiddenReference", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            if (token.equals("fallthrough")) {
                                this.options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", isEnabling != false ? "warning" : "ignore");
                                continue;
                            }
                            throw new InvalidInputException(Main.bind("configure.invalidWarning", token));
                        }
                        if (tokenCounter == 0) {
                            throw new InvalidInputException(Main.bind("configure.invalidWarningOption", currentArg));
                        }
                        didSpecifyWarnings = true;
                        break;
                    }
                    if (currentArg.equals("-target")) {
                        mode = 3;
                        break;
                    }
                    if (currentArg.equals("-preserveAllLocals")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
                        mode = 0;
                        break;
                    }
                    if (currentArg.equals("-enableJavadoc")) {
                        mode = 0;
                        this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
                        useEnableJavadoc = true;
                        break;
                    }
                    if (currentArg.equals("-Xemacs")) {
                        mode = 0;
                        this.logger.setEmacs();
                        break;
                    }
                    if (currentArg.startsWith("-X")) {
                        mode = 0;
                        break;
                    }
                    if (currentArg.startsWith("-J")) {
                        mode = 0;
                        break;
                    }
                    if (currentArg.equals("-O")) {
                        mode = 0;
                        break;
                    }
                    ** GOTO lbl802
                }
                case 3: {
                    if (this.didSpecifyTarget) {
                        throw new InvalidInputException(Main.bind("configure.duplicateTarget", currentArg));
                    }
                    this.didSpecifyTarget = true;
                    if (currentArg.equals("1.1")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
                    } else if (currentArg.equals("1.2")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                    } else if (currentArg.equals("1.3")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.3");
                    } else if (currentArg.equals("1.4")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                    } else if (currentArg.equals("1.5") || currentArg.equals("5") || currentArg.equals("5.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                    } else if (currentArg.equals("1.6") || currentArg.equals("6") || currentArg.equals("6.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                    } else if (currentArg.equals("jsr14")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "jsr14");
                    } else {
                        throw new InvalidInputException(Main.bind("configure.targetJDK", currentArg));
                    }
                    mode = 0;
                    break;
                }
                case 4: {
                    this.log = currentArg;
                    mode = 0;
                    break;
                }
                case 5: {
                    try {
                        this.repetitions = Integer.parseInt(currentArg);
                        if (this.repetitions <= 0) {
                            throw new InvalidInputException(Main.bind("configure.repetition", currentArg));
                        }
                    }
                    catch (NumberFormatException v3) {
                        throw new InvalidInputException(Main.bind("configure.repetition", currentArg));
                    }
                    mode = 0;
                    break;
                }
                case 9: {
                    try {
                        this.maxProblems = Integer.parseInt(currentArg);
                        if (this.maxProblems <= 0) {
                            throw new InvalidInputException(Main.bind("configure.maxProblems", currentArg));
                        }
                        this.options.put("org.eclipse.jdt.core.compiler.maxProblemPerUnit", currentArg);
                    }
                    catch (NumberFormatException v4) {
                        throw new InvalidInputException(Main.bind("configure.maxProblems", currentArg));
                    }
                    mode = 0;
                    break;
                }
                case 6: {
                    if (this.didSpecifySource) {
                        throw new InvalidInputException(Main.bind("configure.duplicateSource", currentArg));
                    }
                    this.didSpecifySource = true;
                    if (currentArg.equals("1.3")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                    } else if (currentArg.equals("1.4")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.4");
                    } else if (currentArg.equals("1.5") || currentArg.equals("5") || currentArg.equals("5.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.5");
                    } else if (currentArg.equals("1.6") || currentArg.equals("6") || currentArg.equals("6.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.6");
                    } else {
                        throw new InvalidInputException(Main.bind("configure.source", currentArg));
                    }
                    mode = 0;
                    break;
                }
                case 7: {
                    if (didSpecifyDefaultEncoding) {
                        throw new InvalidInputException(Main.bind("configure.duplicateDefaultEncoding", currentArg));
                    }
                    try {
                        new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), currentArg);
                    }
                    catch (UnsupportedEncodingException v5) {
                        throw new InvalidInputException(Main.bind("configure.unsupportedEncoding", currentArg));
                    }
                    this.options.put("org.eclipse.jdt.core.encoding", currentArg);
                    didSpecifyDefaultEncoding = true;
                    mode = 0;
                    break;
                }
                case 2: {
                    this.destinationPath = currentArg;
                    mode = 0;
                    break;
                }
                case 1: {
                    classpaths.add(currentArg);
                    mode = 0;
                    break;
                }
                case 8: {
                    bootclasspaths.add(currentArg);
                    mode = 0;
                    break;
                }
                case 11: {
                    sourcepathClasspaths.add(currentArg);
                    mode = 0;
                    break;
                }
                case 10: {
                    tokenizer = new StringTokenizer(currentArg, File.pathSeparator, false);
                    extdirsClasspaths = new ArrayList<Object>(4);
                    while (tokenizer.hasMoreTokens()) {
                        extdirsClasspaths.add(tokenizer.nextToken());
                    }
                    mode = 0;
                    break;
                }
                case 12: {
                    tokenizer = new StringTokenizer(currentArg, File.pathSeparator, false);
                    endorsedDirClasspaths = new ArrayList<Object>(4);
                    while (tokenizer.hasMoreTokens()) {
                        endorsedDirClasspaths.add(tokenizer.nextToken());
                    }
                    mode = 0;
                    break;
                }
lbl802:
                // 2 sources

                default: {
                    currentArg = currentArg.replace('/', File.separatorChar);
                    if (currentArg.endsWith(File.separator)) {
                        currentArg = currentArg.substring(0, currentArg.length() - File.separator.length());
                    }
                    if (!(dir = new File(currentArg)).isDirectory()) {
                        throw new InvalidInputException(Main.bind("configure.directoryNotExist", currentArg));
                    }
                    finder = new FileFinder();
                    try {
                        finder.find(dir, ".JAVA", this.verbose);
                    }
                    catch (Exception v6) {
                        throw new InvalidInputException(Main.bind("configure.IOError", currentArg));
                    }
                    if (this.filenames != null) {
                        results = finder.resultFiles;
                        length = results.length;
                        this.filenames = new String[length + filesCount];
                        System.arraycopy(this.filenames, 0, this.filenames, 0, filesCount);
                        this.encodings = new String[length + filesCount];
                        System.arraycopy(this.encodings, 0, this.encodings, 0, filesCount);
                        System.arraycopy(results, 0, this.filenames, filesCount, length);
                        i = 0;
                        while (i < length) {
                            this.encodings[filesCount + i] = customEncoding;
                            ++i;
                        }
                        filesCount += length;
                        customEncoding = null;
                    } else {
                        this.filenames = finder.resultFiles;
                        filesCount = this.filenames.length;
                        this.encodings = new String[filesCount];
                        i = 0;
                        while (i < filesCount) {
                            this.encodings[i] = customEncoding;
                            ++i;
                        }
                        customEncoding = null;
                    }
                    mode = 0;
                }
            }
        }
        if (this.log != null) {
            this.logger.setLog(this.log);
        } else {
            this.showProgress = false;
        }
        this.logger.logVersion(printVersionRequired);
        if (printUsageRequired || filesCount == 0) {
            if (usageSection == null) {
                this.printUsage();
            } else {
                this.printUsage(usageSection);
            }
            this.proceed = false;
            return;
        }
        javaHome = this.getJavaHome();
        bootclasspathsSize = bootclasspaths.size();
        if (bootclasspathsSize != 0) {
            paths = new String[bootclasspathsSize];
            bootclasspaths.toArray(paths);
            bootclasspaths.clear();
            i = 0;
            while (i < bootclasspathsSize) {
                this.processPathEntries(4, bootclasspaths, paths[i], customEncoding, false);
                ++i;
            }
        } else {
            javaversion = System.getProperty("java.version");
            if (javaversion != null && javaversion.equalsIgnoreCase("1.1.8")) {
                this.logger.logWrongJDK();
                this.proceed = false;
                return;
            }
            if (javaHome != null) {
                directoriesToCheck = null;
                directoriesToCheck = System.getProperty("os.name").startsWith("Mac") != false ? new File[]{new File(javaHome, "../Classes")} : new File[]{new File(javaHome, "lib")};
                systemLibrariesJars = this.getLibrariesFiles(directoriesToCheck);
                if (systemLibrariesJars != null) {
                    i = 0;
                    max = systemLibrariesJars.length;
                    while (i < max) {
                        current = systemLibrariesJars[i];
                        if (current != null) {
                            j = 0;
                            max2 = current.length;
                            while (j < max2) {
                                classpath = FileSystem.getClasspath(current[j].getAbsolutePath(), null, false, null);
                                if (classpath != null) {
                                    bootclasspaths.add(classpath);
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        classpathsSize = classpaths.size();
        if (classpaths.size() != 0) {
            paths = new String[classpathsSize];
            classpaths.toArray(paths);
            classpaths.clear();
            i = 0;
            while (i < classpathsSize) {
                this.processPathEntries(4, classpaths, paths[i], customEncoding, false);
                ++i;
            }
        } else {
            classProp = System.getProperty("java.class.path");
            if (classProp == null || classProp.length() == 0) {
                this.logger.logNoClasspath();
                classpaths.add(FileSystem.getClasspath(System.getProperty("user.dir"), customEncoding, null));
            } else {
                tokenizer = new StringTokenizer(classProp, File.pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    token = tokenizer.nextToken();
                    currentClasspath = FileSystem.getClasspath(token, customEncoding, null);
                    if (currentClasspath != null) {
                        classpaths.add(currentClasspath);
                        continue;
                    }
                    this.logger.logIncorrectClasspath(token);
                }
            }
        }
        sourcepathClasspathsSize = sourcepathClasspaths.size();
        if (sourcepathClasspathsSize != 0) {
            paths = new String[sourcepathClasspathsSize];
            sourcepathClasspaths.toArray(paths);
            sourcepathClasspaths.clear();
            i = 0;
            while (i < sourcepathClasspathsSize) {
                this.processPathEntries(4, sourcepathClasspaths, paths[i], customEncoding, true);
                ++i;
            }
        }
        if (filesCount != 0) {
            this.filenames = new String[filesCount];
            System.arraycopy(this.filenames, 0, this.filenames, 0, filesCount);
        }
        if (extdirsClasspaths == null) {
            extdirsClasspaths = new ArrayList<E>(4);
            extdirsStr = System.getProperty("java.ext.dirs");
            if (extdirsStr == null) {
                if (javaHome != null) {
                    extdirsClasspaths.add(String.valueOf(javaHome.getAbsolutePath()) + "/lib/ext");
                }
            } else {
                tokenizer = new StringTokenizer(extdirsStr, File.pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    extdirsClasspaths.add(tokenizer.nextToken());
                }
            }
        }
        if (extdirsClasspaths.size() != 0) {
            directoriesToCheck = new File[extdirsClasspaths.size()];
            i = 0;
            while (i < directoriesToCheck.length) {
                directoriesToCheck[i] = new File((String)extdirsClasspaths.get(i));
                ++i;
            }
            extdirsClasspaths.clear();
            extdirsJars = this.getLibrariesFiles(directoriesToCheck);
            if (extdirsJars != null) {
                i = 0;
                max = extdirsJars.length;
                while (i < max) {
                    current = extdirsJars[i];
                    if (current != null) {
                        j = 0;
                        max2 = current.length;
                        while (j < max2) {
                            classpath = FileSystem.getClasspath(current[j].getAbsolutePath(), null, null);
                            if (classpath != null) {
                                extdirsClasspaths.add(classpath);
                            }
                            ++j;
                        }
                    } else if (directoriesToCheck[i].isFile()) {
                        this.logger.logIncorrectExtDirsEntry(directoriesToCheck[i].getAbsolutePath());
                    }
                    ++i;
                }
            }
        }
        if (endorsedDirClasspaths == null) {
            endorsedDirClasspaths = new ArrayList<E>(4);
            endorsedDirsStr = System.getProperty("java.endorsed.dirs");
            if (endorsedDirsStr == null) {
                if (javaHome != null) {
                    endorsedDirClasspaths.add(String.valueOf(javaHome.getAbsolutePath()) + "/lib/endorsed");
                }
            } else {
                tokenizer = new StringTokenizer(endorsedDirsStr, File.pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    endorsedDirClasspaths.add(tokenizer.nextToken());
                }
            }
        }
        if (endorsedDirClasspaths.size() != 0) {
            directoriesToCheck = new File[endorsedDirClasspaths.size()];
            i = 0;
            while (i < directoriesToCheck.length) {
                directoriesToCheck[i] = new File((String)endorsedDirClasspaths.get(i));
                ++i;
            }
            endorsedDirClasspaths.clear();
            endorsedDirsJars = this.getLibrariesFiles(directoriesToCheck);
            if (endorsedDirsJars != null) {
                i = 0;
                max = endorsedDirsJars.length;
                while (i < max) {
                    current = endorsedDirsJars[i];
                    if (current != null) {
                        j = 0;
                        max2 = current.length;
                        while (j < max2) {
                            classpath = FileSystem.getClasspath(current[j].getAbsolutePath(), null, null);
                            if (classpath != null) {
                                endorsedDirClasspaths.add(classpath);
                            }
                            ++j;
                        }
                    } else if (directoriesToCheck[i].isFile()) {
                        this.logger.logIncorrectEndorsedDirsEntry(directoriesToCheck[i].getAbsolutePath());
                    }
                    ++i;
                }
            }
        }
        bootclasspaths.addAll(endorsedDirClasspaths);
        bootclasspaths.addAll(extdirsClasspaths);
        bootclasspaths.addAll(sourcepathClasspaths);
        bootclasspaths.addAll(classpaths);
        classpaths = bootclasspaths;
        this.checkedClasspaths = new FileSystem.Classpath[classpaths.size()];
        classpaths.toArray(this.checkedClasspaths);
        if (this.destinationPath == null) {
            this.generatePackagesStructure = false;
        } else if ("none".equals(this.destinationPath)) {
            this.destinationPath = null;
        }
        if (didSpecifyCompliance) {
            version = this.options.get("org.eclipse.jdt.core.compiler.compliance");
            if ("1.3".equals(version)) {
                if (!this.didSpecifySource) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
                }
            } else if ("1.4".equals(version)) {
                if (!this.didSpecifySource) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                }
            } else if ("1.5".equals(version)) {
                if (!this.didSpecifySource) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.5");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                }
            } else if ("1.6".equals(version)) {
                if (!this.didSpecifySource) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.6");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                }
            }
        }
        if (this.didSpecifySource) {
            version = this.options.get("org.eclipse.jdt.core.compiler.source");
            if ("1.4".equals(version)) {
                if (!didSpecifyCompliance) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                }
            } else if ("1.5".equals(version)) {
                if (!didSpecifyCompliance) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                }
            } else if ("1.6".equals(version)) {
                if (!didSpecifyCompliance) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                }
            }
        }
        sourceVersion = this.options.get("org.eclipse.jdt.core.compiler.source");
        compliance = this.options.get("org.eclipse.jdt.core.compiler.compliance");
        if (sourceVersion.equals("1.6") && CompilerOptions.versionToJdkLevel(compliance) < 0x320000L) {
            throw new InvalidInputException(Main.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.6"));
        }
        if (sourceVersion.equals("1.5") && CompilerOptions.versionToJdkLevel(compliance) < 0x310000L) {
            throw new InvalidInputException(Main.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.5"));
        }
        if (sourceVersion.equals("1.4") && CompilerOptions.versionToJdkLevel(compliance) < 0x300000L) {
            throw new InvalidInputException(Main.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.4"));
        }
        if (this.didSpecifyTarget) {
            targetVersion = this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
            if ("jsr14".equals(targetVersion)) {
                if (CompilerOptions.versionToJdkLevel(sourceVersion) < 0x310000L) {
                    throw new InvalidInputException(Main.bind("configure.incompatibleTargetForGenericSource", (String)targetVersion, (String)sourceVersion));
                }
            } else {
                if (CompilerOptions.versionToJdkLevel(sourceVersion) >= 0x320000L && CompilerOptions.versionToJdkLevel(targetVersion) < 0x320000L) {
                    throw new InvalidInputException(Main.bind("configure.incompatibleTargetForSource", (String)targetVersion, "1.6"));
                }
                if (CompilerOptions.versionToJdkLevel(sourceVersion) >= 0x310000L && CompilerOptions.versionToJdkLevel(targetVersion) < 0x310000L) {
                    throw new InvalidInputException(Main.bind("configure.incompatibleTargetForSource", (String)targetVersion, "1.5"));
                }
                if (CompilerOptions.versionToJdkLevel(sourceVersion) >= 0x300000L && CompilerOptions.versionToJdkLevel(targetVersion) < 0x300000L) {
                    throw new InvalidInputException(Main.bind("configure.incompatibleTargetForSource", (String)targetVersion, "1.4"));
                }
                if (CompilerOptions.versionToJdkLevel(compliance) < CompilerOptions.versionToJdkLevel(targetVersion)) {
                    throw new InvalidInputException(Main.bind("configure.incompatibleComplianceForTarget", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), (String)targetVersion));
                }
            }
        }
        this.logger.logCommandLineArguments(newCommandLineArgs);
        this.logger.logOptions(this.options);
        this.logger.logClasspath(this.checkedClasspaths);
        if (this.repetitions == 0) {
            this.repetitions = 1;
        }
        if (this.repetitions >= 3 && this.timing) {
            this.times = new long[this.repetitions];
            this.timesCounter = 0;
        }
    }

    private void disableWarnings() {
        Object[] entries = this.options.entrySet().toArray();
        int i = 0;
        int max = entries.length;
        while (i < max) {
            Map.Entry entry = (Map.Entry)entries[i];
            if (entry.getKey() instanceof String && entry.getValue() instanceof String && ((String)entry.getValue()).equals("warning")) {
                this.options.put(entry.getKey(), "ignore");
            }
            ++i;
        }
        this.options.put("org.eclipse.jdt.core.compiler.taskTags", "");
    }

    public String extractDestinationPathFromSourceFile(CompilationResult result) {
        String outputPathName;
        File output;
        char[] fileName;
        int lastIndex;
        ICompilationUnit compilationUnit = result.compilationUnit;
        if (compilationUnit != null && (lastIndex = CharOperation.lastIndexOf(File.separatorChar, fileName = compilationUnit.getFileName())) != -1 && (output = new File(outputPathName = new String(fileName, 0, lastIndex))).exists() && output.isDirectory()) {
            return outputPathName;
        }
        return System.getProperty("user.dir");
    }

    public ICompilerRequestor getBatchRequestor() {
        return new ICompilerRequestor(){
            int lineDelta = 0;

            public void acceptResult(CompilationResult compilationResult) {
                if (compilationResult.lineSeparatorPositions != null) {
                    int unitLineCount = compilationResult.lineSeparatorPositions.length;
                    Main.this.lineCount += (long)unitLineCount;
                    this.lineDelta += unitLineCount;
                    if (Main.this.showProgress && this.lineDelta > 2000) {
                        Main.this.logger.logProgress();
                        this.lineDelta = 0;
                    }
                }
                Main.this.logger.startLoggingSource(compilationResult);
                if (compilationResult.hasProblems() || compilationResult.hasTasks()) {
                    int localErrorCount = Main.this.logger.logProblems(compilationResult.getAllProblems(), compilationResult.compilationUnit.getContents(), Main.this);
                    if (Main.this.systemExitWhenFinished && !Main.this.proceedOnError && localErrorCount > 0) {
                        CompilationUnitDeclaration[] queuedUnits = Main.this.batchCompiler.unitsToProcess;
                        int i = 0;
                        int length = Main.this.batchCompiler.totalUnits;
                        while (i < length) {
                            CompilationResult result;
                            CompilationUnitDeclaration queuedUnit = queuedUnits[i];
                            if (queuedUnit != null && (result = queuedUnit.compilationResult).hasProblems() && !result.hasBeenAccepted) {
                                Main.this.logger.logProblems(result.getAllProblems(), result.compilationUnit.getContents(), Main.this);
                            }
                            ++i;
                        }
                        Main.this.logger.endLoggingSource();
                        Main.this.logger.endLoggingSources();
                        Main.this.logger.printStats(Main.this);
                        Main.this.logger.flush();
                        Main.this.logger.close();
                        System.exit(-1);
                    }
                }
                Main.this.outputClassFiles(compilationResult);
                Main.this.logger.endLoggingSource();
            }
        };
    }

    public CompilationUnit[] getCompilationUnits() throws InvalidInputException {
        int fileCount = this.filenames.length;
        CompilationUnit[] units = new CompilationUnit[fileCount];
        HashtableOfObject knownFileNames = new HashtableOfObject(fileCount);
        String defaultEncoding = (String)this.options.get("org.eclipse.jdt.core.encoding");
        if ("".equals(defaultEncoding)) {
            defaultEncoding = null;
        }
        int i = 0;
        while (i < fileCount) {
            char[] charName = this.filenames[i].toCharArray();
            if (knownFileNames.get(charName) != null) {
                throw new InvalidInputException(Main.bind("unit.more", this.filenames[i]));
            }
            knownFileNames.put(charName, charName);
            File file = new File(this.filenames[i]);
            if (!file.exists()) {
                throw new InvalidInputException(Main.bind("unit.missing", this.filenames[i]));
            }
            String encoding = this.encodings[i];
            if (encoding == null) {
                encoding = defaultEncoding;
            }
            units[i] = new CompilationUnit(null, this.filenames[i], encoding);
            ++i;
        }
        return units;
    }

    public IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            public boolean proceedOnErrors() {
                return Main.this.proceedOnError;
            }

            public boolean stopOnFirstError() {
                return false;
            }
        };
    }

    private File getJavaHome() {
        if (!this.javaHomeChecked) {
            this.javaHomeChecked = true;
            String javaHome = System.getProperty("java.home");
            if (javaHome != null) {
                this.javaHomeCache = new File(javaHome);
                if (!this.javaHomeCache.exists()) {
                    this.javaHomeCache = null;
                }
            }
        }
        return this.javaHomeCache;
    }

    private File[][] getLibrariesFiles(File[] files) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                String lowerCaseName = name.toLowerCase();
                return lowerCaseName.endsWith(".jar") || lowerCaseName.endsWith(".zip");
            }
        };
        int filesLength = files.length;
        File[][] result = new File[filesLength][];
        int i = 0;
        while (i < filesLength) {
            File currentFile = files[i];
            if (currentFile.exists() && currentFile.isDirectory()) {
                result[i] = currentFile.listFiles(filter);
            }
            ++i;
        }
        return result;
    }

    public FileSystem getLibraryAccess() {
        String defaultEncoding = (String)this.options.get("org.eclipse.jdt.core.encoding");
        if ("".equals(defaultEncoding)) {
            defaultEncoding = null;
        }
        return new FileSystem(this.checkedClasspaths, this.filenames);
    }

    public IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(Locale.getDefault());
    }

    public void outputClassFiles(CompilationResult unitResult) {
        if (unitResult != null && (!unitResult.hasErrors() || this.proceedOnError)) {
            ClassFile[] classFiles = unitResult.getClassFiles();
            if (!this.generatePackagesStructure) {
                this.destinationPath = this.extractDestinationPathFromSourceFile(unitResult);
            }
            if (this.destinationPath != null) {
                int i = 0;
                int fileCount = classFiles.length;
                while (i < fileCount) {
                    ClassFile classFile = classFiles[i];
                    char[] filename = classFile.fileName();
                    int length = filename.length;
                    char[] relativeName = new char[length + 6];
                    System.arraycopy(filename, 0, relativeName, 0, length);
                    System.arraycopy(SuffixConstants.SUFFIX_class, 0, relativeName, length, 6);
                    CharOperation.replace(relativeName, '/', File.separatorChar);
                    String relativeStringName = new String(relativeName);
                    try {
                        if (this.compilerOptions.verbose) {
                            this.out.println(Messages.bind(Messages.compilation_write, new String[]{String.valueOf(this.exportedClassFilesCounter + 1), relativeStringName}));
                        }
                        ClassFile.writeToDisk(this.generatePackagesStructure, this.destinationPath, relativeStringName, classFile);
                        LookupEnvironment env = this.batchCompiler.lookupEnvironment;
                        if (classFile.isShared) {
                            env.classFilePool.release(classFile);
                        }
                        this.logger.logClassFile(this.generatePackagesStructure, this.destinationPath, relativeStringName);
                        ++this.exportedClassFilesCounter;
                    }
                    catch (IOException e) {
                        this.logger.logNoClassFileCreated(this.destinationPath, relativeStringName, e);
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performCompilation() throws InvalidInputException {
        this.startTime = System.currentTimeMillis();
        FileSystem environment = this.getLibraryAccess();
        this.compilerOptions = new CompilerOptions(this.options);
        this.compilerOptions.performStatementsRecovery = false;
        this.batchCompiler = new Compiler((INameEnvironment)environment, this.getHandlingPolicy(), this.compilerOptions, this.getBatchRequestor(), this.getProblemFactory(), this.out);
        this.compilerOptions.verbose = this.verbose;
        this.compilerOptions.produceReferenceInfo = this.produceRefInfo;
        try {
            this.logger.startLoggingSources();
            this.batchCompiler.compile(this.getCompilationUnits());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.logger.endLoggingSources();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.logger.endLoggingSources();
            this.logger.printStats(this);
            environment.cleanup();
            return;
        }
    }

    public void printUsage() {
        this.printUsage("misc.usage");
    }

    private void printUsage(String sectionID) {
        this.logger.logUsage(Main.bind(sectionID, new String[]{System.getProperty("path.separator"), Main.bind("compiler.name"), Main.bind("compiler.version"), Main.bind("compiler.copyright")}));
        this.logger.flush();
    }

    private void processPathEntries(int defaultSize, ArrayList paths, String currentPath, String customEncoding, boolean isSourceOnly) {
        String currentClasspathName = null;
        ArrayList<String> currentRuleSpecs = new ArrayList<String>(defaultSize);
        StringTokenizer tokenizer = new StringTokenizer(currentPath, String.valueOf(File.pathSeparator) + "[]", true);
        int state = 0;
        String token = null;
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (token.equals(File.pathSeparator)) {
                switch (state) {
                    case 0: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        state = 3;
                        this.addNewEntry(paths, currentClasspathName, currentRuleSpecs, customEncoding, isSourceOnly);
                        currentRuleSpecs.clear();
                        break;
                    }
                    case 6: {
                        state = 4;
                        break;
                    }
                    default: {
                        state = 99;
                        break;
                    }
                }
                continue;
            }
            if (token.equals("[")) {
                switch (state) {
                    case 1: {
                        state = 5;
                        break;
                    }
                    default: {
                        state = 99;
                        break;
                    }
                }
                continue;
            }
            if (token.equals("]")) {
                switch (state) {
                    case 6: {
                        state = 2;
                        break;
                    }
                    default: {
                        state = 99;
                        break;
                    }
                }
                continue;
            }
            switch (state) {
                case 0: 
                case 3: {
                    state = 1;
                    currentClasspathName = token;
                    break;
                }
                case 4: 
                case 5: {
                    state = 6;
                    currentRuleSpecs.add(token);
                    break;
                }
                default: {
                    state = 99;
                }
            }
        }
        switch (state) {
            case 1: 
            case 2: 
            case 3: {
                this.addNewEntry(paths, currentClasspathName, currentRuleSpecs, customEncoding, isSourceOnly);
                break;
            }
            default: {
                this.logger.logIncorrectClasspath(currentPath);
            }
        }
    }

    public static class Logger {
        private static final String LINE_SEPARATOR = System.getProperty("line.separator");
        private PrintWriter err;
        private PrintWriter log;
        private PrintWriter out;
        private HashMap parameters;
        private int tab;
        int tagBits;
        private static final String CLASS = "class";
        private static final String CLASS_FILE = "classfile";
        private static final String CLASSPATH = "classpath";
        private static final String CLASSPATH_FILE = "FILE";
        private static final String CLASSPATH_FOLDER = "FOLDER";
        private static final String CLASSPATH_ID = "id";
        private static final String CLASSPATH_JAR = "JAR";
        private static final String CLASSPATHS = "classpaths";
        private static final String COMMAND_LINE_ARGUMENT = "argument";
        private static final String COMMAND_LINE_ARGUMENTS = "command_line";
        private static final String COMPILER = "compiler";
        private static final String COMPILER_COPYRIGHT = "copyright";
        private static final String COMPILER_NAME = "name";
        private static final String COMPILER_VERSION = "version";
        public static final int EMACS = 2;
        private static final String ERROR = "ERROR";
        private static final String ERROR_TAG = "error";
        private static final String EXCEPTION = "exception";
        private static final HashMap FIELD_TABLE = new HashMap();
        private static final String KEY = "key";
        private static final String MESSAGE = "message";
        private static final String NUMBER_OF_CLASSFILES = "number_of_classfiles";
        private static final String NUMBER_OF_ERRORS = "errors";
        private static final String NUMBER_OF_LINES = "number_of_lines";
        private static final String NUMBER_OF_PROBLEMS = "problems";
        private static final String NUMBER_OF_TASKS = "tasks";
        private static final String NUMBER_OF_WARNINGS = "warnings";
        private static final String OPTION = "option";
        private static final String OPTIONS = "options";
        private static final String PATH = "path";
        private static final String PROBLEM_ARGUMENT = "argument";
        private static final String PROBLEM_ARGUMENT_VALUE = "value";
        private static final String PROBLEM_ARGUMENTS = "arguments";
        private static final String PROBLEM_ID = "id";
        private static final String PROBLEM_LINE = "line";
        private static final String PROBLEM_MESSAGE = "message";
        private static final String PROBLEM_SEVERITY = "severity";
        private static final String PROBLEM_SOURCE_END = "charEnd";
        private static final String PROBLEM_SOURCE_START = "charStart";
        private static final String PROBLEM_SUMMARY = "problem_summary";
        private static final String PROBLEM_TAG = "problem";
        private static final String PROBLEMS = "problems";
        private static final String SOURCE = "source";
        private static final String SOURCE_CONTEXT = "source_context";
        private static final String SOURCE_END = "sourceEnd";
        private static final String SOURCE_START = "sourceStart";
        private static final String SOURCES = "sources";
        private static final String STATS = "stats";
        private static final String TASK = "task";
        private static final String TASKS = "tasks";
        private static final String TIME = "time";
        private static final String VALUE = "value";
        private static final String WARNING = "WARNING";
        public static final int XML = 1;
        private static final String XML_DTD_DECLARATION = "<!DOCTYPE compiler PUBLIC \"-//Eclipse.org//DTD Eclipse JDT 3.2.002 Compiler//EN\" \"http://www.eclipse.org/jdt/core/compiler_32_002.dtd\">";
        private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        static /* synthetic */ Class class$0;

        static {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.core.compiler.IProblem");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Class<?> c = clazz;
                Field[] fields = c.getFields();
                int i = 0;
                int max = fields.length;
                while (i < max) {
                    Field field = fields[i];
                    FIELD_TABLE.put(field.get(null), field.getName());
                    ++i;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        private static void appendEscapedChar(StringBuffer buffer, char c) {
            String replacement = Logger.getReplacement(c);
            if (replacement != null) {
                buffer.append('&');
                buffer.append(replacement);
                buffer.append(';');
            } else {
                buffer.append(c);
            }
        }

        private static String getEscaped(String s) {
            StringBuffer result = new StringBuffer(s.length() + 10);
            int i = 0;
            while (i < s.length()) {
                Logger.appendEscapedChar(result, s.charAt(i));
                ++i;
            }
            return result.toString();
        }

        private static String getReplacement(char c) {
            switch (c) {
                case '<': {
                    return "lt";
                }
                case '>': {
                    return "gt";
                }
                case '\"': {
                    return "quot";
                }
                case '\'': {
                    return "apos";
                }
                case '&': {
                    return "amp";
                }
            }
            return null;
        }

        public Logger(PrintWriter out, PrintWriter err) {
            this.out = out;
            this.err = err;
            this.parameters = new HashMap();
        }

        public String buildFileName(String outputPath, String relativeFileName) {
            char fileSeparatorChar = File.separatorChar;
            String fileSeparator = File.separator;
            outputPath = outputPath.replace('/', fileSeparatorChar);
            StringBuffer outDir = new StringBuffer(outputPath);
            if (!outputPath.endsWith(fileSeparator)) {
                outDir.append(fileSeparator);
            }
            StringTokenizer tokenizer = new StringTokenizer(relativeFileName, fileSeparator);
            String token = tokenizer.nextToken();
            while (tokenizer.hasMoreTokens()) {
                outDir.append(token).append(fileSeparator);
                token = tokenizer.nextToken();
            }
            return outDir.append(token).toString();
        }

        public void close() {
            if (this.log != null) {
                if ((this.tagBits & 1) != 0) {
                    this.endTag(COMPILER);
                    this.flush();
                }
                this.log.close();
            }
        }

        public void compiling() {
            this.printlnOut(Main.bind("progress.compiling"));
        }

        private void endLoggingProblems() {
            this.endTag("problems");
        }

        public void endLoggingSource() {
            if ((this.tagBits & 1) != 0) {
                this.endTag(SOURCE);
            }
        }

        public void endLoggingSources() {
            if ((this.tagBits & 1) != 0) {
                this.endTag(SOURCES);
            }
        }

        public void endLoggingTasks() {
            if ((this.tagBits & 1) != 0) {
                this.endTag("tasks");
            }
        }

        public void endTag(String name) {
            --this.tab;
            this.printTag(String.valueOf('/') + name, null, true, false);
            --this.tab;
        }

        private void extractContext(CategorizedProblem problem, char[] unitSource) {
            char c;
            int endPosition;
            int startPosition = problem.getSourceStart();
            if (startPosition > (endPosition = problem.getSourceEnd()) || startPosition < 0 && endPosition < 0) {
                this.parameters.put("value", Messages.problem_noSourceInformation);
                this.parameters.put(SOURCE_START, "-1");
                this.parameters.put(SOURCE_END, "-1");
                return;
            }
            int length = unitSource.length;
            int begin = startPosition >= length ? length - 1 : startPosition;
            while (begin > 0) {
                c = unitSource[begin - 1];
                if (c == '\n' || c == '\r') break;
                --begin;
            }
            int end = endPosition >= length ? length - 1 : endPosition;
            while (end + 1 < length) {
                c = unitSource[end + 1];
                if (c == '\r' || c == '\n') break;
                ++end;
            }
            while ((c = unitSource[begin]) == ' ' || c == '\t') {
                ++begin;
            }
            while ((c = unitSource[end]) == ' ' || c == '\t') {
                --end;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(unitSource, begin, end - begin + 1);
            this.parameters.put("value", String.valueOf(buffer));
            this.parameters.put(SOURCE_START, Integer.toString(startPosition - begin));
            this.parameters.put(SOURCE_END, Integer.toString(endPosition - begin));
        }

        public void flush() {
            this.out.flush();
            this.err.flush();
            if (this.log != null) {
                this.log.flush();
            }
        }

        private String getFieldName(int id) {
            return (String)FIELD_TABLE.get(new Integer(id));
        }

        public void logAverage(long[] times, long lineCount) {
            Arrays.sort(times);
            int length = times.length;
            long sum = 0L;
            int i = 1;
            int max = length - 1;
            while (i < max) {
                sum += times[i];
                ++i;
            }
            long time = sum / (long)(length - 2);
            this.printlnOut(Main.bind("compile.averageTime", new String[]{String.valueOf(lineCount), String.valueOf(time), String.valueOf((double)((int)((double)lineCount * 10000.0 / (double)time)) / 10.0)}));
        }

        public void logClassFile(boolean generatePackagesStructure, String outputPath, String relativeFileName) {
            if ((this.tagBits & 1) != 0) {
                String fileName = null;
                if (generatePackagesStructure) {
                    fileName = this.buildFileName(outputPath, relativeFileName);
                } else {
                    char fileSeparatorChar = File.separatorChar;
                    String fileSeparator = File.separator;
                    outputPath = outputPath.replace('/', fileSeparatorChar);
                    int indexOfPackageSeparator = relativeFileName.lastIndexOf(fileSeparatorChar);
                    if (indexOfPackageSeparator == -1) {
                        fileName = outputPath.endsWith(fileSeparator) ? String.valueOf(outputPath) + relativeFileName : String.valueOf(outputPath) + fileSeparator + relativeFileName;
                    } else {
                        int length = relativeFileName.length();
                        fileName = outputPath.endsWith(fileSeparator) ? String.valueOf(outputPath) + relativeFileName.substring(indexOfPackageSeparator + 1, length) : String.valueOf(outputPath) + fileSeparator + relativeFileName.substring(indexOfPackageSeparator + 1, length);
                    }
                }
                File f = new File(fileName);
                try {
                    this.parameters.clear();
                    this.parameters.put(PATH, f.getCanonicalPath());
                    this.printTag(CLASS_FILE, this.parameters, true, true);
                }
                catch (IOException e) {
                    this.logNoClassFileCreated(outputPath, relativeFileName, e);
                }
            }
        }

        public void logClasspath(FileSystem.Classpath[] classpaths) {
            int length;
            if (classpaths == null) {
                return;
            }
            if ((this.tagBits & 1) != 0 && (length = classpaths.length) != 0) {
                this.printTag(CLASSPATHS, null, true, false);
                int i = 0;
                while (i < length) {
                    this.parameters.clear();
                    String classpath = classpaths[i].getPath();
                    this.parameters.put(PATH, classpath);
                    File f = new File(classpath);
                    String id = null;
                    if (f.isFile()) {
                        id = Util.isArchiveFileName(classpath) ? CLASSPATH_JAR : CLASSPATH_FILE;
                    } else if (f.isDirectory()) {
                        id = CLASSPATH_FOLDER;
                    }
                    if (id != null) {
                        this.parameters.put("id", id);
                        this.printTag(CLASSPATH, this.parameters, true, true);
                    }
                    ++i;
                }
                this.endTag(CLASSPATHS);
            }
        }

        public void logCommandLineArguments(String[] commandLineArguments) {
            int length;
            if (commandLineArguments == null) {
                return;
            }
            if ((this.tagBits & 1) != 0 && (length = commandLineArguments.length) != 0) {
                this.printTag(COMMAND_LINE_ARGUMENTS, null, true, false);
                this.parameters.clear();
                int i = 0;
                while (i < length) {
                    this.parameters.put("value", commandLineArguments[i]);
                    this.printTag("argument", this.parameters, true, true);
                    ++i;
                }
                this.endTag(COMMAND_LINE_ARGUMENTS);
            }
        }

        public void logException(Exception e) {
            String message;
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            e.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            String stackTrace = writer.getBuffer().toString();
            if ((this.tagBits & 1) != 0) {
                LineNumberReader reader = new LineNumberReader(new StringReader(stackTrace));
                int i = 0;
                StringBuffer buffer = new StringBuffer();
                String message2 = e.getMessage();
                if (message2 != null) {
                    buffer.append(message2).append(LINE_SEPARATOR);
                }
                try {
                    String line;
                    while ((line = reader.readLine()) != null && i < 4) {
                        buffer.append(line).append(LINE_SEPARATOR);
                        ++i;
                    }
                    reader.close();
                }
                catch (IOException iOException) {}
                message2 = buffer.toString();
                this.parameters.clear();
                this.parameters.put("message", message2);
                this.parameters.put(CLASS, e.getClass());
                this.printTag(EXCEPTION, this.parameters, true, true);
            }
            if ((message = e.getMessage()) == null) {
                this.printlnErr(stackTrace);
            } else {
                this.printlnErr(message);
            }
        }

        public void logIncorrectClasspath(String wrongClasspath) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.clear();
                this.parameters.put("message", Main.bind("configure.incorrectClasspath", wrongClasspath));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(Main.bind("configure.incorrectClasspath", wrongClasspath));
        }

        public void logIncorrectExtDirsEntry(String wrongPath) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.clear();
                this.parameters.put("message", Main.bind("configure.incorrectExtDirsEntry", wrongPath));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(Main.bind("configure.incorrectExtDirsEntry", wrongPath));
        }

        public void logIncorrectEndorsedDirsEntry(String wrongPath) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.clear();
                this.parameters.put("message", Main.bind("configure.incorrectEndorsedDirsEntry", wrongPath));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(Main.bind("configure.incorrectEndorsedDirsEntry", wrongPath));
        }

        public void logNoClassFileCreated(String outputDir, String relativeFileName, IOException e) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.clear();
                this.parameters.put("message", Main.bind("output.noClassFileCreated", new String[]{outputDir, relativeFileName, e.getMessage()}));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(Main.bind("output.noClassFileCreated", new String[]{outputDir, relativeFileName, e.getMessage()}));
        }

        public void logNoClasspath() {
            if ((this.tagBits & 1) != 0) {
                this.parameters.clear();
                this.parameters.put("message", Main.bind("configure.noClasspath"));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(Main.bind("configure.noClasspath"));
        }

        public void logNumberOfClassFilesGenerated(int exportedClassFilesCounter) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.clear();
                this.parameters.put("value", new Integer(exportedClassFilesCounter));
                this.printTag(NUMBER_OF_CLASSFILES, this.parameters, true, true);
            }
            if (exportedClassFilesCounter == 1) {
                this.printlnOut(Main.bind("compile.oneClassFileGenerated"));
            } else {
                this.printlnOut(Main.bind("compile.severalClassFilesGenerated", String.valueOf(exportedClassFilesCounter)));
            }
        }

        public void logOptions(Map options) {
            if ((this.tagBits & 1) != 0) {
                this.printTag(OPTIONS, null, true, false);
                Set keySet = options.keySet();
                Object[] keys = keySet.toArray();
                Arrays.sort(keys);
                int i = 0;
                int max = keys.length;
                while (i < max) {
                    this.parameters.clear();
                    Object key = keys[i];
                    this.parameters.put(KEY, key);
                    this.parameters.put("value", options.get(key));
                    this.printTag(OPTION, this.parameters, true, true);
                    ++i;
                }
                this.endTag(OPTIONS);
            }
        }

        private void logProblem(CategorizedProblem problem, int localErrorCount, int globalErrorCount, char[] unitSource) {
            if ((this.tagBits & 2) != 0) {
                String result = String.valueOf(new String(problem.getOriginatingFileName())) + ":" + problem.getSourceLineNumber() + ": " + (problem.isError() ? Main.bind("output.emacs.error") : Main.bind("output.emacs.warning")) + ": " + problem.getMessage();
                this.printlnErr(result);
                String errorReportSource = ((DefaultProblem)problem).errorReportSource(unitSource, this.tagBits);
                if (errorReportSource.length() != 0) {
                    this.printlnErr(errorReportSource);
                }
            } else {
                if (localErrorCount == 0) {
                    this.printlnErr("----------");
                }
                this.printErr(problem.isError() ? Main.bind("requestor.error", Integer.toString(globalErrorCount), new String(problem.getOriginatingFileName())) : Main.bind("requestor.warning", Integer.toString(globalErrorCount), new String(problem.getOriginatingFileName())));
                try {
                    String errorReportSource = ((DefaultProblem)problem).errorReportSource(unitSource);
                    this.printlnErr(errorReportSource);
                    this.printlnErr(problem.getMessage());
                }
                catch (Exception exception) {
                    this.printlnErr(Main.bind("requestor.notRetrieveErrorMessage", problem.toString()));
                }
                this.printlnErr("----------");
            }
        }

        public int logProblems(CategorizedProblem[] problems, char[] unitSource, Main currentMain) {
            int count = problems.length;
            int localErrorCount = 0;
            int localProblemCount = 0;
            if (count != 0) {
                if ((this.tagBits & 1) != 0) {
                    CategorizedProblem problem;
                    int errors = 0;
                    int warnings = 0;
                    int tasks = 0;
                    int i = 0;
                    while (i < count) {
                        problem = problems[i];
                        if (problem != null) {
                            ++currentMain.globalProblemsCount;
                            this.logProblem(problem, localProblemCount, currentMain.globalProblemsCount, unitSource);
                            ++localProblemCount;
                            if (problem.isError()) {
                                ++localErrorCount;
                                ++errors;
                                ++currentMain.globalErrorsCount;
                            } else if (problem.getID() == 536871362) {
                                ++currentMain.globalTasksCount;
                                ++tasks;
                            } else {
                                ++currentMain.globalWarningsCount;
                                ++warnings;
                            }
                        }
                        ++i;
                    }
                    if (errors + warnings != 0) {
                        this.startLoggingProblems(errors, warnings);
                        i = 0;
                        while (i < count) {
                            problem = problems[i];
                            if (problem != null && problem.getID() != 536871362) {
                                this.logXmlProblem(problem, unitSource);
                            }
                            ++i;
                        }
                        this.endLoggingProblems();
                    }
                    if (tasks != 0) {
                        this.startLoggingTasks(tasks);
                        i = 0;
                        while (i < count) {
                            problem = problems[i];
                            if (problem != null && problem.getID() == 536871362) {
                                this.logXmlTask(problem, unitSource);
                            }
                            ++i;
                        }
                        this.endLoggingTasks();
                    }
                } else {
                    int i = 0;
                    while (i < count) {
                        if (problems[i] != null) {
                            ++currentMain.globalProblemsCount;
                            this.logProblem(problems[i], localProblemCount, currentMain.globalProblemsCount, unitSource);
                            ++localProblemCount;
                            if (problems[i].isError()) {
                                ++localErrorCount;
                                ++currentMain.globalErrorsCount;
                            } else {
                                ++currentMain.globalWarningsCount;
                            }
                        }
                        ++i;
                    }
                }
            }
            return localErrorCount;
        }

        public void logProblemsSummary(int globalProblemsCount, int globalErrorsCount, int globalWarningsCount, int globalTasksCount) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.clear();
                this.parameters.put("problems", new Integer(globalProblemsCount));
                this.parameters.put(NUMBER_OF_ERRORS, new Integer(globalErrorsCount));
                this.parameters.put(NUMBER_OF_WARNINGS, new Integer(globalWarningsCount));
                this.parameters.put("tasks", new Integer(globalTasksCount));
                this.printTag(PROBLEM_SUMMARY, this.parameters, true, true);
            }
            if (globalProblemsCount == 1) {
                String message = null;
                message = globalErrorsCount == 1 ? Main.bind("compile.oneError") : Main.bind("compile.oneWarning");
                this.printErr(Main.bind("compile.oneProblem", message));
            } else {
                int warningsNumber;
                String errorMessage = null;
                String warningMessage = null;
                if (globalErrorsCount > 0) {
                    errorMessage = globalErrorsCount == 1 ? Main.bind("compile.oneError") : Main.bind("compile.severalErrors", String.valueOf(globalErrorsCount));
                }
                if ((warningsNumber = globalWarningsCount + globalTasksCount) > 0) {
                    warningMessage = warningsNumber == 1 ? Main.bind("compile.oneWarning") : Main.bind("compile.severalWarnings", String.valueOf(warningsNumber));
                }
                if (errorMessage == null || warningMessage == null) {
                    if (errorMessage == null) {
                        this.printErr(Main.bind("compile.severalProblemsErrorsOrWarnings", String.valueOf(globalProblemsCount), warningMessage));
                    } else {
                        this.printErr(Main.bind("compile.severalProblemsErrorsOrWarnings", String.valueOf(globalProblemsCount), errorMessage));
                    }
                } else {
                    this.printErr(Main.bind("compile.severalProblemsErrorsAndWarnings", new String[]{String.valueOf(globalProblemsCount), errorMessage, warningMessage}));
                }
            }
            if ((this.tagBits & 2) != 0) {
                this.printlnErr();
            }
        }

        public void logProgress() {
            this.printOut('.');
        }

        public void logRepetition(int i, int repetitions) {
            this.printlnOut(Main.bind("compile.repetition", String.valueOf(i + 1), String.valueOf(repetitions)));
        }

        public void logTiming(long time, long lineCount) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.clear();
                this.parameters.put("value", new Long(time));
                this.printTag(TIME, this.parameters, true, true);
                this.parameters.clear();
                this.parameters.put("value", new Long(lineCount));
                this.printTag(NUMBER_OF_LINES, this.parameters, true, true);
            }
            if (lineCount != 0L) {
                this.printlnOut(Main.bind("compile.instantTime", new String[]{String.valueOf(lineCount), String.valueOf(time), String.valueOf((double)((int)((double)lineCount * 10000.0 / (double)time)) / 10.0)}));
            } else {
                this.printlnOut(Main.bind("compile.totalTime", String.valueOf(time)));
            }
        }

        public void logUsage(String usage) {
            this.printlnOut(usage);
        }

        public void logVersion(boolean printToOut) {
            if (this.log != null && (this.tagBits & 1) == 0) {
                String version = Main.bind("misc.version", new String[]{Main.bind("compiler.name"), Main.bind("compiler.version"), Main.bind("compiler.copyright")});
                this.log.println("# " + version);
                if (printToOut) {
                    this.out.println(version);
                    this.out.flush();
                }
            } else if (printToOut) {
                String version = Main.bind("misc.version", new String[]{Main.bind("compiler.name"), Main.bind("compiler.version"), Main.bind("compiler.copyright")});
                this.out.println(version);
                this.out.flush();
            }
        }

        public void logWrongJDK() {
            if ((this.tagBits & 1) != 0) {
                this.parameters.clear();
                this.parameters.put("message", Main.bind("configure.requiresJDK1.2orAbove"));
                this.printTag(ERROR, this.parameters, true, true);
            }
            this.printlnErr(Main.bind("configure.requiresJDK1.2orAbove"));
        }

        private void logXmlProblem(CategorizedProblem problem, char[] unitSource) {
            int sourceStart = problem.getSourceStart();
            int sourceEnd = problem.getSourceEnd();
            this.parameters.clear();
            this.parameters.put("id", this.getFieldName(problem.getID()));
            this.parameters.put(PROBLEM_SEVERITY, problem.isError() ? ERROR : WARNING);
            this.parameters.put(PROBLEM_LINE, new Integer(problem.getSourceLineNumber()));
            this.parameters.put(PROBLEM_SOURCE_START, new Integer(sourceStart));
            this.parameters.put(PROBLEM_SOURCE_END, new Integer(sourceEnd));
            this.printTag(PROBLEM_TAG, this.parameters, true, false);
            this.parameters.clear();
            this.parameters.put("value", problem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.parameters.clear();
            this.extractContext(problem, unitSource);
            this.printTag(SOURCE_CONTEXT, this.parameters, true, true);
            String[] arguments = problem.getArguments();
            int length = arguments.length;
            if (length != 0) {
                this.printTag(PROBLEM_ARGUMENTS, null, true, false);
                this.parameters.clear();
                int i = 0;
                while (i < length) {
                    this.parameters.put("value", arguments[i]);
                    this.printTag("argument", this.parameters, true, true);
                    ++i;
                }
                this.endTag(PROBLEM_ARGUMENTS);
            }
            this.endTag(PROBLEM_TAG);
        }

        private void logXmlTask(CategorizedProblem problem, char[] unitSource) {
            this.parameters.clear();
            this.parameters.put(PROBLEM_LINE, new Integer(problem.getSourceLineNumber()));
            this.parameters.put(PROBLEM_SOURCE_START, new Integer(problem.getSourceStart()));
            this.parameters.put(PROBLEM_SOURCE_END, new Integer(problem.getSourceEnd()));
            this.printTag(TASK, this.parameters, true, false);
            this.parameters.clear();
            this.parameters.put("value", problem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.parameters.clear();
            this.extractContext(problem, unitSource);
            this.printTag(SOURCE_CONTEXT, this.parameters, true, true);
            this.endTag(TASK);
        }

        private void printErr(String s) {
            this.err.print(s);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.print(s);
            }
        }

        private void printlnErr() {
            this.err.println();
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println();
            }
        }

        private void printlnErr(String s) {
            this.err.println(s);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println(s);
            }
        }

        private void printlnOut(String s) {
            this.out.println(s);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println(s);
            }
        }

        public void printNewLine() {
            this.out.println();
        }

        private void printOut(char c) {
            this.out.print(c);
        }

        public void printStats(Main main) {
            boolean isTimed = main.timing;
            if ((this.tagBits & 1) != 0) {
                this.printTag(STATS, null, true, false);
            }
            if (isTimed) {
                long time = System.currentTimeMillis() - main.startTime;
                this.logTiming(time, main.lineCount);
                if (main.times != null) {
                    main.times[main.timesCounter++] = time;
                }
            }
            if (main.globalProblemsCount > 0) {
                this.logProblemsSummary(main.globalProblemsCount, main.globalErrorsCount, main.globalWarningsCount, main.globalTasksCount);
            }
            if (main.exportedClassFilesCounter != 0 && (main.showProgress || isTimed || main.verbose)) {
                this.logNumberOfClassFilesGenerated(main.exportedClassFilesCounter);
            }
            if ((this.tagBits & 1) != 0) {
                this.endTag(STATS);
            }
        }

        public void printTag(String name, HashMap params, boolean insertNewLine, boolean closeTag) {
            int i = this.tab;
            while (i > 0) {
                this.log.print('\t');
                --i;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("<");
            buffer.append(name);
            if (params != null) {
                int length = this.parameters.size();
                Object[] keys = new String[length];
                this.parameters.keySet().toArray(keys);
                Arrays.sort(keys);
                int i2 = 0;
                while (i2 < length) {
                    buffer.append(" ");
                    buffer.append((String)keys[i2]);
                    buffer.append("=\"");
                    buffer.append(Logger.getEscaped(String.valueOf(params.get(keys[i2]))));
                    buffer.append("\"");
                    ++i2;
                }
            }
            if (closeTag) {
                buffer.append("/>");
            } else {
                buffer.append(">");
                ++this.tab;
            }
            if (insertNewLine) {
                this.log.println(String.valueOf(buffer));
            } else {
                this.log.print(String.valueOf(buffer));
            }
        }

        public void setEmacs() {
            this.tagBits |= 2;
        }

        public void setLog(String logFileName) throws InvalidInputException {
            block6: {
                Date date = new Date();
                DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 1, Locale.getDefault());
                try {
                    this.log = new PrintWriter(new FileOutputStream(logFileName, false));
                    int index = logFileName.lastIndexOf(46);
                    if (index != -1) {
                        if (logFileName.substring(index).toLowerCase().equals(".xml")) {
                            this.tagBits |= 1;
                            this.log.println(XML_HEADER);
                            try {
                                this.log.println("<!-- " + new String(dateFormat.format(date).getBytes(), "UTF-8") + " -->");
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                            }
                            this.log.println(XML_DTD_DECLARATION);
                            this.tab = 0;
                            this.parameters.clear();
                            this.parameters.put(COMPILER_NAME, Main.bind("compiler.name"));
                            this.parameters.put(COMPILER_VERSION, Main.bind("compiler.version"));
                            this.parameters.put(COMPILER_COPYRIGHT, Main.bind("compiler.copyright"));
                            this.printTag(COMPILER, this.parameters, true, false);
                            break block6;
                        }
                        this.log.println("# " + dateFormat.format(date));
                        break block6;
                    }
                    this.log.println("# " + dateFormat.format(date));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new InvalidInputException(Main.bind("configure.cannotOpenLog"));
                }
            }
        }

        private void startLoggingProblems(int errors, int warnings) {
            this.parameters.clear();
            this.parameters.put("problems", new Integer(errors + warnings));
            this.parameters.put(NUMBER_OF_ERRORS, new Integer(errors));
            this.parameters.put(NUMBER_OF_WARNINGS, new Integer(warnings));
            this.printTag("problems", this.parameters, true, false);
        }

        public void startLoggingSource(CompilationResult compilationResult) {
            if ((this.tagBits & 1) != 0) {
                ICompilationUnit compilationUnit = compilationResult.compilationUnit;
                char[] fileName = compilationUnit.getFileName();
                File f = new File(new String(fileName));
                if (fileName != null) {
                    this.parameters.clear();
                    if (compilationUnit != null) {
                        this.parameters.put(PATH, f.getAbsolutePath());
                    }
                }
                this.printTag(SOURCE, this.parameters, true, false);
            }
        }

        public void startLoggingSources() {
            if ((this.tagBits & 1) != 0) {
                this.printTag(SOURCES, null, true, false);
            }
        }

        public void startLoggingTasks(int tasks) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.clear();
                this.parameters.put("tasks", new Integer(tasks));
                this.printTag("tasks", this.parameters, true, false);
            }
        }
    }
}

