/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.php.internal.core.phpModel.parser.PHPUserModel;
import org.eclipse.php.internal.core.phpModel.parser.management.GlobalParsingManager;
import org.eclipse.php.internal.core.phpModel.parser.management.UserModelParserClientFactoryVersionDependent;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.util.DefaultCacheManager;

public class PHPUserModelManager {
    private PHPUserModel userModel;
    private PHPUserModel cachedUserModel;
    private IProject project;
    private UserModelParserClientFactoryVersionDependent userModelParserClientFactoryVersionDependent;

    PHPUserModelManager(IProject iProject, PHPUserModel pHPUserModel) {
        this.project = iProject;
        this.userModel = pHPUserModel;
        this.userModelParserClientFactoryVersionDependent = new UserModelParserClientFactoryVersionDependent(this);
        GlobalParsingManager.getInstance().addParserClient(this.userModelParserClientFactoryVersionDependent, iProject);
        this.cachedUserModel = new PHPUserModel();
        DefaultCacheManager.instance().load(iProject, this.cachedUserModel, false);
    }

    public void dispose() {
        GlobalParsingManager.getInstance().removeParserClient(this.userModelParserClientFactoryVersionDependent, this.project);
        IPath iPath = this.project.getLocation();
        if (iPath == null) {
            return;
        }
        File file = iPath.toFile();
        if (file.exists()) {
            DefaultCacheManager.instance().save(this.project, this.userModel, false);
        }
    }

    public void fileRemoved(IFile iFile) {
        this.userModel.delete(iFile.getFullPath().toString());
    }

    public synchronized void clean() {
        this.userModel.clear();
    }

    public IProject getProject() {
        return this.project;
    }

    public PHPUserModel getUserModel() {
        return this.userModel;
    }

    public boolean shouldParse(String string) {
        PHPFileData pHPFileData = this.cachedUserModel.getFileData(string);
        if (pHPFileData != null && pHPFileData.isValid()) {
            this.userModel.insert(pHPFileData);
            this.cachedUserModel.delete(string);
            return false;
        }
        return true;
    }
}

