/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.core.internal.ui.util.resources;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.rdb.core.internal.ui.RDBCoreUIPlugin;
import org.eclipse.wst.rdb.internal.models.sql.tables.BaseTable;
import org.eclipse.wst.rdb.internal.models.sql.tables.ViewTable;
import org.osgi.framework.Bundle;

public class ResourceLoader {
    private static final RDBCoreUIPlugin plugin = RDBCoreUIPlugin.getDefault();
    private static final String RESOURCE_PATH = "org/eclipse/wst/rdb/core/internal/ui/l10n/";
    private static final String ICONS_DIRECTORY = "icons/";
    private static final String UI_RESOURCES = "datatoolsCoreUI";
    private static final String NO_RESOURCE_FOUND = "NO_RESOURCE_FOUND";
    private static final ResourceLoader instance = new ResourceLoader();
    private ResourceBundle bundle = null;
    private static String iconLocation;

    public static ResourceLoader getResourceLoader() {
        return instance;
    }

    private ResourceLoader() {
        try {
            Bundle bundle = RDBCoreUIPlugin.getDefault().getBundle();
            iconLocation = String.valueOf(FileLocator.resolve((URL)bundle.getEntry("/")).getPath()) + ICONS_DIRECTORY;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.bundle = ResourceBundle.getBundle("org/eclipse/wst/rdb/core/internal/ui/l10n/datatoolsCoreUI");
    }

    private Image queryImage(String imagePath) {
        Image image = null;
        image = plugin.getImageRegistry().get(imagePath);
        if (image == null) {
            image = new Image((Device)Display.getDefault(), imagePath);
            plugin.getImageRegistry().put(imagePath, image);
        }
        return image;
    }

    public Image queryImageFromRegistry(String imagePath) {
        return this.queryAbsolutePathImageFromRegistry(String.valueOf(iconLocation) + imagePath);
    }

    public Image queryAbsolutePathImageFromRegistry(String imagePath) {
        return this.queryImage(imagePath);
    }

    public Image queryAbsolutePathImageFromRegistry(Bundle bundle, String imagePath) {
        Image image = null;
        image = plugin.getImageRegistry().get(imagePath);
        if (image == null) {
            try {
                URL fullPathString = FileLocator.find((Bundle)bundle, (IPath)new Path(imagePath), null);
                URL uRL = fullPathString = fullPathString != null ? fullPathString : new URL(imagePath);
                if (fullPathString != null) {
                    image = ImageDescriptor.createFromURL((URL)fullPathString).createImage();
                    plugin.getImageRegistry().put(imagePath, image);
                }
            }
            catch (IOException iOException) {
                return image;
            }
        }
        return image;
    }

    public static byte[] getImageData(EObject eObject) {
        if (eObject instanceof BaseTable) {
            return ResourceLoader.getImageData("table.gif");
        }
        if (eObject instanceof ViewTable) {
            return ResourceLoader.getImageData("view.gif");
        }
        return new byte[100];
    }

    public static byte[] getImageData(String name) {
        String image = String.valueOf(iconLocation) + name;
        try {
            FileInputStream fis = new FileInputStream(image);
            int size = fis.available();
            byte[] imageBytes = new byte[size];
            fis.read(imageBytes);
            fis.close();
            return imageBytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String queryString(String stringID) {
        try {
            String resource = null;
            resource = this.bundle.getString(stringID);
            return resource;
        }
        catch (Throwable throwable) {
            return NO_RESOURCE_FOUND;
        }
    }
}

