/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.internal.patch.Diff;
import org.eclipse.compare.internal.patch.WorkspacePatcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class DiffProject
implements IWorkbenchAdapter,
IAdaptable {
    List fDiffs = new ArrayList();
    IProject fProject;
    String fOriginalProjectName = null;
    static /* synthetic */ Class class$0;

    DiffProject(IProject project) {
        this.fProject = project;
        this.fOriginalProjectName = project.getName();
    }

    void addDiff(Diff diff) {
        this.fDiffs.add(diff);
    }

    void addDiffs(Diff[] diffs) {
        int i = 0;
        while (i < diffs.length) {
            this.fDiffs.add(diffs[i]);
            ++i;
        }
    }

    IProject getProject() {
        return this.fProject;
    }

    String getName() {
        return this.fProject.getName();
    }

    void setProject(IProject project) {
        this.fProject = project;
    }

    ArrayList reset(WorkspacePatcher patcher, int strip, int fuzzfactor) {
        ArrayList hunksToCheck = new ArrayList();
        Iterator iter = this.fDiffs.iterator();
        while (iter.hasNext()) {
            Diff diff = (Diff)iter.next();
            hunksToCheck.addAll(diff.reset(patcher, strip, fuzzfactor));
        }
        return hunksToCheck;
    }

    public IFile getFile(IPath path) {
        return this.fProject.getFile(path);
    }

    public IFile[] getTargetFiles() {
        ArrayList<IFile> files = new ArrayList<IFile>();
        Iterator iter = this.fDiffs.iterator();
        while (iter.hasNext()) {
            Diff diff = (Diff)iter.next();
            if (!diff.isEnabled()) continue;
            files.add(diff.getTargetFile());
        }
        return files.toArray(new IFile[files.size()]);
    }

    public Object[] getChildren(Object o) {
        return this.fDiffs.toArray();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        Object o;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((o = this.fProject.getAdapter((Class)clazz)) instanceof IWorkbenchAdapter) {
            ImageDescriptor id = ((IWorkbenchAdapter)o).getImageDescriptor((Object)this.fProject);
            return id;
        }
        return null;
    }

    public String getLabel(Object o) {
        return this.getName();
    }

    public Object getParent(Object o) {
        return null;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return null;
    }

    public String getOriginalProjectName() {
        return this.fOriginalProjectName;
    }
}

