/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.launcher.ContainerTestSearchExtent;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.ITestSearchExtent;
import org.eclipse.jdt.internal.junit.launcher.SingleTypeTestSearchExtent;
import org.eclipse.jdt.internal.junit.launcher.TestKindRegistry;
import org.eclipse.jdt.internal.junit.launcher.TestSearchResult;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class JUnitBaseLaunchConfiguration
extends AbstractJavaLaunchConfigurationDelegate {
    public static final String NO_DISPLAY_ATTR = "org.eclipse.jdt.junit.NO_DISPLAY";
    public static final String RUN_QUIETLY_MODE = "runQuietly";
    public static final String PORT_ATTR = "org.eclipse.jdt.junit.PORT";
    public static final String TESTTYPE_ATTR = "org.eclipse.jdt.junit.TESTTYPE";
    public static final String TESTNAME_ATTR = "org.eclipse.jdt.junit.TESTNAME";
    public static final String ATTR_KEEPRUNNING = "org.eclipse.jdt.junit.KEEPRUNNING_ATTR";
    public static final String LAUNCH_CONTAINER_ATTR = "org.eclipse.jdt.junit.CONTAINER";
    public static final String FAILURES_FILENAME_ATTR = "org.eclipse.jdt.junit.FAILURENAMES";
    public static final String TEST_KIND_ATTR = "org.eclipse.jdt.junit.TEST_KIND";
    static /* synthetic */ Class class$0;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor pm) throws CoreException {
        if (mode.equals(RUN_QUIETLY_MODE)) {
            launch.setAttribute(NO_DISPLAY_ATTR, "true");
            mode = "run";
        }
        TestSearchResult testTypes = this.findTestTypes(configuration, pm);
        IVMInstall install = this.getVMInstall(configuration);
        IVMRunner runner = install.getVMRunner(mode);
        if (runner == null) {
            this.abort(Messages.format(JUnitMessages.JUnitBaseLaunchConfiguration_error_novmrunner, new String[]{install.getId()}), null, 106);
        }
        int port = SocketUtil.findFreePort();
        VMRunnerConfiguration runConfig = this.launchTypes(configuration, mode, testTypes, port);
        this.setDefaultSourceLocator(launch, configuration);
        launch.setAttribute(PORT_ATTR, Integer.toString(port));
        launch.setAttribute(TESTTYPE_ATTR, testTypes.getTypes()[0].getHandleIdentifier());
        runner.run(runConfig, launch, pm);
    }

    protected TestSearchResult findTestTypes(ILaunchConfiguration configuration, IProgressMonitor pm) throws CoreException {
        boolean isJUnit4Configuration;
        IJavaProject javaProject = this.getJavaProject(configuration);
        if (javaProject == null || !javaProject.exists()) {
            this.informAndAbort(JUnitMessages.JUnitBaseLaunchConfiguration_error_invalidproject, null, 107);
        }
        if (!TestSearchEngine.hasTestCaseType(javaProject)) {
            this.informAndAbort(JUnitMessages.JUnitBaseLaunchConfiguration_error_junitnotonpath, null, 10004);
        }
        if ((isJUnit4Configuration = "org.eclipse.jdt.junit.loader.junit4".equals(TestKindRegistry.getDefault().getKind(configuration).getId())) && !TestSearchEngine.hasTestAnnotation(javaProject)) {
            this.informAndAbort(JUnitMessages.JUnitBaseLaunchConfiguration_error_junit4notonpath, null, 10004);
        }
        ITestSearchExtent testTarget = this.testSearchTarget(configuration, javaProject, pm);
        TestSearchResult searchResult = TestKindRegistry.getDefault().getTestTypes(configuration, testTarget);
        if (searchResult.isEmpty()) {
            ITestKind testKind = searchResult.getTestKind();
            String msg = testKind == null || testKind.isNull() ? JUnitMessages.JUnitBaseLaunchConfiguration_error_notests : Messages.format(JUnitMessages.JUnitBaseLaunchConfiguration_error_notests_kind, testKind.getDisplayName());
            this.informAndAbort(msg, null, 101);
        }
        return searchResult;
    }

    protected void informAndAbort(String message, Throwable exception, int code) throws CoreException {
        Status status = new Status(1, "org.eclipse.jdt.junit", code, message, exception);
        if (this.showStatusMessage((IStatus)status)) {
            throw new CoreException((IStatus)status);
        }
        this.abort(message, exception, code);
    }

    protected VMRunnerConfiguration launchTypes(ILaunchConfiguration configuration, String mode, TestSearchResult tests, int port) throws CoreException {
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        String vmArgs = this.getVMArguments(configuration);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, "");
        String[] envp = this.getEnvironment(configuration);
        VMRunnerConfiguration runConfig = this.createVMRunner(configuration, tests, port, mode);
        runConfig.setVMArguments(execArgs.getVMArgumentsArray());
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setEnvironment(envp);
        Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        String[] bootpath = this.getBootpath(configuration);
        runConfig.setBootClassPath(bootpath);
        return runConfig;
    }

    public ITestSearchExtent testSearchTarget(ILaunchConfiguration configuration, IJavaProject javaProject, IProgressMonitor pm) throws CoreException {
        String containerHandle = configuration.getAttribute(LAUNCH_CONTAINER_ATTR, "");
        if (containerHandle.length() != 0) {
            return this.containerTestTarget(containerHandle, pm);
        }
        String testTypeName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
        return this.singleTypeTarget(javaProject, this.performStringSubstitution(testTypeName));
    }

    protected String performStringSubstitution(String testTypeName) throws CoreException {
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(testTypeName);
    }

    protected ITestSearchExtent containerTestTarget(String containerHandle, IProgressMonitor pm) {
        return new ContainerTestSearchExtent(pm, containerHandle);
    }

    public ITestSearchExtent singleTypeTarget(IJavaProject javaProject, String testName) throws CoreException {
        IType type = null;
        try {
            type = javaProject.findType(testName);
        }
        catch (JavaModelException javaModelException) {
            this.testTypeDoesNotExist();
        }
        if (type == null) {
            this.testTypeDoesNotExist();
        }
        return new SingleTypeTestSearchExtent(type);
    }

    private boolean showStatusMessage(final IStatus status) {
        final boolean[] success = new boolean[1];
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                Shell shell = JUnitPlugin.getActiveWorkbenchShell();
                if (shell == null) {
                    shell = JUnitBaseLaunchConfiguration.this.getDisplay().getActiveShell();
                }
                if (shell != null) {
                    MessageDialog.openInformation((Shell)shell, (String)JUnitMessages.JUnitBaseLaunchConfiguration_dialog_title, (String)status.getMessage());
                    success[0] = true;
                }
            }
        });
        return success[0];
    }

    private Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private void testTypeDoesNotExist() throws CoreException {
        this.abort("Test type does not exist", null, 101);
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.junit", code, message, exception));
    }

    protected abstract VMRunnerConfiguration createVMRunner(ILaunchConfiguration var1, TestSearchResult var2, int var3, String var4) throws CoreException;

    protected boolean keepAlive(ILaunchConfiguration config) {
        try {
            return config.getAttribute(ATTR_KEEPRUNNING, false);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public List getBasicArguments(ILaunchConfiguration configuration, int port, String runMode, TestSearchResult result) throws CoreException {
        ArrayList<String> argv = new ArrayList<String>();
        argv.add("-version");
        argv.add("3");
        argv.add("-port");
        argv.add(Integer.toString(port));
        if (this.keepAlive(configuration) && runMode.equals("debug")) {
            argv.add(0, "-keepalive");
        }
        String testLoaderId = result.getTestKind().getLoaderClassName();
        argv.add("-testLoaderClass");
        argv.add(testLoaderId);
        return argv;
    }

    public String defaultTestLoaderClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.internal.junit.runner.junit3.JUnit3TestLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getName();
    }
}

