/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.php.internal.core.documentModel.parser.regions.PhpScriptRegion;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.hover.PHPCodeHyperLink;
import org.eclipse.php.internal.ui.util.CodeDataResolver;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class OpenDeclarationAction
extends TextEditorAction
implements IUpdate {
    private CodeData fCodeData;

    public OpenDeclarationAction(ResourceBundle resourceBundle, PHPStructuredEditor pHPStructuredEditor) {
        super(resourceBundle, "OpenAction_declaration_", (ITextEditor)pHPStructuredEditor);
        this.setEnabled(true);
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.validAction()) {
            PHPCodeHyperLink pHPCodeHyperLink = new PHPCodeHyperLink(null, this.fCodeData);
            pHPCodeHyperLink.open();
            return;
        }
    }

    public void update() {
        super.update();
        if (this.validAction()) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    protected ITextSelection getCurrentSelection() {
        ITextEditor iTextEditor = this.getTextEditor();
        if (iTextEditor == null) {
            return null;
        }
        ISelectionProvider iSelectionProvider = iTextEditor.getSelectionProvider();
        if (iSelectionProvider == null) {
            return null;
        }
        ISelection iSelection = iSelectionProvider.getSelection();
        if (iSelection instanceof ITextSelection) {
            return (ITextSelection)iSelection;
        }
        return null;
    }

    private boolean validAction() {
        PhpScriptRegion phpScriptRegion;
        String string;
        ITextEditor iTextEditor = this.getTextEditor();
        if (iTextEditor == null) {
            return false;
        }
        IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
        IEditorInput iEditorInput = iTextEditor.getEditorInput();
        if (iDocumentProvider == null || iEditorInput == null) {
            return false;
        }
        IDocument iDocument = iDocumentProvider.getDocument((Object)iEditorInput);
        if (iDocument == null) {
            return false;
        }
        if (!(iDocument instanceof IStructuredDocument)) {
            return false;
        }
        ITextSelection iTextSelection = this.getCurrentSelection();
        int n = iTextSelection.getOffset();
        IStructuredDocument iStructuredDocument = (IStructuredDocument)iDocument;
        try {
            string = iStructuredDocument.getPartition(n).getType();
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
            return false;
        }
        if (!string.equals("org.eclipse.php.PHP_DEFAULT")) {
            return false;
        }
        IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n);
        ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
        if (iTextRegion == null) {
            return false;
        }
        if (iTextRegion.getType() == "PHP_CONTENT") {
            phpScriptRegion = (PhpScriptRegion)iTextRegion;
            try {
                iTextRegion = phpScriptRegion.getPhpToken(n - iStructuredDocumentRegion.getStartOffset() - phpScriptRegion.getStart());
            }
            catch (BadLocationException badLocationException) {
                iTextRegion = null;
            }
        }
        if (iTextRegion == null) {
            return false;
        }
        phpScriptRegion = (StructuredTextEditor)iTextEditor;
        try {
            this.fCodeData = CodeDataResolver.getCodeData((ITextViewer)phpScriptRegion.getTextViewer(), n);
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
            return false;
        }
        if (this.fCodeData == null) {
            return false;
        }
        return this.fCodeData.getUserData() != null;
    }
}

