/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;

public abstract class NewGenericFileTemplatesWizardPage
extends WizardPage {
    private String fLastSelectedTemplateName;
    private SourceViewer fPatternViewer;
    private TableViewer fTableViewer;
    private TemplateStore fTemplateStore;
    private Button fUseTemplateButton;

    public NewGenericFileTemplatesWizardPage(String string, String string2) {
        super("NewGenericTemplatesWizardPage", string, null);
        this.setDescription(string2);
    }

    private void configureTableResizing(final Composite composite, final Table table, final TableColumn tableColumn, final TableColumn tableColumn2) {
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Point point;
                Rectangle rectangle = composite.getClientArea();
                Point point2 = table.computeSize(-1, -1);
                int n = rectangle.width - 2 * table.getBorderWidth();
                if (point2.y > rectangle.height) {
                    point = table.getVerticalBar().getSize();
                    n -= point.x;
                }
                point = table.getSize();
                if (point.x > n) {
                    tableColumn.setWidth(n / 2);
                    tableColumn2.setWidth(n / 2);
                    table.setSize(n, rectangle.height);
                } else {
                    table.setSize(n, rectangle.height);
                    tableColumn.setWidth(n / 2);
                    tableColumn2.setWidth(n / 2);
                }
            }
        });
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.fUseTemplateButton = new Button(composite2, 32);
        this.fUseTemplateButton.setText(this.getUseTemplateMessage());
        GridData gridData = new GridData(4, 4, true, false, 2, 1);
        this.fUseTemplateButton.setLayoutData((Object)gridData);
        this.fUseTemplateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewGenericFileTemplatesWizardPage.this.enableTemplates();
            }
        });
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout2);
        GridData gridData2 = new GridData(4, 4, true, true, 2, 1);
        composite3.setLayoutData((Object)gridData2);
        Link link = new Link(composite3, 0);
        link.setText(this.getTemplatesLocationMessage());
        gridData = new GridData(4, 4, true, false, 2, 1);
        link.setLayoutData((Object)gridData);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewGenericFileTemplatesWizardPage.this.linkClicked();
            }
        });
        Table table = new Table(composite3, 67584);
        gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(2);
        gridData.heightHint = this.convertHeightInCharsToPixels(10);
        gridData.horizontalSpan = 2;
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText(HTMLUIMessages.NewHTMLTemplatesWizardPage_2);
        TableColumn tableColumn2 = new TableColumn(table, 0);
        tableColumn2.setText(HTMLUIMessages.NewHTMLTemplatesWizardPage_3);
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new TemplateContentProvider());
        this.fTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof Template && object2 instanceof Template) {
                    Template template = (Template)object;
                    Template template2 = (Template)object2;
                    int n = template.getName().compareToIgnoreCase(template2.getName());
                    if (n != 0) {
                        return n;
                    }
                    return template.getDescription().compareToIgnoreCase(template2.getDescription());
                }
                return super.compare(viewer, object, object2);
            }

            public boolean isSorterProperty(Object object, String string) {
                return true;
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                NewGenericFileTemplatesWizardPage.this.updateViewerInput();
            }
        });
        this.fPatternViewer = this.doCreateViewer(composite2);
        this.fTemplateStore = PHPUiPlugin.getDefault().getTemplateStore();
        this.fTableViewer.setInput((Object)this.fTemplateStore);
        this.configureTableResizing(composite3, table, tableColumn, tableColumn2);
        this.loadLastSavedPreferences();
        String string = this.getNewFileWizardTemplatePageHelpId();
        if (string != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, string);
        }
        Dialog.applyDialogFont((Control)composite2);
        this.setControl((Control)composite2);
    }

    protected abstract String getNewFileWizardTemplatePageHelpId();

    private SourceViewer createViewer(Composite composite) {
        SourceViewer sourceViewer = new SourceViewer(composite, null, null, false, 2816);
        SourceViewerConfiguration sourceViewerConfiguration = new SourceViewerConfiguration();
        sourceViewer.configure(sourceViewerConfiguration);
        Document document = new Document();
        sourceViewer.setDocument((IDocument)document);
        return sourceViewer;
    }

    private SourceViewer doCreateViewer(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(HTMLUIMessages.NewHTMLTemplatesWizardPage_5);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        SourceViewer sourceViewer = this.createViewer(composite);
        sourceViewer.setEditable(false);
        Control control = sourceViewer.getControl();
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)gridData);
        return sourceViewer;
    }

    void enableTemplates() {
        boolean bl = this.fUseTemplateButton.getSelection();
        if (!bl) {
            Template template = this.getSelectedTemplate();
            this.fLastSelectedTemplateName = template != null ? template.getName() : "";
            this.fTableViewer.setSelection(null);
        } else {
            this.setSelectedTemplate(this.fLastSelectedTemplateName);
        }
        this.fTableViewer.getControl().setEnabled(bl);
        this.fPatternViewer.getControl().setEnabled(bl);
    }

    protected abstract String getPreferencePageId();

    private Template getSelectedTemplate() {
        Template template = null;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (iStructuredSelection.size() == 1) {
            template = (Template)iStructuredSelection.getFirstElement();
        }
        return template;
    }

    public String getTemplateString() {
        String string = null;
        Template template = this.getSelectedTemplate();
        if (template != null) {
            TemplateContextType templateContextType = this.getTemplatesContextTypeRegistry().getContextType(this.getTemplateContextTypeId());
            Document document = new Document();
            DocumentTemplateContext documentTemplateContext = new DocumentTemplateContext(templateContextType, (IDocument)document, 0, 0);
            try {
                TemplateBuffer templateBuffer = documentTemplateContext.evaluate(template);
                string = templateBuffer.getString();
            }
            catch (Exception exception) {
                Logger.log(202, "Could not create template for new PHP", exception);
            }
        }
        return string;
    }

    void linkClicked() {
        String string = this.getPreferencePageId();
        PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)string, (String[])new String[]{string}, null);
        preferenceDialog.open();
        this.fTableViewer.refresh();
    }

    private void loadLastSavedPreferences() {
        String string = this.getPreferenceStore().getString("newFileTemplateName");
        if (string == null || string.length() == 0) {
            this.fLastSelectedTemplateName = "";
            this.fUseTemplateButton.setSelection(false);
        } else {
            this.fLastSelectedTemplateName = string;
            this.fUseTemplateButton.setSelection(true);
        }
        this.enableTemplates();
    }

    protected abstract IPreferenceStore getPreferenceStore();

    void saveLastSavedPreferences() {
        String string = "";
        Template template = this.getSelectedTemplate();
        if (template != null) {
            string = template.getName();
        }
        this.getPreferenceStore().setValue("newFileTemplateName", string);
    }

    private void setSelectedTemplate(String string) {
        Object object = null;
        if (string != null && string.length() > 0) {
            object = this.fTemplateStore.findTemplate(string, this.getTemplateContextTypeId());
        }
        if (object == null) {
            object = this.fTableViewer.getElementAt(0);
        }
        if (object != null) {
            StructuredSelection structuredSelection = new StructuredSelection(object);
            this.fTableViewer.setSelection((ISelection)structuredSelection, true);
        }
    }

    void updateViewerInput() {
        Template template = this.getSelectedTemplate();
        if (template != null) {
            this.fPatternViewer.getDocument().set(template.getPattern());
        } else {
            this.fPatternViewer.getDocument().set("");
        }
    }

    protected abstract String getTemplateContextTypeId();

    protected abstract String getUseTemplateMessage();

    protected abstract String getTemplatesLocationMessage();

    protected abstract ContextTypeRegistry getTemplatesContextTypeRegistry();

    private class TemplateContentProvider
    implements IStructuredContentProvider {
        private TemplateStore fStore;

        private TemplateContentProvider() {
        }

        public void dispose() {
            this.fStore = null;
        }

        public Object[] getElements(Object object) {
            return this.fStore.getTemplates(NewGenericFileTemplatesWizardPage.this.getTemplateContextTypeId());
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            this.fStore = (TemplateStore)object2;
        }
    }

    private class TemplateLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TemplateLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            Template template = (Template)object;
            switch (n) {
                case 0: {
                    return template.getName();
                }
                case 1: {
                    return template.getDescription();
                }
            }
            return "";
        }
    }
}

