/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.LaunchShortcutAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.actions.OpenLaunchDialogAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public abstract class ContextualLaunchAction
implements IObjectActionDelegate,
IMenuCreator {
    private IStructuredSelection fSelection;
    private IAction fDelegateAction;
    private String fMode;
    private ILaunchGroup fGroup = null;
    private Map fGroupsByCategory = null;
    private boolean fFillMenu = true;

    public ContextualLaunchAction(String mode) {
        this.fMode = mode;
        ILaunchGroup[] groups = DebugUITools.getLaunchGroups();
        this.fGroupsByCategory = new HashMap(3);
        int i = 0;
        while (i < groups.length) {
            ILaunchGroup group = groups[i];
            if (group.getMode().equals(mode)) {
                if (group.getCategory() == null) {
                    this.fGroup = group;
                } else {
                    this.fGroupsByCategory.put(group.getCategory(), group);
                }
            }
            ++i;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        Menu menu = new Menu(parent);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                if (ContextualLaunchAction.this.fFillMenu) {
                    Menu m = (Menu)e.widget;
                    MenuItem[] items = m.getItems();
                    int i = 0;
                    while (i < items.length) {
                        items[i].dispose();
                        ++i;
                    }
                    ContextualLaunchAction.this.fillMenu(m);
                    ContextualLaunchAction.this.fFillMenu = false;
                }
            }
        });
        return menu;
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fFillMenu = true;
            if (this.fDelegateAction != action) {
                this.fDelegateAction = action;
                this.fDelegateAction.setMenuCreator((IMenuCreator)this);
            }
            this.fSelection = (IStructuredSelection)selection;
            action.setEnabled(true);
            return;
        }
        action.setEnabled(false);
    }

    protected void fillMenu(Menu menu) {
        if (this.fSelection == null) {
            return;
        }
        IEvaluationContext context = this.createContext();
        List allShortCuts = this.getLaunchConfigurationManager().getLaunchShortcuts();
        Iterator iter = allShortCuts.iterator();
        ArrayList<LaunchShortcutExtension> filteredShortCuts = new ArrayList<LaunchShortcutExtension>(10);
        while (iter.hasNext()) {
            LaunchShortcutExtension ext = (LaunchShortcutExtension)iter.next();
            try {
                if (WorkbenchActivityHelper.filterItem((Object)ext) || !this.isApplicable(ext, context)) continue;
                filteredShortCuts.add(ext);
            }
            catch (CoreException coreException) {}
        }
        iter = filteredShortCuts.iterator();
        int accelerator = 1;
        ArrayList<String> categories = new ArrayList<String>();
        while (iter.hasNext()) {
            LaunchShortcutExtension ext = (LaunchShortcutExtension)iter.next();
            Set modes = ext.getModes();
            Iterator modeIter = modes.iterator();
            while (modeIter.hasNext()) {
                String mode = (String)modeIter.next();
                if (!mode.equals(this.fMode)) continue;
                String category = ext.getCategory();
                if (categories != null && !categories.contains(category)) {
                    categories.add(category);
                }
                this.populateMenuItem(mode, ext, menu, accelerator++);
            }
        }
        if (categories.isEmpty()) {
            OpenLaunchDialogAction action = new OpenLaunchDialogAction(this.fGroup.getIdentifier());
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(menu, -1);
        } else {
            iter = categories.iterator();
            while (iter.hasNext()) {
                String category = (String)iter.next();
                ILaunchGroup group = this.fGroup;
                if (category != null) {
                    group = (ILaunchGroup)this.fGroupsByCategory.get(category);
                }
                if (group == null) continue;
                if (accelerator > 1) {
                    new MenuItem(menu, 2);
                }
                OpenLaunchDialogAction action = new OpenLaunchDialogAction(group.getIdentifier());
                ActionContributionItem item = new ActionContributionItem((IAction)action);
                item.fill(menu, -1);
            }
        }
    }

    private IEvaluationContext createContext() {
        List selection = this.getSelectedElements();
        EvaluationContext context = new EvaluationContext(null, (Object)selection);
        context.addVariable("selection", (Object)selection);
        return context;
    }

    private List getSelectedElements() {
        ArrayList result = new ArrayList();
        Iterator iter = this.fSelection.iterator();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    private boolean isApplicable(LaunchShortcutExtension ext, IEvaluationContext context) throws CoreException {
        Expression expr = ext.getContextualLaunchEnablementExpression();
        return ext.evalEnablementExpression(context, expr);
    }

    private void populateMenuItem(String mode, LaunchShortcutExtension ext, Menu menu, int accelerator) {
        String contextLabel;
        LaunchShortcutAction action = new LaunchShortcutAction(mode, ext);
        action.setActionDefinitionId(String.valueOf(ext.getId()) + "." + mode);
        String helpContextId = ext.getHelpContextId();
        if (helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, helpContextId);
        }
        StringBuffer label = new StringBuffer();
        if (accelerator >= 0 && accelerator < 10) {
            label.append('&');
            label.append(accelerator);
            label.append(' ');
        }
        label.append((contextLabel = ext.getContextLabel(mode)) != null ? contextLabel : action.getText());
        action.setText(label.toString());
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(menu, -1);
    }

    private LaunchConfigurationManager getLaunchConfigurationManager() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager();
    }
}

