/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.adapters.jdom;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jem.internal.adapters.jdom.JDOMAdaptor;
import org.eclipse.jem.internal.adapters.jdom.JDOMSearchHelper;
import org.eclipse.jem.internal.adapters.jdom.JavaClassJDOMAdaptor;
import org.eclipse.jem.internal.java.adapters.IJavaMethodAdapter;
import org.eclipse.jem.internal.java.adapters.nls.ResourceHandler;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaVisibilityKind;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.internal.impl.MethodImpl;
import org.eclipse.jem.util.TimerTests;

public class JavaMethodJDOMAdaptor
extends JDOMAdaptor
implements IJavaMethodAdapter {
    public static final String REFLECT_METHOD = "Reflect JDOM Method";
    protected IMethod sourceMethod = null;
    protected IType parentType = null;

    public JavaMethodJDOMAdaptor(Notifier target, IJavaProject workingProject) {
        super(target, workingProject);
    }

    protected boolean flushReflectedValues(boolean clearCachedModelObject) {
        if (clearCachedModelObject) {
            this.clearSource();
        }
        MethodImpl method = (MethodImpl)this.getTarget();
        method.setIsGenerated(false);
        method.setFinal(false);
        method.setNative(false);
        method.setStatic(false);
        method.setSynchronized(false);
        method.setConstructor(false);
        method.setAbstract(false);
        method.setJavaVisibility(JavaVisibilityKind.PUBLIC_LITERAL);
        method.setEType(null);
        method.getParametersGen().clear();
        method.getJavaExceptionsGen().clear();
        this.parentType = null;
        return true;
    }

    protected void postFlushReflectedValuesIfNecessary(boolean isExisting) {
        ((MethodImpl)this.getTarget()).setReflected(false);
        super.postFlushReflectedValuesIfNecessary(isExisting);
    }

    protected void addExceptions() {
        try {
            IMethod sourceMethod = this.getSourceMethod();
            String[] exceptionNames = sourceMethod.getExceptionTypes();
            EList exceptions = ((MethodImpl)this.getTarget()).getJavaExceptionsGen();
            int i = 0;
            while (i < exceptionNames.length) {
                exceptions.add(this.createJavaClassRef(this.typeNameFromSignature(exceptionNames[i])));
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    protected String[] getParameterNames() {
        String[] parmNames = new String[]{};
        String[] parmTypeNames = this.getSourceMethod().getParameterTypes();
        try {
            parmNames = this.getSourceMethod().getParameterNames();
        }
        catch (JavaModelException javaModelException) {}
        if (parmNames == null || parmNames.length == 0) {
            parmNames = new String[parmTypeNames.length];
            int i = 0;
            while (i < parmTypeNames.length) {
                parmNames[i] = "arg" + i;
                ++i;
            }
        }
        return parmNames;
    }

    protected void addParameters() {
        String[] parmTypeNames = this.getSourceMethod().getParameterTypes();
        MethodImpl javaMethodTarget = (MethodImpl)this.getTarget();
        EList params = javaMethodTarget.getParametersGen();
        int i = 0;
        while (i < parmTypeNames.length) {
            params.add(this.createJavaParameter((Method)javaMethodTarget, null, this.typeNameFromSignature(parmTypeNames[i])));
            ++i;
        }
    }

    protected void clearSource() {
        this.sourceMethod = null;
    }

    protected JavaClass getContainingJavaClass() {
        return ((Method)this.getTarget()).getContainingJavaClass();
    }

    protected IType getParentType() {
        Method targetMethod;
        JavaClass parentJavaClass;
        JavaClassJDOMAdaptor pa;
        if (this.parentType == null && (pa = (JavaClassJDOMAdaptor)EcoreUtil.getAdapter((List)(parentJavaClass = (targetMethod = (Method)this.getTarget()).getContainingJavaClass()).eAdapters(), (Object)"JavaReflection")) != null) {
            this.parentType = pa.getSourceType();
        }
        return this.parentType;
    }

    protected String[] getParmTypeSignatures() {
        Method javaMethodTarget = (Method)this.getTarget();
        String[] typeNames = JavaMethodJDOMAdaptor.getTypeNamesFromMethodID((String)((XMIResource)javaMethodTarget.eResource()).getID((EObject)javaMethodTarget));
        if (typeNames == null) {
            return emptyStringArray;
        }
        int n = typeNames.length;
        if (n == 0) {
            return emptyStringArray;
        }
        String[] typeSigs = new String[n];
        try {
            int i = 0;
            while (i < n) {
                typeSigs[i] = Signature.createTypeSignature((String)new String(typeNames[i]), (boolean)this.getParentType().isBinary());
                ++i;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return typeSigs;
    }

    public Object getReflectionSource() {
        return this.getSourceMethod();
    }

    public boolean hasCachedReflectionSource() {
        return this.sourceMethod != null;
    }

    public void primSetMethod(IMethod method) {
        this.sourceMethod = method;
    }

    public IMethod getSourceMethod() {
        if (this.sourceMethod == null || !this.sourceMethod.exists()) {
            try {
                IType parent = this.getParentType();
                if (parent != null) {
                    String[] parmNames = this.getParmTypeSignatures();
                    this.sourceMethod = JDOMSearchHelper.searchForMatchingMethod(parent, ((Method)this.getTarget()).getName(), parmNames);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return this.sourceMethod;
    }

    protected IType getType() {
        return this.getParentType();
    }

    protected Map getTypeResolutionCache() {
        JDOMAdaptor classAdaptor;
        JavaClass javaClass;
        Method method = (Method)this.getTarget();
        if (method != null && (javaClass = method.getJavaClass()) != null && (classAdaptor = (JDOMAdaptor)JavaMethodJDOMAdaptor.retrieveAdaptorFrom((EObject)javaClass)) != null) {
            return classAdaptor.getTypeResolutionCache();
        }
        return null;
    }

    public Object getValueIn(EObject object, EObject attribute) {
        return super.getValueIn(object, attribute);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean reflectValues() {
        block3: {
            super.reflectValues();
            try {
                TimerTests.basicTest.startCumulativeStep(REFLECT_METHOD);
                if (!this.isResourceLoaded() || this.getSourceProject() == null || this.getSourceMethod() == null || !this.sourceMethod.exists()) break block3;
                this.setModifiers();
                this.setNaming();
                this.setReturnType();
                this.addParameters();
                this.addExceptions();
                Object var1_1 = null;
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                TimerTests.basicTest.stopCumulativeStep(REFLECT_METHOD);
                throw throwable;
            }
            TimerTests.basicTest.stopCumulativeStep(REFLECT_METHOD);
            return true;
        }
        Object var1_3 = null;
        TimerTests.basicTest.stopCumulativeStep(REFLECT_METHOD);
        return false;
    }

    protected void setGeneratedFlag() {
        Method methodTarget = (Method)this.getTarget();
        try {
            int index;
            String source = this.getSourceMethod().getSource();
            if (source != null && (index = source.indexOf("@generated")) > 0) {
                methodTarget.setIsGenerated(true);
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public boolean reflectGeneratedIfNecessary() {
        if (this.reflectValuesIfNecessary()) {
            this.setGeneratedFlag();
            return true;
        }
        return false;
    }

    public boolean reflectParamNamesIfNecessary() {
        if (this.reflectValuesIfNecessary()) {
            String[] paramNames = this.getParameterNames();
            EList param = ((MethodImpl)this.getTarget()).getParameters();
            int i = 0;
            while (i < paramNames.length) {
                ((JavaParameter)param.get(i)).setName(paramNames[i]);
                ++i;
            }
            return true;
        }
        return false;
    }

    protected void setModifiers() {
        Method methodTarget = (Method)this.getTarget();
        try {
            methodTarget.setFinal(Flags.isFinal((int)this.getSourceMethod().getFlags()));
            methodTarget.setNative(Flags.isNative((int)this.getSourceMethod().getFlags()));
            methodTarget.setStatic(Flags.isStatic((int)this.getSourceMethod().getFlags()));
            methodTarget.setSynchronized(Flags.isSynchronized((int)this.getSourceMethod().getFlags()));
            methodTarget.setConstructor(this.getSourceMethod().isConstructor());
            JavaClass javaClass = this.getContainingJavaClass();
            if (javaClass.getKind().getValue() == 2) {
                methodTarget.setAbstract(true);
            } else {
                methodTarget.setAbstract(Flags.isAbstract((int)this.getSourceMethod().getFlags()));
            }
            if (javaClass.getKind().getValue() == 2 || Flags.isPublic((int)this.getSourceMethod().getFlags())) {
                methodTarget.setJavaVisibility(JavaVisibilityKind.PUBLIC_LITERAL);
            } else if (Flags.isPrivate((int)this.getSourceMethod().getFlags())) {
                methodTarget.setJavaVisibility(JavaVisibilityKind.PRIVATE_LITERAL);
            } else if (Flags.isProtected((int)this.getSourceMethod().getFlags())) {
                methodTarget.setJavaVisibility(JavaVisibilityKind.PROTECTED_LITERAL);
            } else {
                methodTarget.setJavaVisibility(JavaVisibilityKind.PACKAGE_LITERAL);
            }
        }
        catch (JavaModelException npe) {
            System.out.println(ResourceHandler.getString((String)"Error_Introspecting_Flags_ERROR_", (Object[])new Object[]{((XMIResource)methodTarget.eResource()).getID((EObject)methodTarget), npe.getMessage()}));
        }
    }

    protected void setNaming() {
    }

    protected void setReturnType() {
        String typeName = null;
        try {
            typeName = this.typeNameFromSignature(this.getSourceMethod().getReturnType());
        }
        catch (JavaModelException javaModelException) {}
        if (typeName != null) {
            Method javaMethodTarget = (Method)this.getTarget();
            javaMethodTarget.setEType((EClassifier)this.createJavaClassRef(typeName));
        }
    }

    public void setSourceMethod(IMethod newSourceMethod) {
        this.sourceMethod = newSourceMethod;
    }

    protected String typeNameFromSignature(String typeSignature) {
        String erasure = null;
        try {
            erasure = Signature.getTypeErasure((String)typeSignature);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (erasure != null) {
            String variableName = null;
            String resolvedVariable = null;
            int arrayCount = Signature.getArrayCount((String)erasure);
            if (arrayCount > 0) {
                String elementTypeName = Signature.getElementType((String)erasure);
                variableName = Signature.toString((String)elementTypeName);
                resolvedVariable = this.resolveVariableName(erasure, variableName);
                if (resolvedVariable != null) {
                    StringBuffer b = new StringBuffer(resolvedVariable);
                    int i = 0;
                    while (i < arrayCount) {
                        b.append("[]");
                        ++i;
                    }
                    resolvedVariable = b.toString();
                }
            } else {
                variableName = Signature.toString((String)erasure);
                resolvedVariable = this.resolveVariableName(erasure, variableName);
            }
            if (resolvedVariable == null) {
                return super.typeNameFromSignature(erasure);
            }
            return resolvedVariable;
        }
        return super.typeNameFromSignature(typeSignature);
    }

    private String resolveVariableName(String erasure, String variableName) {
        IMethod method = this.getSourceMethod();
        ITypeParameter[] typeParameters = null;
        try {
            typeParameters = method.getTypeParameters();
        }
        catch (JavaModelException javaModelException) {}
        ITypeParameter typeParam = null;
        if (typeParameters != null && typeParameters.length > 0) {
            int i = 0;
            while (i < typeParameters.length) {
                if (typeParameters[i].exists() && variableName.equals(typeParameters[i].getElementName())) {
                    typeParam = typeParameters[i];
                    break;
                }
                ++i;
            }
            if (typeParam != null) {
                String[] bounds = null;
                try {
                    bounds = typeParam.getBounds();
                }
                catch (JavaModelException javaModelException) {}
                if (bounds != null && bounds.length > 0) {
                    return JDOMSearchHelper.getResolvedTypeName(bounds[0], this.getType(), this.getTypeResolutionCache());
                }
                return "java.lang.Object";
            }
        }
        return null;
    }
}

