/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocTag;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;

public class PHPCodeDataHTMLDescriptionUtilities {
    private static Pattern dolar_pattern = Pattern.compile("\\$");
    private static Pattern unknown_type_pattern = Pattern.compile("unknown_type\\ ");
    private static StringBuffer descriptionText = new StringBuffer();
    private static StringBuffer helpBuffer = new StringBuffer();

    public static final String createFunctionDescriptionText(PHPCodeData pHPCodeData, PHPProjectModel pHPProjectModel) {
        boolean bl;
        descriptionText.delete(0, descriptionText.length());
        String string = pHPCodeData.getDescription();
        PHPCodeData pHPCodeData2 = pHPCodeData.getContainer();
        String string2 = pHPCodeData.isUserCode() ? pHPCodeData.getUserData().getFileName() : null;
        boolean bl2 = bl = pHPCodeData2 != null && pHPCodeData2 instanceof PHPClassData;
        if (string2 != null) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getLocationTableRow(string2));
        }
        if (bl) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getClassNameTableRow(pHPCodeData2.getName(), pHPProjectModel));
        }
        if (string.length() > 0) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getDescriptionTableRow(string));
        }
        if (pHPCodeData.getDocBlock() != null) {
            Iterator iterator = pHPCodeData.getDocBlock().getTags(7);
            if (iterator.hasNext()) {
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getParamTagTableRows(iterator));
            }
            if ((iterator = pHPCodeData.getDocBlock().getTags(6)).hasNext()) {
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getReturnTagTableRows(iterator));
            }
            if ((iterator = pHPCodeData.getDocBlock().getTags(8)).hasNext()) {
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getSeeAlsoTagTableRows(iterator, pHPProjectModel, pHPCodeData));
            }
            if ((iterator = pHPCodeData.getDocBlock().getTags(2)).hasNext()) {
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getDeprecatedTagTableRow(iterator));
            }
        }
        return descriptionText.toString();
    }

    public static String createClassDescriptionText(PHPClassData pHPClassData, PHPProjectModel pHPProjectModel) {
        Object object;
        int n;
        descriptionText.delete(0, descriptionText.length());
        PHPFileData pHPFileData = (PHPFileData)pHPClassData.getContainer();
        PHPClassData.PHPSuperClassNameData pHPSuperClassNameData = pHPClassData.getSuperClassData();
        PHPClassData.PHPInterfaceNameData[] pHPInterfaceNameDataArray = pHPClassData.getInterfacesNamesData();
        String string = null;
        String string2 = null;
        String[] stringArray = null;
        String string3 = pHPClassData.getDescription();
        if (pHPFileData != null) {
            string = pHPFileData.getName();
        }
        if (pHPSuperClassNameData != null) {
            string2 = pHPSuperClassNameData.getName();
        }
        if (pHPInterfaceNameDataArray != null && pHPInterfaceNameDataArray.length > 0) {
            stringArray = new String[pHPInterfaceNameDataArray.length];
            n = 0;
            while (n < pHPInterfaceNameDataArray.length) {
                object = pHPInterfaceNameDataArray[n];
                stringArray[n] = object.getName();
                ++n;
            }
        }
        if (string != null) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getLocationTableRow(string));
        }
        if (string2 != null) {
            descriptionText.append("<br><dt>Extends</dt>");
            descriptionText.append("<dd>");
            descriptionText.append(string2);
            descriptionText.append("</dd>");
        }
        if (stringArray != null) {
            descriptionText.append("<br><dt>Implements</dt>");
            descriptionText.append("<dd>");
            n = 0;
            while (n < stringArray.length) {
                object = stringArray[n];
                descriptionText.append((String)object);
                if (stringArray.length > 1 && n < stringArray.length - 1) {
                    descriptionText.append("<br>");
                }
                ++n;
            }
            descriptionText.append("</dd>");
        }
        if (string3.length() > 0) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getDescriptionTableRow(string3));
        }
        return descriptionText.toString();
    }

    public static String createVariableDescriptionText(PHPVariableData pHPVariableData) {
        descriptionText.delete(0, descriptionText.length());
        String string = pHPVariableData.getDescription();
        if (string.length() > 0) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getDescriptionTableRow(string));
        }
        return descriptionText.toString();
    }

    public static String createClassVariableDescriptionText(PHPClassVarData pHPClassVarData, PHPProjectModel pHPProjectModel) {
        String string;
        descriptionText.delete(0, descriptionText.length());
        String string2 = pHPClassVarData.getDescription();
        PHPCodeData pHPCodeData = pHPClassVarData.getContainer();
        String string3 = pHPCodeData != null ? pHPCodeData.getName() : null;
        String string4 = string = pHPCodeData != null ? pHPClassVarData.getUserData().getFileName() : null;
        if (string != null) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getLocationTableRow(string));
        }
        if (string3 != null) {
            PHPCodeDataHTMLDescriptionUtilities.getClassNameTableRow(string3, pHPProjectModel);
        }
        if (string2.length() > 0) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getDescriptionTableRow(string2));
        }
        return descriptionText.toString();
    }

    public static String createPHPConstantDescriptionText(PHPConstantData pHPConstantData) {
        descriptionText.delete(0, descriptionText.length());
        String string = pHPConstantData.getDescription();
        String string2 = pHPConstantData.getUserData() != null ? pHPConstantData.getUserData().getFileName() : null;
        String string3 = pHPConstantData.getValue();
        if (string2 != null) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getLocationTableRow(string2));
        }
        if (string3 != null && string3.length() > 0) {
            descriptionText.append("<br><dt>Value</dt>");
            descriptionText.append("<dd>");
            descriptionText.append(string3);
            descriptionText.append("</dd>");
        }
        if (string.length() > 0) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getDescriptionTableRow(string));
        }
        return descriptionText.toString();
    }

    public static String createPHPClassConstDescriptionText(PHPClassConstData pHPClassConstData, PHPProjectModel pHPProjectModel) {
        String string;
        descriptionText.delete(0, descriptionText.length());
        String string2 = pHPClassConstData.getDescription();
        String string3 = pHPClassConstData.getContainer().getName();
        String string4 = string = pHPClassConstData.getUserData() != null ? pHPClassConstData.getUserData().getFileName() : null;
        if (string != null) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getLocationTableRow(string));
        }
        if (string3 != null) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getClassNameTableRow(string3, pHPProjectModel));
        }
        if (string2.length() > 0) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getDescriptionTableRow(string2));
        }
        return descriptionText.toString();
    }

    private static String getLocationTableRow(String string) {
        helpBuffer.delete(0, helpBuffer.length());
        helpBuffer.append("<br><dt>Location</dt> ");
        helpBuffer.append("<dd>");
        helpBuffer.append(string);
        helpBuffer.append("</dd>");
        return helpBuffer.toString();
    }

    private static String getSeeAlsoTagTableRows(Iterator iterator, PHPProjectModel pHPProjectModel, PHPCodeData pHPCodeData) {
        helpBuffer.delete(0, helpBuffer.length());
        helpBuffer.append("<br><dt>See Also</dt>");
        helpBuffer.append("<dd>");
        PHPDocTag pHPDocTag = (PHPDocTag)iterator.next();
        String string = pHPDocTag.getValue();
        String[] stringArray = string.split(",");
        int n = 0;
        while (n < stringArray.length) {
            Object object;
            String string2 = stringArray[n];
            CodeData[] codeDataArray = pHPProjectModel.getClasses(string2);
            boolean bl = false;
            int n2 = 0;
            while (n2 < codeDataArray.length) {
                object = codeDataArray[n2];
                if (codeDataArray.equals(object.getName())) {
                    helpBuffer.append(object.getName());
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) break;
            if (pHPProjectModel.getFileData(string2) != null) {
                helpBuffer.append(string2);
                break;
            }
            PHPConstantData pHPConstantData = pHPProjectModel.getConstantData(string2, false);
            if (pHPConstantData != null) {
                helpBuffer.append(pHPConstantData.getName());
                break;
            }
            if (pHPCodeData instanceof PHPFunctionData && pHPCodeData.getContainer() != null && pHPCodeData.getContainer() instanceof PHPClassData) {
                String string3;
                object = string2;
                if (string2.indexOf(40) != -1) {
                    object = string2.substring(0, string2.indexOf(40));
                }
                String string4 = string3 = pHPCodeData.isUserCode() ? pHPCodeData.getUserData().getFileName() : null;
                if (string3 != null && pHPProjectModel.getClassFunctionData(string3, pHPCodeData.getContainer().getName(), (String)object) != null) {
                    helpBuffer.append(string2);
                    break;
                }
                if (string3 != null) {
                    PHPCodeContext pHPCodeContext = ModelSupport.createContext((CodeData)pHPCodeData);
                    object = string2;
                    if (string2.startsWith("$")) {
                        object = string2.substring(1);
                    }
                    codeDataArray = pHPProjectModel.getVariables(string3, pHPCodeContext, (String)object, true);
                    int n3 = 0;
                    while (n3 < codeDataArray.length) {
                        pHPConstantData = codeDataArray[n3];
                        if (((PHPCodeData)pHPConstantData).getName().equals(object)) {
                            helpBuffer.append(string2);
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                }
                if (bl) break;
                if (pHPProjectModel.getFunction(string2) != null && pHPProjectModel.getFunction(string2).length > 0) {
                    helpBuffer.append(string2);
                    break;
                }
            }
            helpBuffer.append(string2);
            ++n;
        }
        helpBuffer.append("</dd>");
        return helpBuffer.toString();
    }

    private static String getDeprecatedTagTableRow(Iterator iterator) {
        helpBuffer.delete(0, helpBuffer.length());
        helpBuffer.append("<br><dt>Deprecated</dt>");
        helpBuffer.append("<dd>");
        PHPDocTag pHPDocTag = (PHPDocTag)iterator.next();
        helpBuffer.append(pHPDocTag.getValue());
        helpBuffer.append("</dd>");
        return helpBuffer.toString();
    }

    private static String getReturnTagTableRows(Iterator iterator) {
        helpBuffer.delete(0, helpBuffer.length());
        helpBuffer.append("<br><dt>Returns</dt>");
        PHPDocTag pHPDocTag = (PHPDocTag)iterator.next();
        String string = pHPDocTag.getValue();
        helpBuffer.append("<dd>");
        helpBuffer.append(string);
        helpBuffer.append("</dd>");
        return helpBuffer.toString();
    }

    private static String getParamTagTableRows(Iterator iterator) {
        Object object;
        helpBuffer.delete(0, helpBuffer.length());
        while (iterator.hasNext()) {
            object = (PHPDocTag)iterator.next();
            String string = object.getValue();
            string = dolar_pattern.matcher(string).replaceAll("");
            if ((string = unknown_type_pattern.matcher(string).replaceAll("")).split(" ").length <= 1) continue;
            helpBuffer.append("<dd>");
            helpBuffer.append(string);
            helpBuffer.append("</dd>");
        }
        if (helpBuffer.toString().length() > 0) {
            object = "<br><dt>Parameters</dt>";
            helpBuffer = helpBuffer.insert(0, ((String)object).toCharArray(), 0, ((String)object).length());
        }
        return helpBuffer.toString();
    }

    private static String getDescriptionTableRow(String string) {
        helpBuffer.delete(0, helpBuffer.length());
        string = string.replaceAll("\\n", "<br>");
        helpBuffer.append("<br><dt>Description</dt>");
        helpBuffer.append("<dd>");
        helpBuffer.append(string);
        helpBuffer.append("</dd>");
        return helpBuffer.toString();
    }

    private static String getClassNameTableRow(String string, PHPProjectModel pHPProjectModel) {
        helpBuffer.delete(0, helpBuffer.length());
        helpBuffer.append("<br><dt>Class</dt>");
        helpBuffer.append("<dd>");
        helpBuffer.append(string);
        helpBuffer.append("</dd>");
        return helpBuffer.toString();
    }

    public static String getHTMLHyperlinkDescriptionText(CodeData codeData, PHPProjectModel pHPProjectModel) {
        if (!(codeData instanceof PHPCodeData)) {
            return "";
        }
        if (codeData instanceof PHPFunctionData) {
            return PHPCodeDataHTMLDescriptionUtilities.createFunctionDescriptionText((PHPCodeData)codeData, pHPProjectModel);
        }
        if (codeData instanceof PHPClassData) {
            return PHPCodeDataHTMLDescriptionUtilities.createClassDescriptionText((PHPClassData)codeData, pHPProjectModel);
        }
        if (codeData instanceof PHPClassVarData) {
            return PHPCodeDataHTMLDescriptionUtilities.createClassVariableDescriptionText((PHPClassVarData)codeData, pHPProjectModel);
        }
        if (codeData instanceof PHPVariableData) {
            return PHPCodeDataHTMLDescriptionUtilities.createVariableDescriptionText((PHPVariableData)codeData);
        }
        if (codeData instanceof PHPConstantData) {
            return PHPCodeDataHTMLDescriptionUtilities.createPHPConstantDescriptionText((PHPConstantData)codeData);
        }
        if (codeData instanceof PHPClassConstData) {
            return PHPCodeDataHTMLDescriptionUtilities.createPHPClassConstDescriptionText((PHPClassConstData)codeData, pHPProjectModel);
        }
        return "";
    }
}

