/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class TypedElementSelectionValidator
implements ISelectionStatusValidator {
    private IStatus fgErrorStatus = new StatusInfo(4, "");
    private IStatus fgOKStatus = new StatusInfo();
    private Class[] fAcceptedTypes;
    private boolean fAllowMultipleSelection;
    private Collection fRejectedElements;

    public TypedElementSelectionValidator(Class[] classArray, boolean bl) {
        this(classArray, bl, null);
    }

    public TypedElementSelectionValidator(Class[] classArray, boolean bl, Collection collection) {
        Assert.isNotNull((Object)classArray);
        this.fAcceptedTypes = classArray;
        this.fAllowMultipleSelection = bl;
        this.fRejectedElements = collection;
    }

    public IStatus validate(Object[] objectArray) {
        if (this.isValid(objectArray)) {
            return this.fgOKStatus;
        }
        return this.fgErrorStatus;
    }

    private boolean isOfAcceptedType(Object object) {
        int n = 0;
        while (n < this.fAcceptedTypes.length) {
            if (this.fAcceptedTypes[n].isInstance(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isRejectedElement(Object object) {
        return this.fRejectedElements != null && this.fRejectedElements.contains(object);
    }

    protected boolean isSelectedValid(Object object) {
        return true;
    }

    private boolean isValid(Object[] objectArray) {
        if (objectArray.length == 0) {
            return false;
        }
        if (!this.fAllowMultipleSelection && objectArray.length != 1) {
            return false;
        }
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (!this.isOfAcceptedType(object) || this.isRejectedElement(object) || !this.isSelectedValid(object)) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

