/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointContainer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class BreakpointsViewer
extends CheckboxTreeViewer {
    public BreakpointsViewer(Tree tree) {
        super(tree);
    }

    public Item[] getSelectedItems() {
        return this.getSelection(this.getControl());
    }

    public Widget searchItem(Object element) {
        return this.findItem(element);
    }

    public void refreshItem(TreeItem item) {
        this.updateItem((Widget)item, item.getData());
    }

    public IBreakpoint[] getVisibleBreakpoints() {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        Object[] elements = ((ITreeContentProvider)this.getContentProvider()).getElements((Object)manager);
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < elements.length) {
            TreeItem item = (TreeItem)this.searchItem(elements[i]);
            if (item != null) {
                this.collectExpandedBreakpoints(item, list);
            }
            ++i;
        }
        return list.toArray(new IBreakpoint[list.size()]);
    }

    private void collectExpandedBreakpoints(TreeItem item, List list) {
        Object data = item.getData();
        if (data instanceof IBreakpoint) {
            list.add(data);
            return;
        }
        if (item.getExpanded()) {
            TreeItem[] items = item.getItems();
            int i = 0;
            while (i < items.length) {
                this.collectExpandedBreakpoints(items[i], list);
                ++i;
            }
        }
    }

    protected void setSelection(TreeItem item) {
        this.getTree().setSelection(new TreeItem[]{item});
        this.updateSelection(this.getSelection());
    }

    public void refresh() {
        super.refresh();
        this.initializeCheckedState();
    }

    private void initializeCheckedState() {
        TreeItem[] items = this.getTree().getItems();
        int i = 0;
        while (i < items.length) {
            this.updateCheckedState(items[i]);
            ++i;
        }
    }

    public void updateCheckedState(Object element) {
        Widget[] widgets = this.searchItems(element);
        int i = 0;
        while (i < widgets.length) {
            Widget widget = widgets[i];
            if (widget != null) {
                this.updateCheckedState((TreeItem)widget);
            }
            ++i;
        }
    }

    private Widget[] searchItems(Object element) {
        ArrayList list = new ArrayList();
        TreeItem[] items = this.getTree().getItems();
        int i = 0;
        while (i < items.length) {
            this.findAllOccurrences(items[i], element, list);
            ++i;
        }
        return list.toArray(new Widget[0]);
    }

    private void findAllOccurrences(TreeItem item, Object element, ArrayList list) {
        if (element.equals(item.getData())) {
            list.add(item);
        }
        TreeItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            this.findAllOccurrences(items[i], element, list);
            ++i;
        }
    }

    public void updateCheckedState(TreeItem item) {
        Object element = item.getData();
        if (element instanceof IBreakpoint) {
            try {
                item.setChecked(((IBreakpoint)element).isEnabled());
                this.refreshItem(item);
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        } else if (element instanceof BreakpointContainer) {
            IBreakpoint[] breakpoints = ((BreakpointContainer)((Object)element)).getBreakpoints();
            int enabledChildren = 0;
            int i = 0;
            while (i < breakpoints.length) {
                IBreakpoint breakpoint = breakpoints[i];
                try {
                    if (breakpoint.isEnabled()) {
                        ++enabledChildren;
                    }
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
                ++i;
            }
            if (enabledChildren == 0) {
                item.setGrayed(false);
                item.setChecked(false);
            } else if (enabledChildren == breakpoints.length) {
                item.setGrayed(false);
                item.setChecked(true);
            } else {
                item.setGrayed(true);
                item.setChecked(true);
            }
            TreeItem[] items = item.getItems();
            int i2 = 0;
            while (i2 < items.length) {
                this.updateCheckedState(items[i2]);
                ++i2;
            }
        }
    }
}

