/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.debugger.Expression;
import org.eclipse.php.internal.debug.core.debugger.StackLayer;
import org.eclipse.php.internal.debug.core.model.PHPDebugElement;
import org.eclipse.php.internal.debug.core.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.model.PHPThread;
import org.eclipse.php.internal.debug.core.sourcelookup.PHPSourceSearchEngine;

public class PHPStackFrame
extends PHPDebugElement
implements IStackFrame {
    private PHPThread fThread;
    private String fName;
    private String fFileName;
    private int fPC;
    private int fId;
    private String fResName;

    public PHPStackFrame(IThread iThread, String string, String string2, int n, int n2, String string3) {
        super((PHPDebugTarget)iThread.getDebugTarget());
        this.baseInit(iThread, string, string2, n, n2, string3);
    }

    private void baseInit(IThread iThread, String string, String string2, int n, int n2, String string3) {
        this.fName = string2;
        this.fFileName = string;
        this.fPC = n;
        this.fId = n2;
        this.fThread = (PHPThread)iThread;
        PHPDebugTarget pHPDebugTarget = (PHPDebugTarget)this.fThread.getDebugTarget();
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(pHPDebugTarget.getProjectName());
        IFile iFile = PHPSourceSearchEngine.getResource(string3, iProject);
        this.fResName = iFile.getProjectRelativePath().toString();
    }

    public PHPStackFrame(IThread iThread, String string, String string2, int n, int n2, StackLayer stackLayer, String string3) {
        super((PHPDebugTarget)iThread.getDebugTarget());
        this.baseInit(iThread, string, string2, n, n2, string3);
    }

    public IThread getThread() {
        return this.fThread;
    }

    public IVariable[] getVariables() throws DebugException {
        return ((PHPDebugTarget)this.getDebugTarget()).getVariables();
    }

    public boolean hasVariables() throws DebugException {
        return ((PHPDebugTarget)this.getDebugTarget()).getVariables().length > 0;
    }

    public int getLineNumber() throws DebugException {
        return this.fPC;
    }

    public int checkLineNumber() throws DebugException {
        return this.fPC;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public String getSourceName() {
        return this.fResName;
    }

    public String getAbsoluteFileName() {
        return this.fFileName;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof PHPStackFrame) {
            PHPStackFrame pHPStackFrame = (PHPStackFrame)((Object)object);
            try {
                return pHPStackFrame.fId == this.fId && pHPStackFrame.checkSourceName().equals(this.checkSourceName()) && pHPStackFrame.getName().equals(this.getName());
            }
            catch (DebugException debugException) {}
        }
        return false;
    }

    private String checkSourceName() {
        return this.fResName;
    }

    public int hashCode() {
        return this.getSourceName().hashCode() + this.fId;
    }

    protected int getIdentifier() {
        return this.fId;
    }

    public Expression[] getStackVariables() {
        return ((PHPDebugTarget)this.getDebugTarget()).getStackVariables(this);
    }
}

