/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.documentModel.parser;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.documentModel.parser.regions.PhpScriptRegion;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredTextReParser;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.parser.XMLStructuredDocumentReParser;

public class PhpStructuredDocumentReParser
extends XMLStructuredDocumentReParser {
    public IStructuredTextReParser newInstance() {
        return new PhpStructuredDocumentReParser();
    }

    protected StructuredDocumentEvent checkForComments() {
        StructuredDocumentEvent structuredDocumentEvent = this.checkForCriticalKey("/*");
        if (structuredDocumentEvent == null) {
            structuredDocumentEvent = this.checkForCriticalKey("*/");
        }
        return structuredDocumentEvent != null ? structuredDocumentEvent : super.checkForComments();
    }

    protected StructuredDocumentEvent checkForCrossStructuredDocumentRegionSyntax() {
        StructuredDocumentEvent structuredDocumentEvent = super.checkForCrossStructuredDocumentRegionSyntax();
        if (structuredDocumentEvent == null && (structuredDocumentEvent = this.checkForCriticalKey("<%")) == null) {
            structuredDocumentEvent = this.checkForCriticalKey("%>");
        }
        return structuredDocumentEvent;
    }

    public StructuredDocumentEvent reparse() {
        RegionChangedEvent regionChangedEvent;
        ITextRegion iTextRegion;
        StructuredDocumentEvent structuredDocumentEvent = super.reparse();
        if (structuredDocumentEvent instanceof RegionChangedEvent && (iTextRegion = (regionChangedEvent = (RegionChangedEvent)structuredDocumentEvent).getRegion()).getType() == "PHP_CONTENT") {
            int n = regionChangedEvent.getStructuredDocumentRegion().getStartOffset();
            try {
                PhpScriptRegion phpScriptRegion = (PhpScriptRegion)iTextRegion;
                int n2 = n + iTextRegion.getStart();
                String string = structuredDocumentEvent.getDocument().get(n2, iTextRegion.getLength());
                boolean bl = phpScriptRegion.reparse(regionChangedEvent.fText, string, regionChangedEvent.fOffset - n2, regionChangedEvent.getDeletedText());
                if (!bl) {
                    phpScriptRegion.completeReparse(string);
                    return regionChangedEvent;
                }
            }
            catch (BadLocationException badLocationException) {
                Logger.logException(badLocationException);
            }
        }
        return structuredDocumentEvent;
    }
}

