/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPUserModel;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.php.internal.core.util.ICachable;
import org.eclipse.php.internal.core.util.IncludeCacheManager;
import org.eclipse.php.internal.core.util.SerializationUtil;
import org.eclipse.php.internal.core.util.StreamUtils;

public class DefaultCacheManager {
    private static final String DATA_MODEL_FILE_NAME = ".dataModel";
    private static final String CACHE_DIR_NAME = ".cache";
    public static final int DEFAULT_CACHE_POLICY = 0;
    public static final int VERSION_IDENTIFIER = 200206;
    private HashMap projectToCacheDir;
    private File sharedCacheDir;
    private PreferencesSupport preferencesSupport;
    private IncludeCacheManager includeCacheManager;
    private Object writeLock = new Object();
    public static DefaultCacheManager instance;

    public static DefaultCacheManager instance() {
        if (instance == null) {
            instance = new DefaultCacheManager();
        }
        return instance;
    }

    private DefaultCacheManager() {
        this.projectToCacheDir = new HashMap();
        IPath iPath = PHPCorePlugin.getDefault().getStateLocation();
        this.sharedCacheDir = new File(iPath.toFile(), CACHE_DIR_NAME);
        if (!this.sharedCacheDir.exists()) {
            this.sharedCacheDir.mkdirs();
        }
        this.preferencesSupport = new PreferencesSupport("org.eclipse.php.core", PHPCorePlugin.getDefault().getPreferenceStore());
        this.includeCacheManager = new IncludeCacheManager(this);
    }

    public IncludeCacheManager getIncludeCacheManager() {
        return this.includeCacheManager;
    }

    public void deleteCacheFromDisk(IProject iProject) {
        File file = this.getCacheDir(iProject);
        File file2 = new File(file, DATA_MODEL_FILE_NAME);
        if (file2.exists()) {
            file2.delete();
        }
    }

    protected File getCacheDir(IProject iProject) {
        File file = (File)this.projectToCacheDir.get(iProject);
        if (file == null && iProject != null) {
            IPath iPath = iProject.getLocation();
            if (iPath == null) {
                return null;
            }
            File file2 = iPath.toFile();
            if (file2 != null) {
                file = new File(file2, CACHE_DIR_NAME);
                if (!file.exists()) {
                    file.mkdirs();
                }
                this.projectToCacheDir.put(iProject, file);
            }
        }
        return file;
    }

    public long getSharedCacheModificationTime(IProject iProject, IPhpModel iPhpModel) {
        File file = this.getSharedCacheFile(iProject, iPhpModel);
        return file.lastModified();
    }

    public File getSharedCacheDirectory() {
        return this.sharedCacheDir;
    }

    protected File getSharedCacheFile(IProject iProject, IPhpModel iPhpModel) {
        return this.getSharedCacheFile(iProject, iPhpModel.getID());
    }

    public File getSharedCacheFile(IProject iProject, String string) {
        String string2 = this.preferencesSupport.getPreferencesValue("phpVersion", null, iProject);
        return this.getSharedCacheFile(string2, string);
    }

    public File getSharedCacheFile(String string, String string2) {
        String string3 = String.valueOf(string2.hashCode());
        String string4 = String.valueOf(string3) + '_' + (string != null ? string : "");
        return new File(this.sharedCacheDir, string4);
    }

    public void load(IProject iProject, IPhpModel iPhpModel, boolean bl) {
        if (!(iPhpModel instanceof PHPUserModel)) {
            return;
        }
        PHPUserModel pHPUserModel = (PHPUserModel)iPhpModel;
        File file = null;
        file = bl ? this.getSharedCacheFile(iProject, iPhpModel) : new File(this.getCacheDir(iProject), DATA_MODEL_FILE_NAME);
        this.innerLoadModel(pHPUserModel, file);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void innerLoadModel(PHPUserModel var1_1, File var2_2) {
        if (!var2_2.exists()) {
            return;
        }
        var3_3 = false;
        Runtime.getRuntime().gc();
        var4_4 = null;
        var5_5 = null;
        var6_6 = null;
        try {
            try {
                block10: {
                    var4_4 = new FileInputStream(var2_2);
                    var5_5 = new BufferedInputStream(var4_4, 2048);
                    var6_6 = new DataInputStream(var5_5);
                    var7_7 = var6_6.readInt();
                    if (var7_7 != 200206) break block10;
                    var8_9 = SerializationUtil.deserializePHPFileDataArray(var6_6);
                    var9_10 = 0;
                    while (true) {
                        block11: {
                            if (var9_10 < var8_9.length) break block11;
                            Runtime.getRuntime().gc();
                            ** GOTO lbl-1000
                        }
                        var10_11 = var8_9[var9_10];
                        var1_1.insert(var10_11);
                        ++var9_10;
                    }
                }
                var3_3 = true;
            }
            catch (FileNotFoundException v0) {
            }
            catch (Exception var7_8) {
                PHPCorePlugin.log(var7_8);
            }
        }
        catch (Throwable var12_12) {
            var11_13 = null;
            StreamUtils.closeStream(var6_6);
            StreamUtils.closeStream(var5_5);
            StreamUtils.closeStream(var4_4);
            if (var3_3 == false) throw var12_12;
            if (var2_2.delete()) {
                PHPCorePlugin.logErrorMessage("Invalid cache version. The cache file was deleted.");
                throw var12_12;
            }
            PHPCorePlugin.logErrorMessage("Invalid cache version. Could not delete the file: " + var2_2.getPath());
            throw var12_12;
        }
lbl-1000:
        // 4 sources

        {
            var11_14 = null;
        }
        StreamUtils.closeStream(var6_6);
        StreamUtils.closeStream(var5_5);
        StreamUtils.closeStream(var4_4);
        if (var3_3 == false) return;
        if (var2_2.delete()) {
            PHPCorePlugin.logErrorMessage("Invalid cache version. The cache file was deleted.");
            return;
        }
        PHPCorePlugin.logErrorMessage("Invalid cache version. Could not delete the file: " + var2_2.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(IProject iProject, IPhpModel iPhpModel, boolean bl) {
        if (!(iPhpModel instanceof PHPUserModel)) {
            return;
        }
        PHPUserModel pHPUserModel = (PHPUserModel)iPhpModel;
        File file = null;
        if (bl) {
            file = this.getSharedCacheFile(iProject, iPhpModel);
            Object object = this.writeLock;
            synchronized (object) {
                if (file.exists()) {
                    if (System.currentTimeMillis() - file.lastModified() > 60000L) {
                        this.innerSaveModel(pHPUserModel, file);
                    }
                } else {
                    this.innerSaveModel(pHPUserModel, file);
                }
            }
        } else {
            file = new File(this.getCacheDir(iProject), DATA_MODEL_FILE_NAME);
            this.innerSaveModel(pHPUserModel, file);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void innerSaveModel(PHPUserModel pHPUserModel, File file) {
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        DataOutputStream dataOutputStream = null;
        try {
            try {
                ICachable[] iCachableArray = pHPUserModel.getCachableFiles();
                fileOutputStream = new FileOutputStream(file);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 2048);
                dataOutputStream = new DataOutputStream(bufferedOutputStream);
                dataOutputStream.writeInt(200206);
                SerializationUtil.serialize(iCachableArray, dataOutputStream);
                dataOutputStream.flush();
            }
            catch (IOException iOException) {
                PHPCorePlugin.log(iOException);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            StreamUtils.closeStream(dataOutputStream);
            StreamUtils.closeStream(fileOutputStream);
            StreamUtils.closeStream(bufferedOutputStream);
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        StreamUtils.closeStream(dataOutputStream);
        StreamUtils.closeStream(fileOutputStream);
        StreamUtils.closeStream(bufferedOutputStream);
        Runtime.getRuntime().gc();
    }
}

