/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.swt.widgets.Shell;

public class ActionUtils {
    public static boolean containsOnlyProjects(List list) {
        if (list.isEmpty()) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (ActionUtils.isProject(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsOnly(List list, Class clazz) {
        if (list.isEmpty()) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (clazz.isAssignableFrom(iterator.next().getClass())) continue;
            return false;
        }
        return true;
    }

    public static boolean isProject(Object object) {
        return object instanceof PHPProjectModel || object instanceof IProject;
    }

    public static IResource[] getResources(List list) {
        return ActionUtils.getResources(list, false);
    }

    public static IResource[] getResources(List list, boolean bl) {
        ArrayList arrayList = new ArrayList(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof IResource) {
                arrayList.add(e);
                continue;
            }
            if (!bl || !(e instanceof PHPFileData)) continue;
            arrayList.add(PHPModelUtil.getResource(e));
        }
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    public static IResource[] getResources(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IResource) {
                arrayList.add(objectArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    public static Object[] getPHPElements(List list) {
        return ActionUtils.getPHPElements(list, false);
    }

    public static Object[] getPHPElements(List list, boolean bl) {
        ArrayList arrayList = new ArrayList(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof PHPCodeData) && !(e instanceof PHPProjectModel) && !(e instanceof PHPWorkspaceModelManager) || bl && e instanceof PHPFileData) continue;
            arrayList.add(e);
        }
        return arrayList.toArray();
    }

    public static Object[] getPHPElements(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof PHPCodeData || object instanceof PHPProjectModel || object instanceof PHPWorkspaceModelManager) {
                arrayList.add(object);
            }
            ++n;
        }
        return arrayList.toArray();
    }

    public static boolean isPHPSource(PHPCodeData pHPCodeData) {
        IResource iResource = PHPModelUtil.getResource((Object)pHPCodeData);
        if (iResource == null) {
            return false;
        }
        IProject iProject = iResource.getProject();
        if (iProject == null) {
            return false;
        }
        try {
            IProjectNature iProjectNature = iProject.getNature("org.eclipse.php.core.PHPNature");
            if (iProjectNature != null) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static boolean isProcessable(Shell shell, Object object) {
        if (!(object instanceof PHPCodeData)) {
            return true;
        }
        return ActionUtils.isPHPSource((PHPCodeData)object);
    }

    public static boolean isProcessable(Shell shell, PHPStructuredEditor pHPStructuredEditor) {
        if (pHPStructuredEditor == null) {
            return true;
        }
        PHPFileData pHPFileData = SelectionConverter.getInput(pHPStructuredEditor);
        if (pHPFileData == null) {
            return false;
        }
        return ActionUtils.isProcessable(shell, pHPFileData);
    }

    public static boolean isRenameAvailable(IResource iResource) {
        if (iResource == null) {
            return false;
        }
        if (!iResource.exists()) {
            return false;
        }
        return iResource.isAccessible();
    }

    public static boolean isDeleteAvailable(IResource iResource) {
        if (!iResource.exists() || iResource.isPhantom()) {
            return false;
        }
        return iResource.getType() != 8 && iResource.getType() != 4;
    }

    public static boolean isDeleteAvailable(Object object) {
        if (object instanceof PHPWorkspaceModelManager || object instanceof PHPProjectModel) {
            return false;
        }
        return object instanceof PHPFileData;
    }

    public static boolean isDeleteAvailable(Object[] objectArray) {
        if (objectArray.length != 0) {
            Object[] objectArray2;
            IResource[] iResourceArray = ActionUtils.getResources(objectArray);
            if (objectArray.length != iResourceArray.length + (objectArray2 = ActionUtils.getPHPElements(objectArray)).length) {
                return false;
            }
            int n = 0;
            while (n < iResourceArray.length) {
                if (!ActionUtils.isDeleteAvailable(iResourceArray[n])) {
                    return false;
                }
                ++n;
            }
            n = 0;
            while (n < objectArray2.length) {
                if (!ActionUtils.isDeleteAvailable(objectArray2[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public static boolean arePHPElements(Object[] objectArray) {
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof PHPCodeData && !(objectArray[n] instanceof PHPFileData)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static boolean isInsidePHPFile(Object object) {
        return object instanceof PHPCodeData;
    }
}

