/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dialogs.openType;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.php.internal.core.phpModel.IPHPLanguageModel;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.dialogs.openType.PhpTypeFilter;
import org.eclipse.php.internal.ui.dialogs.openType.PhpTypeFilterComposite;
import org.eclipse.php.internal.ui.dialogs.openType.PhpTypeTableLabelProvider;
import org.eclipse.php.internal.ui.dialogs.openType.generic.BasicSelector;
import org.eclipse.php.internal.ui.dialogs.openType.generic.CompositeFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class OpenPhpTypeDialog
extends Dialog {
    private PHPCodeData selectedElement = null;
    private BasicSelector basicSelector;

    public OpenPhpTypeDialog(Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Point getInitialSize() {
        return this.getShell().computeSize(500, 400, true);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        final PhpTypeFilter phpTypeFilter = new PhpTypeFilter();
        CompositeFactory compositeFactory = new CompositeFactory(){

            public Composite createComposite(Composite composite) {
                return new PhpTypeFilterComposite(composite, phpTypeFilter, phpTypeFilter);
            }
        };
        this.basicSelector = new BasicSelector(composite2, compositeFactory);
        this.basicSelector.setLayoutData(new GridData(1808));
        this.basicSelector.addFilter(phpTypeFilter);
        this.basicSelector.setLabelProvider(new PhpTypeTableLabelProvider());
        this.basicSelector.setElements(this.getElements());
        this.basicSelector.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                OpenPhpTypeDialog.this.okPressed();
            }
        });
        this.basicSelector.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (selectionChangedEvent.getSelection().isEmpty()) {
                    OpenPhpTypeDialog.this.getButton(0).setEnabled(false);
                    return;
                }
                OpenPhpTypeDialog.this.getButton(0).setEnabled(true);
            }
        });
        return composite2;
    }

    private Object[] getElements() {
        ArrayList arrayList = new ArrayList();
        IProject[] iProjectArray = PHPUiPlugin.getWorkspace().getRoot().getProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            block6: {
                IProject iProject;
                block7: {
                    iProject = iProjectArray[n];
                    try {
                        if (!iProject.exists() || !iProject.isOpen()) break block6;
                        if (!iProject.hasNature("org.eclipse.php.core.PHPNature")) {
                        }
                        break block7;
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                    }
                    break block6;
                }
                PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
                IPhpModel[] iPhpModelArray = pHPProjectModel.getModels();
                IPHPLanguageModel iPHPLanguageModel = pHPProjectModel.getPHPLanguageModel();
                int n2 = 0;
                while (n2 < iPhpModelArray.length) {
                    IPhpModel iPhpModel = iPhpModelArray[n2];
                    if (iPhpModel != iPHPLanguageModel) {
                        this.addClassesData(iPhpModel.getClasses(), arrayList);
                        this.addData(iPhpModel.getFunctions(), arrayList);
                        this.addData(iPhpModel.getConstants(), arrayList);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        Object[] objectArray = arrayList.toArray();
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return object.toString().compareToIgnoreCase(object2.toString());
            }
        });
        return objectArray;
    }

    private void addClassesData(CodeData[] codeDataArray, ArrayList arrayList) {
        this.addData(codeDataArray, arrayList);
        int n = 0;
        while (n < codeDataArray.length) {
            PHPClassData pHPClassData = (PHPClassData)codeDataArray[n];
            this.addData((CodeData[])pHPClassData.getConsts(), arrayList);
            this.addData((CodeData[])pHPClassData.getFunctions(), arrayList);
            ++n;
        }
    }

    private void addData(CodeData[] codeDataArray, ArrayList arrayList) {
        int n = 0;
        while (n < codeDataArray.length) {
            CodeData codeData = codeDataArray[n];
            arrayList.add(codeData);
            ++n;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(PHPUIMessages.OpenType_DialogTitle);
    }

    public PHPCodeData getSelectedElement() {
        return this.selectedElement;
    }

    protected void okPressed() {
        this.selectedElement = (PHPCodeData)this.basicSelector.getSelectedElement();
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite composite) {
        super.createButtonsForButtonBar(composite);
        this.getButton(0).setEnabled(false);
    }

    public boolean close() {
        this.basicSelector.close();
        return super.close();
    }
}

