/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.explorer;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.LinkingSelectionListener;
import org.eclipse.php.internal.ui.explorer.ExplorerActionGroup;
import org.eclipse.php.internal.ui.explorer.ExplorerContentProvider;
import org.eclipse.php.internal.ui.explorer.ExplorerLabelProvider;
import org.eclipse.php.internal.ui.explorer.ExplorerSorter;
import org.eclipse.php.internal.ui.explorer.IMultiElementTreeContentProvider;
import org.eclipse.php.internal.ui.explorer.IParentAwareSorter;
import org.eclipse.php.internal.ui.explorer.PHPTreeViewer;
import org.eclipse.php.internal.ui.explorer.WorkingSetAwareContentProvider;
import org.eclipse.php.internal.ui.explorer.WorkingSetAwarePHPElementSorter;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.internal.ui.treecontent.TreeProvider;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.php.internal.ui.util.FilterUpdater;
import org.eclipse.php.internal.ui.util.MultiElementSelection;
import org.eclipse.php.internal.ui.util.PHPElementComparer;
import org.eclipse.php.internal.ui.util.PHPElementLabels;
import org.eclipse.php.internal.ui.util.PHPElementSorter;
import org.eclipse.php.internal.ui.util.StatusBarUpdater;
import org.eclipse.php.internal.ui.util.TreePath;
import org.eclipse.php.internal.ui.workingset.ConfigureWorkingSetAction;
import org.eclipse.php.internal.ui.workingset.WorkingSetModel;
import org.eclipse.php.ui.treecontent.IPHPTreeContentProvider;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.ui.views.navigator.NavigatorDragAdapter;
import org.eclipse.ui.views.navigator.NavigatorDropAdapter;

public class ExplorerPart
extends ViewPart
implements IMenuListener,
FocusListener {
    private static String MEMENTO_ROOT_MODE = "ExplorerPart.rootMode";
    private static String MEMENTO_WORKING_SET = "ExplorerPart.workingSet";
    private PHPTreeViewer fViewer;
    protected ExplorerContentProvider fContentProvider;
    protected ExplorerLabelProvider fLabelProvider;
    private ExplorerActionGroup fActionSet;
    private Menu fContextMenu;
    private boolean fLinkingEnabled;
    private String fWorkingSetName;
    private ISelection fLastOpenSelection;
    private ISelectionChangedListener fPostSelectionListener;
    private FilterUpdater fFilterUpdater;
    private int fRootMode = 1;
    private WorkingSetModel fWorkingSetModel;
    private IPartListener fPartListener = new IPartListener(){

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart instanceof IEditorPart) {
                ExplorerPart.this.editorActivated((IEditorPart)iWorkbenchPart);
            }
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
        }
    };
    IMemento memento;
    private LinkingSelectionListener fSelectionListener = new LinkingSelectionListener(){

        protected ISelection createSelection(Object object) {
            if (object instanceof PHPCodeData) {
                PHPClassData pHPClassData;
                PHPClassData.PHPSuperClassNameData pHPSuperClassNameData;
                PHPClassData pHPClassData2;
                if (object instanceof PHPClassData.PHPSuperClassNameData && (pHPClassData2 = (PHPClassData)(pHPSuperClassNameData = (PHPClassData.PHPSuperClassNameData)object).getContainer()) != null && (pHPClassData = PHPModelUtil.discoverSuperClass((PHPClassData)pHPClassData2, (String)pHPSuperClassNameData.getName())) != null) {
                    object = pHPClassData;
                }
                if ((pHPClassData2 = PHPModelUtil.getResource((Object)(pHPSuperClassNameData = PHPModelUtil.getPHPFileContainer((PHPCodeData)((PHPCodeData)object))))) != null && pHPClassData2.getProject().isAccessible()) {
                    return new StructuredSelection((Object)pHPClassData2);
                }
                if (pHPSuperClassNameData != null) {
                    return new StructuredSelection((Object)pHPSuperClassNameData);
                }
            }
            return super.createSelection(object);
        }
    };

    public void focusGained(FocusEvent focusEvent) {
        this.fContentProvider.postRefresh(this.fViewer.getInput());
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public ExplorerPart() {
        this.fPostSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ExplorerPart.this.handlePostSelectionChanged(selectionChangedEvent);
            }
        };
    }

    public void createPartControl(Composite composite) {
        IEditorPart iEditorPart;
        IMemento iMemento;
        this.fViewer = this.createViewer(composite);
        this.fViewer.getControl().addFocusListener((FocusListener)this);
        this.fSelectionListener.setViewer(this.getViewer());
        this.fViewer.setUseHashlookup(true);
        this.initDragAndDrop();
        this.setProviders();
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuManager.createContextMenu((Control)this.fViewer.getTree());
        this.fViewer.getTree().setMenu(this.fContextMenu);
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        iWorkbenchPartSite.registerContextMenu(menuManager, (ISelectionProvider)this.fViewer);
        iWorkbenchPartSite.setSelectionProvider((ISelectionProvider)this.fViewer);
        iWorkbenchPartSite.getPage().addPartListener(this.fPartListener);
        this.initLinkingEnabled();
        this.fActionSet = new ExplorerActionGroup(this);
        if (this.fWorkingSetModel != null) {
            this.fActionSet.getWorkingSetActionGroup().setWorkingSetModel(this.fWorkingSetModel);
        }
        if (this.memento != null && (iMemento = this.memento.getChild(MEMENTO_WORKING_SET)) != null) {
            this.fActionSet.restoreFilterAndSorterState(this.memento.getChild(MEMENTO_WORKING_SET));
        }
        this.fViewer.setInput(this.findInputElement());
        this.initKeyListener();
        this.fViewer.addPostSelectionChangedListener(this.fPostSelectionListener);
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ExplorerPart.this.fActionSet.handleDoubleClick(doubleClickEvent);
            }
        });
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent openEvent) {
                ExplorerPart.this.fActionSet.handleOpen(openEvent);
                ExplorerPart.this.fLastOpenSelection = openEvent.getSelection();
            }
        });
        iMemento = this.getViewSite().getActionBars().getStatusLineManager();
        this.fViewer.addSelectionChangedListener(new StatusBarUpdater((IStatusLineManager)iMemento));
        this.fillActionBars();
        this.updateTitle();
        this.fFilterUpdater = new FilterUpdater((StructuredViewer)this.fViewer);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        if (this.isLinkingEnabled() && (iEditorPart = this.getViewSite().getPage().getActiveEditor()) != null) {
            this.editorActivated(iEditorPart);
        }
    }

    private PHPTreeViewer createViewer(Composite composite) {
        return new ExplorerTreeViewer(composite, 770);
    }

    Object getElementOfInput(IEditorInput iEditorInput) {
        if (iEditorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)iEditorInput).getFile();
        }
        return null;
    }

    public void setFocus() {
        this.fViewer.getTree().setFocus();
    }

    protected void initDragAndDrop() {
        int n = 3;
        Transfer[] transferArray = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance(), PluginTransfer.getInstance()};
        TreeViewer treeViewer = this.getViewer();
        treeViewer.addDragSupport(n, transferArray, (DragSourceListener)new NavigatorDragAdapter((ISelectionProvider)treeViewer));
        NavigatorDropAdapter navigatorDropAdapter = new NavigatorDropAdapter((StructuredViewer)treeViewer);
        navigatorDropAdapter.setFeedbackEnabled(false);
        treeViewer.addDropSupport(n | 0x10, transferArray, (DropTargetListener)navigatorDropAdapter);
    }

    private void initKeyListener() {
        this.fViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                ExplorerPart.this.fActionSet.handleKeyEvent(keyEvent);
            }
        });
    }

    private void handlePostSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (this.isLinkingEnabled() && !iSelection.equals(this.fLastOpenSelection)) {
            this.linkToEditor((IStructuredSelection)iSelection);
        }
        this.fLastOpenSelection = null;
    }

    private void linkToEditor(IStructuredSelection iStructuredSelection) {
        IEditorPart iEditorPart;
        if (this != this.getSite().getPage().getActivePart()) {
            return;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (iStructuredSelection.size() == 1 && (iEditorPart = EditorUtility.isOpenInEditor(object)) != null) {
            IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
            iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
            if (object instanceof PHPCodeData) {
                EditorUtility.revealInEditor(iEditorPart, (PHPCodeData)object);
            }
        }
    }

    private void setProviders() {
        this.fContentProvider = this.createContentProvider();
        IPHPTreeContentProvider[] iPHPTreeContentProviderArray = TreeProvider.getTreeProviders(this.getViewSite().getId());
        this.fContentProvider.setTreeProviders(iPHPTreeContentProviderArray);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setSorter(new ExplorerSorter());
        this.fLabelProvider = this.createLabelProvider();
        this.fLabelProvider.setTreeProviders(iPHPTreeContentProviderArray);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)this.fLabelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
    }

    void projectStateChanged(Object object) {
        Control control = this.fViewer.getControl();
        if (control != null && !control.isDisposed() && control.isVisible()) {
            this.fViewer.refresh(object, true);
            this.fViewer.setSelection(this.fViewer.getSelection());
        }
    }

    public ExplorerContentProvider createContentProvider() {
        IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean("explorerCuchildren");
        if (this.showProjects()) {
            return new ExplorerContentProvider(this, bl);
        }
        return new WorkingSetAwareContentProvider(this, bl, this.fWorkingSetModel);
    }

    boolean showProjects() {
        return this.fRootMode == 1;
    }

    boolean showWorkingSets() {
        return this.fRootMode == 2;
    }

    protected ExplorerLabelProvider createLabelProvider() {
        return new ExplorerLabelProvider(1627389963, 3, this.fContentProvider);
    }

    private Object findInputElement() {
        if (this.showWorkingSets()) {
            return this.fWorkingSetModel;
        }
        IAdaptable iAdaptable = this.getSite().getPage().getInput();
        if (iAdaptable instanceof IWorkspace || iAdaptable instanceof IWorkspaceRoot) {
            return PHPWorkspaceModelManager.getInstance();
        }
        if (iAdaptable instanceof IContainer) {
            return iAdaptable;
        }
        return PHPWorkspaceModelManager.getInstance();
    }

    public void dispose() {
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this.fSelectionListener);
        if (this.fContextMenu != null && !this.fContextMenu.isDisposed()) {
            this.fContextMenu.dispose();
        }
        this.getSite().getPage().removePartListener(this.fPartListener);
        if (this.fActionSet != null) {
            this.fActionSet.dispose();
        }
        if (this.fFilterUpdater != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        }
        if (this.fWorkingSetModel != null) {
            this.fWorkingSetModel.dispose();
        }
        super.dispose();
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        PHPUiPlugin.createStandardGroups(iMenuManager);
        this.fActionSet.setContext(new ActionContext(this.getSelection()));
        this.fActionSet.fillContextMenu(iMenuManager);
        this.fActionSet.setContext(null);
    }

    void editorActivated(IEditorPart iEditorPart) {
        if (!this.isLinkingEnabled()) {
            return;
        }
        Object object = this.getElementOfInput(iEditorPart.getEditorInput());
        if (object == null) {
            return;
        }
        if (!this.inputIsSelected(iEditorPart.getEditorInput())) {
            this.showInput(object);
        } else {
            this.fViewer.getTree().showSelection();
        }
    }

    private boolean inputIsSelected(IEditorInput iEditorInput) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fViewer.getSelection();
        if (iStructuredSelection.size() != 1) {
            return false;
        }
        IEditorInput iEditorInput2 = null;
        iEditorInput2 = EditorUtility.getEditorInput(iStructuredSelection.getFirstElement());
        return iEditorInput.equals(iEditorInput2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean showInput(Object object) {
        if (object == null) return false;
        StructuredSelection structuredSelection = new StructuredSelection(object);
        if (this.fViewer.getSelection().equals(structuredSelection)) {
            this.fViewer.reveal(object);
            return true;
        }
        try {
            this.fViewer.removePostSelectionChangedListener(this.fPostSelectionListener);
            this.fViewer.setSelection((ISelection)structuredSelection, true);
            while (object != null && this.fViewer.getSelection().isEmpty()) {
                if ((object = this.fContentProvider.getParent(object)) == null) continue;
                structuredSelection = new StructuredSelection(object);
                this.fViewer.setSelection((ISelection)structuredSelection, true);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fViewer.addPostSelectionChangedListener(this.fPostSelectionListener);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.fViewer.addPostSelectionChangedListener(this.fPostSelectionListener);
        return true;
    }

    public TreeViewer getViewer() {
        return this.fViewer;
    }

    private void fillActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fActionSet.fillActionBars(iActionBars);
    }

    private ISelection getSelection() {
        return this.fViewer.getSelection();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void collapseAll() {
        try {
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.collapseToLevel(this.getViewPartInput(), -1);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.fViewer.getControl().setRedraw(true);
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.fViewer.getControl().setRedraw(true);
    }

    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    private void initLinkingEnabled() {
        this.setLinkingEnabled(PreferenceConstants.getPreferenceStore().getBoolean("browsingProjectstoeditor"));
    }

    public void setLinkingEnabled(boolean bl) {
        this.fLinkingEnabled = bl;
        PreferenceConstants.getPreferenceStore().setValue("browsingProjectstoeditor", bl);
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        if (iWorkbenchPartSite == null) {
            return;
        }
        IWorkbenchPage iWorkbenchPage = iWorkbenchPartSite.getPage();
        if (iWorkbenchPage == null) {
            return;
        }
        if (bl) {
            iWorkbenchPage.addPostSelectionListener((ISelectionListener)this.fSelectionListener);
            IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
            if (iEditorPart != null) {
                this.editorActivated(iEditorPart);
            }
        } else {
            iWorkbenchPage.removePostSelectionListener((ISelectionListener)this.fSelectionListener);
        }
    }

    String getFrameName(Object object) {
        if (object instanceof PHPCodeData) {
            return ((PHPCodeData)object).getName();
        }
        return this.fLabelProvider.getText(object);
    }

    String getToolTipText(Object object) {
        Object object2;
        String string = !(object instanceof IResource) ? (object instanceof PHPWorkspaceModelManager ? PHPUIMessages.PHPExplorerPart_workspace : (object instanceof PHPCodeData ? PHPElementLabels.getTextLabel(object, 1090519051L) : this.fLabelProvider.getText(object))) : ((object2 = ((IResource)object).getFullPath()).isRoot() ? PHPUIMessages.PHPExplorer_title : object2.makeRelative().toString());
        if (this.fWorkingSetName == null) {
            return string;
        }
        object2 = MessageFormat.format(PHPUIMessages.PHPExplorer_toolTip, this.fWorkingSetName);
        if (string.length() == 0) {
            return object2;
        }
        return MessageFormat.format(PHPUIMessages.PHPExplorer_toolTip2, string, this.fWorkingSetName);
    }

    void updateTitle() {
        Object object = this.fViewer.getInput();
        if (object == null || object instanceof PHPWorkspaceModelManager) {
            this.setContentDescription("");
            this.setTitleToolTip("");
        } else {
            String string = PHPElementLabels.getTextLabel(object, 1090519051L);
            this.setContentDescription(string);
            this.setTitleToolTip(this.getToolTipText(object));
        }
    }

    void setWorkingSetName(String string) {
        this.fWorkingSetName = string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rootModeChanged(int n) {
        ConfigureWorkingSetAction configureWorkingSetAction;
        this.fRootMode = n;
        if (this.showWorkingSets() && this.fWorkingSetModel == null) {
            this.createWorkingSetModel();
            if (this.fActionSet != null) {
                this.fActionSet.getWorkingSetActionGroup().setWorkingSetModel(this.fWorkingSetModel);
            }
        }
        ISelection iSelection = this.fViewer.getSelection();
        Object object = this.fViewer.getInput();
        boolean bl = PHPWorkspaceModelManager.getInstance().equals(object) || this.fWorkingSetModel != null && this.fWorkingSetModel.equals(object) || object instanceof IWorkingSet;
        try {
            this.fViewer.getControl().setRedraw(false);
            if (bl) {
                this.fViewer.setInput(null);
            }
            this.setProviders();
            this.setSorter();
            this.fActionSet.getWorkingSetActionGroup().fillFilters((StructuredViewer)this.fViewer);
            if (bl) {
                this.fViewer.setInput(this.findInputElement());
            }
            this.fViewer.setSelection(iSelection, true);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.fViewer.getControl().setRedraw(true);
            throw throwable;
        }
        {
            configureWorkingSetAction = null;
        }
        this.fViewer.getControl().setRedraw(true);
        if (bl && this.fWorkingSetModel.needsConfiguration()) {
            configureWorkingSetAction = new ConfigureWorkingSetAction(this.getSite());
            configureWorkingSetAction.setWorkingSetModel(this.fWorkingSetModel);
            configureWorkingSetAction.run();
            this.fWorkingSetModel.configured();
        }
    }

    private void setSorter() {
        if (this.showWorkingSets()) {
            this.fViewer.setSorter(new WorkingSetAwarePHPElementSorter());
        } else {
            this.fViewer.setSorter(new PHPElementSorter());
        }
    }

    private void createWorkingSetModel(final IMemento iMemento) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                ExplorerPart.this.fWorkingSetModel = new WorkingSetModel(iMemento);
            }

            public void handleException(Throwable throwable) {
                ExplorerPart.this.fWorkingSetModel = new WorkingSetModel(iMemento);
            }
        });
    }

    private void createWorkingSetModel() {
        this.createWorkingSetModel(null);
    }

    public WorkingSetModel getWorkingSetModel() {
        return this.fWorkingSetModel;
    }

    public int getRootMode() {
        return this.fRootMode;
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        Integer n;
        super.init(iViewSite, iMemento);
        if (iMemento != null && (n = iMemento.getInteger(MEMENTO_ROOT_MODE)) != null) {
            this.fRootMode = n;
        }
        if (this.showWorkingSets()) {
            this.createWorkingSetModel(iMemento.getChild(MEMENTO_WORKING_SET));
        }
        this.memento = iMemento;
    }

    public void saveState(IMemento iMemento) {
        if (iMemento != null) {
            iMemento.putInteger(MEMENTO_ROOT_MODE, this.fRootMode);
            IMemento iMemento2 = iMemento.createChild(MEMENTO_WORKING_SET);
            if (this.fWorkingSetModel != null) {
                this.fWorkingSetModel.saveState(iMemento2);
            }
            this.fActionSet.saveFilterAndSorterState(iMemento2);
        }
        super.saveState(iMemento);
    }

    private class ExplorerTreeViewer
    extends PHPTreeViewer {
        List fPendingGetChildren;

        public ExplorerTreeViewer(Composite composite, int n) {
            super(composite, n);
            this.fPendingGetChildren = Collections.synchronizedList(new ArrayList());
            this.setComparer(new PHPElementComparer());
        }

        public void add(Object object, Object[] objectArray) {
            if (this.fPendingGetChildren.contains(object)) {
                return;
            }
            super.add(object, objectArray);
        }

        protected Object[] getRawChildren(Object object) {
            Object[] objectArray;
            try {
                this.fPendingGetChildren.add(object);
                objectArray = super.getRawChildren(object);
                Object var2_3 = null;
                this.fPendingGetChildren.remove(object);
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.fPendingGetChildren.remove(object);
                throw throwable;
            }
            return objectArray;
        }

        private Object getElement(TreeItem treeItem) {
            Object object = treeItem.getData();
            if (object == null) {
                return null;
            }
            return object;
        }

        private TreePath createTreePath(TreeItem treeItem) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(treeItem.getData());
            TreeItem treeItem2 = treeItem.getParentItem();
            while (treeItem2 != null) {
                arrayList.add(treeItem2.getData());
                treeItem2 = treeItem2.getParentItem();
            }
            Collections.reverse(arrayList);
            return new TreePath(arrayList.toArray());
        }

        public ISelection getSelection() {
            IContentProvider iContentProvider = this.getContentProvider();
            if (!(iContentProvider instanceof IMultiElementTreeContentProvider)) {
                return super.getSelection();
            }
            Control control = this.getControl();
            if (control == null || control.isDisposed() || !control.isVisible()) {
                return StructuredSelection.EMPTY;
            }
            Tree tree = this.getTree();
            TreeItem[] treeItemArray = tree.getSelection();
            ArrayList<Object> arrayList = new ArrayList<Object>(treeItemArray.length);
            ArrayList<TreePath> arrayList2 = new ArrayList<TreePath>();
            int n = 0;
            while (n < treeItemArray.length) {
                TreeItem treeItem = treeItemArray[n];
                Object object = this.getElement(treeItem);
                if (object != null) {
                    if (!arrayList.contains(object)) {
                        arrayList.add(object);
                    }
                    arrayList2.add(this.createTreePath(treeItem));
                }
                ++n;
            }
            return new MultiElementSelection((StructuredViewer)this, arrayList, arrayList2.toArray(new TreePath[arrayList2.size()]));
        }

        protected Object[] getSortedChildren(Object object) {
            IParentAwareSorter iParentAwareSorter;
            IParentAwareSorter iParentAwareSorter2 = iParentAwareSorter = this.getSorter() instanceof IParentAwareSorter ? (IParentAwareSorter)this.getSorter() : null;
            if (iParentAwareSorter != null) {
                iParentAwareSorter.setParent(object);
            }
            try {
                Object[] objectArray = super.getSortedChildren(object);
                Object var3_4 = null;
                if (iParentAwareSorter != null) {
                    iParentAwareSorter.setParent(null);
                }
                return objectArray;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var3_5 = null;
                    if (iParentAwareSorter == null) break block4;
                    iParentAwareSorter.setParent(null);
                }
                throw throwable;
            }
        }

        public boolean isExpandable(Object object) {
            ViewerFilter[] viewerFilterArray = ExplorerPart.this.fViewer.getFilters();
            Object[] objectArray = ((ITreeContentProvider)ExplorerPart.this.fViewer.getContentProvider()).getChildren(object);
            int n = 0;
            while (n < objectArray.length) {
                Object object2 = objectArray[n];
                if (this.isEssential(object2)) {
                    return true;
                }
                if ((object2 = this.filter(object2, object, viewerFilterArray)) != null) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private Object filter(Object object, Object object2, ViewerFilter[] viewerFilterArray) {
            Object object3 = null;
            int n = 0;
            while (n < viewerFilterArray.length) {
                ViewerFilter viewerFilter = viewerFilterArray[n];
                if (viewerFilter.select((Viewer)ExplorerPart.this.fViewer, object2, object)) {
                    object3 = object;
                }
                ++n;
            }
            return object3;
        }

        protected Object[] filter(Object[] objectArray) {
            ViewerFilter[] viewerFilterArray = this.getFilters();
            if (viewerFilterArray == null || viewerFilterArray.length == 0) {
                return objectArray;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            Object object = this.getRoot();
            int n = 0;
            while (n < objectArray.length) {
                boolean bl = true;
                if (!this.isEssential(objectArray[n])) {
                    int n2 = 0;
                    while (n2 < viewerFilterArray.length) {
                        bl = viewerFilterArray[n2].select((Viewer)this, object, objectArray[n]);
                        if (!bl) break;
                        ++n2;
                    }
                }
                if (bl) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            return arrayList.toArray();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isEssential(Object object) {
            if (!(object instanceof IContainer)) return false;
            IContainer iContainer = (IContainer)object;
            try {
                Object object2 = this.filter(object, object, ExplorerPart.this.fViewer.getFilters());
                if (!(object instanceof IProject)) return object2 != null && iContainer.members().length > 0;
                IProject iProject = (IProject)object;
                if (!iProject.isOpen() || !((IProject)object).hasNature("org.eclipse.php.core.PHPNature")) return false;
                return false;
            }
            catch (CoreException coreException) {
                return false;
            }
        }

        protected void handleInvalidSelection(ISelection iSelection, ISelection iSelection2) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            ArrayList<Object> arrayList = null;
            arrayList = iSelection2 instanceof IStructuredSelection ? new ArrayList(((IStructuredSelection)iSelection2).toList()) : new ArrayList<IProject>();
            boolean bl = false;
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                IProject iProject;
                Object e = iterator.next();
                if (e instanceof PHPProjectModel) {
                    iProject = PHPWorkspaceModelManager.getInstance().getProjectForModel((PHPProjectModel)e);
                    if (iProject.isOpen()) continue;
                    arrayList.add(iProject);
                    bl = true;
                    continue;
                }
                if (!(e instanceof IProject) || !(iProject = (IProject)e).isOpen()) continue;
                bl = true;
            }
            if (bl) {
                iSelection2 = new StructuredSelection(arrayList);
                this.setSelection(iSelection2);
            }
            super.handleInvalidSelection(iSelection, iSelection2);
        }
    }
}

