/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.php.internal.core.util.preferences.Key;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.PHPCoreOptionsConfigurationBlock;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;

public class PHPFormatterConfigurationBlock
extends PHPCoreOptionsConfigurationBlock
implements ModifyListener,
SelectionListener {
    private static final Key PREF_FORMATTER_USE_TABS = PHPFormatterConfigurationBlock.getPHPCoreKey("org.eclipse.php.core.phpForamtterUseTabs");
    private static final Key PREF_FORMATTER_INDENTATION_SIZE = PHPFormatterConfigurationBlock.getPHPCoreKey("org.eclipse.php.core.phpForamtterIndentationSize");
    private IStatus fFormatterStatus = new StatusInfo();
    private final int MIN_INDENTATION_SIZE = 0;
    private final int MAX_INDENTATION_SIZE = 16;
    private Button fIndentUsingTabs;
    private Button fIndentUsingSpaces;
    private Spinner fIndentationSizeSpinner;
    private boolean fUseTabs;
    private int fIndentationSize;

    public PHPFormatterConfigurationBlock(IStatusChangeListener iStatusChangeListener, IProject iProject, IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer) {
        super(iStatusChangeListener, iProject, PHPFormatterConfigurationBlock.getKeys(), iWorkbenchPreferenceContainer);
        this.initValues();
    }

    protected Control createContents(Composite composite) {
        this.setShell(composite.getShell());
        Composite composite2 = this.createFormaterContent(composite);
        this.validateSettings(null, null, null);
        return composite2;
    }

    private Composite createFormaterContent(Composite composite) {
        Composite composite2 = this.createComposite(composite, 2);
        this.fIndentUsingTabs = this.createRadioButton(composite2, XMLUIMessages.Indent_using_tabs);
        ((GridData)this.fIndentUsingTabs.getLayoutData()).horizontalSpan = 2;
        this.fIndentUsingTabs.addSelectionListener((SelectionListener)this);
        this.fIndentUsingSpaces = this.createRadioButton(composite2, XMLUIMessages.Indent_using_spaces);
        ((GridData)this.fIndentUsingSpaces.getLayoutData()).horizontalSpan = 2;
        this.createLabel(composite2, XMLUIMessages.Indentation_size);
        this.fIndentationSizeSpinner = new Spinner(composite2, 2056);
        GridData gridData = new GridData(32);
        this.fIndentationSizeSpinner.setLayoutData((Object)gridData);
        this.fIndentationSizeSpinner.setToolTipText(XMLUIMessages.Indentation_size_tip);
        this.fIndentationSizeSpinner.setMinimum(0);
        this.fIndentationSizeSpinner.setMaximum(16);
        this.fIndentationSizeSpinner.setIncrement(1);
        this.fIndentationSizeSpinner.setPageIncrement(4);
        this.fIndentationSizeSpinner.addModifyListener((ModifyListener)this);
        this.updateValues();
        return composite2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateSettings(Key key, String string, String string2) {
        if (key != null) {
            if (!PREF_FORMATTER_INDENTATION_SIZE.equals(key)) return;
            this.fFormatterStatus = this.validate();
        } else {
            this.fFormatterStatus = this.validate();
        }
        IStatus iStatus = this.fFormatterStatus;
        this.fContext.statusChanged(iStatus);
    }

    protected String[] getFullBuildDialogStrings(boolean bl) {
        return null;
    }

    private IStatus validate() {
        return new StatusInfo();
    }

    private static Key[] getKeys() {
        return new Key[]{PREF_FORMATTER_USE_TABS, PREF_FORMATTER_INDENTATION_SIZE};
    }

    private Composite createComposite(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4);
        gridData.horizontalIndent = 0;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        composite2.setLayoutData((Object)gridData);
        return composite2;
    }

    private Button createRadioButton(Composite composite, String string) {
        Button button = new Button(composite, 16);
        button.setText(string);
        GridData gridData = new GridData(4);
        gridData.verticalAlignment = 2;
        gridData.horizontalAlignment = 4;
        button.setLayoutData((Object)gridData);
        return button;
    }

    private Label createLabel(Composite composite, String string) {
        Label label = new Label(composite, 16384);
        label.setText(string);
        GridData gridData = new GridData(4);
        gridData.verticalAlignment = 2;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (modifyEvent.widget != null && modifyEvent.widget.isDisposed()) {
            return;
        }
        this.validateValues();
        this.enableValues(modifyEvent.widget);
    }

    protected void validateValues() {
    }

    protected void enableValues(Widget widget) {
        this.fIndentationSize = ((Spinner)widget).getSelection();
        this.setValue(PREF_FORMATTER_INDENTATION_SIZE, String.valueOf(this.fIndentationSize));
    }

    protected void updateControls() {
        this.initValues();
        this.updateValues();
    }

    private void initValues() {
        String string = this.getValue(PREF_FORMATTER_USE_TABS);
        String string2 = this.getValue(PREF_FORMATTER_INDENTATION_SIZE);
        this.fUseTabs = Boolean.valueOf(string);
        this.fIndentationSize = Integer.valueOf(string2);
    }

    private void updateValues() {
        this.fIndentUsingTabs.setSelection(this.fUseTabs);
        this.fIndentUsingSpaces.setSelection(!this.fUseTabs);
        this.fIndentationSizeSpinner.setSelection(this.fIndentationSize);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.updateButtonStatus((Button)selectionEvent.widget);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.updateButtonStatus((Button)selectionEvent.widget);
    }

    private void updateButtonStatus(Button button) {
        this.fUseTabs = button.getSelection();
        this.setValue(PREF_FORMATTER_USE_TABS, this.fUseTabs ? "true" : "false");
    }
}

