/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPIncludeFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class PHPElementLabels {
    public static final int M_PARAMETER_TYPES = 1;
    public static final int M_PARAMETER_NAMES = 2;
    public static final int M_APP_RETURNTYPE = 8;
    public static final int M_PRE_RETURNTYPE = 16;
    public static final int M_FULLY_QUALIFIED = 32;
    public static final int M_POST_QUALIFIED = 64;
    public static final int I_POST_QUALIFIED = 256;
    public static final int F_APP_TYPE_SIGNATURE = 512;
    public static final int F_PRE_TYPE_SIGNATURE = 1024;
    public static final int F_FULLY_QUALIFIED = 2048;
    public static final int F_POST_QUALIFIED = 4096;
    public static final int T_FULLY_QUALIFIED = 8192;
    public static final int T_CONTAINER_QUALIFIED = 16384;
    public static final int T_POST_QUALIFIED = 32768;
    public static final int CU_QUALIFIED = 65536;
    public static final int CU_POST_QUALIFIED = 131072;
    public static final int P_QUALIFIED = 0x400000;
    public static final int P_POST_QUALIFIED = 0x800000;
    public static final int ROOT_VARIABLE = 0x1000000;
    public static final int ROOT_QUALIFIED = 0x2000000;
    public static final int ROOT_POST_QUALIFIED = 0x4000000;
    public static final int APPEND_ROOT_PATH = 0x8000000;
    public static final int PREPEND_ROOT_PATH = 0x10000000;
    public static final int P_COMPRESSED = 0x20000000;
    public static final int REFERENCED_ROOT_POST_QUALIFIED = 0x40000000;
    public static final long T_TYPE_PARAMETERS = 0x200000L;
    public static final long CF_POST_QUALIFIED = 0x10000000L;
    public static final long CF_QUALIFIED = 0x8000000L;
    public static final long I_FULLY_QUALIFIED = 1024L;
    public static final long D_QUALIFIED = 0x1000000L;
    public static final long D_POST_QUALIFIED = 0x2000000L;
    public static final int ALL_FULLY_QUALIFIED = 37824544;
    public static final int ALL_POST_QUALIFIED = 75665728;
    public static final int ALL_DEFAULT = 1;
    public static final int DEFAULT_QUALIFIED = 75808;
    public static final int DEFAULT_POST_QUALIFIED = 168256;
    public static final String CONCAT_STRING = " - ";
    public static final String COMMA_STRING = ", ";
    public static final String DECL_STRING = " :";
    public static final String DEFAULT_FOLDER = "(source)";
    private static String fgPkgNamePrefix;
    private static String fgPkgNamePostfix;
    private static int fgPkgNameChars;
    private static int fgPkgNameLength;
    static /* synthetic */ Class class$0;

    static {
        fgPkgNameLength = -1;
    }

    public static String getElementLabel(Object object, long l) {
        StringBuffer stringBuffer = new StringBuffer(60);
        PHPElementLabels.getElementLabel(object, l, stringBuffer);
        return stringBuffer.toString();
    }

    public static void getElementLabel(Object object, long l, StringBuffer stringBuffer) {
        IContainer iContainer = null;
        if (object instanceof PHPCodeData) {
            iContainer = PHPModelUtil.getPHPFolderRoot((PHPCodeData)((PHPCodeData)object));
        }
        if (iContainer != null && PHPElementLabels.getFlag(l, 0x10000000L)) {
            PHPElementLabels.getPHPFolderRootLabel(iContainer, 0x2000000L, stringBuffer);
            stringBuffer.append(CONCAT_STRING);
        }
        if (object instanceof PHPFunctionData) {
            PHPElementLabels.getMethodLabel((PHPFunctionData)object, l, stringBuffer);
        } else if (object instanceof PHPVariableData) {
            PHPElementLabels.getFieldLabel((PHPVariableData)object, l, stringBuffer);
        } else if (object instanceof PHPClassData) {
            PHPElementLabels.getTypeLabel((PHPClassData)object, l, stringBuffer);
        } else if (object instanceof PHPConstantData) {
            stringBuffer.append(((PHPConstantData)object).getName());
        } else if (object instanceof PHPClassConstData) {
            stringBuffer.append(((PHPClassConstData)object).getName());
        } else if (object instanceof PHPFileData) {
            PHPElementLabels.getCompilationUnitLabel((PHPFileData)object, l, stringBuffer);
        } else if (object instanceof PHPIncludeFileData) {
            PHPElementLabels.getIncludeFileLabel((PHPIncludeFileData)object, l, stringBuffer);
        } else if (object instanceof IFolder) {
            PHPElementLabels.getPHPFolderLabel((IContainer)((IFolder)object), l, stringBuffer);
        } else if (object instanceof PHPProjectModel) {
            IProject iProject = PHPWorkspaceModelManager.getInstance().getProjectForModel((PHPProjectModel)object);
            stringBuffer.append(iProject.getName());
        } else if (object instanceof PHPWorkspaceModelManager) {
            stringBuffer.append("PHP Model");
        } else if (object instanceof IResource) {
            stringBuffer.append(((IResource)object).getName());
        }
        if (iContainer != null && PHPElementLabels.getFlag(l, 0x8000000L)) {
            stringBuffer.append(CONCAT_STRING);
            PHPElementLabels.getPHPFolderRootLabel(iContainer, 0x2000000L, stringBuffer);
        }
    }

    private static boolean getFlag(long l, long l2) {
        return (l & l2) != 0L;
    }

    public static void getPHPFolderLabel(IContainer iContainer, long l, StringBuffer stringBuffer) {
        if (PHPElementLabels.getFlag(l, 0x400000L)) {
            PHPElementLabels.getPHPFolderRootLabel(iContainer.getParent(), 0x2000000L, stringBuffer);
            stringBuffer.append('/');
        }
        if (iContainer instanceof IProject) {
            IPath iPath = iContainer.getFullPath();
            IPath iPath2 = iContainer.getProject().getFullPath();
            if ((iPath = iPath.removeFirstSegments(iPath2.segmentCount())).segmentCount() > 0) {
                stringBuffer.append(iPath.toString());
            } else {
                stringBuffer.append(DEFAULT_FOLDER);
            }
        } else if (PHPElementLabels.getFlag(l, 0x20000000L) && fgPkgNameLength >= 0) {
            String string = iContainer.getName();
            int n = 0;
            int n2 = string.indexOf(46, n);
            while (n2 > 0) {
                if (n2 - n > fgPkgNameLength - 1) {
                    stringBuffer.append(fgPkgNamePrefix);
                    if (fgPkgNameChars > 0) {
                        stringBuffer.append(string.substring(n, Math.min(n + fgPkgNameChars, n2)));
                    }
                    stringBuffer.append(fgPkgNamePostfix);
                } else {
                    stringBuffer.append(string.substring(n, n2 + 1));
                }
                n = n2 + 1;
                n2 = string.indexOf(46, n);
            }
            stringBuffer.append(string.substring(n));
        } else {
            stringBuffer.append(iContainer.getName());
        }
        if (PHPElementLabels.getFlag(l, 0x800000L)) {
            stringBuffer.append(CONCAT_STRING);
            PHPElementLabels.getPHPFolderRootLabel(iContainer.getParent(), 0x2000000L, stringBuffer);
        }
    }

    public static void getPHPFolderRootLabel(IContainer iContainer, long l, StringBuffer stringBuffer) {
        PHPElementLabels.getFolderLabel(iContainer, l, stringBuffer);
    }

    private static void getFolderLabel(IContainer iContainer, long l, StringBuffer stringBuffer) {
        IContainer iContainer2 = iContainer;
        boolean bl = PHPElementLabels.getFlag(l, 0x2000000L);
        if (bl) {
            stringBuffer.append(iContainer.getFullPath().makeRelative().toString());
        } else {
            if (iContainer2 != null) {
                stringBuffer.append(iContainer2.getProjectRelativePath().toString());
            } else {
                stringBuffer.append(iContainer.getName());
            }
            if (PHPElementLabels.getFlag(l, 0x4000000L)) {
                stringBuffer.append(CONCAT_STRING);
                stringBuffer.append(iContainer.getParent().getName());
            }
        }
    }

    public static void getMethodLabel(PHPFunctionData pHPFunctionData, long l, StringBuffer stringBuffer) {
        PHPCodeData pHPCodeData;
        stringBuffer.append(pHPFunctionData.getName());
        if (PHPElementLabels.getFlag(l, 3L)) {
            pHPCodeData = pHPFunctionData.getParameters();
            stringBuffer.append('(');
            int n = pHPCodeData != null && PHPElementLabels.getFlag(l, 1L) ? ((PHPFunctionData.PHPFunctionParameter[])pHPCodeData).length : 0;
            int n2 = 0;
            while (n2 < n) {
                String string;
                if (n2 > 0) {
                    stringBuffer.append(COMMA_STRING);
                    stringBuffer.append(" ");
                }
                if (PHPElementLabels.getFlag(l, 1L)) {
                    string = pHPCodeData[n2].getClassType();
                    string = string == null ? "" : String.valueOf(string) + " ";
                    stringBuffer.append(string);
                }
                if (PHPElementLabels.getFlag(l, 2L)) {
                    stringBuffer.append("$" + pHPCodeData[n2].getName());
                    string = pHPCodeData[n2].getDefaultValue();
                    if (string != null && !string.equals("")) {
                        stringBuffer.append(" = " + string);
                    }
                }
                ++n2;
            }
            stringBuffer.append(')');
        }
        if (PHPElementLabels.getFlag(l, 16L)) {
            pHPCodeData = pHPFunctionData.getReturnType();
            stringBuffer.append(DECL_STRING);
            stringBuffer.append((String)pHPCodeData);
        }
        if (PHPElementLabels.getFlag(l, 8L)) {
            pHPCodeData = pHPFunctionData.getReturnType();
            stringBuffer.append(DECL_STRING);
            stringBuffer.append((String)pHPCodeData);
        }
        if (PHPElementLabels.getFlag(l, 64L)) {
            stringBuffer.append(CONCAT_STRING);
            pHPCodeData = pHPFunctionData.getContainer();
            PHPClassData pHPClassData = null;
            if (pHPCodeData != null && pHPCodeData instanceof PHPClassData) {
                pHPClassData = (PHPClassData)pHPCodeData;
            }
            PHPElementLabels.getTypeLabel(pHPClassData, 0x2000L | l & 0x20000000L, stringBuffer);
        }
    }

    public static void getTypeLabel(PHPClassData pHPClassData, long l, StringBuffer stringBuffer) {
        IContainer iContainer;
        String string;
        if (pHPClassData == null) {
            return;
        }
        if (PHPElementLabels.getFlag(l, 8192L) && (string = (IFile)PHPModelUtil.getResource((Object)pHPClassData)) != null && !((iContainer = string.getParent()) instanceof IProject)) {
            PHPElementLabels.getPHPFolderLabel(iContainer, l & 0x20000000L, stringBuffer);
            stringBuffer.append('.');
        }
        string = pHPClassData.getName();
        stringBuffer.append(string);
        if (PHPElementLabels.getFlag(l, 32768L)) {
            iContainer = (IFile)PHPModelUtil.getResource((Object)pHPClassData);
            IContainer iContainer2 = iContainer.getParent();
            stringBuffer.append(CONCAT_STRING);
            PHPElementLabels.getPHPFolderLabel(iContainer2, l & 0x20000000L, stringBuffer);
        }
    }

    public static void getFieldLabel(PHPVariableData pHPVariableData, long l, StringBuffer stringBuffer) {
        stringBuffer.append(pHPVariableData.getName());
        if (PHPElementLabels.getFlag(l, 4096L)) {
            stringBuffer.append(CONCAT_STRING);
            PHPCodeData pHPCodeData = pHPVariableData.getContainer();
            PHPClassData pHPClassData = null;
            if (pHPCodeData != null && pHPCodeData instanceof PHPClassData) {
                pHPClassData = (PHPClassData)pHPCodeData;
            }
            PHPElementLabels.getTypeLabel(pHPClassData, 0x2000L | l & 0x20000000L, stringBuffer);
        }
    }

    public static void getIncludeFileLabel(PHPIncludeFileData pHPIncludeFileData, long l, StringBuffer stringBuffer) {
        IContainer iContainer;
        IFile iFile;
        if (PHPElementLabels.getFlag(l, 65536L) && (iFile = (IFile)PHPModelUtil.getResource((Object)pHPIncludeFileData)) != null && !((iContainer = iFile.getParent()) instanceof IProject)) {
            stringBuffer.append(iContainer.getName());
            stringBuffer.append('.');
        }
        stringBuffer.append(pHPIncludeFileData.getName());
        if (PHPElementLabels.getFlag(l, 131072L)) {
            iFile = (IFile)PHPModelUtil.getResource((Object)pHPIncludeFileData);
            iContainer = iFile.getParent();
            stringBuffer.append(CONCAT_STRING);
            PHPElementLabels.getPHPFolderLabel(iContainer, 0L, stringBuffer);
        }
    }

    public static void getCompilationUnitLabel(PHPFileData pHPFileData, long l, StringBuffer stringBuffer) {
        IContainer iContainer;
        IFile iFile;
        if (PHPElementLabels.getFlag(l, 65536L) && (iFile = (IFile)PHPModelUtil.getResource((Object)pHPFileData)) != null && !((iContainer = iFile.getParent()) instanceof IProject)) {
            stringBuffer.append(iContainer.getName());
            stringBuffer.append('.');
        }
        iFile = new Path(pHPFileData.getName());
        iContainer = null;
        try {
            iContainer = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)iFile);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (iContainer != null && iContainer.exists()) {
            stringBuffer.append(pHPFileData.getComparableName());
        } else {
            int n = pHPFileData.getName().indexOf(".zip");
            if (n != -1) {
                stringBuffer.append(pHPFileData.getComparableName());
            } else {
                stringBuffer.append(pHPFileData.getComparableName());
            }
        }
        if (PHPElementLabels.getFlag(l, 131072L)) {
            IFile iFile2 = (IFile)PHPModelUtil.getResource((Object)pHPFileData);
            IContainer iContainer2 = iFile2.getParent();
            stringBuffer.append(CONCAT_STRING);
            PHPElementLabels.getPHPFolderLabel(iContainer2, 0L, stringBuffer);
        }
    }

    public static String getElementTooltipText(Object object) {
        StringBuffer stringBuffer = new StringBuffer(60);
        if (object instanceof PHPFunctionData) {
            PHPElementLabels.getMethodTooltipText((PHPFunctionData)object, stringBuffer);
        } else if (object instanceof PHPClassData) {
            PHPElementLabels.getClassTooltipText((PHPClassData)object, stringBuffer);
        } else if (object instanceof PHPConstantData) {
            stringBuffer.append(((PHPConstantData)object).getName());
        }
        return stringBuffer.toString();
    }

    public static void getClassTooltipText(PHPClassData pHPClassData, StringBuffer stringBuffer) {
        if (pHPClassData == null) {
            return;
        }
        stringBuffer.append(pHPClassData.getName());
        if (pHPClassData.getDocBlock() != null) {
            stringBuffer.append("\n" + pHPClassData.getDocBlock().getShortDescription());
        }
    }

    public static void getMethodTooltipText(PHPFunctionData pHPFunctionData, StringBuffer stringBuffer) {
        stringBuffer.append(pHPFunctionData.getName());
        stringBuffer.append('(');
        PHPFunctionData.PHPFunctionParameter[] pHPFunctionParameterArray = pHPFunctionData.getParameters();
        int n = 0;
        while (n < pHPFunctionParameterArray.length) {
            if (n > 0) {
                stringBuffer.append(COMMA_STRING);
            }
            stringBuffer.append(pHPFunctionParameterArray[n].getClassType());
            stringBuffer.append(" $" + pHPFunctionParameterArray[n].getName());
            String string = pHPFunctionParameterArray[n].getDefaultValue();
            if (!string.equals("")) {
                stringBuffer.append(" = " + string);
            }
            ++n;
        }
        stringBuffer.append(')');
        stringBuffer.append(DECL_STRING);
        stringBuffer.append(pHPFunctionData.getReturnType());
        if (pHPFunctionData.getDocBlock() != null) {
            stringBuffer.append("\n" + pHPFunctionData.getDocBlock().getShortDescription());
        }
    }

    public static String getTextLabel(Object object, long l) {
        if (object instanceof PHPCodeData || object instanceof PHPProjectModel) {
            return PHPElementLabels.getElementLabel(object, l);
        }
        if (object instanceof IAdaptable) {
            IWorkbenchAdapter iWorkbenchAdapter;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iWorkbenchAdapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                return iWorkbenchAdapter.getLabel(object);
            }
        } else if (object != null && object.equals("constants")) {
            return object.toString();
        }
        return "";
    }

    public static String getTooltipTextLabel(Object object) {
        if (object instanceof PHPCodeData || object instanceof PHPProjectModel) {
            return PHPElementLabels.getElementTooltipText(object);
        }
        if (object instanceof IAdaptable) {
            IWorkbenchAdapter iWorkbenchAdapter;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iWorkbenchAdapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                return iWorkbenchAdapter.getLabel(object);
            }
        } else if (object != null && object.equals("constants")) {
            return object.toString();
        }
        return "";
    }
}

