/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.util.WeakPropertyChangeListener;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.util.PHPManualDirector;
import org.eclipse.php.internal.ui.util.PHPManualSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class PHPManual
implements IPropertyChangeListener {
    private static final String BROWSER_ID = "PHPManual.browser";
    private static int browserCount = 0;
    private PHPManualSite site;
    private boolean openManualInNewBrowser;
    private IPreferenceStore fStore;

    public PHPManual(PHPManualSite pHPManualSite) {
        this.site = pHPManualSite;
        this.fStore = PHPUiPlugin.getDefault().getPreferenceStore();
        this.initPreferences();
        this.fStore.addPropertyChangeListener((IPropertyChangeListener)WeakPropertyChangeListener.create((IPropertyChangeListener)this, (Object)this.fStore));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("phpManualOpenInNewBrowser")) {
            this.initPreferences();
        }
    }

    public void initPreferences() {
        this.openManualInNewBrowser = this.fStore.getBoolean("phpManualOpenInNewBrowser");
    }

    public PHPManualSite getSite() {
        return this.site;
    }

    public void setSite(PHPManualSite pHPManualSite) {
        this.site = pHPManualSite;
    }

    public void showFunctionHelp(String string) {
        if (string != null) {
            IWebBrowser iWebBrowser;
            PHPManualDirector pHPManualDirector = this.site.getDirector();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.site.getUrl());
            if (!this.site.getUrl().endsWith("/")) {
                stringBuffer.append("/");
            }
            stringBuffer.append(pHPManualDirector.getPath(string, this.site.getExtension()));
            IWorkbenchBrowserSupport iWorkbenchBrowserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            try {
                iWebBrowser = this.openManualInNewBrowser ? iWorkbenchBrowserSupport.createBrowser(BROWSER_ID + ++browserCount) : iWorkbenchBrowserSupport.createBrowser(BROWSER_ID);
            }
            catch (PartInitException partInitException) {
                Logger.logException(partInitException);
                return;
            }
            try {
                iWebBrowser.openURL(new URL(stringBuffer.toString()));
            }
            catch (PartInitException partInitException) {
                Logger.logException(partInitException);
            }
            catch (MalformedURLException malformedURLException) {
                Logger.logException(malformedURLException);
            }
        }
    }
}

