/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.php.internal.ui.util.DefaultElementComparer;

public final class TreePath {
    private Object[] fSegments;
    private int fHash;

    public TreePath(Object[] objectArray) {
        Assert.isNotNull((Object)objectArray);
        int n = 0;
        while (n < objectArray.length) {
            Assert.isNotNull((Object)objectArray[n]);
            ++n;
        }
        this.fSegments = objectArray;
    }

    public Object getSegment(int n) {
        return this.fSegments[n];
    }

    public int getSegmentCount() {
        return this.fSegments.length;
    }

    public Object getFirstSegment() {
        if (this.fSegments.length == 0) {
            return null;
        }
        return this.fSegments[0];
    }

    public Object getLastSegment() {
        if (this.fSegments.length == 0) {
            return null;
        }
        return this.fSegments[this.fSegments.length - 1];
    }

    public boolean equals(Object object) {
        if (!(object instanceof TreePath)) {
            return false;
        }
        TreePath treePath = (TreePath)object;
        if (this.fSegments.length != treePath.fSegments.length) {
            return false;
        }
        int n = 0;
        while (n < this.fSegments.length) {
            if (!this.fSegments[n].equals(treePath.fSegments[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        if (this.fHash != 0) {
            return this.fHash;
        }
        int n = 0;
        while (n < this.fSegments.length) {
            this.fHash += this.fSegments[n].hashCode();
            ++n;
        }
        return this.fHash;
    }

    public boolean equals(TreePath treePath, IElementComparer iElementComparer) {
        if (iElementComparer == null) {
            iElementComparer = DefaultElementComparer.INSTANCE;
        }
        if (treePath == null) {
            return false;
        }
        if (this.fSegments.length != treePath.fSegments.length) {
            return false;
        }
        int n = 0;
        while (n < this.fSegments.length) {
            if (!iElementComparer.equals(this.fSegments[n], treePath.fSegments[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

