/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards.fields;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.internal.ui.util.SWTUtil;
import org.eclipse.php.internal.ui.util.TableLayoutComposite;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IListAdapter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ListDialogField
extends DialogField {
    protected TableViewer fTable;
    protected Control fTableControl;
    protected ILabelProvider fLabelProvider;
    protected ListViewerAdapter fListViewerAdapter;
    protected List fElements;
    protected ViewerSorter fViewerSorter;
    protected String[] fButtonLabels;
    private Button[] fButtonControls;
    private boolean[] fButtonsEnabled;
    private int fRemoveButtonIndex;
    private int fUpButtonIndex;
    private int fDownButtonIndex;
    private Label fLastSeparator;
    private Composite fButtonsControl;
    private ISelection fSelectionWhenEnabled;
    private IListAdapter fListAdapter;
    private Object fParentElement;
    private ColumnsDescription fTableColumns;

    public ListDialogField(IListAdapter iListAdapter, String[] stringArray, ILabelProvider iLabelProvider) {
        this.fListAdapter = iListAdapter;
        this.fLabelProvider = iLabelProvider;
        this.fListViewerAdapter = new ListViewerAdapter();
        this.fParentElement = this;
        this.fElements = new ArrayList(10);
        this.fButtonLabels = stringArray;
        if (this.fButtonLabels != null) {
            int n = this.fButtonLabels.length;
            this.fButtonsEnabled = new boolean[n];
            int n2 = 0;
            while (n2 < n) {
                this.fButtonsEnabled[n2] = true;
                ++n2;
            }
        }
        this.fTable = null;
        this.fTableControl = null;
        this.fButtonsControl = null;
        this.fTableColumns = null;
        this.fRemoveButtonIndex = -1;
        this.fUpButtonIndex = -1;
        this.fDownButtonIndex = -1;
    }

    public void setRemoveButtonIndex(int n) {
        Assert.isTrue((n < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fRemoveButtonIndex = n;
    }

    public int getRemoveButtonIndex() {
        return this.fRemoveButtonIndex;
    }

    public void setUpButtonIndex(int n) {
        Assert.isTrue((n < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fUpButtonIndex = n;
    }

    public void setDownButtonIndex(int n) {
        Assert.isTrue((n < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fDownButtonIndex = n;
    }

    public void setViewerSorter(ViewerSorter viewerSorter) {
        this.fViewerSorter = viewerSorter;
    }

    public void setTableColumns(ColumnsDescription columnsDescription) {
        this.fTableColumns = columnsDescription;
    }

    private void buttonPressed(int n) {
        if (!this.managedButtonPressed(n) && this.fListAdapter != null) {
            this.fListAdapter.customButtonPressed(this, n);
        }
    }

    protected boolean managedButtonPressed(int n) {
        if (n == this.fRemoveButtonIndex) {
            this.remove();
        } else if (n == this.fUpButtonIndex) {
            this.up();
            if (!this.fButtonControls[n].isEnabled() && this.fDownButtonIndex != -1) {
                this.fButtonControls[this.fDownButtonIndex].setFocus();
            }
        } else if (n == this.fDownButtonIndex) {
            this.down();
            if (!this.fButtonControls[n].isEnabled() && this.fUpButtonIndex != -1) {
                this.fButtonControls[this.fUpButtonIndex].setFocus();
            }
        } else {
            return false;
        }
        return true;
    }

    public Control[] doFillIntoGrid(Composite composite, int n) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        this.assertEnoughColumns(n);
        Label label = this.getLabelControl(composite);
        GridData gridData = ListDialogField.gridDataForLabel(1);
        gridData.verticalAlignment = 1;
        label.setLayoutData((Object)gridData);
        Control control = this.getListControl(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = n - 2;
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(6);
        control.setLayoutData((Object)gridData);
        Composite composite2 = this.getButtonBox(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        composite2.setLayoutData((Object)gridData);
        return new Control[]{label, control, composite2};
    }

    public int getNumberOfControls() {
        return 3;
    }

    public void setButtonsMinWidth(int n) {
        if (this.fLastSeparator != null) {
            ((GridData)this.fLastSeparator.getLayoutData()).widthHint = n;
        }
    }

    public Control getListControl(Composite composite) {
        if (this.fTableControl == null) {
            this.assertCompositeNotNull(composite);
            if (this.fTableColumns == null) {
                this.fTable = this.createTableViewer(composite);
                Table table = this.fTable.getTable();
                this.fTableControl = table;
                table.setLayout((Layout)new TableLayout());
            } else {
                TableLayoutComposite tableLayoutComposite = new TableLayoutComposite(composite, 0);
                tableLayoutComposite.setFont(composite.getFont());
                this.fTableControl = tableLayoutComposite;
                this.fTable = this.createTableViewer(tableLayoutComposite);
                Table table = this.fTable.getTable();
                table.setHeaderVisible(this.fTableColumns.headers != null);
                table.setLinesVisible(this.fTableColumns.drawLines);
                ColumnLayoutData[] columnLayoutDataArray = this.fTableColumns.columns;
                int n = 0;
                while (n < columnLayoutDataArray.length) {
                    tableLayoutComposite.addColumnData(columnLayoutDataArray[n]);
                    TableColumn tableColumn = new TableColumn(table, 0);
                    if (this.fTableColumns.headers != null) {
                        tableColumn.setText(this.fTableColumns.headers[n]);
                    }
                    ++n;
                }
            }
            this.fTable.getTable().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    ListDialogField.this.handleKeyPressed(keyEvent);
                }
            });
            this.fTable.setContentProvider((IContentProvider)this.fListViewerAdapter);
            this.fTable.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
            this.fTable.addSelectionChangedListener((ISelectionChangedListener)this.fListViewerAdapter);
            this.fTable.addDoubleClickListener((IDoubleClickListener)this.fListViewerAdapter);
            this.fTable.setInput(this.fParentElement);
            if (this.fViewerSorter != null) {
                this.fTable.setSorter(this.fViewerSorter);
            }
            this.fTableControl.setEnabled(this.isEnabled());
            if (this.fSelectionWhenEnabled != null) {
                this.postSetSelection(this.fSelectionWhenEnabled);
            }
        }
        return this.fTableControl;
    }

    public TableViewer getTableViewer() {
        return this.fTable;
    }

    protected int getListStyle() {
        int n = 2818;
        if (this.fTableColumns != null) {
            n |= 0x10000;
        }
        return n;
    }

    protected TableViewer createTableViewer(Composite composite) {
        Table table = new Table(composite, this.getListStyle());
        table.setFont(composite.getFont());
        return new TableViewer(table);
    }

    protected Button createButton(Composite composite, String string, SelectionListener selectionListener) {
        Button button = new Button(composite, 8);
        button.setFont(composite.getFont());
        button.setText(string);
        button.addSelectionListener(selectionListener);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 1;
        gridData.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gridData);
        return button;
    }

    private Label createSeparator(Composite composite) {
        Label label = new Label(composite, 258);
        label.setFont(composite.getFont());
        label.setVisible(false);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.verticalIndent = 4;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public Composite getButtonBox(Composite composite) {
        if (this.fButtonsControl == null) {
            this.assertCompositeNotNull(composite);
            SelectionListener selectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    ListDialogField.this.doButtonSelected(selectionEvent);
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ListDialogField.this.doButtonSelected(selectionEvent);
                }
            };
            Composite composite2 = new Composite(composite, 0);
            composite2.setFont(composite.getFont());
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            composite2.setLayout((Layout)gridLayout);
            if (this.fButtonLabels != null) {
                this.fButtonControls = new Button[this.fButtonLabels.length];
                int n = 0;
                while (n < this.fButtonLabels.length) {
                    String string = this.fButtonLabels[n];
                    if (string != null) {
                        this.fButtonControls[n] = this.createButton(composite2, string, selectionListener);
                        this.fButtonControls[n].setEnabled(this.isEnabled() && this.fButtonsEnabled[n]);
                    } else {
                        this.fButtonControls[n] = null;
                        this.createSeparator(composite2);
                    }
                    ++n;
                }
            }
            this.fLastSeparator = this.createSeparator(composite2);
            this.updateButtonState();
            this.fButtonsControl = composite2;
        }
        return this.fButtonsControl;
    }

    private void doButtonSelected(SelectionEvent selectionEvent) {
        if (this.fButtonControls != null) {
            int n = 0;
            while (n < this.fButtonControls.length) {
                if (selectionEvent.widget == this.fButtonControls[n]) {
                    this.buttonPressed(n);
                    return;
                }
                ++n;
            }
        }
    }

    protected void handleKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.character == '\u007f' && keyEvent.stateMask == 0 && this.fRemoveButtonIndex != -1 && this.isButtonEnabled(this.fTable.getSelection(), this.fRemoveButtonIndex)) {
            this.managedButtonPressed(this.fRemoveButtonIndex);
        }
    }

    public void dialogFieldChanged() {
        super.dialogFieldChanged();
        this.updateButtonState();
    }

    protected void updateButtonState() {
        if (this.fButtonControls != null && this.isOkToUse(this.fTableControl)) {
            ISelection iSelection = this.fTable.getSelection();
            int n = 0;
            while (n < this.fButtonControls.length) {
                Button button = this.fButtonControls[n];
                if (this.isOkToUse((Control)button)) {
                    button.setEnabled(this.isButtonEnabled(iSelection, n));
                }
                ++n;
            }
        }
    }

    protected boolean getManagedButtonState(ISelection iSelection, int n) {
        if (n == this.fRemoveButtonIndex) {
            return !iSelection.isEmpty();
        }
        if (n == this.fUpButtonIndex) {
            return !iSelection.isEmpty() && this.canMoveUp();
        }
        if (n == this.fDownButtonIndex) {
            return !iSelection.isEmpty() && this.canMoveDown();
        }
        return true;
    }

    protected void updateEnableState() {
        super.updateEnableState();
        boolean bl = this.isEnabled();
        if (this.isOkToUse(this.fTableControl)) {
            if (!bl) {
                this.fSelectionWhenEnabled = this.fTable.getSelection();
                this.selectElements(null);
            } else {
                this.selectElements(this.fSelectionWhenEnabled);
                this.fSelectionWhenEnabled = null;
            }
            this.fTableControl.setEnabled(bl);
        }
        this.updateButtonState();
    }

    public void enableButton(int n, boolean bl) {
        if (this.fButtonsEnabled != null && n < this.fButtonsEnabled.length) {
            this.fButtonsEnabled[n] = bl;
            this.updateButtonState();
        }
    }

    private boolean isButtonEnabled(ISelection iSelection, int n) {
        boolean bl = this.getManagedButtonState(iSelection, n);
        return this.isEnabled() && bl && this.fButtonsEnabled[n];
    }

    public void setElements(Collection collection) {
        this.fElements = new ArrayList(collection);
        if (this.isOkToUse(this.fTableControl)) {
            this.fTable.refresh();
        }
        this.dialogFieldChanged();
    }

    public List getElements() {
        return new ArrayList(this.fElements);
    }

    public Object getElement(int n) {
        return this.fElements.get(n);
    }

    public int getIndexOfElement(Object object) {
        return this.fElements.indexOf(object);
    }

    public void replaceElement(Object object, Object object2) throws IllegalArgumentException {
        int n = this.fElements.indexOf(object);
        if (n != -1) {
            this.fElements.set(n, object2);
            if (this.isOkToUse(this.fTableControl)) {
                List list = this.getSelectedElements();
                if (list.remove(object)) {
                    list.add(object2);
                }
                this.fTable.refresh();
                this.selectElements((ISelection)new StructuredSelection(list));
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.dialogFieldChanged();
    }

    public void elementChanged(Object object) throws IllegalArgumentException {
        if (this.fElements.contains(object)) {
            if (this.isOkToUse(this.fTableControl)) {
                this.fTable.update(object, null);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.dialogFieldChanged();
    }

    public void addElement(Object object) {
        this.addElement(object, this.fElements.size());
    }

    public void addElement(Object object, int n) {
        if (this.fElements.contains(object)) {
            return;
        }
        this.fElements.add(n, object);
        if (this.isOkToUse(this.fTableControl)) {
            this.fTable.refresh();
            this.fTable.setSelection((ISelection)new StructuredSelection(object));
        }
        this.dialogFieldChanged();
    }

    public void addElements(List list) {
        int n = list.size();
        if (n > 0) {
            ArrayList arrayList = new ArrayList(n);
            int n2 = 0;
            while (n2 < n) {
                Object e = list.get(n2);
                if (!this.fElements.contains(e)) {
                    arrayList.add(e);
                }
                ++n2;
            }
            this.fElements.addAll(arrayList);
            if (this.isOkToUse(this.fTableControl)) {
                this.fTable.add(arrayList.toArray());
                this.fTable.setSelection((ISelection)new StructuredSelection(arrayList));
            }
            this.dialogFieldChanged();
        }
    }

    public void removeAllElements() {
        if (this.fElements.size() > 0) {
            this.fElements.clear();
            if (this.isOkToUse(this.fTableControl)) {
                this.fTable.refresh();
            }
            this.dialogFieldChanged();
        }
    }

    public void removeElement(Object object) throws IllegalArgumentException {
        if (this.fElements.remove(object)) {
            if (this.isOkToUse(this.fTableControl)) {
                this.fTable.remove(object);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.dialogFieldChanged();
    }

    public void removeElements(List list) {
        if (list.size() > 0) {
            this.fElements.removeAll(list);
            if (this.isOkToUse(this.fTableControl)) {
                this.fTable.remove(list.toArray());
            }
            this.dialogFieldChanged();
        }
    }

    public int getSize() {
        return this.fElements.size();
    }

    public void selectElements(ISelection iSelection) {
        this.fSelectionWhenEnabled = iSelection;
        if (this.isOkToUse(this.fTableControl)) {
            this.fTable.setSelection(iSelection, true);
        }
    }

    public void selectFirstElement() {
        Object object = null;
        if (this.fViewerSorter != null) {
            Object[] objectArray = this.fElements.toArray();
            this.fViewerSorter.sort((Viewer)this.fTable, objectArray);
            if (objectArray.length > 0) {
                object = objectArray[0];
            }
        } else if (this.fElements.size() > 0) {
            object = this.fElements.get(0);
        }
        if (object != null) {
            this.selectElements((ISelection)new StructuredSelection(object));
        }
    }

    public void postSetSelection(final ISelection iSelection) {
        if (this.isOkToUse(this.fTableControl)) {
            Display display = this.fTableControl.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    if (ListDialogField.this.isOkToUse(ListDialogField.this.fTableControl)) {
                        ListDialogField.this.selectElements(iSelection);
                    }
                }
            });
        }
    }

    public void refresh() {
        super.refresh();
        if (this.isOkToUse(this.fTableControl)) {
            this.fTable.refresh();
        }
    }

    private List moveUp(List list, List list2) {
        int n = list.size();
        ArrayList arrayList = new ArrayList(n);
        Object e = null;
        int n2 = 0;
        while (n2 < n) {
            Object e2 = list.get(n2);
            if (list2.contains(e2)) {
                arrayList.add(e2);
            } else {
                if (e != null) {
                    arrayList.add(e);
                }
                e = e2;
            }
            ++n2;
        }
        if (e != null) {
            arrayList.add(e);
        }
        return arrayList;
    }

    private void moveUp(List list) {
        if (list.size() > 0) {
            this.setElements(this.moveUp(this.fElements, list));
            this.fTable.reveal(list.get(0));
        }
    }

    private void moveDown(List list) {
        if (list.size() > 0) {
            this.setElements(this.reverse(this.moveUp(this.reverse(this.fElements), list)));
            this.fTable.reveal(list.get(list.size() - 1));
        }
    }

    private List reverse(List list) {
        ArrayList arrayList = new ArrayList(list.size());
        int n = list.size() - 1;
        while (n >= 0) {
            arrayList.add(list.get(n));
            --n;
        }
        return arrayList;
    }

    private void remove() {
        this.removeElements(this.getSelectedElements());
    }

    private void up() {
        this.moveUp(this.getSelectedElements());
    }

    private void down() {
        this.moveDown(this.getSelectedElements());
    }

    private boolean canMoveUp() {
        if (this.isOkToUse(this.fTableControl)) {
            int[] nArray = this.fTable.getTable().getSelectionIndices();
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] != n) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private boolean canMoveDown() {
        if (this.isOkToUse(this.fTableControl)) {
            int[] nArray = this.fTable.getTable().getSelectionIndices();
            int n = this.fElements.size() - 1;
            int n2 = nArray.length - 1;
            while (n2 >= 0) {
                if (nArray[n2] != n) {
                    return true;
                }
                --n2;
                --n;
            }
        }
        return false;
    }

    public List getSelectedElements() {
        ISelection iSelection;
        ArrayList arrayList = new ArrayList();
        if (this.isOkToUse(this.fTableControl) && (iSelection = this.fTable.getSelection()) instanceof IStructuredSelection) {
            Iterator iterator = ((IStructuredSelection)iSelection).iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList;
    }

    protected void doListSelected(SelectionChangedEvent selectionChangedEvent) {
        this.updateButtonState();
        if (this.fListAdapter != null) {
            this.fListAdapter.selectionChanged(this);
        }
    }

    protected void doDoubleClick(DoubleClickEvent doubleClickEvent) {
        if (this.fListAdapter != null) {
            this.fListAdapter.doubleClicked(this);
        }
    }

    public static class ColumnsDescription {
        private ColumnLayoutData[] columns;
        private String[] headers;
        private boolean drawLines;

        public ColumnsDescription(ColumnLayoutData[] columnLayoutDataArray, String[] stringArray, boolean bl) {
            this.columns = columnLayoutDataArray;
            this.headers = stringArray;
            this.drawLines = bl;
        }

        public ColumnsDescription(String[] stringArray, boolean bl) {
            this(ColumnsDescription.createColumnWeightData(stringArray.length), stringArray, bl);
        }

        public ColumnsDescription(int n, boolean bl) {
            this(ColumnsDescription.createColumnWeightData(n), null, bl);
        }

        private static ColumnLayoutData[] createColumnWeightData(int n) {
            ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[n];
            int n2 = 0;
            while (n2 < n) {
                columnLayoutDataArray[n2] = new ColumnWeightData(1);
                ++n2;
            }
            return columnLayoutDataArray;
        }
    }

    private class ListViewerAdapter
    implements IStructuredContentProvider,
    ISelectionChangedListener,
    IDoubleClickListener {
        private ListViewerAdapter() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public boolean isDeleted(Object object) {
            return false;
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return ListDialogField.this.fElements.toArray();
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            ListDialogField.this.doListSelected(selectionChangedEvent);
        }

        public void doubleClick(DoubleClickEvent doubleClickEvent) {
            ListDialogField.this.doDoubleClick(doubleClickEvent);
        }
    }
}

