/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.internal.core.phpModel.IPHPLanguageModel;
import org.eclipse.php.internal.core.phpModel.parser.CompositePhpModel;
import org.eclipse.php.internal.core.phpModel.parser.ExternalFilesModel;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.IPhpProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.IProjectModelListener;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeDataFactory;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModelManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPLanguageModelManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPUserModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class PHPProjectModel
extends CompositePhpModel
implements IPhpProjectModel,
IAdaptable {
    private static String ID = "PHPProjectModel";
    private PHPUserModel userModel;
    private IPHPLanguageModel languageModel;
    private Collection listeners = Collections.synchronizedCollection(new HashSet(2));
    private IProject currentProject;

    public String getID() {
        return ID;
    }

    public void initialize(IProject iProject) {
        this.currentProject = iProject;
        this.userModel = new PHPUserModel();
        this.userModel.initialize(iProject);
        this.addModel(this.userModel);
        this.languageModel = new PHPLanguageModelManager();
        this.languageModel.initialize(iProject);
        this.addModel(this.languageModel);
        PHPIncludePathModelManager pHPIncludePathModelManager = new PHPIncludePathModelManager();
        pHPIncludePathModelManager.initialize(iProject);
        this.addModel(pHPIncludePathModelManager);
        this.addModelListenrs();
    }

    public void initialize() {
        this.languageModel = new PHPLanguageModelManager().setDefaultLanguageModel();
        this.addModel(this.languageModel);
    }

    public IProject getProject() {
        return this.currentProject;
    }

    private void addModelListenrs() {
        IPhpModel[] iPhpModelArray = this.getModels();
        int n = 0;
        while (n < iPhpModelArray.length) {
            IPhpModel iPhpModel = iPhpModelArray[n];
            if (iPhpModel instanceof IProjectModelListener) {
                this.addProjectModelListener((IProjectModelListener)((Object)iPhpModel));
            }
            ++n;
        }
    }

    public PHPUserModel getPHPUserModel() {
        return this.userModel;
    }

    public IPHPLanguageModel getPHPLanguageModel() {
        return this.languageModel;
    }

    public Object getExternalResource(PHPFileData pHPFileData) {
        IPhpModel[] iPhpModelArray = this.getModels();
        int n = 0;
        while (n < iPhpModelArray.length) {
            Object object;
            if (iPhpModelArray[n] instanceof ExternalFilesModel && (object = ((ExternalFilesModel)iPhpModelArray[n]).getExternalResource(pHPFileData)) != null) {
                return object;
            }
            ++n;
        }
        return null;
    }

    public CodeData getActiveConstructor(String string, String string2) {
        PHPClassData pHPClassData = this.getClass(string2, string);
        CodeData codeData = null;
        if (pHPClassData != null && (codeData = this.getUserActiveConstructor(pHPClassData)) == null) {
            codeData = pHPClassData.getConstructor();
        }
        return codeData;
    }

    private CodeData getUserActiveConstructor(PHPClassData pHPClassData) {
        if (pHPClassData == null) {
            return null;
        }
        if (pHPClassData.hasConstructor()) {
            return pHPClassData.getConstructor();
        }
        String string = pHPClassData.getSuperClassData().getName();
        if (string != null) {
            String string2 = pHPClassData.isUserCode() ? pHPClassData.getUserData().getFileName() : "";
            return this.getUserActiveConstructor(this.getClass(string2, string));
        }
        return null;
    }

    public PHPClassData getClass(String string, String string2) {
        PHPClassData pHPClassData = super.getClass(string, string2);
        if (pHPClassData == null) {
            return this.languageModel.getClass(string2);
        }
        return pHPClassData;
    }

    public CodeData getClassFunctionData(String string, String string2, String string3) {
        PHPClassData pHPClassData = this.getClass(string, string2);
        if (pHPClassData == null) {
            return null;
        }
        CodeData[] codeDataArray = pHPClassData.getFunctions();
        int n = ModelSupport.getFirstMatch(codeDataArray, string3, true);
        if (n >= 0) {
            return codeDataArray[n];
        }
        String string4 = pHPClassData.getSuperClassData().getName();
        if (string4 != null) {
            string = pHPClassData.isUserCode() ? pHPClassData.getUserData().getFileName() : "";
            return this.getClassFunctionData(string, string4, string3);
        }
        return null;
    }

    public CodeData[] getClassFunctions(String string, String string2, String string3) {
        PHPClassData pHPClassData = this.getClass(string, string2);
        if (pHPClassData == null) {
            return null;
        }
        CodeData[] codeDataArray = ModelSupport.getCodeDataStartingWith(pHPClassData.getFunctions(), string3);
        CodeData[] codeDataArray2 = null;
        String string4 = pHPClassData.getSuperClassData().getName();
        if (string4 != null) {
            string = pHPClassData.isUserCode() ? pHPClassData.getUserData().getFileName() : "";
            codeDataArray2 = ModelSupport.getFilteredCodeData(this.getClassFunctions(string, string4, string3), ModelSupport.PROTECTED_ACCESS_LEVEL_FILTER);
        }
        return ModelSupport.mergeAndRemoveDuplicated(codeDataArray, codeDataArray2);
    }

    public CodeData getClassVariablesData(String string, String string2, String string3) {
        PHPClassData pHPClassData = this.getClass(string, string2);
        if (pHPClassData == null) {
            return null;
        }
        if (string3.startsWith("$")) {
            string3 = string3.substring(1);
        }
        PHPClassVarData[] pHPClassVarDataArray = pHPClassData.getVars();
        int n = 0;
        while (n < pHPClassVarDataArray.length) {
            if (pHPClassVarDataArray[n].getName().equals(string3)) {
                return pHPClassVarDataArray[n];
            }
            ++n;
        }
        String string4 = pHPClassData.getSuperClassData().getName();
        if (string4 != null) {
            string = pHPClassData.isUserCode() ? pHPClassData.getUserData().getFileName() : "";
            return this.getClassVariablesData(string, string4, string3);
        }
        return null;
    }

    public CodeData[] getClassVariables(String string, String string2, String string3) {
        PHPClassData pHPClassData = this.getClass(string, string2);
        if (pHPClassData == null) {
            return null;
        }
        if (string3.startsWith("$")) {
            string3 = string3.substring(1);
        }
        CodeData[] codeDataArray = ModelSupport.getCodeDataStartingWith(pHPClassData.getVars(), string3);
        CodeData[] codeDataArray2 = null;
        String string4 = pHPClassData.getSuperClassData().getName();
        if (string4 != null) {
            string = pHPClassData.isUserCode() ? pHPClassData.getUserData().getFileName() : "";
            codeDataArray2 = ModelSupport.getFilteredCodeData(this.getClassVariables(string, string4, string3), ModelSupport.PROTECTED_ACCESS_LEVEL_FILTER);
        }
        return ModelSupport.merge(codeDataArray, codeDataArray2);
    }

    public CodeData getClassConstsData(String string, String string2, String string3) {
        PHPClassData pHPClassData = this.getClass(string, string2);
        if (pHPClassData == null) {
            return null;
        }
        PHPClassConstData[] pHPClassConstDataArray = pHPClassData.getConsts();
        int n = 0;
        while (n < pHPClassConstDataArray.length) {
            if (pHPClassConstDataArray[n].getName().equals(string3)) {
                return pHPClassConstDataArray[n];
            }
            ++n;
        }
        String string4 = pHPClassData.getSuperClassData().getName();
        if (string4 != null) {
            string = pHPClassData.isUserCode() ? pHPClassData.getUserData().getFileName() : "";
            return this.getClassConstsData(string, string4, string3);
        }
        return null;
    }

    public CodeData[] getClassConsts(String string, String string2, String string3) {
        PHPClassData pHPClassData = this.getClass(string, string2);
        if (pHPClassData == null) {
            return null;
        }
        CodeData[] codeDataArray = ModelSupport.getCodeDataStartingWith(pHPClassData.getConsts(), string3);
        CodeData[] codeDataArray2 = null;
        String string4 = pHPClassData.getSuperClassData().getName();
        if (string4 != null) {
            string = pHPClassData.isUserCode() ? pHPClassData.getUserData().getFileName() : "";
            codeDataArray2 = this.getClassConsts(string, string4, string3);
        }
        return ModelSupport.merge(codeDataArray, codeDataArray2);
    }

    public String getSuperClassName(String string, String string2) {
        PHPClassData pHPClassData = this.getClass(string, string2);
        if (pHPClassData != null) {
            return pHPClassData.getSuperClassData().getName();
        }
        return null;
    }

    public CodeData[] getKeywordData() {
        return this.languageModel.getKeywordData();
    }

    public CodeData[] getKeywordData(String string) {
        return ModelSupport.getCodeDataStartingWith(this.getKeywordData(), string);
    }

    public CodeData[] getVariables(String string, PHPCodeContext pHPCodeContext, String string2, boolean bl) {
        return ModelSupport.removeRepeatedNames(super.getVariables(string, pHPCodeContext, string2, bl));
    }

    public CodeData[] getArrayVariables(String string, String string2, String string3, boolean bl) {
        if (string2.equals("_SERVER") || string2.equals("HTTP_SERVER_VARS")) {
            return ModelSupport.getCodeDataStartingWith(this.languageModel.getServerVariables(), string3);
        }
        if (string2.equals("_SESSION") || string2.equals("HTTP_SESSION_VARS")) {
            return ModelSupport.getCodeDataStartingWith(this.languageModel.getSessionVariables(), string3);
        }
        if (string2.equals("GLOBALS")) {
            CodeData[] codeDataArray = ModelSupport.getCodeDataStartingWith(this.languageModel.getPHPVariables(), string3);
            CodeData[] codeDataArray2 = this.userModel.getGlobalVariables(string, string3, bl);
            return ModelSupport.removeRepeatedNames(ModelSupport.merge(codeDataArray, codeDataArray2));
        }
        return PHPCodeDataFactory.EMPTY_CODE_DATA_ARRAY;
    }

    public PHPConstantData getConstantData(String string, boolean bl) {
        CodeData[] codeDataArray;
        PHPConstantData pHPConstantData = this.userModel.getConstantData(string);
        if (pHPConstantData == null && (codeDataArray = this.languageModel.getConstants(string, bl)) != null && codeDataArray.length > 0) {
            pHPConstantData = (PHPConstantData)codeDataArray[0];
        }
        return pHPConstantData;
    }

    public Object getAdapter(Class clazz) {
        return Platform.getAdapterManager().getAdapter((Object)this, clazz);
    }

    public void addFileToModel(IFile iFile) {
        this.fireFileDataAdded(iFile);
    }

    public void removeFileFromModel(IFile iFile) {
        this.fireFileDataRemoved(iFile);
    }

    public void fileWasChanged(IFile iFile, IStructuredDocument iStructuredDocument) {
        this.fireFileChanged(iFile, iStructuredDocument);
    }

    public void addProjectModelListener(IProjectModelListener iProjectModelListener) {
        if (!this.listeners.contains(iProjectModelListener)) {
            this.listeners.add(iProjectModelListener);
        }
    }

    public Collection getProjectModelListeners() {
        return this.listeners;
    }

    public void removeProjectModelListener(IProjectModelListener iProjectModelListener) {
        this.listeners.remove(iProjectModelListener);
    }

    private void fireFileChanged(IFile iFile, IStructuredDocument iStructuredDocument) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            IProjectModelListener iProjectModelListener = (IProjectModelListener)iterator.next();
            iProjectModelListener.fileChanged(iFile, iStructuredDocument);
        }
    }

    private void fireFileDataRemoved(IFile iFile) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            IProjectModelListener iProjectModelListener = (IProjectModelListener)iterator.next();
            iProjectModelListener.fileRemoved(iFile);
        }
    }

    private void fireFileDataAdded(IFile iFile) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            IProjectModelListener iProjectModelListener = (IProjectModelListener)iterator.next();
            iProjectModelListener.fileAdded(iFile);
        }
    }
}

