/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.watch;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.php.internal.debug.core.debugger.DefaultExpressionsManager;
import org.eclipse.php.internal.debug.core.debugger.Expression;
import org.eclipse.php.internal.debug.core.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.model.PHPValue;
import org.eclipse.php.internal.debug.ui.Logger;

public class PHPWatchExpressionDelegate
implements IWatchExpressionDelegate {
    private String fExpressionText;
    private IWatchExpressionListener fListener;
    private PHPDebugTarget debugTarget;
    private Job fRunDispatch;

    public void evaluateExpression(String string, IDebugElement iDebugElement, IWatchExpressionListener iWatchExpressionListener) {
        this.fExpressionText = string;
        this.fListener = iWatchExpressionListener;
        IStackFrame iStackFrame = null;
        if (iDebugElement instanceof IStackFrame) {
            iStackFrame = (IStackFrame)iDebugElement;
        } else if (iDebugElement instanceof IThread) {
            try {
                iStackFrame = ((IThread)iDebugElement).getTopStackFrame();
            }
            catch (DebugException debugException) {
                Logger.logException(debugException);
            }
        }
        if (iStackFrame == null) {
            this.fListener.watchEvaluationFinished(null);
        } else {
            IDebugTarget iDebugTarget = iStackFrame.getDebugTarget();
            if (iDebugTarget instanceof PHPDebugTarget) {
                this.debugTarget = (PHPDebugTarget)iDebugTarget;
                this.fRunDispatch = new EvaluationRunnable();
                this.fRunDispatch.schedule();
            } else {
                this.fListener.watchEvaluationFinished(null);
            }
        }
    }

    protected Expression getExpression(PHPDebugTarget pHPDebugTarget, String string) {
        DefaultExpressionsManager defaultExpressionsManager = pHPDebugTarget.getExpressionManager();
        Expression expression = defaultExpressionsManager.buildExpression(string);
        pHPDebugTarget.getExpressionManager().getExpressionValue(expression, 1);
        defaultExpressionsManager.update(expression, 1);
        return expression;
    }

    static /* synthetic */ PHPDebugTarget access$0(PHPWatchExpressionDelegate pHPWatchExpressionDelegate) {
        return pHPWatchExpressionDelegate.debugTarget;
    }

    static /* synthetic */ String access$1(PHPWatchExpressionDelegate pHPWatchExpressionDelegate) {
        return pHPWatchExpressionDelegate.fExpressionText;
    }

    private final class EvaluationRunnable
    extends Job {
        public EvaluationRunnable() {
            super("EvaluationRunnable");
            this.setSystem(true);
        }

        public IStatus run(IProgressMonitor iProgressMonitor) {
            try {
                IWatchExpressionResult iWatchExpressionResult = new IWatchExpressionResult(this){
                    final /* synthetic */ EvaluationRunnable this$1;
                    {
                        this.this$1 = evaluationRunnable;
                    }

                    public IValue getValue() {
                        Expression expression = EvaluationRunnable.access$0(this.this$1).getExpression(PHPWatchExpressionDelegate.access$0(EvaluationRunnable.access$0(this.this$1)), PHPWatchExpressionDelegate.access$1(EvaluationRunnable.access$0(this.this$1)));
                        PHPValue pHPValue = new PHPValue(PHPWatchExpressionDelegate.access$0(EvaluationRunnable.access$0(this.this$1)), expression);
                        return pHPValue;
                    }

                    public boolean hasErrors() {
                        return false;
                    }

                    public String[] getErrorMessages() {
                        return null;
                    }

                    public String getExpressionText() {
                        return PHPWatchExpressionDelegate.access$1(EvaluationRunnable.access$0(this.this$1));
                    }

                    public DebugException getException() {
                        return null;
                    }
                };
                PHPWatchExpressionDelegate.this.fListener.watchEvaluationFinished(iWatchExpressionResult);
            }
            catch (Exception exception) {
                Logger.logException(exception);
                PHPWatchExpressionDelegate.this.fListener.watchEvaluationFinished(null);
            }
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)PHPWatchExpressionDelegate.this, 2, 128)});
            return Status.OK_STATUS;
        }

        static /* synthetic */ PHPWatchExpressionDelegate access$0(EvaluationRunnable evaluationRunnable) {
            return evaluationRunnable.PHPWatchExpressionDelegate.this;
        }
    }
}

