/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.search.PHPSearchContentProvider;
import org.eclipse.php.internal.ui.search.PHPSearchResult;
import org.eclipse.php.internal.ui.search.PHPSearchResultPage;
import org.eclipse.php.internal.ui.search.decorators.IPHPDataLeafMarker;

public class PHPSearchTreeContentProvider
extends PHPSearchContentProvider
implements ITreeContentProvider {
    public static final int LEVEL_PROJECT = 0;
    public static final int LEVEL_FILE = 1;
    public static final int LEVEL_TYPE = 2;
    protected final Object[] EMPTY_ARR = new Object[0];
    private Map fChildrenMap;
    protected PHPSearchResult fResult;
    private int groupingLevel;

    PHPSearchTreeContentProvider(PHPSearchResultPage pHPSearchResultPage, int n) {
        super(pHPSearchResultPage);
        this.groupingLevel = n;
    }

    public void setLevel(int n) {
        this.groupingLevel = n;
        this.initialize(this.fResult);
        this.getPage().getViewer().refresh();
    }

    protected void initialize(PHPSearchResult pHPSearchResult) {
        this.fResult = pHPSearchResult;
        this.fChildrenMap = new HashMap();
        if (pHPSearchResult != null) {
            Object[] objectArray = pHPSearchResult.getElements();
            int n = 0;
            while (n < objectArray.length) {
                if (this.getPage().getDisplayedMatchCount(objectArray[n]) > 0) {
                    this.insert(null, null, objectArray[n]);
                }
                ++n;
            }
        }
    }

    public synchronized void elementsChanged(Object[] objectArray) {
        AbstractTreeViewer abstractTreeViewer = (AbstractTreeViewer)this.getPage().getViewer();
        if (this.fResult == null) {
            return;
        }
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        HashMap hashMap = new HashMap();
        int n = 0;
        while (n < objectArray.length) {
            if (this.getPage().getDisplayedMatchCount(objectArray[n]) > 0) {
                this.insert(hashMap, hashSet2, objectArray[n]);
            } else {
                this.remove(hashSet, hashSet2, objectArray[n]);
            }
            ++n;
        }
        abstractTreeViewer.remove(hashSet.toArray());
        Iterator<Object> iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            HashSet hashSet3 = (HashSet)hashMap.get(k);
            abstractTreeViewer.add(k, hashSet3.toArray());
        }
        iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            abstractTreeViewer.refresh(iterator.next());
        }
    }

    protected void remove(Set set, Set set2, Object object) {
        if (this.hasChildren(object)) {
            if (set2 != null) {
                set2.add(object);
            }
        } else if (this.getPage().getDisplayedMatchCount(object) == 0) {
            this.fChildrenMap.remove(object);
            Object object2 = this.getParent(object);
            if (object2 != null) {
                if (this.removeFromSiblings(object, object2)) {
                    this.remove(set, set2, object2);
                }
            } else if (this.removeFromSiblings(object, (Object)this.fResult) && set != null) {
                set.add(object);
            }
        } else if (set2 != null) {
            set2.add(object);
        }
    }

    private boolean removeFromSiblings(Object object, Object object2) {
        Set set = (Set)this.fChildrenMap.get(object2);
        if (set != null) {
            return set.remove(object);
        }
        return false;
    }

    protected void insert(Map map, Set set, Object object) {
        Object object2 = this.getParent(object);
        while (object2 != null) {
            if (this.insertChild(object2, object)) {
                if (map != null) {
                    this.insertInto(object2, object, map);
                }
            } else {
                if (set != null) {
                    set.add(object2);
                }
                return;
            }
            object = object2;
            object2 = this.getParent(object);
        }
        if (this.insertChild((Object)this.fResult, object) && map != null) {
            this.insertInto((Object)this.fResult, object, map);
        }
    }

    private boolean insertChild(Object object, Object object2) {
        return this.insertInto(object, object2, this.fChildrenMap);
    }

    private boolean insertInto(Object object, Object object2, Map map) {
        HashSet<Object> hashSet = (HashSet<Object>)map.get(object);
        if (hashSet == null) {
            hashSet = new HashSet<Object>();
            map.put(object, hashSet);
        }
        return hashSet.add(object2);
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void clear() {
        this.initialize(this.fResult);
        this.getPage().getViewer().refresh();
    }

    public Object[] getChildren(Object object) {
        Set set = (Set)this.fChildrenMap.get(object);
        if (set == null) {
            return this.EMPTY_ARR;
        }
        return set.toArray();
    }

    public Object getParent(Object object) {
        if (object instanceof PHPCodeData) {
            PHPCodeData pHPCodeData = (PHPCodeData)object;
            PHPCodeData pHPCodeData2 = pHPCodeData.getContainer();
            if (pHPCodeData2 != null) {
                if (this.groupingLevel == 2 && pHPCodeData2 instanceof PHPFileData) {
                    return null;
                }
                return pHPCodeData2;
            }
            if (this.groupingLevel == 0 && pHPCodeData instanceof IPHPDataLeafMarker) {
                return ((IPHPDataLeafMarker)pHPCodeData).getProject();
            }
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        return this.getChildren(object).length > 0;
    }
}

