/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableLayoutComposite
extends Composite {
    private static int COLUMN_TRIM = "carbon".equals(SWT.getPlatform()) ? 24 : 3;
    private List columns = new ArrayList();

    public TableLayoutComposite(Composite composite, int n) {
        super(composite, n);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Rectangle rectangle = TableLayoutComposite.this.getClientArea();
                Table table = (Table)TableLayoutComposite.this.getChildren()[0];
                Point point = TableLayoutComposite.this.computeTableSize(table);
                int n = rectangle.width - 2 * table.getBorderWidth();
                if (point.y > rectangle.height) {
                    Point point2 = table.getVerticalBar().getSize();
                    n -= point2.x;
                }
                TableLayoutComposite.this.layoutTable(table, n, rectangle, table.getSize().x < rectangle.width);
            }
        });
    }

    public void addColumnData(ColumnLayoutData columnLayoutData) {
        this.columns.add(columnLayoutData);
    }

    private Point computeTableSize(Table table) {
        Point point = table.computeSize(-1, -1);
        int n = 0;
        int n2 = this.columns.size();
        int n3 = 0;
        while (n3 < n2) {
            ColumnPixelData columnPixelData;
            ColumnLayoutData columnLayoutData = (ColumnLayoutData)this.columns.get(n3);
            if (columnLayoutData instanceof ColumnPixelData) {
                columnPixelData = (ColumnPixelData)columnLayoutData;
                n += columnPixelData.width;
                if (columnPixelData.addTrim) {
                    n += COLUMN_TRIM;
                }
            } else if (columnLayoutData instanceof ColumnWeightData) {
                columnPixelData = (ColumnWeightData)columnLayoutData;
                n += columnPixelData.minimumWidth;
            } else {
                Assert.isTrue((boolean)false, (String)"Unknown column layout data");
            }
            ++n3;
        }
        if (n > point.x) {
            point.x = n;
        }
        return point;
    }

    private void layoutTable(Table table, int n, Rectangle rectangle, boolean bl) {
        int n2;
        if (n <= 1) {
            return;
        }
        TableColumn[] tableColumnArray = table.getColumns();
        int n3 = Math.min(this.columns.size(), tableColumnArray.length);
        int[] nArray = new int[n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            ColumnPixelData columnPixelData;
            ColumnLayoutData columnLayoutData = (ColumnLayoutData)this.columns.get(n7);
            if (columnLayoutData instanceof ColumnPixelData) {
                columnPixelData = (ColumnPixelData)columnLayoutData;
                n2 = columnPixelData.width;
                if (columnPixelData.addTrim) {
                    n2 += COLUMN_TRIM;
                }
                nArray[n7] = n2;
                n4 += n2;
            } else if (columnLayoutData instanceof ColumnWeightData) {
                columnPixelData = (ColumnWeightData)columnLayoutData;
                ++n5;
                n2 = columnPixelData.weight;
                n6 += n2;
            } else {
                Assert.isTrue((boolean)false, (String)"Unknown column layout data");
            }
            ++n7;
        }
        if (n5 > 0) {
            ColumnWeightData columnWeightData;
            n7 = n - n4;
            int n8 = 0;
            int n9 = 0;
            while (n9 < n3) {
                ColumnLayoutData columnLayoutData = (ColumnLayoutData)this.columns.get(n9);
                if (columnLayoutData instanceof ColumnWeightData) {
                    int n10;
                    columnWeightData = (ColumnWeightData)columnLayoutData;
                    int n11 = columnWeightData.weight;
                    int n12 = n10 = n6 == 0 ? 0 : n11 * n7 / n6;
                    if (n10 < columnWeightData.minimumWidth) {
                        n10 = columnWeightData.minimumWidth;
                    }
                    n8 += n10;
                    nArray[n9] = n10;
                }
                ++n9;
            }
            n9 = n7 - n8;
            n2 = 0;
            while (n9 > 0) {
                if (n2 == n3) {
                    n2 = 0;
                }
                if ((columnWeightData = (ColumnLayoutData)this.columns.get(n2)) instanceof ColumnWeightData) {
                    int n13 = n2;
                    nArray[n13] = nArray[n13] + 1;
                    --n9;
                }
                ++n2;
            }
        }
        if (bl) {
            table.setSize(rectangle.width, rectangle.height);
        }
        n7 = 0;
        while (n7 < n3) {
            tableColumnArray[n7].setWidth(nArray[n7]);
            ++n7;
        }
        if (!bl) {
            table.setSize(rectangle.width, rectangle.height);
        }
    }
}

