/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards.fields;

import org.eclipse.php.internal.ui.util.SWTUtil;
import org.eclipse.php.internal.ui.wizards.fields.IStringButtonAdapter;
import org.eclipse.php.internal.ui.wizards.fields.StringDialogField;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class StringButtonDialogField
extends StringDialogField {
    private Button fBrowseButton;
    private String fBrowseButtonLabel;
    private IStringButtonAdapter fStringButtonAdapter;
    private boolean fButtonEnabled;

    public StringButtonDialogField(IStringButtonAdapter iStringButtonAdapter) {
        this.fStringButtonAdapter = iStringButtonAdapter;
        this.fBrowseButtonLabel = "!Browse...!";
        this.fButtonEnabled = true;
    }

    public void setButtonLabel(String string) {
        this.fBrowseButtonLabel = string;
    }

    public void changeControlPressed() {
        this.fStringButtonAdapter.changeControlPressed(this);
    }

    public Control[] doFillIntoGrid(Composite composite, int n) {
        this.assertEnoughColumns(n);
        Label label = this.getLabelControl(composite);
        label.setLayoutData((Object)StringButtonDialogField.gridDataForLabel(1));
        Text text = this.getTextControl(composite);
        text.setLayoutData((Object)StringButtonDialogField.gridDataForText(n - 2));
        Button button = this.getChangeControl(composite);
        button.setLayoutData((Object)StringButtonDialogField.gridDataForButton(button, 1));
        return new Control[]{label, text, button};
    }

    public int getNumberOfControls() {
        return 3;
    }

    protected static GridData gridDataForButton(Button button, int n) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalSpan = n;
        gridData.widthHint = SWTUtil.getButtonWidthHint(button);
        return gridData;
    }

    public Button getChangeControl(Composite composite) {
        if (this.fBrowseButton == null) {
            this.assertCompositeNotNull(composite);
            this.fBrowseButton = new Button(composite, 8);
            this.fBrowseButton.setFont(composite.getFont());
            this.fBrowseButton.setText(this.fBrowseButtonLabel);
            this.fBrowseButton.setEnabled(this.isEnabled() && this.fButtonEnabled);
            this.fBrowseButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    StringButtonDialogField.this.changeControlPressed();
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    StringButtonDialogField.this.changeControlPressed();
                }
            });
        }
        return this.fBrowseButton;
    }

    public void enableButton(boolean bl) {
        if (this.isOkToUse((Control)this.fBrowseButton)) {
            this.fBrowseButton.setEnabled(this.isEnabled() && bl);
        }
        this.fButtonEnabled = bl;
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fBrowseButton)) {
            this.fBrowseButton.setEnabled(this.isEnabled() && this.fButtonEnabled);
        }
    }
}

