/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.J2EEValidator;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;

public abstract class AbstractEJBValidator
extends J2EEValidator {
    protected Map _validated = new HashMap();
    private IEJBValidationContext _vc = null;

    private Map getValidatedMap() {
        if (this._validated == null) {
            this._validated = new HashMap();
        }
        return this._validated;
    }

    protected void logMissingRule(IEJBValidationContext vc, Object ruleId) {
        Logger logger = vc.getMsgLogger();
        if (logger != null && logger.isLoggingLevel(Level.SEVERE)) {
            logger.write(Level.SEVERE, ruleId + " = null");
        }
        this.addInternalErrorMessage(vc);
    }

    protected void addInternalErrorMessage(IEJBValidationContext vc) {
        this.addInternalErrorMessage(vc, null);
    }

    protected void addInternalErrorMessage(IEJBValidationContext vc, Throwable exc) {
        Logger logger;
        IMessage mssg = vc.getMessage();
        mssg.setId(this.internalErrorMessage());
        vc.addMessage(mssg);
        if (exc != null && (logger = vc.getMsgLogger()) != null && logger.isLoggingLevel(Level.SEVERE)) {
            logger.write(Level.SEVERE, exc);
        }
    }

    protected Map removeOldMessages(IEJBValidationContext vc, Map targets) throws ValidationException {
        if (vc.getURIs() == null) {
            vc.removeAllMessages();
            Object[] objectArray = new Object[2];
            objectArray[0] = vc.getReporter();
            vc.loadModel(this.removeOldMessagesString(), objectArray);
            return null;
        }
        this.preRemoveOldMessages(vc, targets);
        vc.loadModel(this.removeOldMessagesString(), new Object[]{vc.getReporter(), targets});
        return targets;
    }

    protected void preRemoveOldMessages(IEJBValidationContext vc, Map targets) throws ValidationException {
    }

    protected String removeOldMessagesString() {
        return null;
    }

    private String internalErrorMessage() {
        return null;
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        super.validate(helper, reporter);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IValidationRule rule, Object targetParent, Object target) throws ValidationException {
        if (this.isValidated(rule.getId(), targetParent, target)) {
            return;
        }
        try {
            try {
                rule.preValidate(this.getValidationContext(), targetParent, target);
                rule.validate(this.getValidationContext(), targetParent, target);
                rule.postValidate(this.getValidationContext(), targetParent, target);
            }
            catch (ValidationCancelledException validationCancelledException) {
            }
            catch (ValidationException e) {
                throw e;
            }
            catch (Throwable exc) {
                this.addInternalErrorMessage(this.getValidationContext(), exc);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.setValidated(rule.getId(), targetParent, target);
            this.releaseRules(rule);
            throw throwable;
        }
        {
            Object var5_8 = null;
            this.setValidated(rule.getId(), targetParent, target);
            this.releaseRules(rule);
            return;
        }
    }

    protected abstract void releaseRules(IValidationRule var1);

    protected IEJBValidationContext getValidationContext() {
        return this._vc;
    }

    protected void setValidationContext(IEJBValidationContext vc) {
        this._vc = vc;
    }

    public void setValidated(Object key, Object targetParent, Object target) {
        Set<TargetObject> done = null;
        done = this.getValidatedMap().containsKey(key) ? (Set)this.getValidatedMap().get(key) : new HashSet<TargetObject>();
        done.add(this.getTargetObjectPool().getTargetObject(targetParent, target));
        this.getValidatedMap().put(key, done);
    }

    protected abstract TargetObjectPool getTargetObjectPool();

    public boolean isValidated(Object key, Object targetParent, Object target) {
        TargetObject temp;
        block4: {
            if (!this.getValidatedMap().containsKey(key)) {
                return false;
            }
            Set done = (Set)this.getValidatedMap().get(key);
            temp = this.getTargetObjectPool().getTargetObject(targetParent, target);
            try {
                if (!done.contains(temp)) break block4;
                Object var6_6 = null;
                this.getTargetObjectPool().release(temp);
                return true;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.getTargetObjectPool().release(temp);
                throw throwable;
            }
        }
        Object var6_7 = null;
        this.getTargetObjectPool().release(temp);
        return false;
    }

    public void cleanup(IReporter reporter) {
        if (this._validated != null) {
            Iterator iterator = this._validated.keySet().iterator();
            while (iterator.hasNext()) {
                Set done = (Set)this._validated.get(iterator.next());
                Iterator toIterator = done.iterator();
                while (toIterator.hasNext()) {
                    TargetObject to = (TargetObject)toIterator.next();
                    this.getTargetObjectPool().release(to);
                }
                done.clear();
            }
            this._validated.clear();
            this._validated = null;
        }
        this.setValidationContext(null);
    }

    public class TargetObject {
        private Object _parent = null;
        private Object _target = null;

        public Object getTargetParent() {
            return this._parent;
        }

        public Object getTarget() {
            return this._target;
        }

        public void setTargetParent(Object tp) {
            this._parent = tp;
        }

        public void setTarget(Object t) {
            this._target = t;
        }

        public int hashCode() {
            int parent = this.getTargetParent() == null ? 0 : this.getTargetParent().hashCode();
            int target = this.getTarget() == null ? 0 : this.getTarget().hashCode();
            return parent + target;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof TargetObject)) {
                return false;
            }
            Object thisParent = this.getTargetParent();
            Object oParent = ((TargetObject)o).getTargetParent();
            Object thisTarget = this.getTarget();
            Object oTarget = ((TargetObject)o).getTarget();
            if (thisParent != null || oParent != null) {
                if (thisParent != null && oParent != null) {
                    if (!thisParent.equals(oParent)) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (thisTarget == null && oTarget == null) {
                return true;
            }
            if (thisTarget != null && oTarget != null) {
                return thisTarget.equals(oTarget);
            }
            return false;
        }
    }

    protected class TargetObjectPool {
        private int _growSize = 0;
        private Vector _pool = null;

        public TargetObjectPool(int initialSize) {
            this._growSize = initialSize;
            this._pool = new Vector(initialSize, this._growSize);
            this.grow();
        }

        private void grow() {
            int i = 0;
            while (i < this._growSize) {
                this._pool.add(new TargetObject());
                ++i;
            }
        }

        public TargetObject getTargetObject(Object targetParent, Object target) {
            if (this._pool.size() <= 0) {
                this.grow();
            }
            TargetObject obj = (TargetObject)this._pool.remove(0);
            obj.setTargetParent(targetParent);
            obj.setTarget(target);
            return obj;
        }

        public void release(TargetObject obj) {
            obj.setTargetParent(null);
            obj.setTarget(null);
            this._pool.add(obj);
        }
    }
}

