/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.hover;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.hover.AbstractPHPTextHover;
import org.eclipse.php.internal.ui.editor.hover.AbstractReusableInformationControlCreator;
import org.eclipse.php.internal.ui.editor.hover.PHPSourceViewerInformationControl;
import org.eclipse.php.internal.ui.util.CodeDataResolver;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class PHPSourceTextHover
extends AbstractPHPTextHover
implements IInformationProviderExtension2,
ITextHoverExtension {
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new AbstractReusableInformationControlCreator(){

                public IInformationControl doCreateInformationControl(Shell shell) {
                    int n = 20;
                    int n2 = 768;
                    return new PHPSourceViewerInformationControl(shell, n, n2);
                }
            };
        }
        return this.fPresenterControlCreator;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new AbstractReusableInformationControlCreator(){

                public IInformationControl doCreateInformationControl(Shell shell) {
                    return new PHPSourceViewerInformationControl(shell, 0, PHPSourceTextHover.this.getTooltipAffordanceString());
                }
            };
        }
        return this.fHoverControlCreator;
    }

    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        IDocument iDocument = iTextViewer.getDocument();
        if (iDocument instanceof IStructuredDocument) {
            try {
                UserData userData;
                CodeData codeData = CodeDataResolver.getCodeData(iTextViewer, iRegion.getOffset());
                if (codeData != null && !(codeData instanceof PHPVariableData) && (userData = codeData.getUserData()) != null) {
                    FindText findText = new FindText(codeData);
                    Display.getDefault().syncExec((Runnable)findText);
                    String string = findText.getText();
                    if (string != null) {
                        return this.formatHoverInfo(string);
                    }
                    IFile iFile = (IFile)PHPModelUtil.getResource((Object)codeData);
                    if (iFile != null) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(iFile.getContents()));
                        int n = userData.getStartPosition();
                        int n2 = userData.getEndPosition() - n;
                        char[] cArray = new char[n2];
                        bufferedReader.skip(n);
                        bufferedReader.read(cArray, 0, n2);
                        bufferedReader.close();
                        return this.formatHoverInfo(new String(cArray));
                    }
                }
            }
            catch (Exception exception) {
                Logger.logException(exception);
            }
        }
        return null;
    }

    public String formatHoverInfo(String string) {
        String[] stringArray = (string = string.trim()).split("[\r\n]");
        if (stringArray.length > 0) {
            String string2 = stringArray[stringArray.length - 1];
            int n = 0;
            while (Character.isWhitespace(string2.charAt(n))) {
                ++n;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < stringArray.length) {
                int n3 = 0;
                while (n3 < n && n3 < stringArray[n2].length()) {
                    if (!Character.isWhitespace(stringArray[n2].charAt(n3))) break;
                    ++n3;
                }
                stringBuffer.append(stringArray[n2].substring(n3));
                stringBuffer.append("\n");
                ++n2;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private static class FindText
    implements Runnable {
        final CodeData codeData;
        private String text = null;

        public FindText(CodeData codeData) {
            this.codeData = codeData;
        }

        public void run() {
            IEditorPart iEditorPart = EditorUtility.isOpenInEditor(this.codeData);
            if (iEditorPart == null || !(iEditorPart instanceof PHPStructuredEditor)) {
                return;
            }
            StructuredTextViewer structuredTextViewer = ((PHPStructuredEditor)iEditorPart).getTextViewer();
            IDocument iDocument = structuredTextViewer.getDocument();
            UserData userData = this.codeData.getUserData();
            if (userData == null || iDocument == null) {
                return;
            }
            int n = userData.getStartPosition();
            int n2 = userData.getEndPosition() - n;
            try {
                this.text = iDocument.get(n, n2);
            }
            catch (BadLocationException badLocationException) {
                this.text = null;
            }
        }

        public String getText() {
            return this.text;
        }
    }
}

