/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards.fields;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class LayoutUtil {
    public static void doDefaultLayout(Composite composite, DialogField[] dialogFieldArray, boolean bl) {
        LayoutUtil.doDefaultLayout(composite, dialogFieldArray, bl, 0, 0);
    }

    public static void doDefaultLayout(Composite composite, DialogField[] dialogFieldArray, boolean bl, int n, int n2) {
        int n3 = LayoutUtil.getNumberOfColumns(dialogFieldArray);
        Control[][] controlArray = new Control[dialogFieldArray.length][];
        int n4 = 0;
        while (n4 < dialogFieldArray.length) {
            controlArray[n4] = dialogFieldArray[n4].doFillIntoGrid(composite, n3);
            ++n4;
        }
        if (bl) {
            LayoutUtil.modifyLabelSpans(controlArray, --n3);
        }
        GridLayout gridLayout = null;
        gridLayout = composite.getLayout() instanceof GridLayout ? (GridLayout)composite.getLayout() : new GridLayout();
        if (n != -1) {
            gridLayout.marginWidth = n;
        }
        if (n2 != -1) {
            gridLayout.marginHeight = n2;
        }
        gridLayout.numColumns = n3;
        composite.setLayout((Layout)gridLayout);
    }

    public static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter pixelConverter = new PixelConverter((Control)button);
        int n = pixelConverter.convertHorizontalDLUsToPixels(61);
        return Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static int getNumberOfColumns(DialogField[] dialogFieldArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < dialogFieldArray.length) {
            n = Math.max(dialogFieldArray[n2].getNumberOfControls(), n);
            ++n2;
        }
        return n;
    }

    private static void modifyLabelSpans(Control[][] controlArray, int n) {
        int n2 = 0;
        while (n2 < controlArray.length) {
            LayoutUtil.setHorizontalSpan(controlArray[n2][0], n);
            ++n2;
        }
    }

    public static void setHeightHint(Control control, int n) {
        Object object = control.getLayoutData();
        if (object instanceof GridData) {
            ((GridData)object).heightHint = n;
        }
    }

    public static void setHorizontalGrabbing(Control control) {
        Object object = control.getLayoutData();
        if (object instanceof GridData) {
            ((GridData)object).grabExcessHorizontalSpace = true;
        }
    }

    public static void setHorizontalIndent(Control control, int n) {
        Object object = control.getLayoutData();
        if (object instanceof GridData) {
            ((GridData)object).horizontalIndent = n;
        }
    }

    public static void setHorizontalSpan(Control control, int n) {
        Object object = control.getLayoutData();
        if (object instanceof GridData) {
            ((GridData)object).horizontalSpan = n;
        } else if (n != 1) {
            GridData gridData = new GridData();
            gridData.horizontalSpan = n;
            control.setLayoutData((Object)gridData);
        }
    }

    public static void setWidthHint(Control control, int n) {
        Object object = control.getLayoutData();
        if (object instanceof GridData) {
            ((GridData)object).widthHint = n;
        }
    }
}

